/*->c.format */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"
#include "bbc.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "bf.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "mlo.h"
#include "units.h"
#include "bits.h"
#include "conf.h"
#include "colour.h"
#include "redraw.h"
#include "config.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewr.h"
#include "im.h"

#include "fx.h"
#include "user.h"


#include "quant.h"

#include "edit.h"

#include "long.h"
#include "cms.h"
#include "undo.h"

#include "format.h"

#include "fxr.h"


extern dboxstr fbox;


static filestr  * ffile;
static viewstr  * fview;






static formatstr * fsp;
static formatstr   fs;
static formatfn    fsfn;
       formatstr   cformat;






static char * palnames[]=
{
 "None",
 "RGB",
 "RISC OS",
 "Optimal",
 "Linear GS"
};


#define MAXPAL 5



#define UPNAMELEN 24


typedef struct userpalstr
{
 char name[UPNAMELEN];


} userpalstr;


#define UPCHUNK (8*sizeof(userpalstr))

static int          maxuserpal;
static userpalstr * upal;

static char * upath="<HKEY_LOCAL_MACHINE\\Software\\DavidPilling\\DPScan\\>\\Palettes";


static os_error * imloadpal(int n,imagestr * dim)
{
 os_error * err;
 TCHAR      name[FILENAMELEN];
 int        np;

 fs_join(name,NITEM(name),upath,upal[n].name);

 err=readpalfile(dim->ipal.word,&np,name);

 dim->ipal.ncolours=np;

 return(err);
}







#define FDTHRESH 0
#define FDORDER  1
#define FDFS     2


/* maps a bpp into an index */

static char bppmap[]={
                      0,1,2,0,3,0,0,0,
                      4,0,0,0,0,0,0,0,
                      5,0,0,0,0,0,0,0,
                      6,0,0,0,0,0,0,0,
                      7,0,0,0,0,0,0,0,
                     };

/* maps an index into a bpp */

static char invbppmap[]={1,1,2,4,8,16,24,32};

#define MAXBPP 8


static int fgetpal(imagestr * im)
{
 imagestr temp;
 int      i;

 if(im->bpp>8) return(FPNONE);

 memcpy(&temp,im,sizeof(imagestr));
 imospal(&temp);

 for(i=0;i<temp.ipal.ncolours;i++)
 {
  if((temp.ipal.word[i]&0xFFFFFF00)!=(im->ipal.word[i]&0xFFFFFF00))
  {
   break;
  }
 }

 if(i>=temp.ipal.ncolours) return(FPRISCOS);


 if(imgrey(im))
 {
  if(imlingrey(im)) return(FPLINGS);
 }

 return(FPOPT);
}




static os_error * ficon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 return(err);
 USE(handle);
 USE(userhandle);
 USE(m);
}



static os_error * fkey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 return(viewsubkey(fview,key));

 USE(handle);
 USE(userhandle);
 USE(icon);
}



os_error * reformat(formatstr * fsp,imagestr * sim,imagestr * dim)
{
 os_error * err;

 err=NULL;


 switch(fsp->fdith)
 {
  case    FDTHRESH:
                   err=fxrthreshold(sim,dim);
                   break;

  case     FDORDER:
                   err=fxrdither(sim,dim);
                   break;

  case        FDFS:
                   err=fxrfsi(fsp,sim,dim);
                   break;
 }


 return(err);
}





os_error * reformatim(imagestr * sim,imagestr ** dimp,formatstr * fs)
{
 os_error * err;
 int        palchange;
 imagestr * dim;

 err=imnew(sim->xpix,sim->ypix,fs->fbpp,dimp);
 if(!err)
 {
  dim=*dimp;
  dim->xdpi=sim->xdpi;
  dim->ydpi=sim->ydpi;

  dim->ipal=sim->ipal;   /* !!!! */

  dim->tr=sim->tr;

  cmscopyprofile(dim,sim);

  palchange=1;

  if(fs->fbpp<=8)
  {
   if(fs->fpal==FPRGB)    imrgbpal(dim);
   else
   if(fs->fpal==FPOPT)    colorquant(sim,dim,5);
   else
   if(fs->fpal==FPLINGS)  imsetgreypal(dim,fs->fbpp);
   else
   if(fs->fpal>=MAXPAL)   imloadpal(fs->fpal-MAXPAL,dim);
   else               
   if(sim->bpp>8 || fs->fpal==FPRISCOS)imospal(dim);/* give it the OS pal */
   else                   palchange=0;
  }
  else                    palchange=0;

  err=reformat(fs,sim,dim);

  if(err) imtrash(dimp);
  else    imtrash(&sim);
 }

 return(err);
}





os_error * reformatxim(ximagestr * sxim,ximagestr ** dximp,formatstr * fs)
{
 os_error * err;
 int        palchange;
 imagestr * dim;
 imagestr * sim;
 ximagestr * dxim;

 sim=(sxim->sim[IM]);


 err=ximnew(sim->xpix,sim->ypix,fs->fbpp,dximp);
 dxim=*dximp;
 if(!err) err=ximcopyal(sxim,dxim);

 if(!err)
 {
  dim=dxim->sim[IM];
  dim->xdpi=sim->xdpi;
  dim->ydpi=sim->ydpi;

  dim->ipal=sim->ipal;   /* !!!! */

  dim->tr=sim->tr;

  cmscopyprofile(dim,sim);

  palchange=1;

  if(fs->fbpp<=8)
  {
   if(fs->fpal==FPRGB)    imrgbpal(dim);
   else
   if(fs->fpal==FPOPT)    colorquant(sim,dim,5);
   else
   if(fs->fpal==FPLINGS)  imsetgreypal(dim,fs->fbpp);
   else
   if(fs->fpal>=MAXPAL)   imloadpal(fs->fpal-MAXPAL,dim);
   else               
   if(sim->bpp>8 || fs->fpal==FPRISCOS)imospal(dim);/* give it the OS pal */
   else                   palchange=0;
  }
  else                    palchange=0;

  err=reformat(fs,sim,dim);

  if(err) ximtrash(dximp);
  else    ximtrash(&sxim);
 }

 return(err);
}








static os_error * forclose(int code)
{
 os_error  * err;
 imagestr  * sim;
 imagestr  * dim;
 ximagestr * sxim;
 ximagestr * dxim;
 int         palchange=0;


 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  fs.fbpp=invbppmap[fs.fbppindex];

  if(fsp)
  {
   err=fsfn(&fs);
  }
  else
  {
   cformat=fs;

   if(ffile->frames && ffile->framen)
   {
    sxim=ffile->frames[fview->frame].xim;
    sim=(sxim->sim[IM]);

    longprocstart(NULL,0,sim->ypix,fview);

    err=viewdeleteimagefileframe(ffile,fview->frame);

    undostart(sxim);

             err=ximnew(sim->xpix,sim->ypix,fs.fbpp,&dxim);
    if(!err) err=ximcopyal(sxim,dxim);

    if(!err)
    {
     dim=(dxim->sim[IM]);

     dim->xdpi=sim->xdpi;
     dim->ydpi=sim->ydpi;

     dim->ipal=sim->ipal;   /* !!!! */

     dim->tr=sim->tr;

     cmscopyprofile(dim,sim);

     palchange=1;

     if(fs.fbpp<=8)
     {
      if(fs.fpal==FPRGB)    imrgbpal(dim);
      else
      if(fs.fpal==FPOPT)    colorquant(sim,dim,5);
      else
      if(fs.fpal==FPLINGS)  imsetgreypal(dim,fs.fbpp);
      else
      if(fs.fpal>=MAXPAL)   imloadpal(fs.fpal-MAXPAL,dim);
      else               
      if(sim->bpp>8 || fs.fpal==FPRISCOS)imospal(dim);/* give it the OS pal */
      else                   palchange=0;
     }
     else                    palchange=0;

     err=reformat(&fs,sim,dim);

     if(err) ximtrash(&dxim);
     else
     {
      if(undosteps) undolink(sxim,dxim);
      else          ximtrash(&sxim);

      ffile->frames[fview->frame].xim=dxim;
     }
    }

    viewcreateimagefileframe(ffile,fview->frame);

    refreshviewfileframe(ffile,fview->frame);

    modifyview(fview);

    if(palchange) modifypal(fview);

    longprocend();

    fs.fobpp=fs.fbpp;
    fs.fopal=fs.fpal;

    dbwritevalues(&fbox);
   }
  }
 }
 return(err);
}


static os_error * wrb(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}


static os_error * owrb(int value,char * string)
{
 if(fsp) {*string++='-';*string=0;}
 else    return(wrb(value,string));
 return(NULL);
}


static os_error * wrbi(int value,char * string)
{
 strcpy(string,numbertostring(invbppmap[value]));
 return(NULL);
}


static os_error * wrp(int value,char * string)
{
	char   temp[FILELEAFMAX];
	char * p;

 if(value>=MAXPAL)
 {
		xzstrncpy(temp,upal[value-MAXPAL].name,sizeof(temp));
		p=fs_extension(temp);
		if(p>temp) *(p-1)=0;

  strcpy(string,temp);
	}
 else              strcpy(string,palnames[value]);
 return(NULL);
}



static os_error * owrp(int value,char * string)
{
 if(fsp) {*string++='-';*string=0;}
 else    return(wrp(value,string));
 return(NULL);
}



os_error * formatsummary(char * string,formatstr * fsp)
{
 char string1[24];
 char string2[24];

 wrp(fsp->fpal,string1);
 wrbi(bppmap[fsp->fbpp],string2);

 sprintf(string,"%sbpp - %s",string2,string1);

 return(NULL);
}




static dbiconstr ficondefs[]=
{
 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

   16, &fs.fpal,    DBINC   ,0,    0,     1, -1, MAXPAL-1,0,  NULL,   0,
   15, &fs.fpal,    DBDEC   ,0,    0,     1, -1, MAXPAL-1,0,  NULL,   0,

    1, NULL,        DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL,0,
    2, NULL,        DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0, NULL,0,

    5, &fs.fobpp,   DBTEXT,   0,   0,     0, 0, 0, 0,          NULL,owrb,
   10, &fs.fopal,   DBTEXT,   0,   0,     0, 0, 0, 0,          NULL,owrp,

    4, &fs.fbppindex,DBTEXT,   0,   0,     0, 0, 0, 0,          NULL,wrbi,
   12, &fs.fbppindex,DBINC   ,0,    0,     1, -1, MAXBPP-1,1,   NULL,   0,
   14, &fs.fbppindex,DBDEC   ,0,    0,     1, -1, MAXBPP-1,1,   NULL,   0,

    6, &fs.fpal,     DBTEXT,   0,   0,     0, 0, 0, 0,         NULL,wrp,

    3, &fs.fdith,    DBRADIO,  0,   0,   FDTHRESH,F1,1, 0,      NULL,NULL,
   32, &fs.fdith,    DBRADIO,  0,   0,   FDORDER,F2,1, 0,       NULL,NULL,
   13, &fs.fdith,    DBRADIO,  0,   0,   FDFS,F3, 1, 0,         NULL,NULL,

   19, &fs.fszigzag, DBTOGGLE, 0,   0,    1,F4,0,0,             NULL,NULL,
   20, &fs.fssimple, DBTOGGLE, 0,   0,    1,F5,0,0,             NULL,NULL,
   21, &fs.fsexact,  DBTOGGLE, 0,   0,    1,F6,0,0,             NULL,NULL,

 /* N   &V           Type     Grp   Flags          R   L   D   U    In  Out */

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr fbox=
{
 0,
 TFORMAT,
 DBFIX,
 DBGRAB,
 forclose,
 ficon,
 fkey,
 NULL,
 ficondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};



os_error * formatopen(wimp_w parent)
{
 os_error * err;
 imagestr * fim;
 
 err=NULL;


 fsp=NULL;
 fs=cformat;


 fview=menuview;
 ffile=menufile;

 fim=((ffile->frames[fview->frame].xim)->sim[IM]);

 fs.fobpp=fim->bpp;
 if(!fs.fbpp) 
 {
  fs.fpal=FPRISCOS;
  fs.fbpp=fs.fobpp;
  fs.fbppindex=bppmap[fs.fbpp];
 }

 fs.fopal=fgetpal(fim);

 if(fbox.handle) dbclose(&fbox,DBCANCEL);
 err=dodboxparent(&fbox,1,parent);


 return(err);
}




os_error * formatwindow(formatstr * xfs,formatfn xfsfn,wimp_w parent)
{
 os_error * err;


 fsp=xfs;
 fsfn=xfsfn;
 fs=*fsp;

 fs.fbppindex=bppmap[fs.fbpp];

 err=dodboxparent(&fbox,1,parent);

 return(err);
}






os_error * formatinit(void)
{
 os_error * err;
 int        type;
 fxstat     f;
 int        eof;

 maxuserpal=0;

 err=fs_exists(upath,&type);
 if(!err && type>1)
 {
  fs_startscan();
  while(1)
  {
   err=fs_nextitem(upath,&f,"*.*",&eof);
   if(err) break;
   if(eof) break;

   if(upal) err=flex_chunk((flex_ptr)&upal,
                            (maxuserpal+1)*sizeof(userpalstr),UPCHUNK);
   else     err=flex_alloc((flex_ptr)&upal,UPCHUNK);

   if(err) break;

   xzstrncpy(upal[maxuserpal].name,f.name,sizeof(upal[maxuserpal].name));
   maxuserpal++;
  }

  ficondefs[0].data.stepbutton.max=
  ficondefs[1].data.stepbutton.max=MAXPAL+maxuserpal-1;
 }

 return(err);
}


