/*->c.filter */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <math.h>
#include <time.h>

#define _MT
#include <process.h>


#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "config.h"
#include "deb.h"
#include "dbhi.h"


#include "resource.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"

#include "file.h"
#include "view.h"

#include "im.h"

#include "configx.h"
#include "cmap.h"
#include "cms.h"

#include "long.h"

#include "filter.h"





typedef double (*filterfn)(double t);


#ifdef NEVER
#define filter_support          (1.0)

static double filter(double t)
{
        /* f(t) = 2|t|^3 - 3|t|^2 + 1, -1 <= t <= 1 */
        if(t < 0.0) t = -t;
        if(t < 1.0) return((2.0 * t - 3.0) * t * t + 1.0);
        return(0.0);
}

#endif

#define box_support             (0.5)

static double box_filter(double t)
{
        if((t > -0.5) && (t <= 0.5)) return(1.0);
        return(0.0);
}

#define triangle_support        (1.0)

static double triangle_filter(double t)
{
        if(t < 0.0) t = -t;
        if(t < 1.0) return(1.0 - t);
        return(0.0);
}


#ifdef NEVER

#define bell_support            (1.5)

static double bell_filter(double t)          /* box (*) box (*) box */
{
        if(t < 0) t = -t;
        if(t < .5) return(.75 - (t * t));
        if(t < 1.5) {
                t = (t - 1.5);
                return(.5 * (t * t));
        }
        return(0.0);
}

#endif

#define B_spline_support        (2.0)

static double B_spline_filter(double t)      /* box (*) box (*) box (*) box */
{
        double tt;

        if(t < 0) t = -t;
        if(t < 1) {
                tt = t * t;
                return((.5 * tt * t) - tt + (2.0 / 3.0));
        } else if(t < 2) {
                t = 2 - t;
                return((1.0 / 6.0) * (t * t * t));
        }
        return(0.0);
}

static double sinc(double x)
{
        x *= PI;
        if(x != 0) return(sin(x) / x);
        return(1.0);
}

#define Lanczos3_support        (3.0)

static double Lanczos3_filter(double t)
{
        if(t < 0) t = -t;
        if(t < 3.0) return(sinc(t) * sinc(t/3.0));
        return(0.0);
}


#ifdef NEVER

#define Mitchell_support        (2.0)

#define B       (1.0 / 3.0)
#define C       (1.0 / 3.0)

static double Mitchell_filter(double t)
{
        double tt;

        tt = t * t;
        if(t < 0) t = -t;
        if(t < 1.0) {
                t = (((12.0 - 9.0 * B - 6.0 * C) * (t * tt))
                   + ((-18.0 + 12.0 * B + 6.0 * C) * tt)
                   + (6.0 - 2 * B));
                return(t / 6.0);
        } else if(t < 2.0) {
                t = (((-1.0 * B - 6.0 * C) * (t * tt))
                   + ((6.0 * B + 30.0 * C) * tt)
                   + ((-12.0 * B - 48.0 * C) * t)
                   + (8.0 * B + 24 * C));
                return(t / 6.0);
        }
        return(0.0);
}

#endif

/***************************************************************************/

typedef struct filterstr
{
 double   support;
 filterfn filter;
 char    * name;
 int       menuid;
} filterstr;


int filtertype;
int tempfiltertype;


#define NFTYPES 8

static filterstr filtertable[NFTYPES]=
{
// box_support,      box_filter,      "None",      ID_FILTER_NONE,
// filter_support,   filter,          "Hermite",   ID_FILTER_HERMITE,
 box_support,      box_filter,      "Nearest",   ID_FILTER_BOX,
 triangle_support, triangle_filter, "Linear",    ID_FILTER_TRIANGLE,
// bell_support,     bell_filter,     "Bell",      ID_FILTER_BELL,
 B_spline_support, B_spline_filter, "Cubic",     ID_FILTER_BSPLINE,
 Lanczos3_support, Lanczos3_filter, "Lanczos",   ID_FILTER_LANCZOS,
// Mitchell_support, Mitchell_filter, "Mitchell",  ID_FILTER_MITCHELL,
};


contokstr filtertoks[]=
{
// "None",0,
// "Hermite",1,
 "Nearest",0,
 "Linear",1,
// "Bell",4,
 "Cubic",2,
 "Lanczos",3,
// "Mitchell",7,
 NULL,0,
};



static void setgfilter(void)
{
 int i;

 for(i=0;i<NFTYPES;i++) tickmenust(MGFILTER,filtertable[i].menuid,i==tempfiltertype);
}


static os_error * gfilterdecode(int * menu,wimp_w window)
{
 int i;

// cprintf("Gfdecode %d",menu[0]);

 for(i=0;i<NFTYPES;i++)
 {
  if(filtertable[i].menuid==menu[0]) break;
 }

 if(i<NFTYPES) tempfiltertype=i;
 setgfilter();
 gfilterupdate();
 return(NULL);
 USE(window);
}


void setgfiltermenu(void)
{
 setmenufns(MGFILTER,gfilterdecode,NULL);
 linkmenu(MGFILTER,0,0);
 setgfilter();
}

void getgfiltername(int type,char * string)
{
 strcpy(string,filtertable[type].name);
}


/*****************************************************************************/


#define FN 256


static int * contrib;
static int   csize;



static void spread(int * w,int n,int sum)
{
 int extra;
 int delta;
 int prevdelta;
 int wsofar;

	int * wbase=w;
 int   count=n;

//	cprintf("spread *w %x n %d sum %x",*(w+1),n,sum);

 extra=0x10000-sum;
 if(extra!=0)
 {
  wsofar=0;
  prevdelta=0;

  while(n--)
  {
			w++;

   delta=scale(extra,((*w)+wsofar),sum);
   wsofar+=*w;
   (*w++)+=delta-prevdelta;
//			cprintf("inc %x *w %x",delta-prevdelta,*(w-1));
   prevdelta=delta;
  }

		w=wbase;
		n=count;

		int sum=0;

  while(n--)
  {
			w++;
			sum+=*w++;
  }

//		cprintf("sum %x",sum);
 }
}





static os_error * calcweights(int xscale,int dxpix,int sxpix,
                                            filterfn filterf,double fwidth)
{
 os_error * err;
 int    i;
 int    j;
 int    n;                    /* pixel number */
 int    count;
 double center;
 int    left;
 int    right;     /* filter calculation variables */
 double width, fscale, weight;   /* filter calculation variables */
 int  * p;
 int  * q;
	int    sum;

 /* pre-calculate filter contributions for a row */

 if(xscale<0x10000)
 {
  width=(fwidth*(double)0x10000)/(double)xscale;
  fscale=((double)0x10000)/(double)xscale;

  csize=2*((int)(width*2)+1)+1;

  err=flex_alloc((flex_ptr)&contrib,sizeof(int)*csize*dxpix);
  if(!err)
  {
   /* use first location for count, and subsequent ones for pixel/weight */

   p=contrib;
   q=p+1;

   for(i=0;i<dxpix;i++) 
   {
    count=0;
    sum=0;
  
    center=((double)i*(double)0x10000)/((double)xscale);
    left=(int)ceil(center-width);
    right=(int)floor(center+width);

    for(j=left;j<=right;++j) 
    {
     weight=center-(double)j;
     weight=filterf(weight/fscale)/fscale;
     if(j<0) 
     {
      n=-j;
     } 
     else 
     if(j>=sxpix) 
     {
      n=(sxpix-j)+sxpix-1;
     } 
     else 
     {
      n=j;
     }

     count++;
     *q++=n;
     *q++=(int)(weight*(double)0x10000);
					sum+=*(q-1);
    }

    spread(p+1,count,sum);

    *p=count;
    p+=csize;
    q=p+1;
   }
  }
 } 
 else 
 {
  width=fwidth;

  csize=2*((int)(width*2)+1)+1;

  err=flex_alloc((flex_ptr)&contrib,sizeof(int)*csize*dxpix);
  if(!err)
  {
   p=contrib;
   q=p+1;

   for(i=0;i<dxpix;i++) 
   {
    count=0;
    sum=0;

    center=((double)i*(double)0x10000)/((double)xscale);
    left=(int)ceil(center-fwidth);
    right=(int)floor(center+fwidth);

//    cprintf("center %f left %d right %d fwidth %f",center,left,right,fwidth);

    for(j=left;j<=right;j++) 
    {
     weight=center-(double)j;
     weight=(*filterf)(weight);
     if(j<0) 
     {
      n=-j;
     } 
     else 
     if(j>=sxpix) 
     {
      n=(sxpix-j)+sxpix-1;
     } 
     else 
     {
      n=j;
     }

     count++;
     *q++=n;
     *q++=(int)(weight*(double)0x10000);
     sum+=*(q-1);
    }

    spread(p+1,count,sum);

    *p=count;
    p+=csize;
    q=p+1;
   }
  }
 }

 return(err);
}





static os_error * calcweights2(int xscale,filterfn filterf,double fwidth)
{
 os_error * err;
 int    i;
 int    j;
 int    count;
 int    sum;
 double center;
 int    left;
 int    right;     /* filter calculation variables */
 double width, fscale, weight;   /* filter calculation variables */
 int  * p;
 int  * q;


 /* pre-calculate filter contributions for a row */

 if(xscale<0x10000)
 {
  width=(fwidth*(double)0x10000)/(double)xscale;
  fscale=((double)0x10000)/(double)xscale;

  csize=2*((int)(width*2)+1)+1;

  err=flex_alloc((flex_ptr)&contrib,sizeof(int)*csize*FN);
  if(!err)
  {
   /* use first location for count, and subsequent ones for pixel/weight */

   p=contrib;
   q=p+1;

   for(i=0;i<FN;i++) 
   {
    count=0;

    center=((double)i)/((double)FN);
    left=(int)ceil(center-width);
    right=(int)floor(center+width);

    *q++=left;

    for(j=left;j<=right;++j) 
    {
     weight=center-(double)j;
     weight=filterf(weight/fscale)/fscale;
     count++;
     *q++=(int)(weight*(double)0x10000);
    }

    *p=count;
    p+=csize;
    q=p+1;
   }
  }
 } 
 else 
 {
  width=fwidth;

  csize=2*((int)(width*2)+1)+1;

  err=flex_alloc((flex_ptr)&contrib,sizeof(int)*csize*FN);
  if(!err)
  {
   p=contrib;
   q=p+1;

   for(i=0;i<FN;i++) 
   {
    count=0;
    sum=0;

    center=((double)i)/((double)FN);
    left=(int)ceil(center-fwidth);
    right=(int)floor(center+fwidth);

    *q++=left;

    for(j=left;j<=right;j++) 
    {
     weight=center-(double)j;
     weight=(*filterf)(weight);
     count++;

     *q++=(int)(weight*(double)0x10000);
     sum+=*(q-1);
    }

    spread(p+2,right-left+1,sum);

    *p=count;
    p+=csize;
    q=p+1;
   }


  }
 }

 return(err);
}



typedef struct zoomxstr
{
	int        start;
	int        step;
	int        dxpix;
	int        dypix;
	int        bpp;
	int        grey;
	int        xshift;
	int        mask;
	imagestr * src;
	imagestr * dst;
	char     * rtab;
	char     * gtab;
	char     * btab;
	int        finished;
	int      * temp;

}	zoomxstr;


static CRITICAL_SECTION g_c;







static os_error * imfind2rwx(imagestr * ip1,int y1,int ** data1,
                     imagestr * ip2,int y2,int ** data2)
{
	os_error * err;

	EnterCriticalSection(&g_c);

	err=imfind2rw(ip1,y1,data1,ip2,y2,data2);

	LeaveCriticalSection(&g_c);

	return(err);
}




static unsigned int __stdcall zoomxsub(void * ptr)
{
	os_error * err;
	zoomxstr * z;
 int    i;
 int    j;
 int    k;                    /* loop variables */
 int    count;
 int  * p;
 int  * q;
 int  * sdata;
 int  * ddata;
 char * sp;
 char * dp;
 char * pix;
 int    r=0;
 int    g=0;
 int    b=0;
 int    rs;
 int    gs;
 int    bs;
 int    w;
 int    bshift;
 int    c;        /* current word for palette images */
 int    v;        /* palette word */




	z=(zoomxstr*)ptr;


  for(k=z->start;k<z->dypix;k+=z->step) 
  {
//   err=longproctick2(k,dypix);

   c=0;
   bshift=0;

   err=imfind2rwx(z->src,k,&sdata,z->dst,k,&ddata);

   sp=(char*)sdata;
   dp=(char*)ddata;

   p=q=contrib;

   for(i=0;i<(z->dst)->xpix;i++) 
   {
    rs=gs=bs=0;

    count=*q++;

    for(j=0;j<count;j++) 
    {
     if(z->bpp==32)
     {
      v=sdata[(*q++)];
      r=v&0xFF;
      g=(v>>8)&0xFF;
      b=(v>>16)&0xFF;
     }
     else
     if(z->bpp==16)
     {
      b=(*q++);
      b=b<<z->xshift;
      v=((sdata[b/32])>>(b & 0x1F))&(z->mask);
      r=(v<<3)&0xF8;
      g=(v>>2)&0xF8;
      b=(v>>7)&0xF8;
     }
     else
     if(z->bpp==24) 
     {
      pix=sp+3*(*q++);
      r=*pix++;
      g=*pix++;
      b=*pix++;
     }
     else
     {
      b=(*q++);
      b=b<<z->xshift;
      v=((sdata[b/32])>>(b & 0x1F))&(z->mask);
      r=z->rtab[v];
      g=z->gtab[v];
      b=z->btab[v];
     }

     w=*q++;

     rs+=r*w;
     gs+=g*w;
     bs+=b*w;
    }

    rs/=0x10000;
    gs/=0x10000;
    bs/=0x10000;

    /* write r,g,b to image */

    if(rs<0) rs=0;
    if(gs<0) gs=0;
    if(bs<0) bs=0;
    if(rs>255) rs=255;
    if(gs>255) gs=255;
    if(bs>255) bs=255;

    if(z->bpp==32)
    {
     *ddata++=rs|(gs<<8)|(bs<<16);
    }
    else
    if(z->bpp==16)
    {
     v=((r&0xF8)>>3)|((g&0xF8)<<2)|((b&0xF8)<<7);

     c|=v<<bshift;
     bshift+=z->bpp;
     if(bshift>=32)
     {
      *ddata++=c;
      bshift=c=0;
     }
    }
    else
    if(z->bpp==24)
    {
     *dp++=(char)rs;
     *dp++=(char)gs;
     *dp++=(char)bs;
    }
    else
    {
     if(z->grey)
     {
      v=z->gtab[r];
     }
     else
     {
      v=((r&0xF0)<<4)|(g&0xF0)|((b&0xF0)>>4);
      v=rgbmap[v];
     }

     c|=v<<bshift;
     bshift+=z->bpp;
     if(bshift>=32)
     {
      *ddata++=c;
      bshift=c=0;
     }
    }

    p+=csize;
    q=p;
   }
   if(bshift) *ddata++=c;
  }

	z->finished=1;

	return(0);
}





static os_error * zoomx(imagestr * dst,imagestr * src,int xscale,
                        filterfn filterf,double fwidth)
{
 os_error * err;
 int    r;
 int    g;
 int    b;
 char   rtab[256];
 char   gtab[256];
 char   btab[256];
 int    size;
	zoomxstr	zblock1;
	zoomxstr	zblock2;



 err=NULL;

 zblock1.dxpix=dst->xpix;
 zblock1.dypix=dst->ypix;
	zblock1.bpp=src->bpp;
 zblock1.grey=imgrey(src);
 zblock1.rtab=rtab;
 zblock1.gtab=gtab;
 zblock1.btab=btab;
	zblock1.src=src;
	zblock1.dst=dst;

 if(zblock1.bpp<=8) 
 {
  imsplitpalette(rtab,gtab,btab,src);

  if(zblock1.grey)
  {
   err=makegmap(src->ipal.ncolours,src->ipal.word,gtab,&size);
   if(size<2) zblock1.grey=0;
  }
  if(!zblock1.grey) err=makecmap(src->ipal.ncolours,src->ipal.word,4,rgbmap);

  if(err) return(err);
 }


 if(zblock1.bpp==1)  {zblock1.xshift=0;zblock1.mask=0x1;}
 else
 if(zblock1.bpp==2)  {zblock1.xshift=1;zblock1.mask=0x3;}
 else
 if(zblock1.bpp==4)  {zblock1.xshift=2;zblock1.mask=0xF;}
 else
 if(zblock1.bpp==8)  {zblock1.xshift=3;zblock1.mask=0xFF;}
 else                {zblock1.xshift=4;zblock1.mask=0x7FFF;}


 err=calcweights(xscale,dst->xpix,src->xpix,filterf,fwidth);


 r=g=b=0; /* compiler */

 /* apply filter to zoom horizontally from src to tmp */

 if(!err)
 {
		unsigned int threadaddr1;

  InitializeCriticalSection(&g_c);
//  InitializeCriticalSectionAndSpinCount(&g_c,50);


		zblock2=zblock1;

		zblock1.start=0;
		zblock1.step=2;
		zblock1.finished=0;

		zblock2.start=1;
		zblock2.step=2;
		zblock2.finished=0;

		_beginthreadex(NULL,0,zoomxsub,(void*)&zblock1,0,&threadaddr1);
//		_beginthreadex(NULL,0,zoomxsub,(void*)&zblock2,0,&threadaddr2);

//		zoomxsub((void*)&zblock1);
		zoomxsub((void*)&zblock2);

		while(zblock1.finished==0)
		{
			Sleep(2);
		}

  DeleteCriticalSection(&g_c);

  flex_free((flex_ptr)&contrib);
 }




 return(err);
}







static CRITICAL_SECTION gr_c;

static os_error * imfind1rx(imagestr * ip,int y,int ** data)
{
	os_error * err;

	EnterCriticalSection(&gr_c);
 
 err=imfind1r(ip,y,data);

	LeaveCriticalSection(&gr_c);

	return(err);
}


static CRITICAL_SECTION gw_c;

static os_error * imfind1wx(imagestr * ip,int y,int ** data)
{
	os_error * err;

	EnterCriticalSection(&gw_c);

	err=imfind1w(ip,y,data);

	LeaveCriticalSection(&gw_c);

	return(err);
}



static unsigned int __stdcall zoomysub(void * ptr)
{
	os_error * err;
	zoomxstr * z;
 int    i;
 int    j;
 int    k;                    /* loop variables */
 int    count;
 int  * sdata;
 int  * ddata;
 char * sp;
 char * dp;
 int    r=0;
 int    g=0;
 int    b=0;
 int  * rs;
 int  * gs;
 int  * bs;
 int    w;
 int    bshift;
 int    c;        /* current word for palette images */
 int    v;        /* palette word */
 int  * temp;
// int    pi;
 int    qi;
 int    ys;


	err=NULL;


	z=(zoomxstr*)ptr;
	temp=z->temp;


  if(!err)
  {
//   pi=qi=0;

   for(i=z->start;i<z->dypix;i+=z->step) 
   {
				qi=csize*i;

				if(qi!=csize*i) cprintf("qi %d",qi);

    memset(temp,0,sizeof(int)*3*(z->dst)->xpix);

    count=contrib[qi++];

    for(j=0;j<count;j++) 
    {
     ys=contrib[qi++];
     w=contrib[qi++];

     err=imfind1rx(z->src,ys,&sdata);
     sp=(char*)sdata;

     rs=temp;
     gs=rs+(z->dst)->xpix;
     bs=gs+(z->dst)->xpix;

     c=*sdata++;
     bshift=0;

     for(k=0;k<z->dxpix;k++) 
     {
      if(z->bpp==32)
      {
       r=c&0xFF;
       g=(c>>8)&0xFF;
       b=(c>>16)&0xFF;
       c=*sdata++;       /* pre inc */
      }
      else
      if(z->bpp==16)
      {
       v=(c>>bshift)&(z->mask);
 
       r=(v<<3)&0xF8;
       g=(v>>2)&0xF8;
       b=(v>>7)&0xF8;

       bshift+=z->bpp;
       if(bshift>=32)
       {
        c=*sdata++;
        bshift=0;
       }
      }
      else
      if(z->bpp==24)
      {
       r=*sp++;
       g=*sp++;
       b=*sp++;
      }
      else
      {
       v=(c>>bshift)&(z->mask);

       r=z->rtab[v];
       g=z->gtab[v];
       b=z->btab[v];
       bshift+=z->bpp;
       if(bshift>=32)
       {
        c=*sdata++;
        bshift=0;
       }
      }

      rs[k]+=r*w;
      gs[k]+=g*w;
      bs[k]+=b*w;
     }
    }
  
    err=imfind1wx(z->dst,i,&ddata);
    dp=(char*)ddata;

    rs=temp;
    gs=rs+(z->dst)->xpix;
    bs=gs+(z->dst)->xpix;

    c=bshift=0;

    for(k=0;k<(z->dst)->xpix;k++) 
    {
     r=rs[k]/0x10000;
     g=gs[k]/0x10000;
     b=bs[k]/0x10000;

     /* write r,g,b to image */

     if(r<0) r=0;
     if(g<0) g=0;
     if(b<0) b=0;
     if(r>255) r=255;
     if(g>255) g=255;
     if(b>255) b=255;


     if(z->bpp==32)
     {
      *ddata++=r|(g<<8)|(b<<16);
     }
     else
     if(z->bpp==16)
     {
      v=((r&0xF8)>>3)|((g&0xF8)<<2)|((b&0xF8)<<7);

      c|=v<<bshift;
      bshift+=z->bpp;
      if(bshift>=32)
      {
       *ddata++=c;
       bshift=c=0;
      }
     }
     else
     if(z->bpp==24)
     {
      *dp++=(char)r;
      *dp++=(char)g;
      *dp++=(char)b;
     }
     else
     {
      if(z->grey)
      {
       v=z->gtab[r];
      }
      else
      {
       v=((r&0xF0)<<4)|(g&0xF0)|((b&0xF0)>>4);
       v=rgbmap[v];
      }

      c|=v<<bshift;
      bshift+=z->bpp;
      if(bshift>=32)
      {
       *ddata++=c;
       bshift=c=0;
      }
     }
    }
    if(bshift) *ddata++=c;

//    pi+=csize;
//    qi=pi;
   }


  }

	z->finished=1;

	return(0);
}






static os_error * zoomy(imagestr * dst,imagestr * src,int yscale,
                                filterfn filterf,double fwidth)
{
 os_error * err;
 char       rtab[256];
 char       gtab[256];
 char       btab[256];
 int        size;
	zoomxstr	  zblock1;
	zoomxstr	  zblock2;


 err=NULL;

 imsplitpalette(rtab,gtab,btab,src);

 zblock1.dxpix=dst->xpix;
 zblock1.dypix=dst->ypix;
	zblock1.bpp=src->bpp;
 zblock1.grey=imgrey(src);
 zblock1.rtab=rtab;
 zblock1.gtab=gtab;
 zblock1.btab=btab;
	zblock1.src=src;
	zblock1.dst=dst;


 if(zblock1.bpp<=8) 
 {
  if(zblock1.grey)
  {
   err=makegmap(src->ipal.ncolours,src->ipal.word,gtab,&size);
   if(size<2) zblock1.grey=0;
  }
  if(!zblock1.grey) err=makecmap(src->ipal.ncolours,src->ipal.word,4,rgbmap);
  if(err) return(err);
 }


 if(zblock1.bpp==1)  {zblock1.mask=0x1;}
 else
 if(zblock1.bpp==2)  {zblock1.mask=0x3;}
 else
 if(zblock1.bpp==4)  {zblock1.mask=0xF;}
 else
 if(zblock1.bpp==8)  {zblock1.mask=0xFF;}
 else                {zblock1.mask=0x7FFF;} 


 err=calcweights(yscale,dst->ypix,src->ypix,filterf,fwidth);

 if(!err)
 {
		unsigned int threadaddr1;
		int    * temp1=NULL;
		int    * temp2=NULL;

           err=flex_alloc((flex_ptr)&temp1,sizeof(int)*3*dst->xpix);
  if(!err) err=flex_alloc((flex_ptr)&temp2,sizeof(int)*3*dst->xpix);

		if(!err)
		{
 		zblock2=zblock1;

 		zblock1.start=0;
 		zblock1.step=2;
 		zblock1.finished=0;
 		zblock1.temp=temp1;

 		zblock2.start=1;
 		zblock2.step=2;
 		zblock2.finished=0;
 		zblock2.temp=temp2;

   InitializeCriticalSection(&gr_c);
   InitializeCriticalSection(&gw_c);

 		_beginthreadex(NULL,0,zoomysub,(void*)&zblock1,0,&threadaddr1);
//		_beginthreadex(NULL,0,zoomxsub,(void*)&zblock2,0,&threadaddr2);
//		zoomysub(&zblock1);
 		zoomysub(&zblock2);

 		while(zblock1.finished==0)
 		{
 			Sleep(2);
 		}

   DeleteCriticalSection(&gr_c);
   DeleteCriticalSection(&gw_c);
		}

  flex_free((flex_ptr)&temp1);
  flex_free((flex_ptr)&temp2);
		
  flex_free((flex_ptr)&contrib);
 }

 return(err);
}




os_error * zoomim(imagestr * sim,imagestr ** dest,int xscale,int yscale)
{
 os_error * err;
 int        xpix;
 int        ypix;
 imagestr * dim;

 err=NULL;

 if(xscale!=0x10000)
 {
  ypix=sim->ypix;
  xpix=scale(sim->xpix,xscale,0x10000);

  err=imnew(xpix,ypix,sim->bpp,&dim);
  if(!err)
  {
   dim->xdpi=sim->xdpi;
   dim->ydpi=sim->ydpi;
   dim->ipal=sim->ipal;
   dim->tr=sim->tr;

   cmscopyprofile(dim,sim);

   zoomx(dim,sim,xscale,filtertable[filtertype].filter,
                        filtertable[filtertype].support);

   imtrash(&sim);
  }
  else dim=sim;
 }
 else dim=sim;

 /* at this point dim is a good image */

 if(yscale!=0x10000 && !err)
 {
  xpix=dim->xpix;
  ypix=scale(dim->ypix,yscale,0x10000);

  err=imnew(xpix,ypix,dim->bpp,&sim);
  if(!err)
  {
   sim->xdpi=dim->xdpi;
   sim->ydpi=dim->ydpi;
   sim->ipal=dim->ipal;

   sim->tr=dim->tr;

   cmscopyprofile(sim,dim);

   zoomy(sim,dim,yscale,filtertable[filtertype].filter,filtertable[filtertype].support);

   imtrash(&dim);
  }
  else sim=dim;
 }
 else sim=dim;

 *dest=sim;

 return(err);
}







os_error * zoomxim(ximagestr * sxim,ximagestr ** dest,int xscale,int yscale)
{
 os_error  * err;
 int         xpix;
 int         ypix;
 ximagestr * dxim;
 imagestr  * dim;
 imagestr  * sim;
 imagestr  * mim;
	int      time=clock();

 err=NULL;

 if(xscale!=0x10000)
 {
  sim=(sxim->sim[IM]);
  mim=(sxim->sim[AL]);

  ypix=sim->ypix;
  xpix=scale(sim->xpix,xscale,0x10000);

  err=ximnew2(xpix,ypix,sim->bpp,mim?mim->bpp:0,&dxim);
  if(!err)
  {
   dim=(dxim->sim[IM]);

   dim->xdpi=sim->xdpi;
   dim->ydpi=sim->ydpi;
   dim->ipal=sim->ipal;
   dim->tr=sim->tr;

   cmscopyprofile(dim,sim);

   zoomx(dim,sim,xscale,filtertable[filtertype].filter,
                        filtertable[filtertype].support);

   if(mim)
   {
    dim=(dxim->sim[AL]);

    dim->xdpi=mim->xdpi;
    dim->ydpi=mim->ydpi;
    dim->ipal=mim->ipal;
    dim->tr=mim->tr;

    zoomx(dim,mim,xscale,filtertable[filtertype].filter,
                         filtertable[filtertype].support);
   }

   ximtrash(&sxim);
  }
  else dxim=sxim;
 }
 else dxim=sxim;

 /* at this point dim is a good image */

 if(yscale!=0x10000 && !err)
 {
  dim=(dxim->sim[IM]);
  mim=(dxim->sim[AL]);

  xpix=dim->xpix;
  ypix=scale(dim->ypix,yscale,0x10000);

  err=ximnew2(xpix,ypix,dim->bpp,mim?mim->bpp:0,&sxim);
  if(!err)
  {
   sim=(sxim->sim[IM]);

   sim->xdpi=dim->xdpi;
   sim->ydpi=dim->ydpi;
   sim->ipal=dim->ipal;
   sim->tr=dim->tr;

   cmscopyprofile(sim,dim);

   zoomy(sim,dim,yscale,filtertable[filtertype].filter,
                        filtertable[filtertype].support);

   if(mim)
   {
    sim=(sxim->sim[AL]);

    sim->xdpi=mim->xdpi;
    sim->ydpi=mim->ydpi;
    sim->ipal=mim->ipal;

    zoomy(sim,mim,yscale,filtertable[filtertype].filter,
                         filtertable[filtertype].support);
   }

   ximtrash(&dxim);
  }
  else sxim=dxim;
 }
 else sxim=dxim;

 *dest=sxim;

	cprintf("time %d",clock()-time);

 return(err);
}






os_error * filtershearsetup(int xscale)
{
 os_error * err;

 err=calcweights2(xscale,filtertable[filtertype].filter,filtertable[filtertype].support);

 return(err);
}


#ifdef NEVER

os_error * filtershearclear(void)
{

 flex_free((flex_ptr)&contrib);

 return(NULL);
}


void filtershearxline(int xpix,char * rsp,char * bsp,char * gsp,int frac,char * rdp,char * gdp,char * bdp)
{
 int    x;
 int    rv;
 int    gv;
 int    bv;
 char * r;
 char * g;
 char * b;
 int  * p;
 int  * q;
 int    i;
 int    j;
 int    rs;
 int    bs;
 int    gs;
 int    count;
 int    w;


 p=contrib+csize*((FN*frac)/0x10000);

 for(i=0;i<xpix;i++) 
 {
  q=p;

  rs=gs=bs=0;

  count=*q++;
  x=*q++;

  r=rsp+x;
  g=gsp+x;
  b=bsp+x;

  for(j=0;j<count;j++) 
  {
   rv=*r++;
   gv=*g++;
   bv=*b++;
   
   w=*q++;

   rs+=rv*w;
   gs+=gv*w;
   bs+=bv*w;
  }

  rs/=0x10000;
  gs/=0x10000;
  bs/=0x10000;

    /* write r,g,b to image */

  if(rs<0) rs=0;
  if(gs<0) gs=0;
  if(bs<0) bs=0;
  if(rs>255) rs=255;
  if(gs>255) gs=255;
  if(bs>255) bs=255;

  *rdp++=(char)rs;
  *gdp++=(char)gs;
  *bdp++=(char)bs;


 }

}

#endif
