/*->h.file */


#define BIGBUFFSIZE 0x20000


typedef os_error * (*configfn)(wimp_w parent);
typedef int        (*bitsfn)(int xcase);
typedef os_error * (*loadframefn)(filestr * file,int fn);

typedef os_error * (*saveimfn)(char * name,int type,imagestr * im);


/* bits values */

#define FAUTORUN 0x1



#define XNAMELEN   16
#define FILESPLEN  16

typedef struct ftypestr
{
 int               type;               /* actual RISC OS file type */
 int               flags;
 loadfn            load;
 loadpostfn        loadpost;
 char          *   name;               /* type name */
 char          *   filename;
 savefn            save;
 configfn          config;
 int               icon;
 bitsfn            bits;
 loadframefn       loadframe;
 char              xname[XNAMELEN];    /* real name we want to see on screen,*/
                                       /* trans'd version of name above*/
 char              filesp[FILESPLEN];  /* "si%0x",table[j].ptr->type   */
 saveinfofn        saveinfo;         

 saveimfn          saveim;             /* to do with EPS previews */

 char          *   extension;          /*  "spr\0""ff9\0" */

 char          *   desc;
} ftypestr;


extern docdatastr defdocdata;


extern os_error * registerfiletype(ftypestr * fts);

extern os_error * addframe(filestr * file,int * fn,int size);

extern filestr  * firstfile;
extern filestr  * loadfile;

extern os_error * closedoc(filestr * file);
extern os_error * loadanyfile(char * name);
extern os_error * savedoc(char * name,filestr * file,int type);
extern os_error * initdoc(void);

extern void       gennewname(filestr * file);
extern os_error * deletefile(filestr * file);

extern os_error * createnewdoc(docdatastr * newdoc,filestr ** filep);

extern os_error * filedynamic(int * menu,char * handle);
extern os_error * filedecode(int * menu,wimp_w window);

extern os_error * fileconfig(int i,wimp_w parent);

extern os_error * savebinstall(void);
extern os_error * ftypemenu(ftypestr * xftype,wimp_w handle,dboxstr * configbox,int * value);
extern os_error * ftypewr(int value,char * string,ftypestr * xftype);
extern int        ftypegetrun(ftypestr * xftype);

extern os_error * newdocument(void);

extern os_error * fileopen(void);

extern os_error * docaddruntype(int type);
extern os_error * docremruntype(int type);

extern os_error * filepopsave(void);

extern os_error * scrapframe(filestr * file,viewstr * view,int fn);
extern os_error * loadframe(filestr * file,viewstr * view,int fn);

extern os_error * filecreateicons(void);
extern os_error * filesetup(void);

extern os_error * loaddocv(char * name,int type,uservalue userhandle,int xvolatile);
extern os_error * loaddocpostv(uservalue userhandle);
extern os_error * loaddoctypev(char * name,int type,mousestr * m,uservalue userhandle,
                                                     int * method);

extern int unsaved(void);

extern int userfiles(void);


extern os_error * readpalfile(int * pal,int * np,char * name);
extern os_error * writepalfile(int * pal,int np,char * name);
extern os_error * loadpalette(char * name,viewstr * view);

extern os_error * saveimagefile(char * name,int type,imagestr * im);
extern os_error * savefilex(char * name,int type);
