/*->c.file */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "akbd.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"

#include "err.h"
#include "fsx.h"
#include "bf.h"
#include "task.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "save.h"
#include "load.h"
#include "ram.h"
#include "etc.h"
#include "config.h"
#include "key.h"
#include "filetype.h"
#include "deb.h"
#include "bits.h"
#include "dbhi.h"
#include "osreg.h"


#include "afxres.h"
#include "resource.h"
#include "constants.h"
#include "str.h"
#include "reslink.h"

#include "view.h"
#include "viewo.h"
#include "viewr.h"
#include "file.h"

#include "im.h"
#include "configx.h"
#include "info.h"
#include "mlo.h"
#include "page.h"
#include "pr.h"
#include "long.h"
#include "undo.h"
#include "rulers.h"

//#include "twain.h"
#include "asprite.h"
#include "gif.h"
#include "jpeg.h"
#include "mtv.h"
#include "tfile.h"
#include "clear.h"
#include "tw.h"
#include "xwia.h"
#include "pbm.h"
#include "pcx.h"
#include "bmp.h"
#include "eps.h"
#include "pngim.h"
#include "draw.h"
#include "ico.h"
#include "edit.h" 
#include "snap.h"


filestr * firstfile;

static int       docno;


typedef struct ftypeptr
{
 int         type;
 ftypestr  * ptr;

} ftypeptr;



#define FTCHUNK (8*sizeof(ftypeptr))

static ftypeptr * table;
static int        tablesize;

static int      * alphatable;  // alpha sort of table indicies



static int cmpptrs(const void * object1,const void * object2)
{
 return(((ftypeptr*)object2)->type-((ftypeptr*)object1)->type);
}


static ftypestr * findftype(int type)
{
 ftypeptr     target;
 ftypeptr   * targetptr;

 target.type=type;

 targetptr=(ftypeptr*)bsearch((void*)&target,table,tablesize,sizeof(ftypeptr),cmpptrs);

 if(targetptr) return(targetptr->ptr);
 else          return(NULL);
}






void gennewname(filestr * file)
{
 filestr * nextfile;

 do
 {
  sprintf(file->oname,"{NEWNAME}%d",docno);
  trans(file->oname,sizeof(file->oname));

  strcpy(file->sname,file->oname);

  if(++docno==100) docno=0;

  nextfile=firstfile;
  while(nextfile)
  {
   if(file!=nextfile && !strcmp(file->sname,fs_leaf(nextfile->sname))) break;
   nextfile=nextfile->next;
  }
 } while(nextfile);
}



int unsaved(void)
{
 filestr * nextfile;
 int       n;

 n=0;
 nextfile=firstfile;

 while(nextfile)
 {
  if(nextfile->modded) n++;
  nextfile=nextfile->next;
 }

 return(n);
}



int userfiles(void)
{
 filestr * file;
 int       count;

 count=0;
 file=firstfile;
 while(file)
 {
/*  if(!file->notuserfile) */count++;
  file=file->next;
 }

 return(count);
}




/* final act of getting rid of file structure */

os_error * deletefile(filestr * file)
{
 os_error * err;
 filestr  * next;
 filestr  * prev;

 next=file->next;
 prev=file->prev;

 if(next) next->prev=prev;
 if(prev) prev->next=next;
 if(firstfile==file) firstfile=next;

 err=sfree((flex_ptr)&file);

 return(err);
}


static os_error * fileimtrash(filestr * file,int fn)
{
 os_error * err;

 err=NULL;

 if(file->frames[fn].xim)
 {
  redotrash(file->frames[fn].xim);
  undotrash(file->frames[fn].xim);
  ximtrash(&file->frames[fn].xim);
  infofinit(&file->frames[fn]);
 }

 return(err);
}



static os_error * loseframes(filestr * file)
{
 os_error * err;
 int        i;

 err=NULL;

 cprintf("lose frames");

 for(i=0;i<file->framen;i++)
 {
  if(file->frames[i].xim) fileimtrash(file,i);
 }

 file->framen=0;

 sfree((flex_ptr)&file->frames);
 sfree((flex_ptr)&file->data);

 return(err);
}


os_error * closedoc(filestr * file)
{
 os_error * err;

 event(EVENT_FCLOSE,file,0);

 err=loseframes(file);
 if(!err) err=deletefile(file);


 return(err);
}



docdatastr defdocdata=
{
 595276,
 841890,
 90,
 90,

};


static os_error * initframes(filestr * file)
{
 cprintf("init frames");

 file->modded=0;
 file->frames=NULL;
 file->data=NULL;
 file->framen=0;

 return(NULL);
}


static os_error * newfile(filestr ** filep,docdatastr * newdoc)
{
 os_error * err;
 filestr  * file;

 err=salloc((flex_ptr)filep,sizeof(filestr));
 if(!err)
 {
  file=*filep;

  initframes(file);

  file->view=0;
  file->viewn=0;
  file->width=newdoc->width;
  file->height=newdoc->height;
  prinitps(&file->ps);

  file->prev=NULL;
  if(firstfile) firstfile->prev=file;
  file->next=firstfile;
  firstfile=file;
 }


 return(err);
}





os_error * readpalfile(int * pal,int * np,char * name)
{
 os_error  * err;
 buffer      bf;
 int         c;
 int         n;
 int         r;
 int         g;
 int         b;

 *np=0;

 err=bf_open(name,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  while(1)
  {
   err=bf_getc(&bf,&c);
   if(err || c!=19) break;

   err=bf_getc(&bf,&n);
   if(err || n==-1) break;

   err=bf_getc(&bf,&c);
   if(err || c==-1) break;

   if(c==16)
   {
    err=bf_getc(&bf,&r);
    if(err || r==-1) break;

    err=bf_getc(&bf,&g);
    if(err || g==-1) break;

    err=bf_getc(&bf,&b);
    if(err || b==-1) break;

    if(n>*np)
    {
     if(n>15) *np=256;
     else
     if(n>3)  *np=16;
     else
     if(n>1)  *np=4;
     else     *np=2;
    }

    pal[n]=(b<<24)|(g<<16)|(r<<8);
   }
  }
  err=bf_close(&bf,err);
 }

 return(err);
}




os_error * writepalfile(int * pal,int np,char * name)
{
 os_error  * err;
 buffer      bf;
 int         n;
 int         r;
 int         g;
 int         b;


 err=bf_open(name,'w',DEFBUFFSIZE,&bf);
 if(!err)
 {
  for(n=0;n<np;n++)
  {
   r=(pal[n]>>8)  & 0xFF;
   g=(pal[n]>>16) & 0xFF;
   b=(pal[n]>>24) & 0xFF;

   err=bf_putc(&bf,19);
   if(err) break;

   err=bf_putc(&bf,n);
   if(err) break;

   err=bf_putc(&bf,16);
   if(err) break;

   err=bf_putc(&bf,r);
   if(err) break;

   err=bf_putc(&bf,g);
   if(err) break;

   err=bf_putc(&bf,b);
   if(err) break;

  }

  err=bf_close(&bf,err);
 }

 return(err);
}



os_error * loadpalette(char * name,viewstr * view)
{
 os_error * err;
 int        pal[256];
 int        n;
 int        i;
 imagestr * im;
 filestr  * file;

 file=view->file;

 err=readpalfile(pal,&n,name);
 if(!err)
 {
  if(loadfile->frames && loadfile->framen)
  {
   im=((loadfile->frames[view->frame].xim)->sim[IM]);

   for(i=0;i<n;i++) im->ipal.word[i]=pal[i];

   err=viewdeleteimagefileframe(loadfile,view->frame);

   viewcreateimagefileframe(loadfile,view->frame);
   refreshviewfileframe(loadfile,view->frame);
   modifyview(view);
   modifypal(view);
  }
 }

 return(err);
}




       filestr   * loadfile;
static ftypestr  * loadfts;
static int         deferedload;

/* load file from disc */

static os_error * loaddoc(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;

 err=NULL;

 loadfts=findftype(type);
 cprintf("loadfts %x",loadfts);

 if(loadfts)
 {
  err=newfile(&loadfile,&defdocdata);
  if(!err)
  {
   strcpy(loadfile->oname,name);
   strcpy(loadfile->sname,name);
   loadfile->type=type;

   xvolatile|=pendingramread();

   deferedload=(!xvolatile)&&(longproc==LMTSK);

   if(loadfts->load && !deferedload) 
   {
 //   longprocstart(NULL,1,0,NULL);
cprintf("fts load");
    err=loadfts->load(name,type,userhandle,xvolatile);
 //   longprocend();
    deferedload=0;
   }

   if(err) closedoc(loadfile);
  }
 }
 else
 if(type==PAL)
 {
  viewstr * view;

  view=(viewstr*)userhandle;

  if(view)
  {
   err=loadpalette(name,view);
  }
 }

 return(err);

 USE(userhandle);
 USE(xvolatile);
}



static os_error * loaddocpost(uservalue userhandle)
{
 os_error    * err;

/* dprintf(0,"load doc post"); */

 err=NULL;

 if(loadfts)
 {
  if(deferedload && loadfts->load)
  {
   longprocstart(NULL,0,0,NULL);
   err=loadfts->load(loadfile->oname,loadfile->type,userhandle,0);
   longprocend();

   if(err) closedoc(loadfile);
  }

  if(!err)
  {
   if(loadfts->loadpost) err=loadfts->loadpost(userhandle);
 
   err=createnewview(loadfile,NULL);
  }
 }

 return(err);
 USE(userhandle);
}




/*****************************************************************************/
/* functions to load files dropped into windows */


os_error *loaddoctypev(char * name,int type,mousestr * m,uservalue userhandle,int * method)
{
 viewstr * view;

 view=(viewstr*)userhandle;

 loadfts=findftype(type);

 cprintf("loadfts=%x type=%d",loadfts,type);

 if(loadfts && view->handle==m->handle) *method=1;
 else
 if(type==PAL)                          *method=1;
 else                                   *method=0;

 return(NULL);
 USE(userhandle);
}



os_error * loaddocv(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;
 viewstr   * view;
 int         fn;
 viewstr   * v;

 err=NULL;

 loadfts=findftype(type);

 view=(viewstr*)userhandle;
 loadfile=(filestr*)view->file;

 cprintf("loadfts=%x type=%d",loadfts,type);

 if(loadfts)
 {
  fn=view->frame;

  /* close all views not of this frame */

  closeviewnotframe(loadfile,fn);
  viewdeleteimagefileframe(loadfile,fn);

  /* reset view frame number to 0 */

  v=loadfile->view;
  while(v)
  {
   v->frame=0;
   v=v->next;
  }

  loseframes(loadfile);
  initframes(loadfile);

  if(!err)
  {
   strcpy(loadfile->oname,name);
   strcpy(loadfile->sname,name);
   loadfile->type=type;

   xvolatile|=pendingramread();

   deferedload=(!xvolatile)&&(longproc==LMTSK);

   if(loadfts->load && !deferedload) 
   {
    longprocstart(NULL,1,0,NULL);
    err=loadfts->load(name,type,userhandle,xvolatile);
    longprocend();
    deferedload=0;
   }

   if(xvolatile) loadfile->type=-1;

			report(err);

			err=NULL;

   if(err) loseframes(loadfile);
  }
 }
 else
 if(type==PAL)
 {
  err=loadpalette(name,view);
 }

 return(err);

 USE(xvolatile);
}



os_error * loaddocpostv(uservalue userhandle)
{
 os_error    * err;

/* dprintf(0,"load doc post"); */

 err=NULL;

 if(loadfts)
 {
  if(deferedload && loadfts->load)
  {
   longprocstart(NULL,0,0,NULL);
   err=loadfts->load(loadfile->oname,loadfile->type,userhandle,0);
   longprocend();

   if(err) loseframes(loadfile);
  }

  if(!err)
  {
   if(loadfts->loadpost) err=loadfts->loadpost(userhandle);

   err=viewcreateimagefile(loadfile);
   refreshviewfileframe(loadfile,0);
   modifyview(loadfile->view);
   refreshrulersu(loadfile->view);
  }
 }

 return(err);
}


/*****************************************************************************/


/* auto run this type of file ? */
/*
static int autorunfile(int type)
{
 int i;

 for(i=0;i<tablesize;i++)
 {
  if(table[i].ptr->type==type && table[i].ptr->bits 
                              && (table[i].ptr->bits() & FAUTORUN)) return(1);
 }

 return(0);
}
*/

os_error * loadanyfile(char * name)
{
 os_error * err;
 fstat      f;

 err=fs_stat(name,&f);
 if(!err)
 {
  if(f.object)
  //  if(autorunfile(f.type))  don't see the point, this is only called on command line
  {
   err=loaddoc(name,f.type,0,0);
cprintf("loaddoc1 name %s type %x",name,f.type);
   if(!err) err=loaddocpost(0);
  }
  else
  {
   err=geterrorf(EFS11,name);
  }
 }

 return(err);
}





os_error * createnewdoc(docdatastr * newdoc,filestr ** filep)
{
 os_error   * err;
 filestr    * file;

 err=newfile(filep,newdoc);
 if(!err)
 {
  file=*filep;

  file->type=-1;

  if(!err) gennewname(file);

  if(err) deletefile(file);
 }

 return(err);
}




/* create a new default file, open a window on it */
os_error * newdocument(void)
{
 os_error * err;
 filestr  * file;

          err=createnewdoc(&defdocdata,&file);
 if(!err) err=createnewview(file,NULL);

 return(err);
}





os_error * registerfiletype(ftypestr * fts)
{
 os_error * err;
 int        i;
 int        j;

 if(table) 
    err=flex_chunk((flex_ptr)&table,(tablesize+1)*sizeof(ftypestr),FTCHUNK);
 else
    err=flex_alloc((flex_ptr)&table,FTCHUNK);

 if(!err)
 {
  for(i=0;i<tablesize;i++) if(table[i].type<fts->type) break;
  for(j=tablesize-1;j>=i;j--) table[j+1]=table[j];
  table[i].type=fts->type;
  table[i].ptr=fts;
  fts->icon=tablesize;
  tablesize++;
 }

 return(err);
}



static int cmpxnames(const void * p1,const void * p2)
{
 int i1;
 int i2;

 i1=*(int*)p1;
 i2=*(int*)p2;

 return(cstrcmp(table[i1].ptr->xname,table[i2].ptr->xname));
}



static os_error * initfiletypes(void)
{
 os_error          * err;
 static filetypelink link;
 filetypetag       * tags;
 int                 i;
 int                 j;
 int                 n;
 int                 tagn;
 char              * p;
 int                 nex;

 tagn=0;
 n=0;

 for(i=0;i<tablesize;i++)
 {
  tagn+=xstrdblecount(table[i].ptr->extension);
 }

 err=salloc((flex_ptr)&tags,(tagn+1)*sizeof(filetypetag));
 if(!err)
 {
  err=addfiletypetable(tags,&link);
  if(!err)
  {
   for(i=0;i<tablesize;i++)
   {
    strcpy(table[i].ptr->xname,table[i].ptr->name);
    trans(table[i].ptr->xname,XNAMELEN);

    nex=xstrdblecount(table[i].ptr->extension);
    p=table[i].ptr->extension;
    for(j=0;j<nex;j++)
    {
     tags[n].filetype=table[i].type;
     tags[n].extension=p;
     tags[n].description=table[i].ptr->xname;
     n++;
     p=p+strlen(p)+1;
    }
   }
  }

  tags[n].filetype=FTLAST;
  tags[n].extension=NULL;
  tags[n].description=NULL;
 }

 for(i=0;i<tablesize;i++)
 {
  docaddruntype(table[i].type);
 }


 if(!err)
 {
  err=salloc((flex_ptr)&alphatable,tablesize*sizeof(int));
  if(!err)
  {
   for(i=0;i<tablesize;i++)
   {
    alphatable[i]=i;
   }

   qsort(alphatable,tablesize,sizeof(int),cmpxnames);
  }
 }

 return(err);
}





#define FFCHUNK 8

/* add a new frame to this image                   */
/* size is sizeof corresponding private data array */

os_error * addframe(filestr * file,int * fn,int size)
{
 os_error * err;

 if(file->frames) err=schunk((flex_ptr)&file->frames,
                (file->framen+1)*sizeof(framestr),FFCHUNK*sizeof(framestr));
 else             err=salloc((flex_ptr)&file->frames,FFCHUNK*sizeof(framestr));

// cprintf("file->frames=%x file=%x",file->frames,file);


 if(!err)
 {
  if(size)
  {
   if(file->data) err=schunk((flex_ptr)&file->data,
                                  (file->framen+1)*size,FFCHUNK*size);
   else           err=salloc((flex_ptr)&file->data,FFCHUNK*size);
  }

  if(!err)
  {
   *fn=file->framen;
   file->framen++;
   err=infoinit(&file->frames[*fn]);
  }
 }
 return(err);
}


os_error * scrapframe(filestr * file,viewstr * view,int fn)
{
 os_error * err;
 viewstr  * nv;
 int        count;

 err=NULL;

 count=0;
 nv=file->view;
 while(nv)
 {
  if(nv->frame==fn) count++;
  nv=nv->next;
 }

 if(count<=1 && file->frames[fn].xim)
 {
  err=fileimtrash(file,fn);
 }

 return(err);

 USE(view);
}



os_error * loadframe(filestr * file,viewstr * view,int fn)
{
 os_error * err;
 ftypestr * ptr;

 err=NULL;

 if(!file->frames[fn].xim)
 {
  ptr=findftype(file->type);
  if(ptr)
  {
   if(ptr->loadframe)
   {
    loadfile=file;
    err=ptr->loadframe(file,fn);
   }
  }
 }

 return(err);

 USE(view);

}





os_error * saveimagefile(char * name,int type,imagestr * im)
{
 os_error * err;
 ftypestr * ptr;

 err=NULL;

 ptr=findftype(type);
 if(ptr)
 {
  if(ptr->saveim) err=ptr->saveim(name,type,im);
 }

 return(err);
}




os_error * savefilex(char * name,int type)
{
 os_error * err;
 ftypestr * ptr;

 err=NULL;

 ptr=findftype(type);

	cprintf("ptr save %x",ptr);

 if(ptr)
 {
  if(ptr->save) err=ptr->save(name,type);
 }

 return(err);
}






/*****************************************************************************/
/* file menu */

#define MAXOPTS 16

static int csave;

static saveoptionstr saveoptions[MAXOPTS];
static int           saveindex[MAXOPTS];

static os_error * savedocfn(char * name,int type)
{
 os_error * err;
 int        ram;
 int        explode;
 int        i;
 char       path[FILENAMELEN];

 ram=pendingramwrite();
 explode=isctrl && !ram;

 if(explode)
 {
  err=fs_cdir(name);
  if(!err)
  {
   for(i=0;i<menufile->framen;i++)
   {
    gotoframe(menuview,menufile,i);

    if(table[saveindex[csave]].ptr->extension)
    {
     sprintf(path,"%s\\%s.%s",name,menufile->frames[i].name,
                              table[saveindex[csave]].ptr->extension);
    }
    else
    {
     sprintf(path,"%s\\%s",name,menufile->frames[i].name);
    }

    err=table[saveindex[csave]].ptr->save(path,type);
    if(err)
    {
     report(err);
     err=NULL;
    }
   }
  }
 }
 else
 {
  longprocstart(NULL,ram,0,NULL);
  err=table[saveindex[csave]].ptr->save(name,type);
  longprocend();

  if(!err)
  {
   if(!ram)
   {
    strcpy(menufile->sname,name);
    demodify(menuview,menufile);
   }
  }
 }

 return(err);
}


/*
static os_error * saveinfo(int * len)
{
 os_error * err;

 err=NULL;

 if(table[saveindex[csave]].ptr->saveinfo) err=table[saveindex[csave]].ptr->saveinfo(len);
 else                           *len=0;

 return(NULL);
}

*/


static os_error * saveoptfn(wimp_w handle,int opt,int * type,TCHAR * name,int maxlen)
{
 xzstrncpyu(name,menufile->sname,maxlen);
 fs_checkextension(name,table[saveindex[csave]].ptr->extension);
 csave=opt;
 *type=table[saveindex[csave]].type;
 return(NULL);
 USE(handle);
}



/*
static os_error * saveinternal(mousestr * m,char * name,int ftype)
{
 return(geterror(ES00));
 USE(m);
 USE(name);
 USE(ftype);
}

*/



static os_error * filesaveas(void) 
{
 os_error * err;
 int        i;
 int        j;
 int        count;


 err=NULL;

 count=0;

 for(j=0;j<tablesize;j++)
 {
  i=alphatable[j];

  if(table[i].ptr->config)
  {
   saveoptions[count].name=table[i].ptr->desc;
   saveoptions[count].fn=saveoptfn;
   saveindex[count]=i;
   if(table[i].ptr->type==menufile->type) csave=count;
   count++;
  }
 }

// cprintf("setsave count %d saveoptions %x",count,saveoptions);

 setsaveoptions(count,saveoptions,&csave);
// err=setsave(menufile->sname,MTV,savedocfn,&handle);
//     setsave2(saveinternal,saveinfo);

 err=opensaveparent(menufile->sname,NITEM(menufile->sname),menufile->type,savedocfn,menuview->handle);

 return(err);
}




static os_error * fload(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error * err;

          err=loaddoc(name,type,(uservalue)menuview,0);
 if(!err) err=loaddocpost((uservalue)menuview);

 return(err);

 USE(userhandle);
 USE(xvolatile);
}




os_error * fileopen(void)
{
 os_error * err;
 loadoptstr opts;
 int        xtype=-1;
 int        copt;
 char       name[MAX_PATH];

 opts.description="All files (*.*)";
 opts.ntypes=1;
 opts.types=&xtype;

 xzstrncpy(name,menufile->sname,sizeof(name));

 err=openloadparent(name,&copt,&opts,1,fload,0,menuview->handle);


 return(err);
}





static os_error * filepage(int w,int h)
{
 os_error * err;

 menufile->width=w;
 menufile->height=h;

 err=setviewextentfile(menufile);

 return(err);
}



/* set up file menu */

os_error * filesetup(void)
{
 unshademenust(MFILE,ID_FILE_SAVEAS,(menufile->frames!=NULL));
 unshademenust(MFILE,ID_FILE_INFO,(menufile->frames!=NULL));
 unshademenust(MFILE,ID_FILE_PRINT,(menufile->frames!=NULL));

 cprintf("filesetup");

#ifdef WIN64

	unshademenust(MFILE,ID_FILE_SELECT,0);
	unshademenust(MFILE,ID_FILE_ACQUIRE,0);

#endif

// unshademst(MFILE,3,TW_GreySelect());
// unshademst(MFILE,4,TW_GreyAcquire());

 setpagemenu(menufile->width,menufile->height,filepage,MFILE,PAGE_M_FILE);

// unshademenust(MFILE,ID_FILE_UNDO,imagecanundo());
// unshademenust(MFILE,ID_FILE_REDO,imagecanredo());

 return(NULL);
}








os_error * filedynamic(int * menu,char * handle)
{
 os_error * err;

 err=NULL;

 cprintf("file dynamic [0]=%d",menu[0]);


 switch(menu[0])
 {

  case -1:
          err=filesetup();
          break;


 }

 return(err);

 USE(handle);
}


os_error * filepopsave(void)
{
 os_error * err;

 err=filesaveas();
 
 return(err);
}




/* create file icons for config file window */

os_error * filecreateicons(void)
{
 os_error * err;
 int        i;
 int        j;

 err=NULL;

 for(i=0;i<tablesize;i++)
 {
  j=alphatable[i];

  if(table[j].ptr->config)
  {
   sprintf(table[j].ptr->filesp,"si%0x",table[j].ptr->type);
   err=configcreateicon(table[j].ptr->xname,table[j].ptr->filesp,&table[j].ptr->icon);
  }
 }

 return(err);
}



os_error * fileconfig(int n,wimp_w parent)
{
 os_error * err;
 int        i;

 err=NULL;

 if(n>=0 && n<tablesize)
 {
  for(i=0;i<tablesize;i++)
  {
   if(table[i].ptr->icon==n)
   {
    if(table[i].ptr->config) err=table[i].ptr->config(parent);
    break;
   }
  }
 }
 return(err);
}



/****************************************************************************/


#define UFTYPEBASE 0x100


static dboxstr * xxconfigbox;
static int     * xxvalue;



static os_error * ftypedecode(int * menu,wimp_w window)
{
 os_error * err;
 int        index;

 err=NULL;

 index=menu[0]-UFTYPEBASE-1;

 *xxvalue=(*xxvalue) ^ (1<<index);
 
 dbchangevalue(xxvalue,xxconfigbox);

 return(err);

 USE(window);
}


os_error * ftypemenu(ftypestr * xftype,wimp_w handle,dboxstr * configbox,int * value)
{
 os_error * err;
 char     * p;
 int        i;

 xxvalue=value;
 xxconfigbox=configbox;

 p=xftype->extension;
 i=0;
 if(*p)
 {
  err=createusermenu(MUSERF,ftypedecode,NULL);
  while(*p)
  {
   err=addusermenu(MUSERF,p,((*value) & (1<<i))?wimp_MTICK:0,UFTYPEBASE+1+i);
   i++;
   p+=strlen(p)+1;
  }
  completeusermenu(MUSERF,"User");
 }

 openupmenu(handle,MUSERF);

 return(NULL);
}


os_error * ftypewr(int value,char * string,ftypestr * xftype)
{
 char * p;
 int    i;


 *string=0;
 p=xftype->extension;
 i=0;
 if(*p)
 {
  while(*p)
  {
   if(value & (1<<i))
   {
    if(*string) strcat(string,", ");
    strcat(string,p);
   }
   i++;
   p+=strlen(p)+1;
  }
 }

 return(NULL);
}


int ftypegetrun(ftypestr * xftype)
{
 os_error * err;
 char     * p;
 int        i;
 int        dbl;
 char       string[32];
 char       action[256];
 int        size;

 dbl=0;

 p=xftype->extension;
 i=0;
 if(*p)
 {
  while(*p)
  {
   sprintf(string,"HKCR\\.%s\\",p);
   size=sizeof(action);
   err=regreadstr(string,action,&size); 
   if(!err && size)
   {
    sprintf(string,"DPScan.%x",xftype->type);

//    cprintf("string %s action %s",string,action);
   
    if(!cstrcmp(string,action))
    {
     dbl|=(1<<i);
    }
   }

   i++;
   p+=strlen(p)+1;
  }
 }

 return(dbl);
}





os_error * savebinstall(void)
{
 os_error * err;
 int        i;
 int        j;
 char     * p;
 int        dbl;
 char       string[32];
 char       string2[32];

 err=NULL;

 for(i=0;i<tablesize;i++)
 {
  if(table[i].ptr->bits)
  {
   dbl=table[i].ptr->bits(FAUTORUN);

   p=table[i].ptr->extension;
   j=0;
   if(*p)
   {
    while(*p)
    {
     if(dbl & (1<<j))
     {
      sprintf(string,"HKCR\\.%s\\",p);
      sprintf(string2,"DPScan.%x",table[i].ptr->type);
      regwritestr(string,string2);
     }

     j++;
     p+=strlen(p)+1;
    }
   }
  }
 }

 return(err);
}



/****************************************************************************/




os_error * filedecode(int * menu,wimp_w window)
{
 os_error * err;

 err=NULL;


 switch(menu[0])
 {

  case ID_FILE_NEW:
                   err=newdocument();
                   break;
 
 case ID_FILE_OPEN:
                   err=fileopen();
                   break;
 
 
 case ID_FILE_SAVEAS: /* save */
         err=filesaveas();
         break;

  case ID_FILE_INFO: /* image info */
         err=popfileinfo();
         break;

  case ID_FILE_PRINT: /* print */
         err=popprint(menuview);
         break;

  case ID_FILE_PAGESETUP:
         err=popprintpagesetup(menuview);
         break;

  case ID_FILE_SELECT: /* select */
         err=twainselect();
         break;

  case ID_FILE_ACQUIRE: /* acquire */
         err=twainacquire();
         break;

	case	ID_FILE_FROMSCANNERORCAMERA:
									err=wiaacquire();
									break;

  case PAGE_M_FILE:
         err=pagedecode(menu+1,window);
         break;

  case ID_FILE_EXIT:
         pollquit(0);
         break;
 }

 return(err);
}


/*****************************************************************************/


os_error * docaddruntype(int type)
{
 os_error * err;

          err=adddataopen(type,loaddoc);
 if(!err) err=adddataopenpost(type,loaddocpost);

 return(err);
}


os_error * docremruntype(int type)
{
 os_error * err;

          err=remdataopen(type,loaddoc);
 if(!err) err=remdataopenpost(type,loaddocpost);

 return(err);
}



os_error * initdoc(void)
{
 os_error * err;

          err=viewinit();

 if(!err) err=spriteinit();
 if(!err) err=tiffinit();
 if(!err) err=drawinit();
 if(!err) err=gifinit();
 if(!err) err=clearinit();
 if(!err) err=jpeginit();
 if(!err) err=mtvinit();
 if(!err) err=pbminit();
 if(!err) err=pcxinit();
 if(!err) err=bmpinit();
 if(!err) err=epsinit();
 if(!err) err=pnginit();
 if(!err) err=icoinit();

 if(!err) err=initfiletypes();

 if(!err) err=twaininit();

	if(!err) err=editinit();

	if(!err) err=snapinit();

 return(err);
}


