/*->c.eps */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"
#include "deb.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"
#include "scrap.h"
#include "bitrev.h"


#include "constants.h"
#include "str.h"
#include "reslink.h"

#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "units.h"
#include "resize.h"
#include "format.h"
#include "filter.h"
#include "bm.h"
#include "cms.h"


#include "eps.h"





static int epjpeg;
static int tepjpeg;
static int epsi;
static int tepsi;
static int eppreview;
static int teppreview;



static resizestr trsz;
static resizestr rsz={0,1, 100,10,100,10, 90,90,90,90, 0};


static formatstr tepfs;
static formatstr epfs;



extern dboxstr configbox;


#define PVEPSI 0x1
#define PVTIFF 0x2








static os_error * loadeps(char * name,int type,uservalue userhandle,int xvolatile)
{
 return(NULL);

 USE(name);
 USE(type);
 USE(userhandle);
 USE(xvolatile);
}




static os_error * loadfilepost(uservalue userhandle)
{
 return(NULL);

 USE(userhandle);
}




 
 
#define EN(c)   (int) ((c) + '!')



static void wordout(long int word,char * p)
{
 int tmp=0;
    
 if(word<0)
 {      /* Because some don't support unsigned long */
  tmp=32;
  word=word-(long)(85*85*85*85*32);
 }

 if(word<0)
 {
  tmp=64;
  word=word-(long)(85*85*85*85*32);
 }

 *p++=(char)((EN((word / (long)(85 * 85 * 85 * 85)) + tmp)));
 word %= (long)(85 * 85 * 85 * 85);
 *p++=(char)((EN(word / (85 * 85 * 85))));
 word %= (85 * 85 * 85);
 *p++=(char)((EN(word / (85 * 85))));
 word %= (85 * 85);
 *p++=(char)((EN(word / 85)));
 word %= 85;
 *p++=(char)((EN(word)));
}


#define MAX85STRING 65
#define MAX85LEN (MAX85STRING+8)

static os_error * epsbase85codefile(buffer * d,int sh)
{
 os_error * err;
 buffer     s;
 fstat      fx;
 char       string[MAX85LEN];
 int        word;
 char     * p;
 char     * stringmax;

 fs_stat(sc_name(sh),&fx);

 err=bf_open(sc_name(sh),'r',DEFBUFFSIZE,&s);
 if(!err)
 {
  p=string;
  stringmax=string+MAX85STRING;

  while(fx.length>=4)
  {
   err=bf_geti(&s,&word);
   if(err) break;
   fx.length-=4;

   if(word==0)
   {
    *p++='z';
   }
   else 
   {
    wordout((word<<24)|
            ((word<<8)&0xFF0000)|
            ((word>>8)&0xFF00)|
            ((word>>24)&0xFF),p);
    p+=5;
   }

   if(p>=stringmax)
   {
    *p++='\n';
    err=bf_write(d,string,p-string);
    if(err) break;
    p=string;
   }
  }


  if(!err)
  {
   if(fx.length)
   {
    word=0;
    bf_read(&s,&word,fx.length);

    wordout((word<<24)|
            ((word<<8)&0xFF0000)|
            ((word>>8)&0xFF00)|
            ((word>>24)&0xFF),p);

    p+=fx.length+1;
   }

   *p++='~';
   *p++='>';
   *p++='\n';
   err=bf_write(d,string,p-string);
  }


  err=bf_close(&s,err);
 }

 return(err);
}





static char xtab[16]=
{
 '0',
 '1',
 '2',
 '3',
 '4',
 '5',
 '6',
 '7',
 '8',
 '9',
 'A',
 'B',
 'C',
 'D',
 'E',
 'F',
};



typedef struct epshdrstr
{
 int magic;
 int psstart;
 int pslength;
 int metastart;
 int metalength;
 int tiffstart;
 int tifflength;
 short int checksum;

} epshdrstr;


#define EPSMAGIC   0xC6D3D0C5
#define EPSHDRSIZE 30



static os_error * saveeps(char * name,int type)
{
 os_error  * err;
 buffer      bf;
 int         xpix;
 int         ypix;
 int         fn;
 int       * idata;
 char      * p;
 imagestr  * saveimage;
 int         x;
 int         y;
 int         shift;
 int         shift2;
 int         word;
 int         mask;
 int         sbyte;
 int         xbyte;
 int         bpp;
 char        rtab[256];
 char        gtab[256];
 char        btab[256];
 int         grey;
 double      xlo;
 double      xhi;
 double      ylo;
 double      yhi;
 int         bitflip;
 imagestr  * xsim=NULL;
 imagestr  * dim;
 resizestr   rz;
 int         xscale;
 int         yscale;
 int         sh;
 epshdrstr   epshdr;
 fstat       fx;
 fshandle    fh;
 int         fposn;
 int         width;
 int         height;
 int         depth;
 int         lines;
 int         posn1;
 int         posn2;
 int         posn3;
 int         palclass;
 int         tempbpp;


 xhi=xlo=yhi=ylo=0; /* compiler */


 err=0;

 sh=0;


 fn=menuview->frame;
 saveimage=((menufile->frames[fn].xim)->sim[IM]);


 xpix=saveimage->xpix;
 ypix=saveimage->ypix;
 bpp=saveimage->bpp;
 grey=imgrey(saveimage);
 palclass=saveimage->ipal.palclass;

 if(eppreview)
 {
  rz=rsz;
  rz.oldw=xpix;
  rz.oldh=ypix;

  rszcalcscale(&rz,&xscale,&yscale);


  if(epsi==PVEPSI && !grey)
  {
   if(saveimage->bpp>8) 
   {
    err=imnew(saveimage->xpix,saveimage->ypix,8,&xsim);  /* make 8bpp map */
    if(!err)
    {
     xsim->xdpi=saveimage->xdpi;
     xsim->ydpi=saveimage->ydpi;
     xsim->ipal=saveimage->ipal;
     xsim->tr=saveimage->tr;
     cmscopyprofile(xsim,saveimage);
    }
   }
   else
   {
    imcopy(saveimage,&xsim);
   }
   err=greyscaleim(saveimage,xsim);
  }
  else
  {
   imcopy(saveimage,&xsim);
  }

  err=zoomim(xsim,&dim,xscale,yscale);
 
  if(rsz.rsmode==RESAMPLE)
  {
   dim->xdpi=rsz.newxdpi;
   dim->ydpi=rsz.newydpi;
  }

  if(epsi==PVTIFF)
  {
   tempbpp=epfs.fbpp;
   epfs.fbpp=MIN(8,epfs.fbpp);
  }

  err=reformatim(dim,&xsim,&epfs);

  if(epsi==PVTIFF)
  {
   epfs.fbpp=tempbpp;
  }

  if(err) imtrash(&dim);
  else
  if(epsi==PVTIFF)
  {
   /* save preview */
   err=sc_create(&sh);
   cprintf("save preview %s",sc_name(sh));

   if(!err) err=saveimagefile(sc_namex(sh),TIFFTYPE,xsim);

   report(err);

   imtrash(&xsim);
  }
 }

 if(!err) err=bf_open(name,'w',DEFBUFFSIZE,&bf);
 if(!err)
 {
  if(eppreview && epsi==PVTIFF)
  {
   memset(&epshdr,0,sizeof(epshdrstr));
   epshdr.magic=EPSMAGIC;

   fs_stat(sc_name(sh),&fx);

   epshdr.tiffstart=EPSHDRSIZE;
   epshdr.tifflength=fx.length;
   epshdr.psstart=epshdr.tiffstart+epshdr.tifflength;

   bf_write(&bf,&epshdr,EPSHDRSIZE);

   err=fs_open(sc_name(sh),'r',&fh);
   if(!err)
   {
    err=bf_copyn(&bf,fh,fx.length,NULL);
    fs_close(fh,err);
   }
  }


  if(!err)
  {
   xlo=0.0;
   ylo=0.0;
   xhi=((double)xpix*72.0)/((double)saveimage->xdpi);
   yhi=((double)ypix*72.0)/((double)saveimage->ydpi);


   bf_printf(&bf,"%%!PS-Adobe-3.0 EPSF-3.0\n");
   bf_printf(&bf,"%%%%Creator: DPScan\n");
   bf_printf(&bf,"%%%%Title: %s\n",fs_leaf(name));
   bf_printf(&bf,"%%%%Pages: 1\n");
   bf_printf(&bf,"%%%%BoundingBox: %d %d %d %d\n",(int)xlo,(int)ylo,
                                             (int)xhi,(int)yhi);
   bf_printf(&bf,"%%%%EndComments\n");
  }


  if(!err && eppreview && epsi==PVEPSI)
  {
   imsplitpalette(rtab,gtab,btab,xsim);

   depth=xsim->bpp;
   height=xsim->ypix;
   width=xsim->xpix;
   lines=((((width*depth+0x7)/8)*2)+77)/78;
   if(!lines) lines=1;

   mask=(1<<depth)-1;

   bf_printf(&bf,"%%%%BeginPreview %d %d %d %d\n",width,height,depth,lines);

   for(y=0;y<height;y++)
   {
    err=imfind1r(xsim,y,&idata);

    shift=32;
    posn1=0;
    shift2=0;
    sbyte=word=0;

    for(x=0;x<width;x++)
    {
     if(posn1==0)
     {
      bf_putc(&bf,'%');
      posn1++;
     }

     if(shift>=32) 
     {
      word=*idata++;
      shift=0;
     }
     sbyte|=((word>>shift)&mask)<<shift2;
     shift+=depth;
     shift2+=depth;

     if(shift2>=8)
     {
      bf_putc(&bf,xtab[rtab[sbyte]>>4]);
      bf_putc(&bf,xtab[rtab[sbyte] & 0xF]);
      posn1+=2;
      shift2=0;
      sbyte=0;

      if(posn1>=77)
      {
       bf_putc(&bf,'\n');
       posn1=0;
      }
     }
    }

    if(shift2)
    {
     bf_putc(&bf,xtab[rtab[sbyte]>>4]);
     bf_putc(&bf,xtab[rtab[sbyte] & 0xF]);
    }

    if(posn1>0)
    {
     bf_putc(&bf,'\n');
     posn1=0;
    }
   }

   imtrash(&xsim);

   bf_printf(&bf,"%%%%EndPreview\n");
  }


  bf_printf(&bf,"%%%%EndSetup\n");


  if(!err)   /* start main image */
  {
   word=0;   /* compiler */
   mask=0xFF;

   if(bpp<=8)
   {
    imsplitpalette(rtab,gtab,btab,saveimage);
    mask=(1<<bpp)-1;
   }

  
   if(epjpeg)
   {
    if(!sh)  err=sc_create(&sh);
    if(!err) err=saveimagefile(sc_namex(sh),JPEG,saveimage);

 /*   if(!err)
    bf_printf(&bf,"%%ImageData: %d %d 8 %d 0 1 5 \"beginimage\"\n",
                                                     xpix,ypix,grey?1:8); */

    bf_printf(&bf,"gsave\n");

    if(!grey)
    {
     bf_printf(&bf,"/hascolor\n");
     bf_printf(&bf,"/deviceinfo where\n");
     bf_printf(&bf,"{pop deviceinfo /Colors known\n");
     bf_printf(&bf,"{deviceinfo /Colors get exec 1 gt}\n");
     bf_printf(&bf,"{false} ifelse}\n");
     bf_printf(&bf,"{/statusdict where\n");
     bf_printf(&bf,"{pop statusdict /processcolors known\n");
     bf_printf(&bf,"{statusdict /processcolors get exec 1 gt}\n");
     bf_printf(&bf,"{false} ifelse}\n");
     bf_printf(&bf,"{false} ifelse}\n");
     bf_printf(&bf,"ifelse\n");
     bf_printf(&bf,"def\n");
    }

    bf_printf(&bf,"40 dict begin\n");
    bf_printf(&bf,"/_image systemdict /image get def\n");
    bf_printf(&bf,"/_setgray systemdict /setgray get def\n");
    bf_printf(&bf,"/_currentgray systemdict /currentgray get def\n");
    bf_printf(&bf,"/_settransfer systemdict /settransfer get def\n");
    bf_printf(&bf,"/_currenttransfer systemdict /currenttransfer get def\n");
    bf_printf(&bf,"/blank 0 _currenttransfer exec\n");
    bf_printf(&bf,"1 _currenttransfer exec eq def\n");
    bf_printf(&bf,"/negative blank\n");
    bf_printf(&bf,"{0 _currenttransfer exec 0.5 lt}\n");
    bf_printf(&bf,"{0 _currenttransfer exec 1 _currenttransfer exec gt}\n");
    bf_printf(&bf,"ifelse def\n");
    bf_printf(&bf,"/inverted? negative def\n");
    bf_printf(&bf,"/level2 systemdict /languagelevel known\n");
    bf_printf(&bf,"{languagelevel 2 ge} {false} ifelse def\n");
    bf_printf(&bf,"gsave\n");
    bf_printf(&bf,"/rows %d def\n",ypix);
    bf_printf(&bf,"/cols %d def\n",xpix);
    bf_printf(&bf,"%10.2f %10.2f translate\n",xlo,ylo);
    bf_printf(&bf,"%10.2f %10.2f scale\n",xhi-xlo,yhi-ylo);

    if(grey)
    {
     bf_printf(&bf,"level2 {\n");
     bf_printf(&bf,"/DeviceGray\n");
     bf_printf(&bf,"setcolorspace} if\n");
    }
    else
    {
     bf_printf(&bf,"level2 {\n");
     bf_printf(&bf,"[/CIEBasedABC 3 dict begin\n");
     bf_printf(&bf,"/DecodeLMN [{1.8 exp} bind dup dup] def\n");
     bf_printf(&bf,"/MatrixLMN [\n");
     bf_printf(&bf,"0.3811 0.2073 0.0213\n");
     bf_printf(&bf,"0.3203 0.6805 0.143\n");
     bf_printf(&bf,"0.2484 0.1122 1.2417\n");
     bf_printf(&bf,"] def\n");
     bf_printf(&bf,"/WhitePoint [0.9497 1 1.406] def\n");
     bf_printf(&bf,"currentdict end]\n");
     bf_printf(&bf,"setcolorspace} if\n");
    }

    bf_printf(&bf,"/beginimage level2\n");
    bf_printf(&bf,"{/image load def}\n");
    bf_printf(&bf,"{{pop .9 setgray 0 0 moveto 0 1 lineto\n");
    bf_printf(&bf,"1 1 lineto 1 0 lineto fill 0 setgray\n");
    bf_printf(&bf,"0 1 translate 1 cols div 1 rows div scale\n");
    bf_printf(&bf,"/ratio {cols 400 div mul} def\n");
    bf_printf(&bf,"/Helvetica findfont 15 ratio scalefont setfont\n");
    bf_printf(&bf,"5 ratio -20 ratio moveto\n");
    bf_printf(&bf,"(JPEG encoded image needs PostScript Level 2) show\n");
    bf_printf(&bf,"/x 128 string def\n");
    bf_printf(&bf,"{currentfile x readline {} {pop exit} ifelse\n");
    bf_printf(&bf,"(~>) search {pop pop pop exit} {pop} ifelse\n");
    bf_printf(&bf,"} loop } def}\n");
    bf_printf(&bf,"ifelse\n");
    bf_printf(&bf,"12 dict begin\n");
    bf_printf(&bf,"/ImageType 1 def\n");
    bf_printf(&bf,"/Width cols def\n");
    bf_printf(&bf,"/Height rows def\n");
    bf_printf(&bf,"/ImageMatrix [cols 0 0 rows neg 0 rows] def\n");
    bf_printf(&bf,"/BitsPerComponent 8 def\n");

    if(grey)
    {
     bf_printf(&bf,"/Decode [0 1] def\n");
    }
    else
    {
     bf_printf(&bf,"/Decode [0 1 0 1 0 1] def\n");
    }

    bf_printf(&bf,"/DataSource currentfile /ASCII85Decode filter\n");
    bf_printf(&bf,"/DCTDecode filter def\n");
    bf_printf(&bf,"currentdict end\n");

    bf_tell(&bf,&posn1);
    bf_printf(&bf,"%%%%BeginBinary: %10d\n",0);
    bf_tell(&bf,&posn2);
    bf_printf(&bf,"beginimage\n");

    err=epsbase85codefile(&bf,sh);
    bf_tell(&bf,&posn3);


    bf_seek(&bf,posn1);
    bf_printf(&bf,"%%%%BeginBinary: %10d\n",posn3-posn2);
    bf_seek(&bf,posn3);

    bf_printf(&bf,"%%%%EndBinary\n");
    bf_printf(&bf,"grestore end\n");
    bf_printf(&bf,"grestore\n");
   }
   else
   if(grey)
   {
    bf_printf(&bf,"/readstring {\n");
    bf_printf(&bf,"  currentfile exch readhexstring pop\n");
    bf_printf(&bf,"} bind def\n");
    bf_printf(&bf,"/picstr %d string def\n",xpix);
    bf_printf(&bf,"%%EndProlog\n");
    bf_printf(&bf,"gsave\n");

    bf_printf(&bf,"%10.2f %10.2f translate\n",xlo,ylo);
    bf_printf(&bf,"%10.2f %10.2f scale\n",xhi-xlo,yhi-ylo);

    bf_printf(&bf,"%d %d %d\n",xpix,ypix,(bpp==1)?1:8);
    bf_printf(&bf,"[%d 0 0 -%d 0 %d]\n",xpix,ypix,ypix);
    bf_printf(&bf,"{picstr readstring}\n");
    bf_printf(&bf,"image\n");


    if(bpp==1)
    {
     if(rtab[1]<128) bitflip=0xFF;
     else            bitflip=0;
    }
    else bitflip=0;  /* compiler */


    for(y=0;y<ypix;y++)
    {
     err=imfind1r(saveimage,y,&idata);

     shift=32;

     if(bpp==1)
     {
      p=(char*)idata;
    
      for(x=0;x<xpix;x+=8)
      {
       xbyte=bitrev[*p++]^bitflip;
       bf_putc(&bf,xtab[xbyte >>  4]);
       bf_putc(&bf,xtab[xbyte & 0xF]);
      }
     }
     else
     {
      for(x=0;x<xpix;x++)
      {
       if(shift>=32) 
       {
        word=*idata++;
        shift=0;
       }
       sbyte=(word>>shift)&mask;
       shift+=bpp;
       bf_putc(&bf,xtab[rtab[sbyte]>>4]);
       bf_putc(&bf,xtab[rtab[sbyte] & 0xF]);
      }
     }

     bf_putc(&bf,'\n');
    }


    bf_printf(&bf,"grestore\n");
   }
   else
   {
    bf_printf(&bf,"/readstring {\n");
    bf_printf(&bf,"  currentfile exch readhexstring pop\n");
    bf_printf(&bf,"} bind def\n");
    bf_printf(&bf,"/picstr %d string def\n",((palclass==CL_CMYK)?4:3)*xpix);
    bf_printf(&bf,"%%EndProlog\n");
    bf_printf(&bf,"gsave\n");

    bf_printf(&bf,"%10.2f %10.2f translate\n",xlo,ylo);
    bf_printf(&bf,"%10.2f %10.2f scale\n",xhi-xlo,yhi-ylo);

    bf_printf(&bf,"%d %d 8\n",xpix,ypix);
    bf_printf(&bf,"[%d 0 0 -%d 0 %d]\n",xpix,ypix,ypix);
    bf_printf(&bf,"{picstr readstring}\n");
    bf_printf(&bf,"false %d\n",(palclass==CL_CMYK)?4:3);
    bf_printf(&bf,"colorimage\n");

    for(y=0;y<ypix;y++)
    {
     err=imfind1r(saveimage,y,&idata);
     if(err) break;

     if(bpp<=8)
     {
      shift=32;

      for(x=0;x<xpix;x++)
      {
       if(shift>=32) 
       {
        word=*idata++;
        shift=0;
       }
       sbyte=(word>>shift)&mask;
       shift+=bpp;
       bf_putc(&bf,xtab[rtab[sbyte]>>4]);
       bf_putc(&bf,xtab[rtab[sbyte] & 0xF]);

       bf_putc(&bf,xtab[gtab[sbyte]>>4]);
       bf_putc(&bf,xtab[gtab[sbyte] & 0xF]);

       bf_putc(&bf,xtab[btab[sbyte]>>4]);
       bf_putc(&bf,xtab[btab[sbyte] & 0xF]);
      }
     }
     else
     if(bpp==24)
     {
      p=(char*)idata;
    
      for(x=0;x<xpix;x++)
      {
       xbyte=*p++;
       bf_putc(&bf,xtab[xbyte >> 4]);
       bf_putc(&bf,xtab[xbyte & 0xF]);

       xbyte=*p++;
       bf_putc(&bf,xtab[xbyte >> 4]);
       bf_putc(&bf,xtab[xbyte & 0xF]);

       xbyte=*p++;
       bf_putc(&bf,xtab[xbyte >> 4]);
       bf_putc(&bf,xtab[xbyte & 0xF]);
      }

      if(err) break;
     }
     else
     if(bpp==16)
     {
      shift=32;
      mask=0x7FFF;

      for(x=0;x<xpix;x++)
      {
       if(shift==32)
       {
        word=*idata++;
        shift=0;
       }
       sbyte=(word>>shift)&mask;
       shift+=bpp;

       xbyte=(sbyte<<3)&0xF8;
       bf_putc(&bf,xtab[xbyte>>4]);
       bf_putc(&bf,xtab[xbyte&0xF]);
     
       xbyte=(sbyte>>2)&0xF8;
       bf_putc(&bf,xtab[xbyte>>4]);
       bf_putc(&bf,xtab[xbyte&0xF]);

       xbyte=(sbyte>>7)&0xF8;
       bf_putc(&bf,xtab[xbyte>>4]);
       bf_putc(&bf,xtab[xbyte&0xF]);
      }
     }
     else
     if(saveimage->bpp==32)
     {
      for(x=0;x<xpix;x++)
      {
       word=*idata++;

       xbyte=(word)&0xFF;
       bf_putc(&bf,xtab[xbyte>>4]);
       bf_putc(&bf,xtab[xbyte&0xF]);

       xbyte=(word>>8)&0xFF;
       bf_putc(&bf,xtab[xbyte>>4]);
       bf_putc(&bf,xtab[xbyte&0xF]);

       xbyte=(word>>16)&0xFF;
       bf_putc(&bf,xtab[xbyte>>4]);
       bf_putc(&bf,xtab[xbyte&0xF]);

       if(palclass==CL_CMYK)
       {
        xbyte=(word>>24)&0xFF;
        bf_putc(&bf,xtab[xbyte>>4]);
        bf_putc(&bf,xtab[xbyte&0xF]);
       }

       if(err) break;
      }
     }
     if(err) break;

     bf_putc(&bf,'\n');
    }
    bf_printf(&bf,"grestore\n");
   }

   bf_printf(&bf,"showpage\n");
   bf_printf(&bf,"%%%%Trailer\n");
  }

  if(!err && eppreview && epsi==PVTIFF)
  {
   bf_tell(&bf,&fposn);
   epshdr.pslength=fposn-epshdr.psstart;

   p=(char*)&epshdr;

   for(x=0;x<EPSHDRSIZE;x++)
   {
    epshdr.checksum^=*p++;
   }

   epshdr.checksum=-1;  /* ignore */

   bf_seek(&bf,0);
   bf_write(&bf,&epshdr,EPSHDRSIZE);
  }

  err=bf_closec(&bf,err,name,type);
 }


 if(sh)
 {
  fs_delete(sc_name(sh));
  err=sc_remove(sh,err);
 }

 return(err);
}


/*****************************************************************************/



static int bits(int xcase)
{


 return(0);

 USE(xcase);
}


static os_error * configloaded(int eventn,uservalue userhandle,
                                                        void * data,int data1)
{


 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  eppreview=teppreview;
  epsi=tepsi;
  epjpeg=tepjpeg;
  rsz=trsz;
  epfs=tepfs;
 }

 return(err);
}




static os_error * crszfn(resizestr * rsz)
{
 trsz=*rsz;
 dbchangevalue(&trsz.rsmode,&configbox);
 return(NULL);
}




static os_error * cfsfn(formatstr * fsp)
{
 tepfs=*fsp;
 dbchangevalue(&tepfs.fpal,&configbox);
 return(NULL);
}




static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 10:
          err=resizewindow(&trsz,crszfn,handle);
          break;

  case 15:
          err=formatwindow(&tepfs,cfsfn,handle);
          break;


 }


 return(err);

 USE(userhandle);
 USE(handle);
}




static os_error * wrf(int value,char * string)
{
 return(formatsummary(string,&tepfs));
 USE(value);
}



static os_error * wrsz(int value,char * string)
{
 return(resizesummary(&trsz,string));
 USE(value);
}




static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
    9, &teppreview,  DBTOGGLE, 0,   0,      1, F1,  0, 0, NULL, 0,
    8, &tepjpeg,     DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
   16, &tepsi,       DBRADIO,  0,   0,      1, F3,  1, 0, NULL, 0,
   19, &tepsi,       DBRADIO,  0,   0,      2, F3,  1, 0, NULL, 0,
   14, &tepfs.fpal,  DBTEXT,   0,   0,      0,  0, 0, 0,         NULL,wrf,
   12, &trsz.rsmode, DBTEXT,   0,   0,      0,  0, 0, 0,         NULL,wrsz,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TEPS,
 DBFIX,
 DBGRAB,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);

 tepjpeg=epjpeg;
 teppreview=eppreview;
 tepsi=epsi;
 trsz=rsz;
 tepfs=epfs;

 err=dodboxparent(&configbox,1,parent);


 return(err);
}

/*****************************************************************************/



static ftypestr ftype=
{
 EPS,             /* file type  */
 0,               /* flags      */
 loadeps,         /* load       */
 loadfilepost,    /* loadpost   */
 "{EPS}",         /* name       */
 "{EPSF}",        /* type name  */
 saveeps,         /* save       */
 config,          /* configure  */
 0,               /* icon       */
 bits,            /* bit flags  */
 NULL,            /* get frame  */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,            /* save info  */


 NULL,            /* saveim */
 "eps\0",         /* extension */

 "Encapsulated PostScript (*.eps)",/* description */
};



static contag contable[]=
{
 "JPEG",CONINT,&epjpeg,NULL,NULL,
 "Preview",CONINT,&eppreview,NULL,NULL,
 "EPSI",CONINT,&epsi,NULL,NULL,

 "Bpp",CONINT,&epfs.fbpp,NULL,NULL,
 "Palette",CONINT,&epfs.fpal,NULL,NULL,
 "Dither",CONINT,&epfs.fdith,NULL,NULL,
 "Simple",CONINT,&epfs.fssimple,NULL,NULL,
 "ZigZag",CONINT,&epfs.fszigzag,NULL,NULL,
 "Exact",CONINT,&epfs.fsexact,NULL,NULL,

 "Resize",CONINT,&rsz.rsmode,NULL,NULL,
 "Width",CONINT,&rsz.neww,NULL,NULL,
 "Height",CONINT,&rsz.newh,NULL,NULL,
 "XRes",CONINT,&rsz.newxdpi,NULL,NULL,
 "YRes",CONINT,&rsz.newydpi,NULL,NULL,
 "Aspect",CONINT,&rsz.lockar,NULL,NULL,
 "ResizeBy",CONINT,&rsz.rsby,NULL,NULL,
// "YResize",CONINT,&rsz.resizebyy,NULL,NULL,

 NULL,0,NULL,NULL,NULL
};





static conlink configlink=
{
 "EPS",
 NULL,
 NULL
};



os_error * epsinit(void)
{
 os_error * err;

 err=registerfiletype(&ftype);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);
 }

 return(err);
}


