/*->c.edit */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "akbd.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "filetype.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "config.h"
#include "oscbx.h"
#include "deb.h"
#include "ram.h"
#include "dbhi.h"



#include "resource.h"

#include "str.h"
#include "constants.h"
#include "reslink.h"

#include "view.h"
#include "viewr.h"
#include "file.h"

#include "im.h"
#include "bm.h"
#include "resize.h"
#include "select.h"
#include "long.h"
#include "undo.h"
#include "cms.h"


#include "edit.h"


/**************************************************************************/
/* routine to support modifying files */

os_error * modifyview(viewstr * view)
{
 event(EVENT_FRAMEMODDED,view,0);

 return(NULL);
}

os_error * modifypal(viewstr * view)
{
 event(EVENT_FRAMEPALMODDED,view,0);

 return(NULL);
}

os_error * modifyres(viewstr * view)
{
 event(EVENT_FRAMERESMODDED,view,0);

 return(NULL);
}

/***************************************************************************/



static os_error * fliphorizontal(filestr * file,viewstr * view)
{
 os_error  * err;
 imagestr  * sim;
 ximagestr * sxim;
 ximagestr * dxim;



 err=NULL;

 if(file->frames && file->framen)
 {
  sxim=file->frames[view->frame].xim;
  sim=(sxim->sim[IM]);

  longprocstart(NULL,0,sim->ypix,view);

  err=viewdeleteimagefileframe(file,view->frame);

  if(!err)
  {
   undostart(sxim);

   if(undosteps) err=ximcopy(sxim,&dxim);
   else          dxim=sxim;

   if(!err)
   {
             err=flipimageh(dxim->sim[IM]);
    if(!err) err=flipimageh(dxim->sim[AL]);

    if(undosteps)
    {
     if(err) ximtrash(&dxim);
     else
     {
      undolink(sxim,dxim);
      file->frames[view->frame].xim=dxim;
     }
    }
   }

   viewcreateimagefileframe(file,view->frame);
   refreshviewfileframe(file,view->frame);

   longprocend();

   modifyview(view);
  }
 }

 return(err);
}



static os_error * flipvertical(filestr * file,viewstr * view)
{
 os_error  * err;
 imagestr  * sim;
 ximagestr * sxim;
 ximagestr * dxim;


 err=NULL;

 if(file->frames && file->framen)
 {
  sxim=file->frames[view->frame].xim;
  sim=(sxim->sim[IM]);

  longprocstart(NULL,0,sim->ypix,view);

  err=viewdeleteimagefileframe(file,view->frame);
  if(!err)
  {
   undostart(sxim);

   if(undosteps) err=ximcopy(sxim,&dxim);
   else          dxim=sxim;

   if(!err)
   {
             err=flipimagev(dxim->sim[IM]);
    if(!err) err=flipimagev(dxim->sim[AL]);

    if(undosteps)
    {
     if(err) ximtrash(&dxim);
     else
     {
      undolink(sxim,dxim);
      file->frames[view->frame].xim=dxim;
     }
    }
   }


   viewcreateimagefileframe(file,view->frame);
   refreshviewfileframe(file,view->frame);

   longprocend();

   modifyview(view);
  }
 }

 return(err);
}






static os_error * crop(filestr * file,viewstr * view)
{
 os_error  * err;
 boxstr      area;
 imagestr  * dim;
 imagestr  * sim;
 imagestr  * mim;
 ximagestr * dxim;
 ximagestr * sxim;
 framestr  * frames;


 err=NULL;


 if(file->frames && file->framen)
 {
  if(!croparea(view,&area))
  {
   frames=&file->frames[view->frame];
   sxim=frames->xim;
   sim=(sxim->sim[IM]);
   mim=(sxim->sim[AL]);

   longprocstart(NULL,0,area.h,view);

   err=viewdeleteimagefileframe(file,view->frame);
   if(!err)
   {
    undostart(sxim);

    err=ximnew2(area.w,area.h,sim->bpp,mim?mim->bpp:0,&dxim);
    if(!err)
    {
     dim=(dxim->sim[IM]);

     dim->xdpi=sim->xdpi;
     dim->ydpi=sim->ydpi;
     dim->ipal=sim->ipal;
     dim->tr=sim->tr;

     cmscopyprofile(dim,sim);

     err=cropim(sim,dim,&area);

     if(!err && mim)
     {
      dim=(dxim->sim[AL]);

      dim->xdpi=mim->xdpi;
      dim->ydpi=mim->ydpi;
      dim->ipal=mim->ipal;
      dim->tr=mim->tr;

      err=cropim(mim,dim,&area);

      dim=(dxim->sim[IM]);
     }

     if(err) ximtrash(&dxim);
     else
     {
      if(undosteps) undolink(sxim,dxim);
      else          ximtrash(&sxim);

      frames->xim=dxim;
      dim->tr.e+=(area.x*72000+35999)/dim->xdpi;
      dim->tr.f+=(area.y*72000+35999)/dim->ydpi;
     }
    }

    viewcreateimagefileframe(file,view->frame);
    refreshviewfileframe(file,view->frame);

    longprocend();

    modifyview(view);
   }
  }
 }
 return(err);
}



static os_error * extend(filestr * file,viewstr * view)
{
 os_error   * err;
 boxstr       area;
 imagestr   * dim;
 imagestr   * sim;
 ximagestr  * dxim;
 ximagestr  * sxim;
 framestr   * frames;

 err=NULL;

 if(file->frames && file->framen)
 {
  if(!extendarea(view,&area))
  {
   frames=&file->frames[view->frame];
   sxim=frames->xim;
   sim=(sxim->sim[IM]);

   longprocstart(NULL,0,area.h,view);

   err=viewdeleteimagefileframe(file,view->frame);
   if(!err)
   {
    undostart(sxim);

    err=extendim(sxim,&dxim,&area);

    if(!err)
    {
     if(undosteps) undolink(sxim,dxim);
     else          ximtrash(&sxim);
 
     frames->xim=dxim;

     dim=(dxim->sim[IM]);

     dim->tr.e+=(area.x*72000+35999)/dim->xdpi;
     dim->tr.f+=(area.y*72000+35999)/dim->ydpi;
    }
   }
   viewcreateimagefileframe(file,view->frame);
   refreshviewfileframe(file,view->frame);

   longprocend();

   modifyview(view);
  }
 }
 return(err);
}



/*****************************************************************************/


static os_error * cbrender(int format)
{
	os_error * err;
 void     * data;
 void     * global;
 int        length=0;

 err=ramnextwritefile(&data,&length);
	if(!err)
	{
		err=savefilex("xxx",DIB);
 	if(!err)
		{
   oscballoc((void**)&global,length);
   memcpy(global,data,length);
		}
  ramwriteoff();
	}

	cprintf("cbrender %d",length);

 return(err);
}



static os_error * cbempty(void)
{
 os_error * err;

 err=NULL;

 return(err);
}



static int formats[2]=
{
	CF_DIB,
	0
};


os_error * cbcopy(void)
{
	os_error * err;

	err=NULL;

 if(menufile->frames!=NULL)
	{
	 err=oscbcopy(formats,cbrender,cbempty,OSCB_IMMEDIATE); 
	}

 return(err);
}





static os_error * importpaste(void * data,int length)
{
 os_error * err;

 cprintf("import paste length %d",length);

 err=ramnextreadfile(data,length);
	if(!err)
	{
           err=loaddocv("Clipboard",DIB,(uservalue)menuview,1);
  if(!err) err=loaddocpostv((uservalue)menuview);

  ramreadoff();
	}
	
 return(err);
}



os_error * cbpaste(void)
{
	os_error * err;

	cprintf("cbpaste");

 err=oscbpaste(CF_DIB,importpaste);

 return(err);
}





os_error * editsetup(void)
{
 int unshade;


 unshade=(menufile->frames && menufile->framen);

	cprintf("unshade %d",unshade);

	unshademenust(MEDIT,ID_EDIT_FLIPHORIZONTAL,unshade);
	unshademenust(MEDIT,ID_EDIT_FLIPVERTICAL,unshade);
	unshademenust(MEDIT,ID_EDIT_ROTATE,unshade);
	unshademenust(MEDIT,ID_EDIT_SKEW,unshade);
	unshademenust(MEDIT,ID_EDIT_RESIZE,unshade);
	unshademenust(MEDIT,ID_EDIT_CROP,unshade);
	unshademenust(MEDIT,ID_EDIT_EXTEND,unshade);
	unshademenust(MEDIT,ID_EDIT_COPYX,unshade);
//	unshademenust(MEDIT,ID_EDIT_PASTEX,unshade);


 unshademenust(MEDIT,ID_EDIT_UNDOX,imagecanundo());
 unshademenust(MEDIT,ID_EDIT_REDOX,imagecanredo());


 return(NULL);
}




os_error * editdecode(int * menu)
{
 os_error * err;

 err=NULL;



 switch(menu[0])
 {

  case ID_EDIT_FLIPHORIZONTAL:
         err=fliphorizontal(menufile,menuview);
         break;

  case ID_EDIT_FLIPVERTICAL:
         err=flipvertical(menufile,menuview);
         break;

  case ID_EDIT_ROTATE:
         err=rotateopen(menuview->handle);
         break;

  case ID_EDIT_SKEW:
         err=skewopen(menuview->handle);
         break;

  case ID_EDIT_RESIZE:
         err=resizeopen(menuview->handle);
         break;


  case ID_EDIT_CROP:
         err=crop(menufile,menuview);
         break;

  case ID_EDIT_EXTEND:
         err=extend(menufile,menuview);
         break;

  case ID_EDIT_UNDOX:
         err=imageundo();
         break;

  case ID_EDIT_REDOX:
         err=imageredo();
         break;

		case	ID_EDIT_COPYX:
									err=cbcopy();
									break;

		case	ID_EDIT_PASTEX:
									err=cbpaste();
									break;

 }

 return(err);
}



os_error * editdynamic(int * menu,char * handle)
{
 os_error * err;

 err=NULL;

 switch(menu[0])
 {
	  case -1:
          err=editsetup();
          break;
 }

 return(err);

 USE(handle);
}




os_error * editinit(void)
{
	os_error * err;

	err=oscbinit(0);

	return(err);
}

