/*->c.draw */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "xmath.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"
#include "scrap.h"


#include "constants.h"
#include "str.h"
#include "reslink.h"

#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "units.h"
#include "resize.h"
#include "format.h"
#include "filter.h"
#include "bm.h"


#include "asprite.h"

#include "draw.h"


extern ftypestr ftype;
extern dboxstr  configbox;


#ifdef NEVER


typedef enum
{
  draw_OBJFONTLIST   =0,
  draw_OBJTEXT       =1,
  draw_OBJPATH       =2,
  draw_OBJRECT       =3,
  draw_OBJELLI       =4,
  draw_OBJSPRITE     =5,
  draw_OBJGROUP      =6,
  draw_OBJTAGG       =7, 
  draw_OBJTEXTAREA   =9,
  draw_OBJTEXTCOL    =10,
  draw_OBJOPTIONS    =11,
  draw_OBJTRANSTEXT  =12,
  draw_OBJTRANSSPRITE=13,
  draw_OBJTRANSJPEG  =16,

  /* Vector extensions */

  draw_OBJLIB        =100,
  draw_OBJSET        =101,
  draw_OBJSIMREP     =102,
  draw_OBJGENREP     =103,
  draw_OBJGENINST    =104,
  draw_OBJMASK       =105,
  draw_OBJRADIATE    =106,
  draw_OBJSIMSKEL    =107,
  draw_OBJGENSKEL    =108


} draw_tagtyp;


#endif



#define draw_OBJSPRITE 5
#define draw_OBJTRANSSPRITE 13


#define DHEADERSIZE 40



static os_error * loaddraw(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error    * err;
 buffer        bf;
 int           n;
 int           size;
 int           otype;
 int           fn;
 int           i;
 newsprite_header sph;
 int           offset;
 int           coords[4];


 err=bf_open(name,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  bf_seek(&bf,DHEADERSIZE);

  i=0;

  while(1)
  {
   err=bf_readn(&bf,&otype,sizeof(int),&n);
   if(err || n==0) break;
   err=bf_read(&bf,&size,sizeof(int));
   if(err) break;

  /* dprintf(0,"type=%x size=%d",otype,size);  */

   if(otype==draw_OBJSPRITE || otype==draw_OBJTRANSSPRITE)
   {
    err=addframe(loadfile,&fn,0);
    if(err) break;

    bf_tell(&bf,&offset);

    loadfile->frames[fn].offset=offset+4*sizeof(int);

    err=bf_read(&bf,coords,4*sizeof(int));

    if(otype==draw_OBJTRANSSPRITE)
    {
     bf_seekrel(&bf,6*sizeof(int));
     loadfile->frames[fn].offset+=6*sizeof(int);
    }

    err=bf_read(&bf,&sph,sizeof(sprite_header));
    if(err) break;


    loadfile->frames[fn].xim=NULL;

    err=spreadhdr(fn,&bf,&sph);
    if(err) break;

    loadfile->frames[fn].fxdpi=
               scale(loadfile->frames[fn].fxpix,256*180,coords[2]-coords[0]);
    loadfile->frames[fn].fydpi=
               scale(loadfile->frames[fn].fypix,256*180,coords[3]-coords[1]);

    if(i==0)
    {
     err=sploadframe(loadfile,&bf,&sph,fn);
     if(err) break;
    }

    bf_seek(&bf,offset+size-2*sizeof(int));
    i++;
   }
   else
   {
    bf_seekrel(&bf,size-2*sizeof(int));
   }

  }
  err=bf_close(&bf,err);
  if(!err && i==0) err=geterror(ED00);
 }

 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}





static os_error * getframe(filestr * file,int fn)
{
 os_error    * err;
 buffer        bf;
 newsprite_header sph;

 err=bf_open(file->oname,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
           err=bf_seek(&bf,file->frames[fn].offset);
  if(!err) err=bf_read(&bf,&sph,sizeof(newsprite_header));
  if(!err) err=spreadhdr(fn,&bf,&sph);
  if(!err) err=sploadframe(loadfile,&bf,&sph,fn);

  err=bf_close(&bf,err);
 }
 return(err);
}




static os_error * loadfilepost(uservalue userhandle)
{
 return(NULL);

 USE(userhandle);
}




 
 


static os_error * savedraw(char * name,int type)
{
 os_error * err;

 err=savespritesub(name,type,1); 

 return(err);
}


/*****************************************************************************/


static int tdbl;
static int dbl;


static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}



static os_error * configloaded(int eventn,uservalue userhandle,
                                                        void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {

  dbl=ftypegetrun(&ftype);

//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
 }

 return(err);
}





static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}







static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TDRAW,
 DBFIX,
 DBGRAB,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);

 tdbl=dbl;
 err=dodboxparent(&configbox,1,parent);


 return(err);
}

/*****************************************************************************/



static ftypestr ftype=
{
 DRAW,            /* file type  */
 0,               /* flags      */
 loaddraw,        /* load       */
 loadfilepost,    /* loadpost   */
 "{DRAW}",        /* name       */
 "{DRAWF}",       /* type name  */
 savedraw,        /* save       */
 config,          /* configure  */
 0,               /* icon       */
 bits,            /* bit flags  */
 getframe,        /* get frame  */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,            /* save info  */


 NULL,            /* saveim */
 "aff\0""drw\0",  /* extension */

 "RISC OS/Acorn Draw File (*.aff)",/* description */
};




static contag contable[4]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "Draw",
 NULL,
 NULL
};




os_error * drawinit(void)
{
 os_error * err;

 err=registerfiletype(&ftype);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);
 }

 return(err);
}


