/*->c.cx */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <time.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "deb.h"
#include "dbhi.h"


#include "str.h"
#include "constants.h"

#include "reslink.h"

#include "file.h"
#include "view.h"

#include "im.h"
#include "cmap.h"
#include "cms.h"


#include "cx.h"







/*****************************************************************************/
/* scale, no dither */

static os_error * convert10(imagestr * dest,imagestr * src,int sl,int el,
                                                            int xmag,int ymag)
{
 os_error * err;
 int        yd;
 int        ys;
 int        xs;
 int        xd;
 int      * ddata;
 int      * sdata;
 char     * sdatab;
 char     * ddatab;
 int        dword;
 int        dshift;
 int        dbpp;
 int        sbpp;
 int        sshift;
 int        sbshift;
 int        sbmask;
 int        smask;
 int        sbyte;
 int        i;
 int        dxpix;
 int        dypix;
 int        sxpix;
 int        sypix;
 int        ex;
 int        mappal;
 unsigned int w;
 char       palmaptab[256];
 int        lasty;

 makecmap(dest->ipal.ncolours,dest->ipal.word,4,rgbmap);

 err=NULL;

 dbpp=dest->bpp;
 dxpix=dest->xpix;
 dypix=dest->ypix;

 sbpp=src->bpp;
 sxpix=src->xpix;
 sypix=src->ypix;


 mappal=1;
 if(sbpp==dbpp)
 {
  if(sbpp<=8)
  {
   for(i=0;i<dest->ipal.ncolours;i++)
   {
    if(dest->ipal.word[i]!=src->ipal.word[i]) break;
   }
   if(i>=dest->ipal.ncolours) mappal=0;
  }
  else mappal=0;
 }



 if(sbpp<=8)
 {

#ifdef NEVER
  for(i=0;i<src->ipal.ncolours;i++)
  {
   sbyte=src->ipal.word[i]; /* rgb */
   sbyte=((sbyte>>4) & 0xF00)|
        ((sbyte>>16) & 0xF0)|
        ((sbyte>>28) & 0xF);

   palmaptab[i]=rgbmap[sbyte];
  }
#endif

  palmapf(src->ipal.ncolours,src->ipal.word,dest->ipal.ncolours,dest->ipal.word,palmaptab);

 }

/* dprintf(0,"xmag=%x ymag=%x",xmag,ymag); */


 /* put this here to make compiler happy */

 if(sbpp==1) {sbshift=3;sbmask=0x7;smask=0x1;sbyte=0;}
 else
 if(sbpp==2) {sbshift=2;sbmask=0x3;smask=0x3;sbyte=0;}
 else
 if(sbpp==4) {sbshift=1;sbmask=0x1;smask=0xF;sbyte=0;}
 else /* if(sbpp==8) */ {sbshift=0;sbmask=0x0;smask=0xFF;sbyte=0;}


 lasty=-1;

 for(yd=sl;yd<el;yd++) /* scan dest bitmap */
 {
  ys=scale(yd,0x10000,ymag);
  if(ys>=sypix) ys=sypix-1;

  if(ys==lasty)
  {
   err=imfind2rw(dest,yd-1,&sdata,dest,yd,&ddata);
   if(err) break;
   memcpy(ddata,sdata,dest->wwidth*sizeof(int));
   continue;                                      /* !!!!!! */
  }
  lasty=ys;

  err=imfind2rw(src,ys,&sdata,dest,yd,&ddata);
  if(err) break;

  dshift=0;
  dword=0;

  xs=0;
  ex=-xmag;

  sdatab=(char*)sdata;
  ddatab=(char*)ddata;

  if(sbpp==16)
  {
   sshift=0;
   w=*sdata++;

   for(xd=0;xd<dxpix;xd++)
   {
    sbyte=w>>sshift;
    sbyte=rgbmap[((sbyte&0x1E)<<7)|((sbyte&0x3C0)>>2)|((sbyte&0x7800)>>11)];

    dword|=(sbyte<<dshift);
    dshift+=dbpp;
    if(dshift==32)
    {
     *ddata++=dword;
     dshift=0;
     dword=0;
    }

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sshift+=16;
     if(sshift>=32)
     {
      w=*sdata++;
      sshift=0;
     }
    }
   }
   *ddata=dword;
  }
  else
  if(sbpp==32)
  {
   for(xd=0;xd<dxpix;xd++)
   {
    sbyte =((*(sdatab+0))<<4)&0xF00;  /* cut down 24 bit rgb */
    sbyte|=((*(sdatab+1))) & 0xF0;
    sbyte|=((*(sdatab+2)))>>4;
    sbyte=rgbmap[sbyte];

    dword|=(sbyte<<dshift);
    dshift+=dbpp;
    if(dshift==32)
    {
     *ddata++=dword;
     dshift=0;
     dword=0;
    }

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sdatab+=4;
    }
   }
   if(dshift) *ddata=dword;
  }
  else
  if(sbpp==24)
  {
   for(xd=0;xd<dxpix;xd++)
   {
    sbyte =((*(sdatab+0))<<4)&0xF00;  /* cut down 24 bit rgb */
    sbyte|=((*(sdatab+1))) & 0xF0;
    sbyte|=((*(sdatab+2)))>>4;

    sbyte=rgbmap[sbyte];

    dword|=(sbyte<<dshift);
    dshift+=dbpp;
    if(dshift==32)
    {
     *ddata++=dword;
     dshift=0;
     dword=0;
    }

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sdatab+=3;
    }
   }
   if(dshift) *ddata=dword;
  }
  else   /* not 24bpp */
  {
   if(sbpp==8 && dbpp==8)
   {
    if(mappal)
    {
     for(xd=0;xd<dxpix;xd++)
     {
      *ddatab++=palmaptab[*sdatab];

      ex+=0x10000;
      while(ex>=0)
      {
       ex-=xmag;
       sdatab++;
      }
     }
    }
    else   /* 8bpp and no palette mapping */
    {
     for(xd=0;xd<dxpix;xd++)
     {
      *ddatab++=*sdatab;

      ex+=0x10000;
      while(ex>=0)
      {
       ex-=xmag;
       sdatab++;
      }
     }
    }
   }
   else  /* not 8bpp -> 8bpp */
   {
    for(xd=0;xd<dxpix;xd++)
    {
     sbyte=*(((char*)sdata)+(xs>>sbshift));
     sbyte=sbyte>>((xs & sbmask)*sbpp);
     sbyte&=smask;

     sbyte=palmaptab[sbyte];
  
     dword|=(sbyte<<dshift);
     dshift+=dbpp;
     if(dshift==32)
     {
      *ddata++=dword;
      dshift=0;
      dword=0;
     }

     ex+=0x10000;
     while(ex>=0)
     {
      ex-=xmag;
      xs++;
     }
    }
    if(dshift) *ddata=dword;
   }
  }
 }
 return(err);
}






static os_error * convert10g(imagestr * dest,imagestr * src,int sl,int el,
                                    int xmag,int ymag,char * gtab)
{
 os_error * err;
 int        yd;
 int        ys;
 int        xs;
 int        xd;
 int      * ddata;
 int      * sdata;
 char     * sdatab;
 char     * ddatab;
 int        dword;
 int        dshift;
 int        dbpp;
 int        sbpp;
 int        sbshift;
 int        sbmask;
 int        smask;
 int        sbyte;
 int        i;
 int        dxpix;
 int        dypix;
 int        sxpix;
 int        sypix;
 int        ex;
 int        mappal;
 char       palmaptab[256];
 int        lasty=-1;


 err=NULL;

 dbpp=dest->bpp;
 dxpix=dest->xpix;
 dypix=dest->ypix;

 sbpp=src->bpp;
 sxpix=src->xpix;
 sypix=src->ypix;


 mappal=1;
 if(sbpp==dbpp)
 {
  if(sbpp<=8)
  {
   for(i=0;i<dest->ipal.ncolours;i++)
     if(dest->ipal.word[i]!=src->ipal.word[i]) break;
   if(i>=dest->ipal.ncolours) mappal=0;
  }
  else mappal=0;
 }

 if(sbpp<=8)
 {
  for(i=0;i<src->ipal.ncolours;i++)
  {
   sbyte=(src->ipal.word[i]>>8)&0xFF; /* rgb */
   palmaptab[i]=gtab[sbyte];
  }
 }


 /* put this here to make compiler happy */

 if(sbpp==1) {sbshift=3;sbmask=0x7;smask=0x1;sbyte=0;}
 else
 if(sbpp==2) {sbshift=2;sbmask=0x3;smask=0x3;sbyte=0;}
 else
 if(sbpp==4) {sbshift=1;sbmask=0x1;smask=0xF;sbyte=0;}
 else /* if(sbpp==8) */ {sbshift=0;sbmask=0x0;smask=0xFF;sbyte=0;}


 lasty=-1;

 for(yd=sl;yd<el;yd++) /* scan dest bitmap */
 {
  ys=scale(yd,0x10000,ymag);
  if(ys>=sypix) ys=sypix-1;


  if(ys==lasty)
  {
   err=imfind2rw(dest,yd-1,&sdata,dest,yd,&ddata);
   if(err) break;
   memcpy(ddata,sdata,dest->wwidth*sizeof(int));
   continue;                                      /* !!!!!! */
  }
  lasty=ys;


  err=imfind2rw(src,ys,&sdata,dest,yd,&ddata);
  if(err) break;

  dshift=0;
  dword=0;

  xs=0;
  ex=-xmag;

  sdatab=(char*)sdata;
  ddatab=(char*)ddata;

  {
   if(sbpp==8 && dbpp==8)
   {
    if(mappal)
    {
     for(xd=0;xd<dxpix;xd++)
     {
      *ddatab++=palmaptab[*sdatab];

      ex+=0x10000;
      while(ex>=0)
      {
       ex-=xmag;
       sdatab++;
      }
     }
    }
    else   /* 8bpp and no palette mapping */
    {
     for(xd=0;xd<dxpix;xd++)
     {
      *ddatab++=*sdatab;

      ex+=0x10000;
      while(ex>=0)
      {
       ex-=xmag;
       sdatab++;
      }
     }
    }
   }
   else  /* not 8bpp -> 8bpp */
   {
    for(xd=0;xd<dxpix;xd++)
    {
     sbyte=*(((char*)sdata)+(xs>>sbshift));
     sbyte=sbyte>>((xs & sbmask)*sbpp);
     sbyte&=smask;

     sbyte=palmaptab[sbyte];
  
     dword|=(sbyte<<dshift);
     dshift+=dbpp;
     if(dshift==32)
     {
      *ddata++=dword;
      dshift=0;
      dword=0;
     }

     ex+=0x10000;
     while(ex>=0)
     {
      ex-=xmag;
      xs++;
     }
    }
    if(dshift) *ddata=dword;
   }
  }
 }
 return(err);
}



/*****************************************************************************/
/* scale, dither */

static os_error * convert20(imagestr * dest,imagestr * src,int sl,int el,
                                                            int xmag,int ymag)
{
 os_error * err;
 int        yd;
 int        ys;
 int        xs;
 int        xd;
 int      * ddata;
 int      * sdata;
 char     * sdatab;
 char     * ddatab;
 int        dword;
 int        dshift;
 int        dbpp;
 int        sbpp;
 int        sshift;
 int        sbshift;
 int        sbmask;
 int        smask;
 int        sbyte;
 int        i;
 int        dxpix;
 int        dypix;
 int        sxpix;
 int        sypix;
 int        ex;
 int        mappal;
 unsigned int w;

 int        r;
 int        g;
 int        b;

 char       rtab[256];
 char       gtab[256];
 char       btab[256];

 char       srtab[256];
 char       sgtab[256];
 char       sbtab[256];

 int        lasty;




 err=NULL;

 dbpp=dest->bpp;
 dxpix=dest->xpix;
 dypix=dest->ypix;

 sbpp=src->bpp;
 sxpix=src->xpix;
 sypix=src->ypix;


 mappal=1;
 if(sbpp==dbpp)
 {
  if(sbpp<=8)
  {
   for(i=0;i<dest->ipal.ncolours;i++)
      if(dest->ipal.word[i]!=src->ipal.word[i]) break;
   if(i>=dest->ipal.ncolours) mappal=0;
  }
  else mappal=0;

  if(!mappal) return(convert10(dest,src,sl,el,xmag,ymag));
 }



 makecmap(dest->ipal.ncolours,dest->ipal.word,4,rgbmap);
 imsplitpalette(rtab,gtab,btab,dest);
 imsplitpalette(srtab,sgtab,sbtab,src);



 /* put this here to make compiler happy */

 if(sbpp==1) {sbshift=3;sbmask=0x7;smask=0x1;sbyte=0;}
 else
 if(sbpp==2) {sbshift=2;sbmask=0x3;smask=0x3;sbyte=0;}
 else
 if(sbpp==4) {sbshift=1;sbmask=0x1;smask=0xF;sbyte=0;}
 else /* if(sbpp==8) */ {sbshift=0;sbmask=0x0;smask=0xFF;sbyte=0;}

 lasty=-1;

 for(yd=sl;yd<el;yd++) /* scan dest bitmap */
 {
  ys=scale(yd,0x10000,ymag);
  if(ys>=sypix) ys=sypix-1;


  if(ys==lasty)
  {
   err=imfind2rw(dest,yd-1,&sdata,dest,yd,&ddata);
   if(err) break;
   memcpy(ddata,sdata,dest->wwidth*sizeof(int));
   continue;                                      /* !!!!!! */
  }
  lasty=ys;


  err=imfind2rw(src,ys,&sdata,dest,yd,&ddata);
  if(err) break;

  dshift=0;
  dword=0;

  xs=0;
  ex=-xmag;

  sdatab=(char*)sdata;
  ddatab=(char*)ddata;

  if(sbpp==16)
  {
   r=g=b=0;

   sshift=0;
   w=*sdata++;

   for(xd=0;xd<dxpix;xd++)
   {
    sbyte=w>>sshift;

    r+=(sbyte<<3)&0xF8;
    if(r<0) r=0;
    if(r>255) r=255;

    g+=(sbyte>>2)&0xF8;
    if(g<0) g=0;
    if(g>255) g=255;

    b+=(sbyte>>7)&0xF8;
    if(b<0) b=0;
    if(b>255) b=255;


    sbyte=rgbmap[((r&0xF0)<<4)|((g&0xF0))|((b&0xF0)>>4)];

    r=r-rtab[sbyte];    /* now errors */
    g=g-gtab[sbyte];
    b=b-btab[sbyte];



    dword|=(sbyte<<dshift);
    dshift+=dbpp;
    if(dshift==32)
    {
     *ddata++=dword;
     dshift=0;
     dword=0;
    }

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sshift+=16;
     if(sshift>=32)
     {
      w=*sdata++;
      sshift=0;
     }
    }
   }
   *ddata=dword;
  }
  else
  if(sbpp==32)
  {
   r=g=b=0;

   for(xd=0;xd<dxpix;xd++)
   {
    r+=sdatab[0];
    if(r<0) r=0;
    if(r>255) r=255;

    g+=sdatab[1];
    if(g<0) g=0;
    if(g>255) g=255;

    b+=sdatab[2];
    if(b<0) b=0;
    if(b>255) b=255;

    sbyte=rgbmap[((r&0xF0)<<4)|((g&0xF0))|((b&0xF0)>>4)];

    r=r-rtab[sbyte];    /* now errors */
    g=g-gtab[sbyte];
    b=b-btab[sbyte];


    dword|=(sbyte<<dshift);
    dshift+=dbpp;
    if(dshift==32)
    {
     *ddata++=dword;
     dshift=0;
     dword=0;
    }

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sdatab+=4;
    }
   }
   if(dshift) *ddata=dword;
  }
  else
  if(sbpp==24)
  {
   r=g=b=0;

   for(xd=0;xd<dxpix;xd++)
   {
    r+=sdatab[0];
    if(r<0) r=0;
    if(r>255) r=255;

    g+=sdatab[1];
    if(g<0) g=0;
    if(g>255) g=255;

    b+=sdatab[2];
    if(b<0) b=0;
    if(b>255) b=255;

    sbyte=rgbmap[((r&0xF0)<<4)|((g&0xF0))|((b&0xF0)>>4)];

    r=r-rtab[sbyte];    /* now errors */
    g=g-gtab[sbyte];
    b=b-btab[sbyte];


    dword|=(sbyte<<dshift);
    dshift+=dbpp;
    if(dshift==32)
    {
     *ddata++=dword;
     dshift=0;
     dword=0;
    }

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sdatab+=3;
    }
   }
   if(dshift) *ddata=dword;
  }
  else   /* not 24bpp */
  {
   if(sbpp==8 && dbpp==8)
   {
    if(mappal)
    {
     r=g=b=0;

     for(xd=0;xd<dxpix;xd++)
     {
      sbyte=*sdatab;

      r+=srtab[sbyte];
      if(r<0) r=0;
      if(r>255) r=255;

      g+=sgtab[sbyte];
      if(g<0) g=0;
      if(g>255) g=255;

      b+=sbtab[sbyte];
      if(b<0) b=0;
      if(b>255) b=255;

      sbyte=rgbmap[((r&0xF0)<<4)|((g&0xF0))|((b&0xF0)>>4)];

      r=r-rtab[sbyte];    /* now errors */
      g=g-gtab[sbyte];
      b=b-btab[sbyte];

      *ddatab++=(char)sbyte;

      ex+=0x10000;
      while(ex>=0)
      {
       ex-=xmag;
       sdatab++;
      }
     }
    }
    else   /* 8bpp and no palette mapping */
    {
     for(xd=0;xd<dxpix;xd++)
     {
      *ddatab++=*sdatab;

      ex+=0x10000;
      while(ex>=0)
      {
       ex-=xmag;
       sdatab++;
      }
     }
    }
   }
   else  /* not 8bpp -> 8bpp */
   {
    r=g=b=0;

    for(xd=0;xd<dxpix;xd++)
    {
     sbyte=*(((char*)sdata)+(xs>>sbshift));
     sbyte=sbyte>>((xs & sbmask)*sbpp);
     sbyte&=smask;


     r+=srtab[sbyte];
     if(r<0) r=0;
     if(r>255) r=255;

     g+=sgtab[sbyte];
     if(g<0) g=0;
     if(g>255) g=255;

     b+=sbtab[sbyte];
     if(b<0) b=0;
     if(b>255) b=255;

     sbyte=rgbmap[((r&0xF0)<<4)|((g&0xF0))|((b&0xF0)>>4)];

     r=r-rtab[sbyte];    /* now errors */
     g=g-gtab[sbyte];
     b=b-btab[sbyte];

  
     dword|=(sbyte<<dshift);
     dshift+=dbpp;
     if(dshift==32)
     {
      *ddata++=dword;
      dshift=0;
      dword=0;
     }

     ex+=0x10000;
     while(ex>=0)
     {
      ex-=xmag;
      xs++;
     }
    }
    if(dshift) *ddata=dword;
   }
  }
 }
 return(err);
}






static os_error * convert20g(imagestr * dest,imagestr * src,int sl,int el,
                                            int xmag,int ymag,char * gtab)
{
 os_error * err;
 int        yd;
 int        ys;
 int        xs;
 int        xd;
 int      * ddata;
 int      * sdata;
 char     * sdatab;
 char     * ddatab;
 int        dword;
 int        dshift;
 int        dbpp;
 int        sbpp;
 int        sbshift;
 int        sbmask;
 int        smask;
 int        sbyte;
 int        i;
 int        dxpix;
 int        dypix;
 int        sxpix;
 int        sypix;
 int        ex;
 int        mappal;

 int        r;

 char       rtab[256];
 char       srtab[256];

 int        lasty;


 err=NULL;

 dbpp=dest->bpp;
 dxpix=dest->xpix;
 dypix=dest->ypix;

 sbpp=src->bpp;
 sxpix=src->xpix;
 sypix=src->ypix;


 mappal=1;
 if(sbpp==dbpp)
 {
  if(sbpp<=8)
  {
   for(i=0;i<dest->ipal.ncolours;i++)
     if(dest->ipal.word[i]!=src->ipal.word[i]) break;
   if(i>=dest->ipal.ncolours) mappal=0;
  }
  else mappal=0;

  if(!mappal) return(convert10g(dest,src,sl,el,xmag,ymag,gtab));
 }


 imsplitpalette(rtab,NULL,NULL,dest);
 imsplitpalette(srtab,NULL,NULL,src);


 /* put this here to make compiler happy */

 if(sbpp==1) {sbshift=3;sbmask=0x7;smask=0x1;sbyte=0;}
 else
 if(sbpp==2) {sbshift=2;sbmask=0x3;smask=0x3;sbyte=0;}
 else
 if(sbpp==4) {sbshift=1;sbmask=0x1;smask=0xF;sbyte=0;}
 else /* if(sbpp==8) */ {sbshift=0;sbmask=0x0;smask=0xFF;sbyte=0;}


 lasty=-1;

 for(yd=sl;yd<el;yd++) /* scan dest bitmap */
 {
  ys=scale(yd,0x10000,ymag);
  if(ys>=sypix) ys=sypix-1;


  if(ys==lasty)
  {
   err=imfind2rw(dest,yd-1,&sdata,dest,yd,&ddata);
   if(err) break;
   memcpy(ddata,sdata,dest->wwidth*sizeof(int));
   continue;                                      /* !!!!!! */
  }
  lasty=ys;


  err=imfind2rw(src,ys,&sdata,dest,yd,&ddata);
  if(err) break;

  dshift=0;
  dword=0;

  xs=0;
  ex=-xmag;

  sdatab=(char*)sdata;
  ddatab=(char*)ddata;

  {
   if(sbpp==8 && dbpp==8)
   {
    if(mappal)
    {
     r=0;

     for(xd=0;xd<dxpix;xd++)
     {
      sbyte=*sdatab;

      r+=srtab[sbyte];
      if(r<0) r=0;
      if(r>255) r=255;

      sbyte=gtab[r];

      r=r-rtab[sbyte];    /* now errors */

      *ddatab++=(char)sbyte;

      ex+=0x10000;
      while(ex>=0)
      {
       ex-=xmag;
       sdatab++;
      }
     }
    }
    else   /* 8bpp and no palette mapping */
    {
     for(xd=0;xd<dxpix;xd++)
     {
      *ddatab++=*sdatab;

      ex+=0x10000;
      while(ex>=0)
      {
       ex-=xmag;
       sdatab++;
      }
     }
    }
   }
   else  /* not 8bpp -> 8bpp */
   {
    r=0;

    for(xd=0;xd<dxpix;xd++)
    {
     sbyte=*(((char*)sdata)+(xs>>sbshift));
     sbyte=sbyte>>((xs & sbmask)*sbpp);
     sbyte&=smask;

     r+=srtab[sbyte];
     if(r<0) r=0;
     if(r>255) r=255;

     sbyte=gtab[r];

     r=r-rtab[sbyte];    /* now errors */
  
     dword|=(sbyte<<dshift);
     dshift+=dbpp;
     if(dshift==32)
     {
      *ddata++=dword;
      dshift=0;
      dword=0;
     }

     ex+=0x10000;
     while(ex>=0)
     {
      ex-=xmag;
      xs++;
     }
    }
    if(dshift) *ddata=dword;
   }
  }
 }
 return(err);
}

/******************************************************************************/

/* something >> 16 bpp sprite */

static os_error * convert30(imagestr * dest,imagestr * src,int sl,int el,
                                                            int xmag,int ymag)
{
 os_error * err;
 int        yd;
 int        ys;
 int        xs;
 int        xd;
 int      * ddata;
 int      * ddata1;
 int      * sdata;
 char     * sdatab;
 int        dword;
 int        dshift;
 int        dbpp;
 int        sbpp;
 int        sshift;
 int        sbshift;
 int        sbmask;
 int        smask;
 int        sbyte;
 int        i;
 int        dxpix;
 int        dypix;
 int        sxpix;
 int        sypix;
 int        ex;
 unsigned int w;
 int        palmaptab[256];
 int        lasty;
 int      * temp;

 err=NULL;

 dbpp=dest->bpp;
 dxpix=dest->xpix;
 dypix=dest->ypix;

 sbpp=src->bpp;
 sxpix=src->xpix;
 sypix=src->ypix;


 temp=NULL;


 if(sbpp<=8)
 {
  for(i=0;i<src->ipal.ncolours;i++)
  {
   palmaptab[i]=src->ipal.word[i];
  }

  cmstranslate(palmaptab,palmaptab,src->ipal.ncolours,&src->profile,CMS_ARGB,&dest->profile,CMS_ARGB);

  for(i=0;i<src->ipal.ncolours;i++)
  {
   w=src->ipal.word[i];

   sbyte=((w & 0xF800)>>11)  |
         ((w & 0xF80000)>>14)|
         ((w & 0xF8000000)>>17);      // OK because w is unsigned

   palmaptab[i]=sbyte;
  }

 }
 else
 if(sbpp==32)
 {
  err=salloc((flex_ptr)&temp,dxpix*sizeof(int));



 }

/* dprintf(0,"xmag=%x ymag=%x",xmag,ymag); */


 /* put this here to make compiler happy */

 if(sbpp==1) {sbshift=3;sbmask=0x7;smask=0x1;sbyte=0;}
 else
 if(sbpp==2) {sbshift=2;sbmask=0x3;smask=0x3;sbyte=0;}
 else
 if(sbpp==4) {sbshift=1;sbmask=0x1;smask=0xF;sbyte=0;}
 else /* if(sbpp==8) */ {sbshift=0;sbmask=0x0;smask=0xFF;sbyte=0;}


 lasty=-1;

 for(yd=sl;yd<el;yd++) /* scan dest bitmap */
 {
  ys=scale(yd,0x10000,ymag);
  if(ys>=sypix) ys=sypix-1;

  if(ys==lasty)
  {
   err=imfind2rw(dest,yd-1,&sdata,dest,yd,&ddata);
   if(err) break;
   memcpy(ddata,sdata,dest->wwidth*sizeof(int));
   continue;                                      /* !!!!!! */
  }
  lasty=ys;

  err=imfind2rw(src,ys,&sdata,dest,yd,&ddata);
  if(err) break;

  dshift=0;
  dword=0;

  xs=0;
  ex=-xmag;

  sdatab=(char*)sdata;

  if(sbpp==16)
  {
//   cprintf("spbpp 16 xmag %x",xmag);

   w=*sdata++;
   sshift=0;

//   if(yd==50) cprintf("last word %x %x %x sxpix %d",*(sdata+sxpix/2-1),*(sdata+sxpix/2-2),*(sdata+sxpix/2-3),sxpix);

   ddata1=ddata;

   for(xd=0;xd<dxpix;xd++)
   {
    sbyte=(w>>sshift) & 0xFFFF;
    dword|=(sbyte<<dshift);

    dshift+=16;
    if(dshift==32)
    {
     *ddata++=dword;
     dshift=0;
     dword=0;
    }

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sshift+=16;
     if(sshift>=32)
     {
      w=*sdata++;
      sshift=0;
     }
    }
   }
   if(dshift) *ddata=dword;

   cmstranslate(ddata1,ddata1,dxpix,&src->profile,CMS_16,&dest->profile,CMS_16);

//   if(yd==50) cprintf("last word %x %x %x dword %x dshift %d",*(ddata),*(ddata-1),*(ddata-2),dword,dshift);
  }
  else
  if(sbpp==32)
  {
   if(!cmsisactive())
   {
    for(xd=0;xd<dxpix;xd++)
    {
     w=*sdata;

     sbyte =(w&0xF8)>>3;
     sbyte|=(w&0xF800)>>6;
     sbyte|=(w&0xF80000)>>9;

     dword|=(sbyte<<dshift);
     dshift+=16;
     if(dshift==32)
     {
      *ddata++=dword;
      dshift=0;
      dword=0;
     }

     ex+=0x10000;
     while(ex>=0)
     {
      ex-=xmag;
      sdata++;
     }
    }
    if(dshift) *ddata=dword;
   }
   else
   {
    ddata1=ddata;

    ddata=temp;

    for(xd=0;xd<dxpix;xd++)
    {
     *ddata++=*sdata;

     ex+=0x10000;
     while(ex>=0)
     {
      ex-=xmag;
      sdata++;
     }
    }

    cmstranslate(ddata1,temp,dxpix,&src->profile,(src->ipal.palclass==CL_CMYK)?CMS_CMYK:CMS_RGBA,&dest->profile,CMS_16);
   }
  }
  else
  if(sbpp==24)
  {

   ddata1=ddata;

   for(xd=0;xd<dxpix;xd++)
   {
    sbyte =((*(sdatab+0)) & 0xF8)>>3;
    sbyte|=((*(sdatab+1)) & 0xF8)<<2;
    sbyte|=((*(sdatab+2)) & 0xF8)<<7;

    dword|=(sbyte<<dshift);
    dshift+=16;
    if(dshift==32)
    {
     *ddata++=dword;
     dshift=0;
     dword=0;
    }

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sdatab+=3;
    }
   }
   if(dshift) *ddata=dword;

   cmstranslate(ddata1,ddata1,dxpix,&src->profile,CMS_16,&dest->profile,CMS_16);
  }
  else   /* <=8bpp */
  {
   for(xd=0;xd<dxpix;xd++)
   {
    sbyte=*(((char*)sdata)+(xs>>sbshift));
    sbyte=sbyte>>((xs & sbmask)*sbpp);
    sbyte&=smask;

    sbyte=palmaptab[sbyte];
  
    dword|=(sbyte<<dshift);
    dshift+=16;
    if(dshift==32)
    {
     *ddata++=dword;
     dshift=0;
     dword=0;
    }

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     xs++;
    }
   }
   if(dshift) *ddata=dword;
  }
 }


 if(temp)
 {
  sfree((flex_ptr)&temp);

 }



 return(err);
}



/* something >> 32 bpp sprite */

static os_error * convert40(imagestr * dest,imagestr * src,int sl,int el,
                                                            int xmag,int ymag)
{
 os_error * err;
 int        yd;
 int        ys;
 int        xs;
 int        xd;
 int      * ddata;
 int      * ddata1;
 int      * sdata;
 char     * sdatab;
 int        dword;
 int        dshift;
 int        dbpp;
 int        sbpp;
 int        sshift;
 int        sbshift;
 int        sbmask;
 int        smask;
 int        sbyte;
 int        i;
 int        dxpix;
 int        dypix;
 int        sxpix;
 int        sypix;
 int        ex;
 unsigned int w;
 int        palmaptab[256];
 int        lasty;


 err=NULL;

 dbpp=dest->bpp;
 dxpix=dest->xpix;
 dypix=dest->ypix;

 sbpp=src->bpp;
 sxpix=src->xpix;
 sypix=src->ypix;


 if(sbpp<=8)
 {
  for(i=0;i<src->ipal.ncolours;i++)
  {
   w=src->ipal.word[i];

   palmaptab[i]=w>>8;
  }

  cmstranslate(palmaptab,palmaptab,src->ipal.ncolours,&src->profile,CMS_RGBA,&dest->profile,CMS_RGBA);
 }

/* dprintf(0,"xmag=%x ymag=%x",xmag,ymag); */


 /* put this here to make compiler happy */

 if(sbpp==1) {sbshift=3;sbmask=0x7;smask=0x1;sbyte=0;}
 else
 if(sbpp==2) {sbshift=2;sbmask=0x3;smask=0x3;sbyte=0;}
 else
 if(sbpp==4) {sbshift=1;sbmask=0x1;smask=0xF;sbyte=0;}
 else /* if(sbpp==8) */ {sbshift=0;sbmask=0x0;smask=0xFF;sbyte=0;}


 lasty=-1;

 for(yd=sl;yd<el;yd++) /* scan dest bitmap */
 {
  ys=scale(yd,0x10000,ymag);
  if(ys>=sypix) ys=sypix-1;

  if(ys==lasty)
  {
   err=imfind2rw(dest,yd-1,&sdata,dest,yd,&ddata);
   if(err) break;
   memcpy(ddata,sdata,dest->wwidth*sizeof(int));
   continue;                                      /* !!!!!! */
  }
  lasty=ys;

  err=imfind2rw(src,ys,&sdata,dest,yd,&ddata);
  if(err) break;

  dshift=0;
  dword=0;

  xs=0;
  ex=-xmag;

  sdatab=(char*)sdata;

  if(sbpp==16)
  {
   w=*sdata++;
   sshift=0;

   ddata1=ddata;

   for(xd=0;xd<dxpix;xd++)
   {
    sbyte=w>>sshift;

    *ddata++=((sbyte&0x1F)<<3)|
             ((sbyte&0x3E0)<<6)|
             ((sbyte&0x7C00)<<9);

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sshift+=16;
     if(sshift>=32)
     {
      w=*sdata++;
      sshift=0;
     }
    }
   }

   cmstranslate(ddata1,ddata1,dxpix,&src->profile,CMS_RGBA,&dest->profile,CMS_RGBA);
  }
  else
  if(sbpp==32)
  {
   ddata1=ddata;

   for(xd=0;xd<dxpix;xd++)
   {
    *ddata++=*sdata;

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sdata++;
    }
   }

   cmstranslate(ddata1,ddata1,dxpix,&src->profile,(src->ipal.palclass==CL_CMYK)?CMS_CMYK:CMS_RGBA,&dest->profile,CMS_RGBA);
  }
  else
  if(sbpp==24)
  {
   ddata1=ddata;

   for(xd=0;xd<dxpix;xd++)
   {
    sbyte =(*(sdatab+0));
    sbyte|=((*(sdatab+1)))<<8;
    sbyte|=((*(sdatab+2)))<<16;

    *ddata++=sbyte;

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     sdatab+=3;
    }
   }

   cmstranslate(ddata1,ddata1,dxpix,&src->profile,CMS_RGBA,&dest->profile,CMS_RGBA);
  }
  else   /* <=8bpp */
  {

   for(xd=0;xd<dxpix;xd++)
   {
    sbyte=*(((char*)sdata)+(xs>>sbshift));
    sbyte=sbyte>>((xs & sbmask)*sbpp);
    sbyte&=smask;

    *ddata++=palmaptab[sbyte];

    ex+=0x10000;
    while(ex>=0)
    {
     ex-=xmag;
     xs++;
    }
   }
  }
 }

 return(err);
}


/*****************************************************************************/


/* sl=start line, el=end line +1 */

os_error * convert(imagestr * dest,imagestr * src,
                   transformstr * tr,int sl,int el,int dither)
{
 os_error * err;
 int        scale;
 int        xmag;
 int        ymag;
 int        grey;
 char       gtab[256];
 int        size;

/* int        time=clock(); */

 err=NULL;

 scale=(tr->a!=0x10000) || (tr->d!=0x10000);

 grey=imgrey(src);

 xmag=tr->a;
 ymag=tr->d;



 if(dest->bpp<=8)
 {
  if(grey)
  {
   err=makegmap(dest->ipal.ncolours,dest->ipal.word,gtab,&size);
   if(size<2) grey=0;
  }

  if(grey)
  {
   if(dither) err=convert20g(dest,src,sl,el,xmag,ymag,gtab);
   else       err=convert10g(dest,src,sl,el,xmag,ymag,gtab);
  }
  else
  if(!grey)
  {
   if(dither) err=convert20(dest,src,sl,el,xmag,ymag);
   else       err=convert10(dest,src,sl,el,xmag,ymag);
  }
 }
 else
 if(dest->bpp==16) err=convert30(dest,src,sl,el,xmag,ymag);
 else
 if(dest->bpp==32) err=convert40(dest,src,sl,el,xmag,ymag);

/* dprintf(0,"time=%d",clock()-time);  */

 return(err);
}


