/*->c.conv */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "config.h"
#include "dbhi.h"


#include "str.h"
#include "constants.h"

#include "reslink.h"

#include "file.h"
#include "view.h"

#include "im.h"
#include "cmap.h"
#include "long.h"

#include "user.h"

#include "conv.h"



os_error * conv(imagestr * sim,imagestr * dim,filterstr * f,
                spanstr ** s,int ylo,int yhi)
{
 os_error * err;

 int x;
 int xpix;
 int y;
 int ypix;
 int sdepth;  /* rows above middle of matrix */
 int fdepth;  /* rows below middle of matrix */
 int depth;   /* total depth of matrix       */
 int swidth;  /* cols to left of middle of matrix */
 int fwidth;  /* so a 3x3 matrix has swidth=1, fwidth=2 */
 int width;
 int sl;
 int sxlo;
 int sxhi;
 int dxlo;
 int dxhi;
 int i;
 int j;
 int ys;
 int yd;
 int w;
 int r;
 int g;
 int b;
 int shift;
 int scale;


 int * rb;        /* pointer to   3*depth*(2*width+xpix) int's */

 int * rs[FMAXY];
 int * gs[FMAXY];
 int * bs[FMAXY];

 int * rp;
 int * gp;
 int * bp;

 int   convol[FMAXY*FMAXX];
 int * cp;

 int * sdata;
 int * ddata;
 char * sp;
 char * dp;

 int    grey;
 int    bpp;
 int    mask;
 int    bshift;
 int    limit;
 int    c;        /* current word for palette images */
 int    v;        /* palette word */

 char   rtab[256];
 char   gtab[256];
 char   btab[256];
 int    size;
 unsigned int uword;


 err=NULL;

 xpix=sim->xpix;
 ypix=sim->ypix;

 shift=f->shift;
 scale=f->scale;
 shift*=scale;


 bpp=sim->bpp;
 grey=imgrey(sim);
 imsplitpalette(rtab,gtab,btab,sim);

 if(bpp<=8) 
 {
  if(grey)
  {
   err=makegmap(dim->ipal.ncolours,dim->ipal.word,gtab,&size);
   if(size<2) grey=0;
  }

  if(!grey) err=makecmap(sim->ipal.ncolours,sim->ipal.word,4,rgbmap);
 }
 if(err) return(err);


 if(bpp==1)  {limit=32;mask=0x1;}
 else
 if(bpp==2)  {limit=32;mask=0x3;}
 else
 if(bpp==4)  {limit=32;mask=0xF;}
 else
 if(bpp==8)  {limit=32;mask=0xFF;}
 else        {limit=32;mask=0x7FFF;}




 /* first, preprocess the matrix */

 for(j=0;j<FMAXY;j++)
 {
  for(i=0;i<FMAXX;i++) if(f->array[j][i]) break;
  if(i<FMAXX) break;
 }

 /* j is now the first row used */

 if(j>=FMAXY) 
 {
  return(imzero(dim));
 }

 sdepth=(FMAXY-1)/2-j;

 for(j=FMAXY-1;j>=0;j--)
 {
  for(i=0;i<FMAXX;i++) if(f->array[j][i]) break;
  if(i<FMAXX) break;
 }
 if(j>=FMAXY) j--;

 /* j is now the last row actually used */

 fdepth=j-(FMAXY-1)/2+1;


 for(i=0;i<FMAXX;i++)
 {
  for(j=0;j<FMAXY;j++) if(f->array[j][i]) break;
  if(j<FMAXY) break;
 }

 /* i is first column used */

 swidth=(FMAXX-1)/2-i;

 for(i=FMAXX-1;i>=0;i--)
 {
  for(j=0;j<FMAXY;j++) if(f->array[j][i]) break;
  if(j<FMAXY) break;
 }

 /* i is last column used */

 fwidth=i-(FMAXX-1)/2+1;

 depth=sdepth+fdepth;
 width=swidth+fwidth;

 cp=convol;

 for(j=0;j<depth;j++)
 {
  for(i=0;i<width;i++)
  {
   *cp=f->array[(FMAXY-1)/2-sdepth+j][(FMAXX-1)/2-swidth+i];
   cp++;
  }
 }

 err=flex_alloc((flex_ptr)&rb,3*depth*(2*width+xpix)*sizeof(int));
 if(err) return(err);

 rp=gp=bp=rb; /* compiler */
 r=g=b=0;     /* compiler */

 sl=0;

 for(y=ylo-sdepth;y<(yhi+fdepth-1);y++)
 {
  longproctick2(y,(yhi-ylo+sdepth+fdepth-1));

  yd=y-(fdepth-1);

  if(y<ylo)   ys=ylo;
  else
  if(y>=yhi)  ys=yhi-1;
  else        ys=y;

  sxlo=(*s)[ys-ylo].xlo;
  sxhi=(*s)[ys-ylo].xhi;

  err=imfind2rw(sim,ys,&sdata,dim,MAX(yd,ylo),&ddata);
  if(err) break;

  for(j=0;j<depth;j++)
  {
   rs[j]=rb+((depth-j+sl)%depth)*(2*width+xpix);
   gs[j]=rs[j]+depth*(2*width+xpix);
   bs[j]=gs[j]+depth*(2*width+xpix);
   rs[j]+=swidth;
   gs[j]+=swidth;
   bs[j]+=swidth;
  }

  memset(rs[0]-swidth,0,(2*width+xpix)*sizeof(int));
  memset(gs[0]-swidth,0,(2*width+xpix)*sizeof(int));
  memset(bs[0]-swidth,0,(2*width+xpix)*sizeof(int));

  rp=swidth+rs[depth-1];
  gp=swidth+gs[depth-1];
  bp=swidth+bs[depth-1];


  /* get one source line, and calculate contributions */

  sp=((char*)sdata)+((bpp*sxlo)/8);
  sdata+=(bpp*sxlo)/32;
  bshift=(bpp*sxlo) & 0x1F;
  c=*sdata++;

  for(x=sxlo-swidth;x<(sxhi+fwidth-1);x++)
  {
   if(x<sxlo)
   {
    if(bpp==32)
    {
     r=c&0xFF;
     g=(c>>8)&0xFF;
     b=(c>>16)&0xFF;
    }
    else
    if(bpp==16)
    {
     v=(c>>bshift)&mask;
     r=(v<<3)&0xF8;
     g=(v>>2)&0xF8;
     b=(v>>7)&0xF8;
    }
    else
    if(bpp==24)
    {
     r=*sp;
     g=*(sp+1);
     b=*(sp+2);
    }
    else
    {
     v=(c>>bshift)&mask;
     r=rtab[v];
     g=gtab[v];
     b=btab[v];
    }
   }
   else
   if(x<xpix)
   {
    if(bpp==32)
    {
     r=c&0xFF;
     g=(c>>8)&0xFF;
     b=(c>>16)&0xFF;
     c=*sdata++;      /* pre inc */
    }
    else
    if(bpp==16)
    {
     v=(c>>bshift)&mask;
     r=(v<<3)&0xF8;
     g=(v>>2)&0xF8;
     b=(v>>7)&0xF8;
     bshift+=bpp;
     if(bshift>=limit)
     {
      c=*sdata++;
      bshift=0;
     }
    }
    else
    if(bpp==24)
    {
     r=*sp++;
     g=*sp++;
     b=*sp++;
    }
    else
    {
     v=(c>>bshift)&mask;
     r=rtab[v];
     g=gtab[v];
     b=btab[v];
     bshift+=bpp;
     if(bshift>=limit)
     {
      c=*sdata++;
      bshift=0;
     }
    }
   }

   cp=convol;

   for(j=0;j<depth;j++)
   {
    for(i=-swidth;i<fwidth;i++)
    {
     w=*cp++;
     *(rs[j]+i)+=w*r;
     *(gs[j]+i)+=w*g;
     *(bs[j]+i)+=w*b;
    }
    rs[j]++;
    gs[j]++;
    bs[j]++;
   }
  }


  if(yd>=ylo) /* start outputing rows */
  {
   dxlo=(*s)[yd-ylo].xlo;
   dxhi=(*s)[yd-ylo].xhi;

   dp=((char*)ddata)+((bpp*dxlo)/8);
   ddata+=(bpp*dxlo)/32;
   bshift=(bpp*dxlo) & 0x1F;

   uword=*ddata;
   uword=uword<<(32-bshift);
   c=uword>>(32-bshift);   /* clearing bits */

   for(x=dxlo;x<dxhi;x++)
   {
    r=*rp++;
    g=*gp++;
    b=*bp++;

    r+=shift;
    r/=scale;
    if(r<0) r=0;
    if(r>255) r=255;

    g+=shift;
    g/=scale;
    if(g<0) g=0;
    if(g>255) g=255;

    b+=shift;
    b/=scale;
    if(b<0) b=0;
    if(b>255) b=255;

  
    if(bpp==32)
    {
     *ddata++=r|(g<<8)|(b<<16);
    }
    else
    if(bpp==16)
    {
     v=((r&0xF8)>>3)|((g&0xF8)<<2)|((b&0xF8)<<7);

     c|=v<<bshift;
     bshift+=bpp;
     if(bshift>=32)
     {
      *ddata++=c;
      bshift=c=0;
     }
    }
    else
    if(bpp==24)
    {
     *dp++=(char)r;
     *dp++=(char)g;
     *dp++=(char)b;
    }
    else
    {
     if(grey) 
     {
      v=gtab[r];
     }
     else
     {
      v=((r&0xF0)<<4)|(g&0xF0)|((b&0xF0)>>4);
      v=rgbmap[v];
     }

     c|=v<<bshift;
     bshift+=bpp;
     if(bshift>=limit)
     {
      *ddata++=c;
      bshift=c=0;
     }
    }
   }
   if(bshift) 
   {
    uword=*ddata;
    uword=uword>>bshift;
    uword=uword<<bshift;
    uword|=c;
    *ddata=uword;
   }
  }

  sl++;
 }

 flex_free((flex_ptr)&rb);

 return(err);
}

