/*->c.config */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "redraw.h"
#include "colour.h"
#include "units.h"
#include "save.h"
#include "bits.h"
#include "pane.h"
#include "deb.h"
#include "osshell.h"
#include "osmem.h"

#include "mlo.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "im.h"
#include "page.h"
#include "filter.h"
#include "col.h"
#include "long.h"
#include "format.h"
#include "undo.h"


#include "configx.h"


extern dboxstr configbox[2];


/*****************************************************************************/

#define MAXMEM 12*1024*1024
#define DMEM   128*1024
#define MINCHUNKS 8


static __int64 systemmaxmemory;

static __int64 maxmemory=1024*1024*128;

static int tmaxmemory;
static int tdeftools;
static int tdefinfo;
static int tdefprintmargin;
static int tdefrulers;
static int tdefdither;
static int twidth;
static int theight;
static int txres;
static int tyres;
static int tunits;
static int tred;
static int tgreen;
static int tblue;
static int tundosteps;


static int templongproc;
static int templongbeep;

       int overhead;
       int pollcount;
       int imchunksize=0x8000;


       int windowx0;
       int windowx1;
       int windowy0;
       int windowy1;


       int toolsxshift=-150;
       int toolsyshift;
       int infoxshift;
       int infoyshift=200;


static viewstr * configview;


/*****************************************************************************/

extern dboxstr generalbox;


static os_error * generalclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  filtertype=tempfiltertype;

  redweight=tred;
  greenweight=tgreen;
  blueweight=tblue;
  longproc=templongproc;
  longbeep=templongbeep;
  undosteps=tundosteps;
 }

 return(err);
}


static os_error * generalicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 32:
          setgfiltermenu();
          err=openupmenu(handle,MGFILTER);
          break;

 }

 return(err);

 USE(handle);
 USE(userhandle);
 USE(m);
}


static os_error * wrgfilter(int value,char * string)
{
 getgfiltername(value,string);
 return(NULL);
}


void gfilterupdate(void)
{
 dbchangevalue(&tempfiltertype,&generalbox);
}



static os_error * wrw(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdw(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}


static dbiconstr generalicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,

   31,&tempfiltertype,DBTEXT,  0,   0,      0,  0,  0,   0,     NULL,wrgfilter,

    8,&tred,         DBWRITE,  0,   0,     10, -1, 22,  -1,     rdw,wrw,
   10,&tgreen,       DBWRITE,  0,   0,     12,  8, 22,  -1,     rdw,wrw,
   12,&tblue,        DBWRITE,  0,   0,     -1, 10, 22,  -1,     rdw,wrw,

//   15,&templongproc, DBRADIO,  0,   0,     LHG, F1, 1, -1,    NULL,NULL,
//   16,&templongproc, DBRADIO,  0,   0,     LDMA,F2, 1, -1,    NULL,NULL,
//   17,&templongproc, DBRADIO,  0,   0,     LMTSK,F3, 1, -1,   NULL,NULL,

//   18,&templongbeep, DBTOGGLE, 0,   0,     1, F4, 0, -1,      NULL,NULL,

   22,&tundosteps,   DBWRITE,  0,   0,     -1, -1, -1,  12,     rdw,wrw,

   -1, NULL,         0,        0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr generalbox=
{
 0,
 TGENERAL,
 DBFIX,
 DBGRAB,
 generalclose,
 generalicon,
 NULL,
 NULL,
 generalicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * general(wimp_w parent)
{
 os_error * err;


 if(generalbox.handle) dbclose(&generalbox,DBCANCEL);

 tempfiltertype=filtertype;
 tred=redweight;
 tgreen=greenweight;
 tblue=blueweight;
 templongproc=longproc;
 templongbeep=longbeep;
 tundosteps=undosteps;

 err=dodboxparent(&generalbox,1,parent);

 return(err);
}


/*****************************************************************************/

extern dboxstr pagebox;

static os_error * pageclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  defdocdata.width=twidth;
  defdocdata.height=theight;
  defdocdata.xres=txres;
  defdocdata.yres=tyres;

  defviewdata.units=tunits;
 }

 return(err);
}


static os_error * pagepage(int w,int h)
{
 twidth=w;
 theight=h;
 dbchangevalue(&twidth,&pagebox);

 return(NULL);
}




static os_error * unitunit(int units)
{
 tunits=units;
 dbchangevalue(&tunits,&pagebox);
 unitssetup(unitunit,tunits,0,0);
 return(NULL);
}


static os_error * resres(int res,int user)
{
 if(user)
 {
  tyres=res;
  dbchangevalue(&tyres,&pagebox);
  ressetup(resres,tyres,1);
 }
 else
 {
  txres=res;
  dbchangevalue(&txres,&pagebox);
  ressetup(resres,txres,0);
 }
 return(NULL);
}



static os_error * pageicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 22:
          setpagemenu(twidth,theight,pagepage,0,0);
          err=openupmenu(handle,MPAGE);
          break;

  case  5:
          unitssetup(unitunit,tunits,0,0);
          err=openupmenu(handle,MUNITS);
          break;

  case  8:
          ressetup(resres,txres,0);
          err=openupmenu(handle,MRES);
          break;

  case 11:
          ressetup(resres,tyres,1);
          err=openupmenu(handle,MRES);
          break;
 }

 return(err);

 USE(handle);
 USE(userhandle);
 USE(m);
}


static os_error * wrpage(int value,char * string)
{
 int  index;

 index=pageindex(twidth,theight);
 getpagename(index,string);

 return(NULL);
 value=value;
}

static os_error * wrunit(int value,char * string)
{
 getunitname(tunits,string);
 return(NULL);
 value=value;
}

static os_error * wrres(int value,char * string)
{
 sprintf(string,"%d",value);
 return(NULL);
}


static dbiconstr pageicondefs[8]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,

   21,&twidth,       DBTEXT,   0,   0,      0,  0,  0,   0,      NULL,wrpage,

    4,&tunits,       DBTEXT,   0,   0,      0,  0,  0,   0,      NULL,wrunit,

    7,&txres,        DBTEXT,   0,   0,      0,  0,  0,   0,      NULL,wrres,
   10,&tyres,        DBTEXT,   0,   0,      0,  0,  0,   0,      NULL,wrres,


   -1, NULL,         0,        0,    0,      0,  0,  0,  0,  0,      0
};


static dboxstr pagebox=
{
 0,
 TPAGE,
 DBFIX,
 DBGRAB,
 pageclose,
 pageicon,
 NULL,
 NULL,
 pageicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * page(wimp_w parent)
{
 os_error * err;

 if(pagebox.handle) err=dbclose(&pagebox,DBCANCEL);

 twidth=defdocdata.width;
 theight=defdocdata.height;
 txres=defdocdata.xres;
 tyres=defdocdata.yres;

 tunits=defviewdata.units;

 err=dodboxparent(&pagebox,1,parent);

 return(err);
}

/*****************************************************************************/


static os_error * windowsclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  defviewdata.tools=tdeftools;
  defviewdata.infopal=tdefinfo;
  defviewdata.rulers=tdefrulers;
  defviewdata.dither=tdefdither;
  defviewdata.printmargin=tdefprintmargin;
 }

 return(err);
}

static dbiconstr windowsicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,

   11, &tdeftools,   DBTOGGLE, 0,   0,       1, F1,  0, 0, NULL, 0,
   12, &tdefinfo,    DBTOGGLE, 0,   0,       1, F2,  0, 0, NULL, 0,
    0, &tdefrulers,  DBTOGGLE, 0,   0,       1, F3,  0, 0, NULL, 0,
    5, &tdefdither,   DBTOGGLE, 0,  0,       1, F4,  0, 0, NULL, 0,
    8, &tdefprintmargin,DBTOGGLE,0, 0,       1, F5,  0, 0, NULL, 0,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};


static dboxstr windowsbox=
{
 0,
 TWINDOWS,
 DBFIX,
 DBGRAB,
 windowsclose,
 NULL,
 NULL,
 NULL,
 windowsicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * windows(wimp_w parent)
{
 os_error * err;

 if(windowsbox.handle) err=dbclose(&windowsbox,DBCANCEL);

 tdeftools=defviewdata.tools;
 tdefinfo=defviewdata.infopal;
 tdefrulers=defviewdata.rulers;
 tdefdither=defviewdata.dither;
 tdefprintmargin=defviewdata.printmargin;

 err=dodboxparent(&windowsbox,1,parent);

 return(err);
}

/****************************************************************************/
/*  memory sub box */

extern dboxstr membox;

static int ramused;
static int discused;
static int systemmaxdisc;


char scrappath[MAX_PATH];



static os_error * wrpath(int value,char * string)
{
 strcpy(string,scrappath);
 return(NULL);
 USE(value);
}

static os_error * rdpath(int * value,char * string)
{
 xzstrncpy(scrappath,string,sizeof(scrappath));
 return(NULL);
 USE(value);
}




static void mempoll(uservalue userhandle)
{
 int tram;
 int tdisc;
 int tdsize;

 imgetmemory(&tram,&tdisc,&tdsize);
	tram/=1024;
	tdisc/=1024;
	tdsize/=1024;


 if(tram!=ramused) 
 {
  ramused=tram;
  wimp_set_icon_state(membox.handle,11,(wimp_iconflags)0,(wimp_iconflags)0);
  dbchangevalue(&ramused,&membox);
 }

 if(tdisc!=discused || tdsize!=systemmaxdisc)
 {
  discused=tdisc;
  systemmaxdisc=tdsize;
  wimp_set_icon_state(membox.handle,15,(wimp_iconflags)0,(wimp_iconflags)0);
  dbchangevalue(&discused,&membox);
 }

 USE(userhandle);
}


static os_error * memclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {

  maxmemory=tmaxmemory*1024;
  maxmemory=ROOF(maxmemory,systemmaxmemory);
  maxmemory=MAX(MINCHUNKS*imchunksize,maxmemory);
  immemory(maxmemory);
 }

 if(code!=DBAPPLY)
 {
  rempollexit(mempoll,0);
 }

 return(err);
}



static os_error * memicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 14:
          err=osshellbrowseforfolder(scrappath,"",handle,0);
          writeicon(handle,13,scrappath);
          break;
 }

 return(err);

 USE(handle);
 USE(userhandle);
 USE(m);
}





static os_error * memredrawsub(wimp_w handle,wimp_redrawstr * redrawstr,int more)
{
 os_error * err;

 err=NULL;

 while(more)
 {
  redrawslider(redrawstr,32,handle,WIMPRED,tmaxmemory,(systemmaxmemory/1024));
  redrawslider(redrawstr,11,handle,WIMPGREEN,ramused,(systemmaxmemory/1024));
  redrawslider(redrawstr,15,handle,WIMPGREEN,discused,systemmaxdisc);
  err=wimp_get_rectangle(redrawstr,&more);
 }

 return(err);
}

static os_error * memredraw(wimp_w handle,uservalue userhandle)
{
 os_error     * err;
 wimp_redrawstr redrawstr;
 int            more;
 redrawstr.w=handle;
 err=wimp_redraw_wind(&redrawstr,&more);
 if(!err) err=memredrawsub(handle,&redrawstr,more);
 return(err);
 USE(userhandle);
}

static os_error * wrmem(int value,char * string)
{
// value/=1024;
 strcpy(string,numbertostring(value));
/* strcat(string,"K"); */
 return(NULL);
}

static os_error * rdmem(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
// *value*=1024;
 return(err);
}


static dbiconstr memicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

   32, &tmaxmemory,  DBSLIDER,0,    0,       1,   -1, MAXMEM,  0,  NULL,   0,
    7, &tmaxmemory,  DBWRITE, 0, DBASSOCINC, -1, -1, 13,  -1, rdmem, wrmem,
    5, &tmaxmemory,  DBINC   ,0,    0,      DMEM,  -1, MAXMEM,  0,  NULL,   0,
    6, &tmaxmemory,  DBDEC   ,0,    0,      DMEM,  -1, MAXMEM,  0,  NULL,   0,


   13, NULL,         DBWRITE, 0,    0,      -1, -1, -1,   7,  rdpath,wrpath,


    8, &ramused,     DBTEXT,  0,    0,      -1, -1, -1,   -1,    NULL,wrmem,
   16, &discused,    DBTEXT,  0,    0,      -1, -1, -1,   -1,    NULL,wrmem,


    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};




static os_error * meminit(void)
{
 __int64 maxvm;
 __int64 maxphys;
 __int64 maxpage;


 Task_MaxVM(&maxvm,&maxphys,&maxpage);

 cprintf("maxvm %d maxphys %d maxpage %d",maxvm/1024,maxphys/1024,maxpage/1024);

 systemmaxmemory=MAX(maxphys,maxpage);


                                    /* now hacking above table on the fly */
 memicondefs[0].data.slider.max=systemmaxmemory/1024;  /* !!!! */
 memicondefs[2].data.stepbutton.max=systemmaxmemory/1024;
 memicondefs[3].data.stepbutton.max=systemmaxmemory/1024;

 return(NULL);
}



static dboxstr membox=
{
 0,
 TMEM,
 DBFIX,
 0,
 memclose,
 memicon,
 NULL,
 memredraw,
 memicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * memory(wimp_w parent)
{
 os_error * err;

 if(membox.handle) err=dbclose(&membox,DBCANCEL);
 imgetmemory(&ramused,&discused,&systemmaxdisc);

	ramused/=1024;
	discused/=1024;
	systemmaxdisc/=1024;

 tmaxmemory=maxmemory/1024;
 err=dodboxparent(&membox,1,parent);
 if(!err)
 {

  addpollexit(mempoll,0);
 }

 cprintf("scrap %s",scrappath);

 return(err);
}

/****************************************************************************/
/* main config box */


static char * configpath="<HKEY_LOCAL_MACHINE\\Software\\DavidPilling\\DPScan\\>\\config.txt";




#define CONLEFT  5
#define CONRIGHT 6

static os_error * configpaneicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 cprintf("config pane icon %d",m->i);

 err=fileconfig(m->i,handle);

 return(err);

 USE(handle);
 USE(userhandle);
 USE(m);
}


#define CLEFTMARGIN 20
#define CWIDTH      100
#define CHEIGHT     80
#define CMARGIN     20
#define CTOPMARGIN  20

static int createicons;

os_error * configcreateicon(char * name,char * filesp,int * icon)
{
 os_error     * err;
 wimp_icreate   wic;
 windowstr      window;
 char           buffer[256];

 err=NULL;


 wic.w=configbox[1].handle;

 getw(wic.w,&window);

 wic.i.box.x0=CLEFTMARGIN+createicons*(CWIDTH+CMARGIN);
 wic.i.box.y0=window.y0-window.y1;
 wic.i.box.x1=wic.i.box.x0+CWIDTH;
 wic.i.box.y1=0;

 wic.i.flags=(wimp_iconflags)0;
 wic.i.data.indirecttext.bufflen=0;

 sprintf(buffer,"\\K1\\C\\T\\I%s\\B\\s%s",filesp+1,name);

 wic.i.data.indirecttext.buffer=buffer;
 wic.i.data.indirecttext.validstring="abx";

 *icon=createicons;

 err=wimp_create_icon(&wic,icon);

 if(!err) createicons++;


 return(err);
}


static os_error * configcreate(void)
{
 os_error * err;
 windowstr  window;
 int        width;
 wimp_w     handle;

 handle=configbox[1].handle;

 getw(handle,&window);
 width=window.x1-window.x0;

 createicons=0;
 err=filecreateicons();

 width=MAX(width,CLEFTMARGIN+createicons*(CWIDTH+CMARGIN));

 extent(handle,0,window.y0-window.y1,width,0);


 return(err);
}

static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;
 windowstr  window;
 int        d;

 err=NULL;

 if(m->i==6) err=memory(handle);
 else
 if(m->i==5) err=page(handle);
 else
 if(m->i==7) err=windows(handle);
 else
 if(m->i==8) err=general(handle);
 else
 if(m->i==3 || m->i==4)
 {
  handle=configbox[1].handle;/* nb click is on main window, but scroll pane */
  getw(handle,&window);

  if((m->i==3 && m->bbits==VBCLICKS) || (m->i==4 && m->bbits==VBCLICKA)) d=1;
  else                                                         d=-1;

  openatscroll(handle,window.scx+d*(CWIDTH+CMARGIN),window.scy);
 }

 return(err);

 USE(handle);
 USE(userhandle);
 USE(m);
}

static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {

 }

 return(err);
}

/* ! window is now closed */

static os_error * scfg(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 windowx0=configview->window.x0;
 windowx1=configview->window.x1;
 windowy0=configview->window.y0;
 windowy1=configview->window.y1;
 toolsxshift=configview->toolsxshift;
 toolsyshift=configview->toolsyshift;
 infoxshift=configview->infoxshift;
 infoyshift=configview->infoyshift;

          err=savebinstall();
 if(!err) err=saveconfig(configpath);

 return(err);

 USE(handle);
 USE(userhandle);
 USE(m);
}


static dbiconstr configicondefs[6]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,(dbreadfn)scfg ,0,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};


static dboxstr configbox[2]=
{
 0,
 TCONFIG,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,


 0,
 TCONFIGPANE,
 DBPANE,
 0,
 NULL,
 configpaneicon,
 NULL,
 NULL,
 NULL,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


os_error * configure(wimp_w parent)
{
 os_error * err;

 configview=menuview;

 if(configbox[0].handle) dbclose(configbox,DBCANCEL);
 err=dodboxparent(configbox,2,parent);
 if(!err) err=configcreate();

 return(err);
}



static contokstr untoks[5]=
{
 "mm",MILIMS,
 "in",INCHES,
 "pt",POINTS,
 "px",PIXELS,
 NULL,0
};


static contag contable[]=
{
 "MaxMemory",    CONINT,&maxmemory,NULL,NULL,
 "DefaultRulers",CONINT,&defviewdata.rulers, NULL,NULL,
 "DefaultInfo",  CONINT,&defviewdata.infopal,NULL,NULL,
 "DefaultPrint", CONINT,&defviewdata.printmargin,NULL,NULL,
 "DefaultTools", CONINT,&defviewdata.tools,  NULL,NULL,
 "DefaultDither",CONINT,&defviewdata.dither, NULL,NULL,
 "DefaultWidth", CONINT,&defdocdata.width,   NULL,NULL,
 "DefaultHeight",CONINT,&defdocdata.height,  NULL,NULL,
 "DefaultXRes",  CONINT,&defdocdata.xres,    NULL,NULL,
 "DefaultYRes",  CONINT,&defdocdata.yres,    NULL,NULL,
 "DefaultUnits", CONTOK,&defviewdata.units,untoks,NULL,
 "Filter",       CONTOK,&filtertype,filtertoks,NULL,
 "RedWeight",    CONINT,&redweight,          NULL,NULL,
 "GreenWeight",  CONINT,&greenweight,        NULL,NULL,
 "BlueWeight",   CONINT,&blueweight,         NULL,NULL,
 "LongProcess",  CONTOK,&longproc,longtoks,NULL,
 "LongBeep",     CONINT,&longbeep,           NULL,NULL,
 "FSISimple",    CONINT,&cformat.fssimple,   NULL,NULL,
 "FSIZigZag",    CONINT,&cformat.fszigzag,   NULL,NULL,
 "UndoSteps",    CONINT,&undosteps,          NULL,NULL,
 "Overhead",     CONINT,&overhead,           NULL,NULL,
 "ChunkSize",    CONINT,&imchunksize,        NULL,NULL,
 "PollCount",    CONINT,&pollcount,          NULL,NULL,
 "ScrapPath",    CONSTR,scrappath,    (contokstr*)MAX_PATH,NULL,
 "WindowX0",     CONINT,&windowx0,           NULL,NULL,
 "WindowX1",     CONINT,&windowx1,           NULL,NULL,
 "WindowY0",     CONINT,&windowy0,           NULL,NULL,
 "WindowY1",     CONINT,&windowy1,           NULL,NULL,
 "ToolsX",       CONINT,&toolsxshift,        NULL,NULL,
 "ToolsY",       CONINT,&toolsyshift,        NULL,NULL,
 "InfoX",        CONINT,&infoxshift,         NULL,NULL,
 "InfoY",        CONINT,&infoyshift,         NULL,NULL,


 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "MAIN",
 NULL,
 NULL
};


os_error * configinit(void)
{
 os_error * err;

 err=addcontable(contable,&configlink);
	if(!err) err=loadconfig(configpath);
	if(!err)
	{
  event(EVENT_CONFIGLOADED,NULL,0);

  meminit();
  maxmemory=ROOF(maxmemory,systemmaxmemory);
  maxmemory=MAX(MINCHUNKS*imchunksize,maxmemory);

  immemory(maxmemory);
	}
 return(err);
}

