/*->c.compare */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"
#include "bbc.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "bf.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "mlo.h"
#include "units.h"
#include "bits.h"
#include "conf.h"
#include "colour.h"
#include "redraw.h"
#include "xmath.h"
#include "config.h"
#include "pane.h"
#include "save.h"



#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewr.h"
#include "im.h"
#include "long.h"

#include "bm.h"
#include "fx.h"
#include "user.h"
#include "col.h"
#include "hist.h"

#include "zmath.h"
#include "simplex.h"

#include "compare.h"







#define CMAX 0x10000

#define MAXGAMMA 17



#define DRAWEND   0     /* end of path                                   */
#define DRAWMOVE  2     /* move to (x,y), starts new subpath             */
#define DRAWDRAW  8     /* line to (x,y)                                 */
#define DRAWCURVE 6     /* bezier curve to (x3,y3) with 2 control points */
#define DRAWCLOSE 5     /* close current subpath with a line             */



static void calctansub(int * result,int * prev,int * curr,
                                                 int * next,int forward)
{
 int    prevangle;
 int    nextangle;
 int    diff;
 int    normal;
 int    tangent;
 int    prevdist;
 int    nextdist;
 int    curx;
 int    nextx;
 int    prevx;


 curx=prevx=nextx=curr[0];

 if(prev) 
 {
  prevdist=zpythag(curr[0]-prev[0],curr[1]-prev[1])/3;
  if(prevdist)
         prevangle=zatan2(prev[1]-curr[1],
                          prev[0]-curr[0]);
  else   prevangle=0;

  prevx=prev[0];
 }
 else
 {
  prevangle=0;
  prevdist=0;
 }

 if(next)
 {
  nextdist=zpythag(curr[0]-next[0],curr[1]-next[1])/3;

  if(nextdist)
         nextangle=zatan2(next[1]-curr[1],
                          next[0]-curr[0]);
  else   nextangle=0;

  nextx=next[0];
 }
 else
 {
  nextangle=0;
  nextdist=0;
 }

 if(!prev) prevangle=nextangle+ZPI;
 if(!next) nextangle=prevangle-ZPI;

 diff=prevangle-nextangle;
 normal=prevangle-diff/2;

 if(diff<0) normal=normal+ZPI;

 if(forward)
 {
  tangent=normal+ZPI/2;
  result[0]=curr[0]+scale(prevdist,zcos(tangent),0x10000);
  result[1]=curr[1]+scale(prevdist,zsin(tangent),0x10000);
  result[0]=CUT(result[0],prevx,curx);
 }
 else
 {
  tangent=normal-ZPI/2;
  result[0]=curr[0]+scale(nextdist,zcos(tangent),0x10000);
  result[1]=curr[1]+scale(nextdist,zsin(tangent),0x10000);
  result[0]=CUT(result[0],curx,nextx);
 }

 result[0]=CUT(result[0],0,CMAX);
 result[1]=CUT(result[1],0,CMAX);
}


static void calctangents(int * path,int skip,int doloop)
{
 int * curr;
 int * prev;
 int * prevp;
 int * next;
 int * first;
 int   looped;
 int   loop;

 prevp=NULL;
 prev=NULL;

 curr=NULL;

 first=path;
 looped=0;
 loop=doloop;


 while((*path && !looped) || ((looped || !*path) && doloop && loop--))
 {
  if(*path==DRAWEND || *path==DRAWCLOSE)
  {
   looped=1;
   path=first+3;
  }

  if(*path==DRAWMOVE || *path==DRAWDRAW)
  {
   curr=path+1;
   path+=3;
   skip--;
  }
  else
  if(*path==DRAWCURVE)   /* need last point and next */
  {
   if(path[7]==DRAWEND || path[7]==DRAWCLOSE)
   {
    if(doloop)
    {
          /* assume it starts with a move */

     if(first[3]==DRAWMOVE || first[3]==DRAWDRAW)
     {
      next=first+(3+1);
     }
     else
     if(first[3]==DRAWCURVE) next=first+(3+5);
     else                    next=NULL;
    }
    else next=NULL;
   }
   else
   if(path[7]==DRAWMOVE || path[7]==DRAWDRAW)
   {
    next=path+(7+1);
   }
   else
   if(path[7]==DRAWCURVE)
   {
    next=path+(7+5);
   }
   else
   {
    next=NULL;
   }

   curr=path+5;

   if(skip--<=0)
   {
    calctansub(path+1,prevp,prev,curr,0);
    calctansub(path+3,prev,curr,next,1);
   }

   path+=7;
  }

  prevp=prev;
  prev=curr;
 }
}



static void makegammapath(int * path,int n,int * array,int line)
{
 int i;
 int j;


 path[0]=DRAWMOVE;
 path[1]=*array++;
 path[2]=*array++;

 j=3;

 if(line)
 {
  for(i=1;i<n;i++)
  {
   path[j]=DRAWDRAW;
   path[j+1]=*array++;
   path[j+2]=*array++;
   j+=3;
  }

  path[j]=DRAWEND;
 }
 else
 {
  for(i=1;i<n;i++)
  {
   path[j]=DRAWCURVE;
   path[j+5]=*array++;
   path[j+6]=*array++;
   j+=7;
  }

  path[j]=DRAWEND;

  calctangents(path,0,0);
 }
}










#define GSTEPS 256
#define GSCALE (0x10000/GSTEPS)



static os_error * generategammavalues(int * path,void * data,
                                      int gstepss,int gwidth,int gscales)
{
 os_error   * err;
// os_regset    rx;
 int        * scrap;
 int        * p;
 int          x;
 int          y;
 int          nx;
 int          ny;
 int          sx;
 int          ex;
 int          i;


// rx.r[0]=(int)path;
// rx.r[1]=0x30+(1<<28); /* flatten */
// rx.r[2]=0;
// rx.r[3]=0x10000>>gstepss;
// rx.r[4]=0;
// rx.r[5]=NULL;
// rx.r[6]=NULL;
// rx.r[7]=3; /* size */


 err=NULL; // os_swix(Draw_ProcessPath,&rx);
 if(!err)
 {
//  err=(os_error*)flex_alloc((flex_ptr)&scrap,rx.r[0]);
  if(!err)
  {
   scrap[0]=0;
//   scrap[1]=rx.r[0];

//   rx.r[0]=(int)path;
//   rx.r[7]=(int)scrap;

//   err=os_swix(Draw_ProcessPath,&rx);


   p=scrap;
   x=0;
   y=*(scrap+2);

   while(1)
   {
    if(!*p)
    {
     if(x>=CMAX) break;
     nx=CMAX;
     ny=y;
    }
    else
    {
     nx=*(p+1);
     ny=*(p+2);
    }

    if(nx<0)       nx=0;
    if(nx>0xFFFF)  nx=0xFFFF;
    if(ny<0)       ny=0;
    if(ny>0xFFFF)  ny=0xFFFF;

    sx=( x<<gstepss)/0x10000;
    ex=(nx<<gstepss)/0x10000;


    if(gwidth==8)
    {
     if(sx==ex)
     {
      ((char*)data)[sx]=(char)((ny+y)>>(gscales+1)); /* /(2*GSCALE); */
     }
     else
     {
      for(i=sx;i<=ex;i++)
      {
       ((char*)data)[i]=(char)((y+((ny-y)*(i-sx))/(ex-sx))>>(gscales));/*/GSCALE;*/
      }
     }
    }
    else
    if(gwidth==16)
    {
     if(sx==ex)
     {
      ((short*)data)[sx]=(char)((ny+y)>>(gscales+1)); /* /(2*GSCALE); */
     }
     else
     {
      for(i=sx;i<=ex;i++)
      {
       ((short*)data)[i]=(char)((y+((ny-y)*(i-sx))/(ex-sx))>>(gscales));/*/GSCALE;*/
      }
     }
    }

    x=nx;
    y=ny;

    if(!*p) break;
    p+=3;
   }


   flex_free((flex_ptr)&scrap);
  }
 }

 return(err);
}






static void makelincurve(int contrast,int brightness,int gamma,
                                                     int * np,int * array)
{
 int    grad;
 int    y0;
 int    y1;
 int    x0;
 int    x1;
 int    xm;
 int    ym;
 int    k;
 int    igamma;
 int  * p;


 /* gamma based on 0x10000 */
 /* grad  based on 0x10000  */

 
 grad=contrast;
 grad=((ZPI/4)*(0x10000+grad))/0x10000;

 if(grad>=(ZPI/2-1)) grad=(ZPI/2-1);
 contrast=ztan(grad);

 /* brightness based on 0x10000 */
 brightness=brightness+(0x10000-contrast)/2;

 y0=brightness;
 y1=y0+contrast;
   
                                                                                 if(contrast==0)
 {
  x0=0;
  x1=0x10000;
 }
 else
 {
  igamma=scale(0x10000,0x10000,gamma);

  x0=scale(0x10000,-brightness,contrast);
  if(x0<0) x0=0;
  else     x0=zpow(x0,igamma);

  x1=scale(0x10000,(0x10000-brightness),contrast);
  if(x1<0) x1=0;
  else     x1=zpow(x1,igamma);
 }



 if(x0<0)       x0=0;
 else
 if(x0>0x10000) x0=0x10000;

 if(x1<0)       x1=0;
 else
 if(x1>0x10000) x1=0x10000;

 if(y0<0)       y0=0;
 else
 if(y0>0x10000) y0=0x10000;
                                                                                 if(y1<0)       y1=0;
 else
 if(y1>0x10000) y1=0x10000;


 *np=6;
 p=array;

 *p++=x0;
 *p++=y0;


 for(k=0;k<4;k++)
 {
  xm=x0+scale((x1-x0),(k+((gamma<0x10000)?1:4)),8);
  ym=brightness+scale(contrast,zpow(xm,gamma),0x10000);

  if(xm<0)       xm=0;
  else
  if(xm>0x10000) xm=0x10000;
    
  if(ym<0)       ym=0;
  else
  if(ym>0x10000) ym=0x10000;

  *p++=xm;
  *p++=ym;
 }

 *p++=x1;
 *p++=y1;
}



/*****************************************************************************/


#define RED   0
#define GREEN 1
#define BLUE  2


static int        xbrightness[3];
static int        xcontrast[3];
static int        xgamma[3];
static int        xplane;


static int bin1[3][256];
static int bin2[3][256];

static int * hist1;
static int * hist2;



#define MAXPOINTS 20


os_error * sresiduals(int p1,int p2,int p3,int p4,int * sumr)
{
 int  np;
 int  array[MAXPOINTS];
 int  path[MAXGAMMA*7];
 char table[256];
 int  data[256];
 int  sum;
 int  i;
 int  delta;
 int  s1;
 int  s2;



 p1=CUT(p1,-0x10000,0x10000);
 p2=CUT(p2,-0x10000,0x10000);
 p3=CUT(p3,0x1,0x80000);


// dprintf(0,"sresiduals %x %x %x",p1,p2,p3);

 makelincurve(p2,p1,p3,&np,array);

 makegammapath(path,np,array,0);

 generategammavalues(path,table,8,8,8);


 memset(data,0,sizeof(data));

 for(i=0;i<256;i++)
 {
  data[table[i]]+=hist1[i];
 }


 sum=0;

 s1=s2=0;

 for(i=0;i<256;i++)
 {
  if(i==0) 
  {
   s1=(5*data[0])/8+(data[1]/4)+(data[2]/8);
   s2=(5*hist2[0])/8+(hist2[1]/4)+(hist2[1]/8);
  }
  else
  if(i==1)
  {
   s1=(3*data[1])/8+(data[0]/4)+(data[2]/4)+(data[3]/8);
   s2=(3*hist2[0])/8+(hist2[0]/4)+(hist2[2]/4)+(hist2[3]/8);
  }
  else
  if(i==254)
  {
   s1=(5*data[255])/8+(data[254]/4)+(data[253]/8);
   s2=(5*hist2[255])/8+(hist2[254]/4)+(hist2[253]/8);
  }
  else
  if(i==255)
  {
   s1=(3*data[255])/4+(data[254]/4);
   s2=(3*hist2[255])/4+(hist2[254]/4);
  }
  else
  {
   s1=(data[i-2]/8)+(data[i-1])/4+(data[i])/4+(data[i+1])/4+(data[i+2]/8);
   s2=(hist2[i-2]/8)+(hist2[i-1])/4+(hist2[i])/2+(hist2[i+1])/4+(hist2[i+2]/8);
  }

  delta=s2-s1;
  if(delta<0) delta=-delta;

  sum+=delta;
//  if(sum<0) dprintf(0,"overflow");
 }

 *sumr=sum;

// dprintf(0,"sresiduals %x %x %x sum=%x",p1,p2,p3,sum);

 return(NULL);

 USE(p4);
}



void fxoutput(int p1,int p2,int p3,int p4)
{
 xbrightness[xplane]=p1;
 xcontrast[xplane]=p2;
 xgamma[xplane]=p3;
 USE(p4);
}



static os_error * compareimages(viewstr * view1,viewstr * view2)
{
 int done;
// int i;


 if(view1 && view2)
 {
  calchist2(view1,256,1,0,bin1[0],bin1[1],bin1[2]);
  calchist2(view2,256,1,0,bin2[0],bin2[1],bin2[2]);

  for(xplane=0;xplane<3;xplane++)
  {
   hist1=bin1[xplane];
   hist2=bin2[xplane];

   simplex(0,0,0x10000,0,&done);
  }
 }

 return(NULL);
}



/****************************************************************************/

typedef os_error * (*getimagefn)(viewstr * view,int handle);

static getimagefn getim;
static int        getimhandle;






static os_error * getimdecode(int * menu)
{
 os_error * err;
 filestr  * file;
 viewstr  * view;
 int        n;

 err=NULL;

 if(menu[0]>=0)
 {
  if(getim)
  {
   file=firstfile;
   n=0;

   while(file)
   {
    view=file->view;

    while(view)
    {
     if(n==menu[0]) 
     {
      err=getim(view,getimhandle);
      break;
     }
     view=view->next;
     n++;
    }

    if(view) break;

    file=file->next;
   }
  }
 }

 return(err);
}




static os_error * getimagefile(getimagefn xgetim,viewstr * cview,int handle)
{
 os_error * err;
 filestr  * file;
 viewstr  * view;
 char       name[256];

 err=NULL;

 if(firstfile)
 {
  getim=xgetim;
  getimhandle=handle;

//  err=createusermenu(getimdecode,NULL);
  if(!err)
  {
   file=firstfile;

   while(file)
   {
    view=file->view;

    while(view)
    {
     sprintf(name,"%s / %s",fs_leaf(file->sname),
                            file->frames[view->frame].name);

//     err=addusermenu(name,cview==view?wimp_MTICK:0);
     if(err) break;

     view=view->next;
    }

    file=file->next;
   }
  }

//  completeusermenu("Image");

//  openupmenu(usermenuindex);
 }

 return(err);

 USE(cview);
}



/****************************************************************************/

extern dboxstr cbox;

static viewstr * cview1;
static viewstr * cview2;


static os_error * cgetim1(viewstr * view,int handle)
{
 cview1=view;
 dbchangevalue((int*)&cview1,&cbox);

 return(NULL);
 USE(handle);
}


static os_error * cgetim2(viewstr * view,int handle)
{
 cview2=view;
 dbchangevalue((int*)&cview2,&cbox);

 return(NULL);
 USE(handle);
}



static os_error * wrv(int value,char * string)
{
 viewstr * view;
 filestr * file;

 view=(viewstr*)value;

 if(view)
 {
  file=view->file;
  sprintf(string,"%s / %s",fs_leaf(file->sname),
                           file->frames[view->frame].name);
 }
 else
 {
  sprintf(string,"None");
 }

 return(NULL);
}




static os_error * wrb(int value,char * string)
{
 strcpy(string,numbertostringxdp(value,2,0));
 return(NULL);
}



static os_error * wrc(int value,char * string)
{
 strcpy(string,numbertostringxdp(value,2,0));
 return(NULL);
}


static os_error * wrg(int value,char * string)
{
 strcpy(string,numbertostringxdp(value,2,0));
 return(NULL);
}




static os_error * cicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;


 switch(m->i)
 {

  case 1:
         getimagefile(cgetim1,cview1,0);
         break;

  case 3:
         getimagefile(cgetim2,cview2,0);
         break;


  case 18:
          err=compareimages(cview1,cview2);
          dbwritevalues(&cbox);
          break;
 }

 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * cclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {


 }

 return(err);
}



static dbiconstr cicondefs[]=
{
 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    0, (int*)&cview1, DBTEXT,   0,   0,      0,  0, 0, 0,         NULL,wrv,
    2, (int*)&cview2, DBTEXT,   0,   0,      0,  0, 0, 0,         NULL,wrv,

    9, &xbrightness[RED],DBTEXT,0,   0,      0,  0, 0, 0,         NULL,wrb,
   10, &xcontrast[RED],DBTEXT,0,     0,      0,  0, 0, 0,         NULL,wrc,
   11, &xgamma[RED],DBTEXT,0,        0,      0,  0, 0, 0,         NULL,wrg,

   12, &xbrightness[GREEN],DBTEXT,0, 0,      0,  0, 0, 0,         NULL,wrb,
   13, &xcontrast[GREEN],DBTEXT,0,   0,      0,  0, 0, 0,         NULL,wrc,
   14, &xgamma[GREEN],DBTEXT,0,      0,      0,  0, 0, 0,         NULL,wrg,

   15, &xbrightness[BLUE],DBTEXT,0,  0,      0,  0, 0, 0,         NULL,wrb,
   16, &xcontrast[BLUE],DBTEXT,0,    0,      0,  0, 0, 0,         NULL,wrc,
   17, &xgamma[BLUE],DBTEXT,0,       0,      0,  0, 0, 0,         NULL,wrg,


   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr cbox=
{
 0,
 TCOMPARE,
 DBFIX,
 0,
 cclose,
 cicon,
 NULL,
 NULL,
 cicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};








os_error * compare(void)
{
 os_error * err;

 err=NULL;

 if(cbox.handle)
 {
  err=forward(cbox.handle,0,NULL);

 }
 else
 {

  err=dodbox(&cbox,1);
 }

 return(err);
}






static os_error * closeevent(int eventn,wimp_w userhandle,void * data,int data1)
{
 viewstr * view;
// filestr * file;


 if(eventn==EVENT_VCLOSE)
 {
  view=(viewstr*)data;

  if(view==cview1)
  {
   cview1=NULL;
   dbchangevalue((int*)&cview1,&cbox);
  }
  else
  if(view==cview2)
  {
   cview2=NULL;
   dbchangevalue((int*)&cview2,&cbox);
  }

 }

 return(NULL);

 USE(userhandle);
 USE(data1);
}









os_error * compareinit(void)
{
 os_error * err;

 err=addevent(EVENT_VCLOSE,closeevent,0);

 return(err);
}


