/*->c.col */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <math.h>


#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"
#include "bbc.h"


#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "mlo.h"
#include "units.h"
#include "redraw.h"
#include "colour.h"
#include "drag.h"
#include "config.h"
#include "deb.h"

#include "resource.h"
#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewo.h"
#include "viewr.h"
#include "select.h"
#include "im.h"
#include "bm.h"
#include "fx.h"
#include "format.h"
#include "pal.h"
#include "edit.h"
#include "hsv.h"
#include "long.h"
#include "undo.h"
#include "cmap.h"
#include "cms.h"

#include "col.h"


int redweight;
int greenweight;
int blueweight;

/*****************************************************************************/

#define MAXCONTRAST 100
#define MAXBRIGHT   100
#define MAXHUE      100
#define MAXSAT      100

#define MAXGAMMA    500
#define MINGAMMA    5


static int brightness=MAXBRIGHT;
static int contrast=MAXCONTRAST;
static int hue=MAXHUE;
static int saturation=MAXSAT;

static int mapr;
static int mapg;
static int mapb;


char rvmap[256];
char gvmap[256];
char bvmap[256];


/* takes hsv and makes gamma maps */


#ifdef NEVER

static void makemaps(void)
{
/* int b;
 int c;
 int x;
 int i;

 b=(brightness-MAXBRIGHT)/(MAXBRIGHT/256);
 c=(contrast-MAXCONTRAST)/(MAXCONTRAST/256);

 for(i=0;i<256;i++)
 {
  rvmap[i]=gvmap[i]=bvmap[i]=i;

  x=CUT((rvmap[i]+b),0,255);
  x=CUT((x+(x*c)/128),0,255);

  if(mapr) rvmap[i]=x;
  if(mapg) gvmap[i]=x;
  if(mapb) bvmap[i]=x;
 } */
}

#endif

#ifdef NEVER

static os_error * cbalicon(int handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;
/*
 switch(m->i)
 {

 }
*/
 return(err);

 USE(m);
 USE(userhandle);
 USE(handle);
}


#endif


static os_error * cbalkey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 return(viewsubkey(menuview,key));

 USE(handle);
 USE(userhandle);
 USE(icon);
}






static os_error * cbalclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  hsvmapstart(contrast-MAXCONTRAST,brightness-MAXBRIGHT,
              saturation-MAXSAT,hue-MAXHUE);
  err=mapfx(menuview,menufile,MIHSV);
  hsvmapend();
 }
 return(err);
}


static os_error * cbalredrawsub(wimp_w handle,wimp_redrawstr * redrawstr,
                                                                     int more)
{
 os_error * err;

 err=NULL;

 while(more)
 {
  redrawslider2(redrawstr,101,102,handle,contrast,2*MAXCONTRAST);
  redrawscale(redrawstr,102,handle);

  redrawslider2(redrawstr,4,5,handle,brightness,2*MAXBRIGHT);
  redrawscale(redrawstr,5,handle);

  redrawslider2(redrawstr,8,10,handle,hue,2*MAXHUE);
  redrawscale(redrawstr,10,handle);

  redrawslider2(redrawstr,9,11,handle,saturation,2*MAXSAT);
  redrawscale(redrawstr,11,handle);

  err=wimp_get_rectangle(redrawstr,&more);
 }

 return(err);
}


static os_error * cbalredraw(wimp_w handle,uservalue userhandle)
{
 os_error     * err;
 wimp_redrawstr redrawstr;
 int            more;
 redrawstr.w=handle;
 err=wimp_redraw_wind(&redrawstr,&more);
 if(!err) err=cbalredrawsub(handle,&redrawstr,more);
 return(err);
 USE(userhandle);
}

static os_error * wrcbal(int value,char * string)
{
 value=value-MAXCONTRAST;
 strcpy(string,numbertostring(value));
// strcat(string,"%");
 return(NULL);
}

static os_error * rdcbal(int * value,char * string)
{
 os_error * err;
 int        temp;

 err=stringtonumber(string,&temp);
 temp+=MAXCONTRAST;
 *value=temp;

 return(err);
}


static dbiconstr cbalicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0, NULL ,0,

  101,  &contrast,   DBSLIDER2,0,    0,    102,-1,2*MAXCONTRAST, 0, NULL, 0,
    4,  &brightness, DBSLIDER2,0,    0,      5,-1,2*MAXBRIGHT,   0, NULL, 0,
    8,  &hue,        DBSLIDER2,0,    0,     10,-1,2*MAXHUE,      0, NULL, 0,
    9,  &saturation, DBSLIDER2,0,    0,     11,-1,2*MAXSAT,      0, NULL, 0,

   13,  &contrast,   DBWRITE,  0,    0,     -1, -1, 14, -1,  rdcbal,wrcbal,
   14,  &brightness, DBWRITE,  0,    0,     -1, -1, 15, 13,  rdcbal,wrcbal,
   15,  &hue,        DBWRITE,  0,    0,     -1, -1, 16, 14,  rdcbal,wrcbal,
   16,  &saturation, DBWRITE,  0,    0,     -1, -1, -1, 15,  rdcbal,wrcbal,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};


static dboxstr cbalbox=
{
 0,
 TBAL,
 DBFIX,
 DBUPDATECARET,
 cbalclose,
 NULL, // cbalicon,
 cbalkey,
 cbalredraw,
 cbalicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * cbalanceopen(wimp_w parent)
{
 os_error * err;

/* brightness=MAXBRIGHT;
 contrast=MAXCONTRAST;
 hue=MAXHUE;
 saturation=MAXSAT; */


 if(cbalbox.handle) dbclose(&cbalbox,DBCANCEL);
 err=dodboxparent(&cbalbox,1,parent);


 return(err);
}


/*****************************************************************************/


extern dboxstr processbox;


#define MAXCONTRASTLEVELS 32
#define MINCONTRASTLEVELS 4


#define CMSTEP   0
#define CMSMOOTH 1
#define CMGAMMA  2
#define CMTHRESH 3


static int          cmode;                 /* Normal, High, Poster */
static int          omode;                 /* old mode             */
static int          ccmode;                /* bit mask, R, G, B    */
static int          clevels;
static char         cin[MAXCONTRASTLEVELS];
static char         cout[MAXCONTRASTLEVELS];

static int gamma;     /* gamma * 100 */

#define MAXC 255

#define GRIDICON 102

#define DXBLOB 5
#define DYBLOB 5

#define MX 8
#define MY 8


static os_error * redrawgrid(wimp_redrawstr * redrawstr,wimp_w handle)
{
 os_error * err;
 int        ox;
 int        oy;
 iconstr    icon;
 int        cx;
 int        cy;
 int        w;
 int        h;
 int        dx;
 int        dy;
 int        x;
 int        y;
 int        i;
 int        j;
 int        nextx;
 int        col;

 err=geti(handle,GRIDICON,&icon);

 if(iconinredraw(redrawstr,&icon))
 {
  ox=redrawstr->box.x0-redrawstr->scx;
  oy=redrawstr->box.y1-redrawstr->scy;
  cx=icon.ix0;
  cy=icon.iy0;

  w=icon.ix1-cx-MX;
  h=icon.iy1-cy-MY;
  dx=w/11;
  dy=h/11;

  /* cx,cy bottom left hand corner of grid, cy is -ve. */

  wimp_setcolour(WIMPBLACK);
  bbc_move(ox+cx+dx,oy+cy);
  bbc_draw(ox+cx+dx,oy+icon.iy1);
  bbc_move(ox+cx,oy+cy+dy);
  bbc_draw(ox+icon.ix1,oy+cy+dy);

  y=oy+cy+2*dy;
  for(i=0;i<10;i++)
  {
   bbc_move(ox+cx+dx,y);
   if(i!=4 && i!=9) bbc_draw(ox+cx+dx/4,y);
   else             bbc_draw(ox+cx,y);
   y+=dy;
  }

  x=ox+cx+2*dx;
  for(i=0;i<10;i++)
  {
   bbc_move(x,oy+cy+dy);
   if(i!=4 && i!=9) bbc_draw(x,oy+cy+dy/4);
   else             bbc_draw(x,oy+cy);
   x+=dx;
  }

  x=ox+cx+2*dx;
  for(i=0;i<10;i++)
  {
   y=oy+cy+2*dy;
   for(j=0;j<10;j++)
   {
    bbc_plot(bbc_Point+bbc_DrawAbsFore,x,y);
    y+=dy;
   }
   x+=dx;
  }

  w-=dx;
  h-=dy;
  cx+=dx;
  cy+=dy;

  wimp_setcolour(WIMPLBLUE);

  if(cmode==CMSTEP)
  {
   for(i=0;i<(clevels-1);i++)
   {
    x=ox+cx+(cin[i]*w)/MAXC;
    y=oy+cy+(cout[i]*h)/MAXC;
    nextx=ox+cx+(cin[i+1]*w)/MAXC;

    col=0;

    if(ccmode & 0x1) {col|=cout[i]<<8;}
    if(ccmode & 0x2) {col|=cout[i]<<16;}
    if(ccmode & 0x4) {col|=cout[i]<<24;}

    setgcol(col);
    bbc_rectanglefill(x,oy+cy,nextx-x,(cout[i]*h)/MAXC);

    wimp_setcolour(WIMPBLACK);
    bbc_rectangle(x,oy+cy,nextx-x,(cout[i]*h)/MAXC);
   }
  }
  else
  {
   for(i=0;i<clevels;i++)
   {
    x=ox+cx+(cin[i]*w)/MAXC;
    y=oy+cy+(cout[i]*h)/MAXC;

    if(i) bbc_draw(x,y);

    bbc_move(x-DXBLOB,y-DYBLOB);
    bbc_plot(96+5,x+DXBLOB,y+DYBLOB);
    bbc_move(x,y);
   }
  }
 }

 return(NULL);
}


static int nearest(int x,int y)
{
 int i;
 int n;
 int s;
 int temp;

 n=-1;
 s=0;

 for(i=0;i<clevels;i++)
 {
  if((temp=(cin[i]-x)*(cin[i]-x)+(cout[i]-y)*(cout[i]-y))<s || n<0)
  {
   n=i;
   s=temp;
  }
 }

 return(n);
}


static void setgrid(int n,int x,int y)
{
 if(n!=0 && n!=(clevels-1)) 
 {
  if(cmode==CMSMOOTH) cin[n]=(char)x;
  else
  if(cmode==CMTHRESH) {cin[1]=cin[2]=(char)x;}
 }
 if(cmode==CMSMOOTH  || cmode==CMSTEP) cout[n]=(char)y;

 wimp_set_icon_state(processbox.handle,GRIDICON,(wimp_iconflags)0,(wimp_iconflags)0);
}


static void newlevels(void)
{
 int i;
 for(i=0;i<clevels;i++)
 {
  cin[i]=cout[i]=(char)((MAXC*i)/(clevels-1));
 }
}


static void newsteps(void)
{
 int i;
 for(i=0;i<clevels;i++)
 {
  cin[i]=(char)((MAXC*i)/(clevels-1));

  if(i<(clevels-1)) cout[i]=(char)((MAXC*i)/(clevels-2));
  else              cout[i]=(char)cout[i-1];
 }
}


static void newgamma(void)
{
 int i;
 for(i=0;i<clevels;i++)
 {
  cin[i]=(char)((MAXC*i)/(clevels-1));
  cout[i]=(char)(int)(MAXC*pow((double)cin[i]/(double)MAXC,(double)gamma/100.0));
 }
}


static void newthresh(void)
{
 clevels=4;
 cin[0]=0;
 cout[0]=0;
 cin[3]=MAXC;
 cout[3]=MAXC;
 cin[1]=cin[2]=MAXC/2;
 cout[1]=0;
 cout[2]=MAXC;
}


static int griddrag;
static int griddragn;
static os_error * gridclick(wimp_w handle,wimp_mousestr * m);
static int oldx;
static int oldy;

static os_error * griddragzero(wimp_w handle,uservalue userhandle,wimp_mousestr * mstr)
{

// wimp_get_point_info(&mstr);
 if(mstr->x!=oldx || mstr->y!=oldy)
 {
  gridclick(handle,mstr);
  oldx=mstr->x;
  oldy=mstr->y;
 }

 return(NULL);

 USE(userhandle);
}



static os_error * griddragend(wimp_w handle,uservalue userhandle,wimp_box * box)
{
 os_error * err;

 err=NULL;

// err=remzeroevent(griddragzero,handle);
 griddrag=0;

 return(err);

 USE(userhandle);
 USE(box);
 USE(handle);
}



static os_error * gridclick(wimp_w handle,wimp_mousestr * m)
{
 os_error * err;
 windowstr  window;
 iconstr    icon;
 int        cx;
 int        cy;
 int        dx;
 int        dy;
 int        w;
 int        h;
 int        n;
 int        vx;
 int        vy;
 int        minx;
 int        maxx;

          err=getw(handle,&window);
 if(!err) err=geti(handle,GRIDICON,&icon);
 if(!err)
 {
  cx=window.bx+icon.ix0;
  cy=window.by+icon.iy0;

  w=icon.ix1-icon.ix0-MX;
  h=icon.iy1-icon.iy0-MY;
  dx=w/11;
  dy=h/11;
  w-=dx;
  h-=dy;
  cx+=dx;
  cy+=dy;

  vx=((m->x-cx)*MAXC)/w;
  vx=CUT(vx,0,MAXC);
  vy=((m->y-cy)*MAXC)/h;
  vy=CUT(vy,0,MAXC);

  if(griddrag) n=griddragn;
  else         n=nearest(vx,vy);

  setgrid(n,vx,vy);

  minx=cx;
  maxx=cx+w;

  if(cmode==CMSTEP)
  {
   minx=cx+(cin[n]*w)/MAXC;
   if(n<(clevels-1)) maxx=cx+(cin[n+1]*w)/MAXC;
  }
  else
  if(cmode!=CMTHRESH)
  {
   if(n!=0)          minx=cx+(cin[n-1]*w)/MAXC;
   if(n<(clevels-1)) maxx=cx+(cin[n+1]*w)/MAXC;
  }



  if(m->bbits==0x40 && !griddrag)
  {
   if(!err) err=userdrag(handle,minx,cy,maxx,cy+h);
   if(!err) err=startdrag2(handle,0,griddragend,griddragzero);
 
//   if(!err) err=addzeroevent(griddragzero,handle);

   griddrag=1;
   griddragn=n;
  }
 }
 return(err);
}



static os_error *processcolredrawsub(wimp_w handle,wimp_redrawstr * redrawstr,
                                                                     int more)
{
 os_error * err;

 err=NULL;

 while(more)
 {
  redrawgrid(redrawstr,handle);
  wimp_get_rectangle(redrawstr,&more);
 }
 return(err);

 USE(handle);
}

static os_error * processredraw(wimp_w handle,uservalue userhandle)
{
 os_error     * err;
 wimp_redrawstr redrawstr;
 int            more;
 redrawstr.w=handle;
 err=wimp_redraw_wind(&redrawstr,&more);

 if(!err) err=processcolredrawsub(handle,&redrawstr,more);

 return(err);
 USE(userhandle);
}



static os_error * invert(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 int i;

 for(i=0;i<clevels;i++)
 {
  cout[i]=(char)(MAXC-cout[i]);
 }
 wimp_set_icon_state(handle,GRIDICON,(wimp_iconflags)0,(wimp_iconflags)0);

 return(NULL);
 USE(handle);
 USE(userhandle);
 USE(m);
}




static os_error * processicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case       23:
                err=invert(handle,userhandle,m);
                break;

  case       24:
                if(cmode==CMSMOOTH) newlevels();
                else
                if(cmode==CMSTEP)  newsteps();

                wimp_set_icon_state(processbox.handle,GRIDICON,(wimp_iconflags)0,(wimp_iconflags)0);
                break;

  case GRIDICON:
                err=gridclick(handle,m);
                break;
 }

 return(err);
 USE(userhandle);
}



static os_error * addcolour(viewstr * view,filestr * file)
{
 os_error * err;
 int        i;
 int        tfrontp;
 int        r;
 int        g;
 int        b;

 mapr=mapg=mapb=1;

 tfrontp=(tfront*256)/255;

 for(i=0;i<256;i++)
 {
  r=i+((rfront*tfrontp)>>8);
  if(r>255) r=255;

  g=i+((gfront*tfrontp)>>8);
  if(g>255) g=255;

  b=i+((bfront*tfrontp)>>8);
  if(b>255) b=255;

  rvmap[i]=(char)r;
  gvmap[i]=(char)g;
  bvmap[i]=(char)b;
 }

 err=mapfx(view,file,MIGAMMA);
 return(err);
}


static os_error * subcolour(viewstr * view,filestr * file)
{
 os_error * err;
 int        i;
 int        tfrontp;
 int        r;
 int        g;
 int        b;

 mapr=mapg=mapb=1;

 tfrontp=(tfront*256)/255;

 for(i=0;i<256;i++)
 {
  r=i-((rfront*tfrontp)>>8);
  if(r<0) r=0;

  g=i-((gfront*tfrontp)>>8);
  if(g<0) g=0;

  b=i-((bfront*tfrontp)>>8);
  if(b<0) b=0;

  rvmap[i]=(char)r;
  gvmap[i]=(char)g;
  bvmap[i]=(char)b;
 }

 err=mapfx(view,file,MIGAMMA);
 return(err);
}


static os_error * tintcolour(viewstr * view,filestr * file)
{
 os_error * err;
 int        i;
 int        tfrontp;
 int        r;
 int        g;
 int        b;

 mapr=mapg=mapb=1;

 tfrontp=(tfront*256)/255;

 for(i=0;i<256;i++)
 {
  r=(i*(256-tfrontp)+rfront*tfrontp)>>8;
  if(r<0)   r=0;
  if(r>255) r=255;

  g=(i*(256-tfrontp)+gfront*tfrontp)>>8;
  if(g<0)   g=0;
  if(g>255) g=255;

  b=(i*(256-tfrontp)+bfront*tfrontp)>>8;
  if(b<0)   b=0;
  if(b>255) b=255;

  rvmap[i]=(char)r;
  gvmap[i]=(char)g;
  bvmap[i]=(char)b;
 }

 err=mapfx(view,file,MIGAMMA);
 return(err);
}


static os_error * filtercolour(viewstr * view,filestr * file)
{
 os_error * err;
 int        i;
 int        tfrontp;
 int        r;
 int        g;
 int        b;


 mapr=mapg=mapb=1;

 tfrontp=(tfront*256)/255;

 for(i=0;i<256;i++)
 {
  r=(i*(256-tfrontp)+(rfront*i*tfrontp)/255)>>8;
  if(r<0)   r=0;
  if(r>255) r=255;

  g=(i*(256-tfrontp)+(gfront*i*tfrontp)/255)>>8;
  if(g<0)   g=0;
  if(g>255) g=255;

  b=(i*(256-tfrontp)+(bfront*i*tfrontp)/255)>>8;
  if(b<0)   b=0;
  if(b>255) b=255;

  rvmap[i]=(char)r;
  gvmap[i]=(char)g;
  bvmap[i]=(char)b;
 }

 err=mapfx(view,file,MIGAMMA);
 return(err);
}




static os_error * invfiltercolour(viewstr * view,filestr * file)
{
 os_error * err;
 int        i;
 int        tfrontp;
 int        r;
 int        g;
 int        b;


 mapr=mapg=mapb=1;

 tfrontp=(tfront*256)/255;

 for(i=0;i<256;i++)
 {
  if(rfront)
  {
   r=(i*(256-tfrontp)+(255*i*tfrontp)/rfront)>>8;
   if(r<0)   r=0;
   if(r>255) r=255;
  }
  else
  {
   r=255;
  }

  if(gfront)
  {
   g=(i*(256-tfrontp)+(255*i*tfrontp)/gfront)>>8;
   if(g<0)   g=0;
   if(g>255) g=255;
  }
  else
  {
   g=255;
  }

  if(bfront)
  {
   b=(i*(256-tfrontp)+(255*i*tfrontp)/bfront)>>8;
   if(b<0)   b=0;
   if(b>255) b=255;
  }
  else
  {
   b=255;
  }

  rvmap[i]=(char)r;
  gvmap[i]=(char)g;
  bvmap[i]=(char)b;
 }

 err=mapfx(view,file,MIGAMMA);
 return(err);
}





static os_error * processclose(int code)
{
 os_error        * err;
 int               i;
 int               j;
 int               x;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  mapr=ccmode & 0x1;
  mapg=ccmode & 0x2;
  mapb=ccmode & 0x4;

  j=0;
  for(i=0;i<256;i++)
  {
   rvmap[i]=gvmap[i]=bvmap[i]=(char)i;

   while(cin[j+1]<i) j++;

   if(cmode==CMSTEP || cmode==CMTHRESH) x=cout[j];
   else
   {
    x=cout[j]+((i-cin[j])*(cout[j+1]-cout[j]))/(cin[j+1]-cin[j]);
    x=CUT(x,0,255);
   }

   if(mapr) rvmap[i]=(char)x;
   if(mapg) gvmap[i]=(char)x;
   if(mapb) bvmap[i]=(char)x;
  }

  err=mapfx(menuview,menufile,MIGAMMA);
 }
 return(err);
}


static os_error * setupmode(void)
{

 switch(omode)
 {
  case CMTHRESH:
                dbshade(1,0,&processbox);
                break;

 }


 switch(cmode)
 {
     case CMSTEP:
                 newsteps();
                 break;

    case CMGAMMA:
                 newgamma();
                 break;

   case CMTHRESH:
                 newthresh();
                 dbshade(1,1,&processbox);
                 break;

   case CMSMOOTH:
                 if(omode!=CMGAMMA) newlevels();
                 break;

 }

 omode=cmode;

 return(NULL);
}


static os_error * setmode(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 switch(m->i)
 {
  case  3:
  case  4:
  case  5:
  case  6:
          setupmode();
          wimp_set_icon_state(handle,GRIDICON,(wimp_iconflags)0,(wimp_iconflags)0);
          break;
 }

 return(NULL);
 USE(handle);
 USE(userhandle);
 USE(m);
}



static os_error * wrlevel(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdlevel(int * value,char * string)
{
 os_error * err;
 int        temp;

 err=stringtonumber(string,&temp);
 if(!err)
 {
  *value=CUT(temp,MINCONTRASTLEVELS,MAXCONTRASTLEVELS);
 }

 return(err);
}


static os_error * wrgamma(int value,char * string)
{
 strcpy(string,numbertostringdp(value,2));
 return(NULL);
}

static os_error * rdgamma(int * value,char * string)
{
 os_error * err;
 err=stringtonumberdp(string,value,2);
 return(err);
}




static os_error * setgamma(void)
{
 if(cmode==CMGAMMA)  
 {
  newgamma();
  wimp_set_icon_state(processbox.handle,GRIDICON,(wimp_iconflags)0,(wimp_iconflags)0);
 }
 return(NULL);
}



static os_error * newlev(void)
{
 if(cmode==CMSTEP)   newsteps();
 else
 if(cmode==CMGAMMA)  newgamma();
 else
 if(cmode==CMSMOOTH) newlevels();
 else
 if(cmode==CMTHRESH)
 {
  clevels=4;
  return(NULL);
 }

 wimp_set_icon_state(processbox.handle,GRIDICON,(wimp_iconflags)0,(wimp_iconflags)0);

 return(NULL);
}




static os_error * processkey(wimp_w handle,uservalue userhandle,int icon,int * key)
{
 char * string;

 if(icon==0 && *key==RETURN)
 {
  iconaddr(handle,icon,&string);
  rdlevel(&clevels,string);
  newlevels();
  wimp_set_icon_state(processbox.handle,GRIDICON,(wimp_iconflags)0,(wimp_iconflags)0);
 }
 else
 if(icon==17 && *key==RETURN)
 {
  iconaddr(handle,icon,&string);
  rdgamma(&gamma,string);
  newgamma();
  wimp_set_icon_state(processbox.handle,GRIDICON,(wimp_iconflags)0,(wimp_iconflags)0);
 }
 else
 {
  viewsubkey(menuview,key);
 }

 return(NULL);

 USE(userhandle);
}




static dbiconstr processicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key     - -   clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,-1, 0,0,    NULL, 0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE, 0,0,NULL, 0,

   15,  &gamma,      DBDEC,    0,   0,      1,-1,MAXGAMMA,MINGAMMA,NULL,NULL,
   16,  &gamma,      DBINC,    0,   0,      1,-1,MAXGAMMA,MINGAMMA,NULL,NULL,
   17,  &gamma,      DBWRITE,  0,   0,      -1, -1, -1, -1,   rdgamma,wrgamma,


 /* N   &V           Type     Grp   Flags   Step Key  max  min clickfn 0 */

    0,  &clevels,    DBWRITE,  1,   0,      -1, -1, -1, -1,   rdlevel,wrlevel,
   13,  &clevels,    DBDEC,    1,   0,      1,-1,MAXCONTRASTLEVELS,
                                                 MINCONTRASTLEVELS,NULL,NULL,
   14,  &clevels,    DBINC,    1,   0,      1,-1,MAXCONTRASTLEVELS,
                                                 MINCONTRASTLEVELS,NULL,NULL,


 /* N   &V           Type     Grp   Flags   Msk Key -  -      clickfn 0 */

   3,  &cmode,      DBRADIO,  0,   0,CMSTEP,  F1, 1,0,(dbreadfn)setmode,NULL,
   4,  &cmode,      DBRADIO,  0,   0,CMSMOOTH,F2, 1,0,(dbreadfn)setmode,NULL,
   5,  &cmode,      DBRADIO,  0,   0,CMGAMMA, F3, 1,0,(dbreadfn)setmode,NULL,
   6,  &cmode,      DBRADIO,  0,   0,CMTHRESH,F4, 1,0,(dbreadfn)setmode,NULL,


   8,  &ccmode,     DBTOGGLE, 0,    0,     1, F5, 1, 0,          NULL,NULL,
  10,  &ccmode,     DBTOGGLE, 0,    0,     2, F6, 1, 0,          NULL,NULL,
  11,  &ccmode,     DBTOGGLE, 0,    0,     4, F7, 1, 0,          NULL,NULL,

GRIDICON, &ccmode,    DBUPDATE, 0,   0,     -1, -1, -1, -1,        NULL,NULL,

GRIDICON, &clevels,   DBUPDATE, 0,   0,   -1, -1, -1, -1,(dbreadfn)newlev,NULL,
GRIDICON, &gamma,     DBUPDATE, 0,   0, -1, -1, -1, -1,(dbreadfn)setgamma,NULL,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr processbox=
{
 0,
 TPROCESS,
 DBFIX,
 0,
 processclose,
 processicon,
 processkey,
 processredraw,
 processicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};



/* script function opens the picture dialogue box */

static os_error * openprocessbox(wimp_w parent)
{
 os_error * err;

 if(!clevels) {clevels=8;newlevels();ccmode=7;gamma=150;cmode=CMSMOOTH;}

 if(processbox.handle) dbclose(&processbox,DBCANCEL);

 err=dodboxparent(&processbox,1,parent);
 omode=-1;

 return(err);
}


/****************************************************************************/

static os_error * greyscale(viewstr * view,filestr * file)
{
 os_error  * err;
 imagestr  * sim;
 imagestr  * dim;
 ximagestr * sxim;
 ximagestr * dxim;


 err=NULL;

 if(file->frames && file->framen)
 {
  sxim=file->frames[view->frame].xim;
  sim=(sxim->sim[IM]);

  longprocstart(NULL,0,sim->ypix,view);

  err=viewdeleteimagefileframe(file,view->frame);

  undostart(sxim);

  if(sim->bpp>8)  /* generate a new dim */
  {
            err=ximnew(sim->xpix,sim->ypix,8,&dxim);  /* make 8bpp map */
   if(!err) err=ximcopyal(sxim,dxim);

   if(!err)
   {
    dim=(dxim->sim[IM]);

    dim->xdpi=sim->xdpi;
    dim->ydpi=sim->ydpi;
    dim->ipal=sim->ipal;
    dim->tr=sim->tr;

    cmscopyprofile(dim,sim);

    err=greyscaleim(sim,dim);

    if(!err)
    {
     if(undosteps) undolink(sxim,dxim);
     else          ximtrash(&sxim);

     file->frames[view->frame].xim=dxim;
    }
    else
    {
     ximtrash(&dxim);
    }
   }
  }
  else 
  {
   if(undosteps) err=ximcopy(sxim,&dxim);
   else          dxim=sxim;

   dim=(dxim->sim[IM]);

   if(!err)
   {
    err=greyscaleim(dim,dim);
    if(undosteps)
    {
     if(err) ximtrash(&dxim);
     else
     {
      undolink(sxim,dxim);
      file->frames[view->frame].xim=dxim;
     }
    }
   }
  }

  viewcreateimagefileframe(file,view->frame);
  refreshviewfileframe(file,view->frame);
  modifyview(view);
  longprocend();
 }
 return(err);
}


static rotmap[4][2]=
{
 ID_COLOUR_ROTATE_ROTATE, MIMROT,
 ID_COLOUR_ROTATE_RG,     MIMRG,
 ID_COLOUR_ROTATE_GB,     MIMGB,
 ID_COLOUR_ROTATE_BR,     MIMBR,
};




static os_error * rotdecode(int * menu)
{
 int code;
 int n;

 code=*menu;

 for(n=0;n<4;n++)
 {
  if(code==rotmap[n][0])
  {
   return(mapfx(menuview,menufile,rotmap[n][1]));
  }
 }
 return(NULL);
}



os_error * coloursetup(void)
{
 int unshade;

 unshade=(menufile->frames && menufile->framen);

 unshademenust(MCOLOUR,ID_COLOUR_GREYSCALE,unshade);
 unshademenust(MCOLOUR,ID_COLOUR_FORMAT,unshade);
 unshademenust(MCOLOUR,ID_COLOUR_BALANCE,unshade);
 unshademenust(MCOLOUR,ID_COLOUR_NONLINEAR,unshade);
 unshademenust(MCOLOUR,ID_COLOUR_PALETTE,unshade);
 unshademenust(MCOLOUR,ID_COLOUR_TINT,unshade);
 unshademenust(MCOLOUR,ID_COLOUR_FILTER,unshade);
 unshademenust(MCOLOUR,ID_COLOUR_ADD,unshade);
 unshademenust(MCOLOUR,ID_COLOUR_SUBTRACT,unshade);
 unshademenust(MCOLOUR,ID_COLOUR_INVERT,unshade);
 unshademenust(MCOLOUR,ID_COLOUR_PROFILE,unshade);

 unshademenust(MROTCOL,ID_COLOUR_ROTATE_ROTATE,unshade);
 unshademenust(MROTCOL,ID_COLOUR_ROTATE_RG,unshade);
 unshademenust(MROTCOL,ID_COLOUR_ROTATE_GB,unshade);
 unshademenust(MROTCOL,ID_COLOUR_ROTATE_BR,unshade);

 return(NULL);
}



os_error * colourdynamic(int * menu,char * handle)
{
 os_error * err;

 err=NULL;

 switch(menu[0])
 {
  case -1:
          err=coloursetup();
          break;


 }
 return(err);

 USE(handle);
}



os_error * colourdecode(int * menu)
{
 os_error * err;

 err=NULL;

 switch(menu[0])
 {
  case 0:           /* user filters */
         err=rotdecode(menu+1);
         break;

  case ID_COLOUR_GREYSCALE:           /* grey scale */
         err=greyscale(menuview,menufile);
         break;

  case ID_COLOUR_FORMAT:
         err=formatopen(menuview->handle);
         break;

  case ID_COLOUR_BALANCE:       /* balance */
         err=cbalanceopen(menuview->handle);
         break;

  case ID_COLOUR_NONLINEAR:       /* non-linear */
         err=openprocessbox(menuview->handle);
         break;

  case ID_COLOUR_PALETTE:
         err=openpal(menuview,menufile);
         break;

  case ID_COLOUR_TINT:
         err=tintcolour(menuview,menufile);
         break;

  case ID_COLOUR_FILTER:
         err=filtercolour(menuview,menufile);
         break;

  case ID_COLOUR_ADD:
         err=addcolour(menuview,menufile);
         break;

  case ID_COLOUR_SUBTRACT:
         err=subcolour(menuview,menufile);
         break;

  case ID_COLOUR_INVERT:
          err=invfiltercolour(menuview,menufile);
          break;

  case ID_COLOUR_PROFILE:
          err=cmsprofiledbox(menuview,menufile);
          break;

 }
 return(err);
}
