/*->c.cms */




#include "stdafx.h"

#include "specstrings.h"
#include "icm.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "resources\resource.h"

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"
#include "alloc.h"
#include "bbc.h"

#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "scanplus.h"
#include "bf.h"
#include "etc.h"
#include "dbhi.h"
#include "key.h"
#include "mlo.h"
#include "units.h"
#include "bits.h"
#include "conf.h"
#include "colour.h"
#include "redraw.h"
#include "xmath.h"
#include "config.h"
#include "pane.h"
#include "save.h"
#include "deb.h"
#include "comctls.h"
#include "osprint.h"
#include "oscms.h"
#include "osgraphics.h"
#include "osreg.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewr.h"
#include "im.h"
#include "long.h"

#include "bm.h"
#include "fx.h"
#include "user.h"
#include "col.h"
#include "hist.h"
#include "edit.h"
#include "zmath.h"
#include "format.h"
#include "undo.h"


#include "cms.h"


#include "lcms.h"



static int useicm=1;

static os_error * cmserr;


static int cmsErrorHandler(int ErrorCode,const char *ErrorText)
{

 cmserr=generror(ErrorCode,(char*)ErrorText);
// errorbox((char*)ErrorText);

 return(1);

 USE(ErrorCode);
}



static os_error * XcmsCloseProfile(cmsHPROFILE hProfile)
{
	os_error * err;

	if(useicm)
	{
  err=XCloseColorProfile((HPROFILE)hProfile);
		return(err);
	}
	else
	{
  cmserr=NULL;
  cmsCloseProfile(hProfile);
  return(cmserr);
	}
}





static os_error * XcmsOpenProfileFromFile(const char *ICCProfile, const char *sAccess,cmsHPROFILE * hprofile)
{
	os_error * err;

	if(useicm)
	{
		PROFILE Profile;

		Profile.cbDataSize=(DWORD)(strlen(ICCProfile)+1);
		Profile.dwType=PROFILE_FILENAME;
		Profile.pProfileData=(void*)ICCProfile;

	 err=XOpenColorProfile(&Profile,PROFILE_READ,FILE_SHARE_READ,OPEN_EXISTING,(HPROFILE*)hprofile);

		return(err);
	}
	else
	{
  cmserr=NULL;
  *hprofile=cmsOpenProfileFromFile(ICCProfile,sAccess);
  return(cmserr);
	}
}



static os_error * XcmsOpenProfileFromMem(LPVOID MemPtr,DWORD dwSize,cmsHPROFILE * hprofile)
{
	os_error * err;

	if(useicm)
	{
		PROFILE Profile;

		Profile.cbDataSize=dwSize;
		Profile.dwType=PROFILE_MEMBUFFER;
		Profile.pProfileData=MemPtr;

	 err=XOpenColorProfile(&Profile,PROFILE_READ,FILE_SHARE_READ,OPEN_EXISTING,(HPROFILE*)hprofile);

		return(err);
	}
	else
	{
  cmserr=NULL;
  *hprofile=cmsOpenProfileFromMem(MemPtr,dwSize);
  return(cmserr);
	}
}



static void mapformat(int format,DWORD * cmsformat)
{
 if(format==CMS_CMYK)  *cmsformat=TYPE_CMYK_8;
 else
 if(format==CMS_RGB)   *cmsformat=TYPE_RGB_8;
 else
// if(format==CMS_BGRA)  *cmsformat=TYPE_BGRA_8;
// else
 if(format==CMS_RGBA)  *cmsformat=TYPE_RGBA_8;
 else
 if(format==CMS_ARGB)  *cmsformat=TYPE_ARGB_8;
 else                  *cmsformat=TYPE_BGRA_8;

}




static void icmmapformat(int format,BMFORMAT * icmformat)
{
 if(format==CMS_CMYK)  *icmformat=BM_KYMCQUADS;							// KKYYMMCC
 else
 if(format==CMS_RGBA)  *icmformat=BM_xBGRQUADS;	  				// XXBBGGRR
 else                  *icmformat=BM_RGBTRIPLETS;

}




//#define CMM_FROM_PROFILE 0

static os_error * XcmsCreateTransform(cmsHPROFILE Input,
                                       DWORD InputFormat,
                                       cmsHPROFILE Output,
                                       DWORD OutputFormat,
                                       int Intent,
                                       DWORD dwFlags,cmsHTRANSFORM * htransform)
{
	os_error * err;

	if(useicm)
	{
		HPROFILE Profiles[2];

		Profiles[0]=(HPROFILE)Input;
		Profiles[1]=(HPROFILE)Output;

  err=XCreateMultiProfileTransform(Profiles,2,(DWORD*)&Intent,1,NORMAL_MODE,INDEX_DONT_CARE/*CMM_FROM_PROFILE*/,(HTRANSFORM*)htransform);

#ifdef _DEBUG
  {
   int code;

   code=GetCMMInfo((HTRANSFORM)(*htransform),CMM_IDENT);

   cprintf("GetCMM %x",code);
  }
#endif

		return(err);
	}
	else
	{
		DWORD inputformat;
		DWORD outputformat;

  mapformat(InputFormat,&inputformat);
  mapformat(OutputFormat,&outputformat);


  cmserr=NULL;
  *htransform=cmsCreateTransform(Input,inputformat,Output,outputformat,Intent,dwFlags);
  return(cmserr);
	}
}



static os_error * XcmsCreateProofingTransform(cmsHPROFILE Input,
                        DWORD InputFormat,
                        cmsHPROFILE Output,
                        DWORD OutputFormat,
                        cmsHPROFILE Proofing,
                        int Intent,
                        int ProofingIntent,
                        DWORD dwFlags,cmsHTRANSFORM * htransform)
{
	os_error * err;

	if(useicm)
	{
		HPROFILE Profiles[3];
		DWORD    Intents[3];

		Profiles[0]=(HPROFILE)Input;
		Profiles[1]=(HPROFILE)Proofing;
		Profiles[2]=(HPROFILE)Output;

		Intents[0]=INTENT_ABSOLUTE_COLORIMETRIC;
		Intents[1]=ProofingIntent;
		Intents[2]=Intent;

  err=XCreateMultiProfileTransform(Profiles,3,Intents,3,NORMAL_MODE,INDEX_DONT_CARE/*CMM_FROM_PROFILE*/,(HTRANSFORM*)htransform);

#ifdef _DEBUG
  {
   int code;

   code=GetCMMInfo((HTRANSFORM)(*htransform),CMM_IDENT);

   cprintf("GetCMM %x",code);
  }
#endif

		return(err);
	}
	else
	{
		DWORD inputformat;
		DWORD outputformat;

  mapformat(InputFormat,&inputformat);
  mapformat(OutputFormat,&outputformat);

  cmserr=NULL;
  *htransform=cmsCreateProofingTransform(Input,inputformat,Output,outputformat,Proofing,Intent,ProofingIntent,dwFlags);
  return(cmserr);
	}
}


static os_error * XcmsDeleteTransform(cmsHTRANSFORM hTransform)
{
	os_error * err;

	if(useicm)
	{
		err=XDeleteColorTransform((HTRANSFORM)hTransform);

		return(err);
	}
	else
	{
  cmserr=NULL;
  cmsDeleteTransform(hTransform);
  return(cmserr);
	}
}




static os_error * XcmsIsTag(cmsHPROFILE hProfile,int tag,int * exists)
{
	os_error * err;

	if(useicm)
	{
		err=XIsColorProfileTagPresent((HPROFILE)hProfile,(TAGTYPE)tag,(PBOOL)exists);

		return(err);
	}
	else
	{
  cmserr=NULL;
 	*exists=cmsIsTag(hProfile,(icTagSignature)tag);
 	return(cmserr);
	}
}


static os_error * XcmsReadICCText(cmsHPROFILE hProfile,int tag,char * text,int size)
{
	os_error * err;

	if(useicm)
	{
		DWORD pcbSize;
		BOOL  ref;

		pcbSize=size;

//  err=XGetColorProfileElement((HPROFILE)hProfile,(TAGTYPE)tag,0,&pcbSize,NULL,&ref);
//  if(!err)
 err=XGetColorProfileElement((HPROFILE)hProfile,(TAGTYPE)tag,12,&pcbSize,text,&ref);

		return(NULL);
	}
	else
	{
  cmserr=NULL;
  cmsReadICCText(hProfile,(icTagSignature)tag,text);

//		cprintf("cmsread %s",text);
 	return(cmserr);
	}
}



static os_error * XcmsDoTransform(cmsHTRANSFORM hTransform,
                                  LPVOID InputBuffer,int informat,
                                  LPVOID OutputBuffer,int outformat,unsigned int Size)
{
	os_error * err;

	if(useicm)
	{
		BMFORMAT	bmInputFormat=BM_BGRTRIPLETS ;
		BMFORMAT bmOutputFormat=BM_BGRTRIPLETS ;


		icmmapformat(informat,&bmInputFormat);
		icmmapformat(outformat,&bmOutputFormat);

  err=XTranslateBitmapBits((HTRANSFORM)hTransform,InputBuffer,bmInputFormat,Size,1,0,
																																													OutputBuffer,bmOutputFormat,0,NULL,0);


		return(err);
	}
	else
	{
  cmserr=NULL;
  cmsDoTransform(hTransform,InputBuffer,OutputBuffer,Size);
  return(cmserr);
	}
}


static os_error * XcmsGetColorSpace(cmsHPROFILE hProfile,int * cspace)
{
	os_error * err;

	if(useicm)
	{
  PROFILEHEADER Header;
		err=XGetColorProfileHeader((HPROFILE)hProfile,&Header);
		*cspace=Header.phDataColorSpace;

		return(err);
	}
	else
	{
  cmserr=NULL;
  *cspace=cmsGetColorSpace(hProfile);
 	return(cmserr);
	}
}


static char * upaths[]=
{
 "<%SystemRoot%>\\System32\\SPOOL\\DRIVERS\\COLOR",
 "<%SystemRoot%>\\System32\\COLOR",
 "<%Windir%>\\System\\SPOOL\\DRIVERS\\COLOR",
 "<%Windir%>\\System\\COLOR"


};


static char * upath0;
static char * upath1;

static char   icmpath[MAX_PATH];


static os_error * XcmsGetPaths(void)
{
	os_error * err;

	if(useicm)
	{
		DWORD size;

		size=sizeof(icmpath);
  err=XGetColorDirectory(NULL,icmpath,&size);

		upath0=icmpath;
		upath1=NULL;

		return(err);
	}
	else
	{
 	if(ISW9X)
 	{
 		upath0=upaths[2];
 		upath1=upaths[3];
 	}
 	else
 	{
 		upath0=upaths[0];
 		upath1=upaths[1];
	 }

		return(NULL);
	}
}




static char * cmsmatchers="HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Windows NT\\CurrentVersion\\ICM\\ICMatchers";


#define MAXCMM 32

static int     cmsmodules;
static char *  cmsmodulename[MAXCMM];
static int     cmsmoduleid[MAXCMM];

static int cmsmoduleindex(int useicm)
{
 int i;

 for(i=0;i<cmsmodules;i++)
 {
  if(cmsmoduleid[i]==useicm) return(i);
 }

 return(0);
}


static int cmsmodulefromindex(int index)
{
 if(index>=0 && index<cmsmodules) return(cmsmoduleid[index]);
 return(0);
}




// translate ASCII to integer, taking the ASCII values in turn, inverse of 'ADBE'

static int atoicv(char * string,int * len)
{
 char * p;
 int    val;
 int    c;


 p=string;
 val=0;

 while((c=(*p++))!=0)
 {
  val=val*256+c;
 }

 if(len) *len=p-string;

 return(val);
}



static os_error * XcmsCMM(void)
{
 os_error * err;
 int        eof;
 int        index;
 int        size;
 int        dsize;
 int        stype;
 oskeyh     skey;
 char       string[256];
 char       data[MAX_PATH];
 char     * alloc;
 char     * p;

 err=NULL;

 cmsmodulename[0]="LCMS";
 cmsmoduleid[0]=0;

 cmsmodulename[1]="Windows default";
 cmsmoduleid[1]=1;

 cmsmodules=2;


 err=regopenkey(cmsmatchers,&skey,'r');
 if(!err)
 {
  index=0;
  while(1)
  {
   size=sizeof(string)/sizeof(TCHAR);
			dsize=sizeof(data); // NB bytes not TCHARs
   err=regenumvalue(skey,string,&size,&stype,data,&dsize,&eof,&index);

   if(err) break;
   if(eof) break;

   if(stype==REG_SZ)
   {
    cmsmoduleid[cmsmodules]=atoicv(string,NULL);

    p=fs_leaf(data);
    if(p && *p)
    {
     err=stralloc(fs_leaf(data),&alloc);
     if(err) break;

     cmsmodulename[cmsmodules++]=alloc;

     cprintf("XCMS %s %s",string,data);

//     XRegisterCMM(NULL,cmsmoduleid[cmsmodules-1],data);



//     RegisterCMM(NULL,cmsmoduleid[cmsmodules-1],data);
/*
     int xtype;

     fs_exists(data,&xtype);

     cprintf("Register %x %s exists %d",cmsmoduleid[cmsmodules-1],data,xtype);

     HMODULE handle;

extern os_error * XLoadLibrary(LPCTSTR lpFileName,HMODULE * handle);

     XLoadLibrary(data,&handle);
*/

    }
   }
  }
  err=regclosekey(&skey,err);
 }


 return(err);
}







static os_error * XcmsInit(int xuseicm)
{
	os_error * err;
	int        icmpresent;

	err=NULL;

	useicm=0;

	if(xuseicm)
	{
  icminit(&icmpresent);

		if(icmpresent) useicm=xuseicm;

  cprintf("cmsinit %d",icmpresent);
	}

	XcmsGetPaths();
 XcmsCMM();

 if(useicm)
 {
  err=XSelectCMM((useicm==1)?0:useicm);
  cprintf("setting useicm %x %x %x",useicm,'ADBE',err);
  
  report(err);
 }

	if(!useicm)
	{
  cmsErrorAction(LCMS_ERROR_SHOW);
  cmsSetErrorHandler(cmsErrorHandler);
	}

	return(err);
}



/***********************************************************************************/



static os_error * XcmsGetProductName(cmsHPROFILE hProfile,char * Name,int size)
{
	os_error * err;
 char       Manufacturer[512];
 char       Model[512];
	int        exists;


 Name[0]='\0';
 Manufacturer[0]=Model[0]='\0';


 err=XcmsIsTag(hProfile,icSigDeviceMfgDescTag,&exists);
	if(!err)
	{
//		cprintf("mfr ex %d",exists);
		if(exists)
  {
   err=XcmsReadICCText(hProfile,icSigDeviceMfgDescTag,Manufacturer,sizeof(Manufacturer));
  }

  if(!err) err=XcmsIsTag(hProfile,icSigDeviceModelDescTag,&exists);
		if(!err)
		{
//					cprintf("mod ex %d",exists);
			if(exists)
   {
    err=XcmsReadICCText(hProfile,icSigDeviceModelDescTag,Model,sizeof(Model));
   }

			if(!err)
			{
    if(!Manufacturer[0] && !Model[0])
    {
     err=XcmsIsTag(hProfile,icSigProfileDescriptionTag,&exists);
		 		if(!err)
		 		{
//								cprintf("desc ex %d",exists);
		 			if(exists)
      {
       err=XcmsReadICCText(hProfile,icSigProfileDescriptionTag,Name,size);
      }
      else
      {
       strcpy(Name,"{no name}");
      }
	    }
		 	}
		 	else
    if(!Manufacturer[0] || strncmp(Model,Manufacturer,8)==0 || strlen(Model)>30)
   	{
     err=xzstrncpye(Name,Model,size);
   	}
    else
    {
					err=xsprintf(size,NULL,Name, "%s - %s", Model, Manufacturer);
 	  }
			}
		}
	}

//	cprintf("*name %s",*name);
	
 return(err);
}



static os_error * XcmsGetProductDesc(cmsHPROFILE hProfile,char * Name,int size)
{
	os_error * err;
	int        exists;

	*Name=0;

 err=XcmsIsTag(hProfile,icSigProfileDescriptionTag,&exists);
	if(!err)
 {
		if(exists)
		{
   err=XcmsReadICCText(hProfile,icSigProfileDescriptionTag,Name,size);
   if(!err)
   {
    if(strncmp(Name,"Copyrig",7)==0)
				{
     err=XcmsGetProductName(hProfile,Name,size);
				}
			}
  }
  else
  {
   err=XcmsGetProductName(hProfile,Name,size);
		}
	}

 return(err);
}





/**************************************************************************************/




#define CMSTYPEFREE 0x0
#define CMSTYPEFILE 0x1
#define CMSTYPEMEM  0x2



typedef struct cmsprofilestr
{
 int             xtype;

 int             flags;
 char          * leaf;
 char          * name;
 cmsHPROFILE     profile;
 int             cspace;

 unsigned char * data;
 unsigned int    datalen;
 int             count;

} cmsprofilestr;


#define CMSCHUNK (16*sizeof(cmsprofilestr))



static cmsprofilestr * cmsprofile;
static int             cmsprofilen;
static int             cmsprofilen2;

/*

Location Purpose 
C:\WINDOWS\SYSTEM32\COLOR\ Photoshop 5 looks here. 
C:\WINDOWS\SYSTEM32\SPOOL\DRIVERS\COLOR\ Photoshop 6 and 7 look here. 

%system%

*/


//static char * upath="<HKEY_LOCAL_MACHINE\\Software\\DavidPilling\\DPScan\\>\\Profiles";




#define MAXPROFILENAME 128


static char cmykname[MAXPROFILENAME];
static int  cmykindex;

static char monitorname[MAXPROFILENAME];
static int  monitorindex;

static char rgbname[MAXPROFILENAME];
static int  rgbindex;

static char scannername[MAXPROFILENAME];
static int  scannerindex;

static char printername[MAXPROFILENAME];
static int  printerindex;


static int  printerintent;
static int  monitorintent;

static int  cmsactive;
static int  printcmsactive;
static int  proofing;

static int  xcmsactive;
static int  xprintcmsactive;
static int  xproofing;

static int  monitorsystem;
static int  printersystem;

static int  xmonitorsystem;
static int  xprintersystem;

static int  xuseicm;
//static int  xxuseicm;



static char * cmsintentname[]=
{
 "Perceptual",
 "Relative Colourimetric",
 "Saturation",
 "Absolute Colourimetric"
};


#define CMSINTENTN (sizeof(cmsintentname)/sizeof(char*))





/*******************************************************************************/


static int cymkindexfromallindex(int index)
{
 int n;
 int i;

 n=-1;

 for(i=0;i<=index;i++)
 {
  if(cmsprofile[i].cspace==icSigCmykData) n++;
 }

 return(n);
}


static int allindexfromcmykindex(int index)
{
 int i;

 for(i=0;i<cmsprofilen;i++)
 {
  if(cmsprofile[i].cspace==icSigCmykData) index--;
  if(index<0) break;
 }

 return(i);
}



static int rgbindexfromallindex(int index)
{
 int n;
 int i;

 n=-1;

 for(i=0;i<=index;i++)
 {
  if(cmsprofile[i].cspace==icSigRgbData) n++;
 }

 return(n);
}


static int allindexfromrgbindex(int index)
{
 int i;

 for(i=0;i<cmsprofilen;i++)
 {
  if(cmsprofile[i].cspace==icSigRgbData) index--;
  if(index<0) break;
 }

 return(i);
}



static int cmsfirstcmyk(void)
{
 int i;

 for(i=0;i<cmsprofilen;i++)
 {
  if(cmsprofile[i].cspace==icSigCmykData) return(i);
 }

 return(CMS_NONE);
}



static int cmsfirstrgb(void)
{
 int i;

 for(i=0;i<cmsprofilen;i++)
 {
  if(cmsprofile[i].cspace==icSigRgbData) return(i);
 }

 return(CMS_NONE);
}



static int cmsfindname(char * name)
{
 int i;

 for(i=0;i<cmsprofilen;i++)
 {
  if(!cstrcmp(name,cmsprofile[i].name)) break;
 }


 if(i>=cmsprofilen) return(CMS_NONE);

// cprintf("find name %s %s",name,cmsprofile[i].name);

 return(i);
}



static int cmsfindfilename(char * filename)
{
	os_error * err;
 int        i;
	TCHAR      path[MAX_PATH];
	TCHAR      name[MAX_PATH];

 for(i=0;i<cmsprofilen;i++)
 {
  err=fs_expandpath((cmsprofile[i].flags & 0x1)?upath1:upath0,path,sizeof(path));
  if(!err)
  {
   fs_join(name,NITEM(name),path,cmsprofile[i].leaf);

   if(!cstrcmp(filename,name)) break;
  }
	}

	cprintf("find %s found %d",filename,i<cmsprofilen);

 if(i>=cmsprofilen) return(CMS_NONE);

 cprintf("find name %s %s",name,cmsprofile[i].name);

 return(i);
}





typedef struct cmstransformstr
{
 cmsHTRANSFORM hTransform;
 cmsHPROFILE   hInProfile;
 cmsHPROFILE   hOutProfile;
 cmsHPROFILE   hProof;
 int           informat;
 int           outformat;
 int           intent;
 int           proofing;

} cmstransformstr;


static cmstransformstr cmstransform;



static os_error * cmsflushtransform(void)
{

 if(cmstransform.hTransform)
 {
  XcmsDeleteTransform(cmstransform.hTransform);
  cmstransform.hTransform=NULL;
 }

 return(NULL);
}


static os_error * cmsflushtransformprofile(cmsHPROFILE profile)
{

 if(cmstransform.hTransform)
 {
  if(cmstransform.hInProfile==profile || cmstransform.hOutProfile==profile)
  {
   XcmsDeleteTransform(cmstransform.hTransform);
   cmstransform.hTransform=NULL;
  }
 }

 return(NULL);
}




static os_error * cmsfindtransform(improfilestr * in,int informat,improfilestr * out,int outformat,int intent,cmsHTRANSFORM * htransform)
{
 os_error  * err;
 TCHAR       path[MAX_PATH];
 TCHAR       name[MAX_PATH];


 
 err=NULL;

 if(in->index==CMS_NONE || out->index==CMS_NONE)
 {
  *htransform=NULL;

  return(NULL);
 }
 else
 if(cmstransform.hTransform &&
    cmstransform.hInProfile==cmsprofile[in->index].profile &&
    cmstransform.hOutProfile==cmsprofile[out->index].profile &&
    cmstransform.informat==informat &&
    cmstransform.outformat==outformat &&
    cmstransform.intent==intent &&
    cmstransform.proofing==out->proofing &&
    (out->proofing?(cmstransform.hProof==cmsprofile[out->proofingindex].profile):1)
    )
 {


 }
 else
 {
  if(cmstransform.hTransform)
  {
   XcmsDeleteTransform(cmstransform.hTransform);
   cmstransform.hTransform=NULL;
  }

  if(cmsprofile[in->index].profile==NULL)
  {
   if(cmsprofile[in->index].xtype==CMSTYPEFILE)
   {
    err=fs_expandpath((cmsprofile[in->index].flags & 0x1)?upath1:upath0,path,sizeof(path));
    if(!err)
    {
     fs_join(name,NITEM(name),path,cmsprofile[in->index].leaf);
     err=XcmsOpenProfileFromFile(name,TEXT("r"),&cmsprofile[in->index].profile);
    }
   }
   else
   if(cmsprofile[in->index].xtype==CMSTYPEMEM)
   {
    err=XcmsOpenProfileFromMem(cmsprofile[in->index].data,cmsprofile[in->index].datalen,&cmsprofile[in->index].profile);
   }
  }

  if(!err && cmsprofile[out->index].profile==NULL)
  {
   if(cmsprofile[out->index].xtype==CMSTYPEFILE)
   {
    err=fs_expandpath((cmsprofile[out->index].flags & 0x1)?upath1:upath0,path,sizeof(path));
    if(!err)
    {
     fs_join(name,NITEM(name),path,cmsprofile[out->index].leaf);
     err=XcmsOpenProfileFromFile(name,"r",&cmsprofile[out->index].profile);
    }
   }
   else
   if(cmsprofile[out->index].xtype==CMSTYPEMEM)
   {
    err=XcmsOpenProfileFromMem(cmsprofile[out->index].data,cmsprofile[out->index].datalen,&cmsprofile[out->index].profile);
   }
  }


  if(!err && out->proofing && cmsprofile[out->proofingindex].profile==NULL)
  {
   if(cmsprofile[out->proofingindex].xtype==CMSTYPEFILE)
   {
    err=fs_expandpath((cmsprofile[out->proofingindex].flags & 0x1)?upath1:upath0,path,sizeof(path));
    if(!err)
    {
     fs_join(name,NITEM(name),path,cmsprofile[out->proofingindex].leaf);
     err=XcmsOpenProfileFromFile(name,"r",&cmsprofile[out->proofingindex].profile);
    }
   }
   else
   if(cmsprofile[out->proofingindex].xtype==CMSTYPEMEM)
   {
    err=XcmsOpenProfileFromMem(cmsprofile[out->proofingindex].data,cmsprofile[out->proofingindex].datalen,&cmsprofile[out->proofingindex].profile);
   }
  }


  if(!err)
  {


   if(out->proofing)
   {
    err=XcmsCreateProofingTransform(cmsprofile[in->index].profile,informat,
                       cmsprofile[out->index].profile,outformat,
                       cmsprofile[out->proofingindex].profile,INTENT_ABSOLUTE_COLORIMETRIC,
                       intent,/*cmsFLAGS_GAMUTCHECK|*/cmsFLAGS_SOFTPROOFING,
                       &cmstransform.hTransform);




   }
   else
   {
    err=XcmsCreateTransform(cmsprofile[in->index].profile,informat,
                       cmsprofile[out->index].profile,outformat,
                       intent,0,&cmstransform.hTransform);
   }

   cmstransform.hInProfile=cmsprofile[in->index].profile;
   cmstransform.hOutProfile=cmsprofile[out->index].profile;
   cmstransform.informat=informat;
   cmstransform.outformat=outformat;
   cmstransform.intent=intent;
   cmstransform.proofing=out->proofing;

   if(out->proofing) cmstransform.hProof=cmsprofile[out->proofingindex].profile;
   else              cmstransform.hProof=NULL;
  }
 }

 *htransform=cmstransform.hTransform;

 return(err);
}



static int * cmstransbuffer;

#define CMSTRANCHUNK 0x200



os_error * cmstranslate(int * ddata,int * sdata,int xpix,improfilestr * in,int informat,improfilestr * out,int outformat)
{
 os_error       * err;
 cmsHTRANSFORM    cmstransform;
 int              informatp;
 int              outformatp;
 int            * sdatap;
 int            * ddatap;
 int            * s;
 int            * d;
 int              x;
 int              w;
 int              sbyte;
 int              sshift;
 int              dword;
	char           * p;


 err=NULL;

 if(out->active)
 {
  informatp=informat;
  outformatp=outformat;
  sdatap=sdata;
  ddatap=ddata;

  if(informat==CMS_16)
  {
   if(outformat==CMS_16 || outformat==CMS_RGBA)
   {
    informatp=CMS_RGBA;
    outformatp=CMS_RGBA;
    err=schunk((flex_ptr)&cmstransbuffer,xpix*sizeof(int),CMSTRANCHUNK);
    if(!err)
    {
     sdatap=d=cmstransbuffer;
     if(outformat==CMS_16) ddatap=cmstransbuffer;
     s=sdata;

     w=*s++;
     sshift=0;

     for(x=0;x<xpix;x++)
     {
      sbyte=w>>sshift;

      *d++=((sbyte&0x1F)<<3)|((sbyte&0x3E0)<<6)|((sbyte&0x7C00)<<9);

      sshift+=16;
      if(sshift>=32)
      {
       w=*s++;
       sshift=0;
      }
     }
    }
   }
  }
  else
  if(informat==CMS_RGB)
  {
   informatp=CMS_RGBA;
   outformatp=CMS_RGBA;
   err=schunk((flex_ptr)&cmstransbuffer,xpix*sizeof(int),CMSTRANCHUNK);
   if(!err)
   {
    cprintf("map RGB in");

   	p=(char*)sdata;
    sdatap=d=cmstransbuffer;
    if(outformat==CMS_RGB) ddatap=cmstransbuffer;
    for(x=0;x<xpix;x++)
    {
					w=*p++;
					w|=(*p++)<<8;
					w|=(*p++)<<16;
					*d++=w;
				}
			}
		}
		else
  if(informat==CMS_ARGB)
		{
   informatp=CMS_RGBA;
   outformatp=CMS_RGBA;
   err=schunk((flex_ptr)&cmstransbuffer,xpix*sizeof(int),CMSTRANCHUNK);
   if(!err)
   {
				s=sdata;
    sdatap=d=cmstransbuffer;
    if(outformat==CMS_ARGB) ddatap=cmstransbuffer;
    for(x=0;x<xpix;x++)
    {
					w=*s++;
					*d++=(w>>8)&0xFFFFFF;
				}
			}
		}
		else
		if(informat==CMS_RGBA || informat==CMS_CMYK)
		{
   if(outformat==CMS_16)
   {
    outformatp=CMS_RGBA;
    err=schunk((flex_ptr)&cmstransbuffer,xpix*sizeof(int),CMSTRANCHUNK);
    if(!err)
    {
     ddatap=cmstransbuffer;
  
    }
			}
  }


  if(!err)
  {
   err=cmsfindtransform(in,informatp,out,outformatp,out->intent,&cmstransform);
   if(!err)
   {
    if(cmstransform)
    {
     XcmsDoTransform(cmstransform,sdatap,informatp,ddatap,outformatp,xpix);
    }

    if(outformat==CMS_16)
    {
     if(outformatp==CMS_RGBA)
     {

      s=ddatap;
      d=ddata;

      sshift=0;
      dword=0;


      for(x=0;x<xpix;x++)
      {
       w=*s++;

       sbyte =(w&0xF8)>>3;
       sbyte|=(w&0xF800)>>6;
       sbyte|=(w&0xF80000)>>9;

       dword|=(sbyte<<sshift);
       sshift+=16;
       if(sshift==32)
       {
        *d++=dword;
        sshift=0;
        dword=0;
       }
      }
      if(sshift) *d=dword;
     }
    }
				else
				if(outformat==CMS_RGB)
				{
         cprintf("map RGB out");

					s=cmstransbuffer;
					p=(char*)ddata;
     for(x=0;x<xpix;x++)
     {
 					w=*s++;
 					*p++=(char)(w & 0xFF);
						*p++=(char)((w & 0xFF00)>>8);
						*p++=(char)((w & 0xFF0000)>>16);
 				}
				}
				else
				if(outformat==CMS_ARGB)
				{
 				s=cmstransbuffer;
     d=ddata;
     for(x=0;x<xpix;x++)
     {
 					w=*s++;
 					*d++=(w<<8);
 				}
				}
   }
  }
 }

 return(err);
}






os_error * cmscmykprofile(improfilestr * profile)
{

 profile->index=cmykindex;
 profile->intent=CMS_NOINTENT;

 return(NULL);
}


os_error * cmsrgbprofile(improfilestr * profile)
{

 profile->index=rgbindex;
 profile->intent=CMS_NOINTENT;

 return(NULL);
}





static os_error * cmsmonitorsystem(int * index)
{
	os_error * err;
	char       buffer[MAX_PATH];
	DWORD      size=sizeof(buffer);

	err=NULL;

	if(useicm)
	{
 	buffer[0]=0;
		err=XGetDisplayProfile(buffer,&size);

		cprintf("bufffer %s size %d err %x",buffer,size,err);

  if(!err) *index=cmsfindfilename(buffer);
	}
	else
	{
		*index=monitorindex;
	}

	return(err);
}




static os_error * cmsprintersystem(wimp_redrawstr * r,int * index)
{
	os_error * err;
	char       buffer[MAX_PATH];
	int        size=sizeof(buffer);

	err=NULL;


	if(useicm)
	{
 	buffer[0]=0;

		if(r)	err=XGetICMProfile(((hdcstr*)r->hdcptr)->hdc,(PDWORD)&size,buffer);
		else		err=osprintprofile(&size,buffer);

		cprintf("print profile %s",buffer);

  if(!err) *index=cmsfindfilename(buffer);
	}
	else
	{
		*index=printerindex;
	}

	return(err);
}



os_error * cmsmonitorprofile(improfilestr * profile)
{

	if(useicm)
	{
  if(monitorsystem) cmsmonitorsystem(&monitorindex);
  if(printersystem) cmsprintersystem(NULL,&printerindex);
	}

 profile->index=monitorindex;
 profile->intent=monitorintent;
 profile->active=cmsactive;
 profile->proofing=proofing;
 profile->proofingindex=printerindex;

 if(cmsprofilen<=0) profile->active=0;

 return(NULL);
}




os_error * cmsprinterprofile(wimp_redrawstr * r,improfilestr * profile)
{

	if(useicm)
	{
  if(printersystem) cmsprintersystem(r,&printerindex);
	}

 profile->index=printerindex;
 profile->intent=printerintent;
 profile->active=printcmsactive;
 profile->proofing=0;
 profile->proofingindex=CMS_NONE;

 if(cmsprofilen<=0) profile->active=0;

 return(NULL);
}






os_error * cmsscannerprofile(improfilestr * profile)
{

 profile->index=scannerindex;
 profile->intent=CMS_NOINTENT;

 return(NULL);
}









os_error * cmsinitprofile(improfilestr * profile)
{

 memset(profile,0,sizeof(improfilestr));

 profile->index=CMS_NONE;
 profile->intent=CMS_NOINTENT;

 return(NULL);
}


os_error * cmsscrapprofile(improfilestr * profile)
{
 int index;

 if((index=profile->index)!=CMS_NONE)
 {
  cmsprofile[index].count--;
  if(cmsprofile[index].count<=0)
  {
   if(cmsprofile[index].xtype==CMSTYPEMEM)
   {
    if(cmsprofile[index].profile)
    {
     cmsflushtransformprofile(cmsprofile[index].profile);

     XcmsCloseProfile(cmsprofile[index].profile);
     cmsprofile[index].profile=NULL;
    }

    free(cmsprofile[index].data);
    cmsprofile[index].data=NULL;

    cmsprofile[index].xtype=CMSTYPEFREE;
   }
  }
 }

 return(NULL);
}


os_error * cmscopyprofile(imagestr * dest,imagestr * src)
{
 int index;

 dest->profile=src->profile;

 if((index=dest->profile.index)!=CMS_NONE)
 {
  cmsprofile[index].count++;


 }

 return(NULL);
}




os_error * cmsembedprofile(imagestr * image,unsigned char ** iccdata,unsigned int * icclen)
{
 os_error * err;
 improfilestr * profile;
 int            index;

 err=NULL;

 *iccdata=NULL;
 *icclen=0;

 profile=&image->profile;
 index=profile->index;

 if(cmsprofile[index].xtype==CMSTYPEMEM)
 {
  *iccdata=cmsprofile[index].data;
  *icclen=cmsprofile[index].datalen;
 }

 return(err);
}




os_error * cmsaddprofile(improfilestr * profile,unsigned char ** iccdata,unsigned int icclen,int flags)
{
 os_error    * err;
 int           i;
 cmsHPROFILE   hInProfile;
 char        * str=NULL;
	char          buffer[1024];

 err=NULL;


 for(i=cmsprofilen;i<cmsprofilen2;i++)
 {
  if(cmsprofile[i].xtype==CMSTYPEFREE) break;
 }

 if(i>=cmsprofilen2)
 {
  if(cmsprofile) err=flex_chunk((flex_ptr)&cmsprofile,(cmsprofilen2+1)*sizeof(cmsprofilestr),CMSCHUNK);
  else           err=flex_alloc((flex_ptr)&cmsprofile,CMSCHUNK);

  cmsprofilen2++;
 }

 if(!err)
 {
  cmsprofile[i].xtype=CMSTYPEMEM;

  if(flags & CMSADDALLOC)
  {
   cmsprofile[i].data=(unsigned char*)malloc(icclen);
   cmsprofile[i].datalen=icclen;
   memcpy(cmsprofile[i].data,*iccdata,icclen);
  }
  else
  {
   cmsprofile[i].data=*iccdata;
   cmsprofile[i].datalen=icclen;
   *iccdata=NULL;
  }

  cmsprofile[i].leaf=NULL;
  cmsprofile[i].count=1;
  cmsprofile[i].profile=NULL;

// fill in name so info can display something

  err=XcmsOpenProfileFromMem(cmsprofile[i].data,cmsprofile[i].datalen,&hInProfile);
  if(!err)
  {
   if(hInProfile)
   {
    err=XcmsGetProductDesc(hInProfile,buffer,sizeof(buffer));
				if(!err) err=stralloc(buffer,&str);
    if(!err)
    {
     cmsprofile[i].name=str;

//     cprintf("name %s",str);
    }
     
    XcmsCloseProfile(hInProfile);
   }

   profile->index=i;
   profile->intent=CMS_NOINTENT;
  }
 }


 return(err);
}




static os_error * cmscreateembeddedprofile(improfilestr * src,improfilestr * dest)
{
 os_error * err;
 int        index;
 char       path[MAX_PATH];
 char       name[MAX_PATH];
 unsigned char * iccdata;
 unsigned int    icclen=0;


 err=cmsinitprofile(dest);
	if(!err)
	{
  index=src->index;

  if(cmsprofile[index].xtype==CMSTYPEMEM)
  {
   cmsprofile[index].count++;
  }
  else
  if(cmsprofile[index].xtype==CMSTYPEFILE)
  {
   err=fs_expandpath((cmsprofile[index].flags & 0x1)?upath1:upath0,path,sizeof(path));
   if(!err)
   {
    fs_join(name,NITEM(name),path,cmsprofile[index].leaf);
    if(!err) err=fs_alloc(name,&iccdata,&icclen);
    if(!err) err=cmsaddprofile(dest,&iccdata,icclen,0);
			}
  }

		if(!err)
		{
   dest->intent=src->intent;
		}
	}
 return(err);
}





os_error * cmsprofilename(improfilestr * profile,char * string,int len)
{
 int i;

 *string=0;
 i=profile->index;
 if(i>=0 && i<cmsprofilen2)
 {
  if(cmsprofile[i].xtype==CMSTYPEMEM || cmsprofile[i].xtype==CMSTYPEFILE)
  {
   if(cmsprofile[i].name)
   {
    xzstrncpy(string,cmsprofile[i].name,len);
   }
  }
 }


 return(NULL);
}



int cmsisactive(void)
{
 return(cmsactive);
}








/*******************************************************************************/

extern dboxstr cbox;

static comboboxh combo1boxhandle;
static comboboxh combo2boxhandle;
static comboboxh combo3boxhandle;
static comboboxh combo4boxhandle;
static comboboxh combo5boxhandle;
static comboboxh combo6boxhandle;
static comboboxh combo7boxhandle;
static comboboxh combo8boxhandle;


static os_error * cicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

/*
 switch(m->i)
 {

 default:
         break;
 
 }
*/
 return(err);

 USE(userhandle);
 USE(handle);
 USE(m);
}



static os_error * cclose(int code)
{
 os_error * err;
 int        index;
 int        changed;

 err=NULL;

 changed=0;

 if(code==DBOK || code==DBAPPLY)
 {
//		xuseicm=xxuseicm;
		monitorsystem=xmonitorsystem;
		printersystem=xprintersystem;

		if(monitorsystem)
		{
			cmsmonitorsystem(&index);
		}
		else
		{
   cc_getselectcombobox(combo1boxhandle,&index);
   index=allindexfromrgbindex(index);
		}

  if(index>=0 && index<cmsprofilen)
  {
   changed|=(monitorindex!=index);
   monitorindex=index;
   xzstrncpy(monitorname,cmsprofile[monitorindex].name,sizeof(monitorname));
  }

  cc_getselectcombobox(combo3boxhandle,&index);
  index=allindexfromcmykindex(index);
  if(index>=0 && index<cmsprofilen)
  {
   cmykindex=index;
   xzstrncpy(cmykname,cmsprofile[cmykindex].name,sizeof(cmykname));
  }


  printcmsactive=xprintcmsactive;

  if(proofing!=xproofing)
  {
   proofing=xproofing;
   changed=1;
  }

		if(printersystem)
		{
			cmsprintersystem(NULL,&index);
		}
		else
		{
   cc_getselectcombobox(combo4boxhandle,&index);
   index=allindexfromrgbindex(index);
		}

  if(index>=0 && index<cmsprofilen)
  {
   printerindex=index;
   xzstrncpy(printername,cmsprofile[printerindex].name,sizeof(printername));
   if(proofing) changed=1;
  }

  cc_getselectcombobox(combo6boxhandle,&index);
  index=allindexfromrgbindex(index);
  if(index>=0 && index<cmsprofilen)
  {
   rgbindex=index;
   xzstrncpy(rgbname,cmsprofile[rgbindex].name,sizeof(rgbname));
  }

  cc_getselectcombobox(combo7boxhandle,&index);
  index=allindexfromrgbindex(index);
  if(index>=0 && index<cmsprofilen)
  {
   scannerindex=index;
   xzstrncpy(scannername,cmsprofile[scannerindex].name,sizeof(scannername));
  }


  cc_getselectcombobox(combo2boxhandle,&index);
  if(index>=0 && index<CMSINTENTN)
  {
   changed|=(monitorintent!=index);
   monitorintent=index;
  }


  cc_getselectcombobox(combo5boxhandle,&index);
  if(index>=0 && index<CMSINTENTN)
  {
   printerintent=index;
  }


  cc_getselectcombobox(combo8boxhandle,&index);
  if(index>=0 && index<cmsmodules)
  {
   xuseicm=cmsmodulefromindex(index);
  }

  cprintf("useicm %x index %x",xuseicm,index);


  if(cmsactive!=xcmsactive)
  {
   cmsactive=xcmsactive;
   changed=1;
  }




//  cprintf("monitor %d %s",monitorindex,monitorname);
//  cprintf("printer %d %s",printerindex,printername);
//  cprintf("scanner %d %s",scannerindex,scannername);
//  cprintf("rgb     %d %s",rgbindex,rgbname);
//  cprintf("cmyk    %d %s",cmykindex,cmykname);


  if(changed)
  {
   viewrecreateall();
   viewrefreshall();
  }
 }

 return(err);
}


static os_error * monclick(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
	os_error * err;
	int        index;

	if(xmonitorsystem)
	{
		cmsmonitorsystem(&index);

		if(index!=CMS_NONE) index=rgbindexfromallindex(index);
		if(index!=CMS_NONE) cc_selectcombobox(combo1boxhandle,index);
	}


	err=shadeiconst(handle,IDC_COMBO1,xmonitorsystem);

	return(err);

	USE(userhandle);
	USE(m);
}



static os_error * printclick(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
	os_error * err;
	int        index;

	if(xprintersystem)
	{
		cmsprintersystem(NULL,&index);

		if(index!=CMS_NONE) index=rgbindexfromallindex(index);
		if(index!=CMS_NONE) cc_selectcombobox(combo4boxhandle,index);
	}

	err=shadeiconst(handle,IDC_COMBO4,xprintersystem);

	return(err);

	USE(userhandle);
	USE(m);
}



static dbiconstr cicondefs[]=
{
 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
    3, NULL,         DBACTION, 0,   0,      DBAPPLY,-1,0,0 ,NULL ,0,

 IDC_CHECK2,&xcmsactive,     DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
 IDC_CHECK1,&xproofing,      DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
 IDC_CHECK3,&xprintcmsactive,DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,

 IDC_CHECK4,&xmonitorsystem,DBTOGGLE, 0,   0,      1, F2,  0, 0, (dbreadfn)monclick, 0,
 IDC_CHECK5,&xprintersystem,DBTOGGLE, 0,   0,      1, F2,  0, 0, (dbreadfn)printclick, 0,
// IDC_CHECK6,&xxuseicm,DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr cbox=
{
 0,
 TCMS,
 DBFIX,
 0,
 cclose,
 cicon,
 NULL,
 NULL,
 cicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};




os_error * cmssetup(wimp_w handle)
{
 os_error * err;
 int        i;
 int        seenindex;

 err=NULL;


 if(cbox.handle) err=dbclose(&cbox,DBCANCEL);

 if(cmsprofilen<=0) err=geterror(EIC00);


 if(!err)
 {
  if(monitorsystem) cmsmonitorsystem(&monitorindex);
		if(printersystem) cmsprintersystem(NULL,&printerindex);

  xcmsactive=cmsactive;
  xprintcmsactive=printcmsactive;
  xproofing=proofing;
//		xxuseicm=xuseicm;
		xmonitorsystem=monitorsystem;
		xprintersystem=printersystem;


  err=dodboxparent(&cbox,1,handle);
  if(!err)
  {

  // Monitor profile

   cc_addcombobox(cbox.handle,0,IDC_COMBO1,&combo1boxhandle,NULL);

   seenindex=CMS_NONE;

   for(i=0;i<cmsprofilen;i++)
   {
    if(cmsprofile[i].cspace==icSigRgbData)
    {
     cc_addcomboboxstring(combo1boxhandle,cmsprofile[i].name);
     seenindex=i;
    }
   }

   cc_selectcombobox(combo1boxhandle,rgbindexfromallindex((monitorindex!=CMS_NONE)?monitorindex:seenindex));


//  cprintf("monitor index %d",monitorindex);

  // CMYK profile

   cc_addcombobox(cbox.handle,0,IDC_COMBO3,&combo3boxhandle,NULL);

   seenindex=CMS_NONE;

   for(i=0;i<cmsprofilen;i++)
   {
    if(cmsprofile[i].cspace==icSigCmykData)
    {
     cc_addcomboboxstring(combo3boxhandle,cmsprofile[i].name);
     seenindex=i;
    }
   }

   cc_selectcombobox(combo3boxhandle,cymkindexfromallindex((cmykindex!=CMS_NONE)?cmykindex:seenindex));


  // Printer profile

   cc_addcombobox(cbox.handle,0,IDC_COMBO4,&combo4boxhandle,NULL);

   seenindex=CMS_NONE;

   for(i=0;i<cmsprofilen;i++)
   {
    if(cmsprofile[i].cspace==icSigRgbData)
    {
     cc_addcomboboxstring(combo4boxhandle,cmsprofile[i].name);
     seenindex=i;
    }
   }

   cc_selectcombobox(combo4boxhandle,rgbindexfromallindex((printerindex!=CMS_NONE)?printerindex:seenindex));


  // RGB profile

   cc_addcombobox(cbox.handle,0,IDC_COMBO6,&combo6boxhandle,NULL);

   seenindex=CMS_NONE;

   for(i=0;i<cmsprofilen;i++)
   {
    if(cmsprofile[i].cspace==icSigRgbData)
    {
     cc_addcomboboxstring(combo6boxhandle,cmsprofile[i].name);
     seenindex=i;
    }
   }

   cc_selectcombobox(combo6boxhandle,rgbindexfromallindex((rgbindex!=CMS_NONE)?rgbindex:seenindex));


  // Scanner profile

   cc_addcombobox(cbox.handle,0,IDC_COMBO7,&combo7boxhandle,NULL);

   seenindex=CMS_NONE;

   for(i=0;i<cmsprofilen;i++)
   {
    if(cmsprofile[i].cspace==icSigRgbData)
    {
     cc_addcomboboxstring(combo7boxhandle,cmsprofile[i].name);
     seenindex=i;
    }
   }

   cc_selectcombobox(combo7boxhandle,rgbindexfromallindex((scannerindex!=CMS_NONE)?scannerindex:seenindex));



   cc_addcombobox(cbox.handle,0,IDC_COMBO2,&combo2boxhandle,NULL);


   for(i=0;i<CMSINTENTN;i++)
   {
    cc_addcomboboxstring(combo2boxhandle,cmsintentname[i]);
   }

   cc_selectcombobox(combo2boxhandle,monitorintent);


   cc_addcombobox(cbox.handle,0,IDC_COMBO5,&combo5boxhandle,NULL);

   for(i=0;i<CMSINTENTN;i++)
   {
    cc_addcomboboxstring(combo5boxhandle,cmsintentname[i]);
   }

   cc_selectcombobox(combo5boxhandle,printerintent);



   // CMM which module


   cc_addcombobox(cbox.handle,0,IDC_COMBO8,&combo8boxhandle,NULL);


   for(i=0;i<cmsmodules;i++)
   {
    cc_addcomboboxstring(combo8boxhandle,cmsmodulename[i]);
   }

   cc_selectcombobox(combo8boxhandle,cmsmoduleindex(xuseicm));


			if(useicm!=0)
			{
				if(xmonitorsystem)	shadeicon(cbox.handle,IDC_COMBO1);
				if(xprintersystem)	shadeicon(cbox.handle,IDC_COMBO4);
			}
			else
			{
				shadeicon(cbox.handle,IDC_CHECK4);
				shadeicon(cbox.handle,IDC_CHECK5);
			}
  }
 }
 
 return(err);
}





/********************************************************************************/

static int profileindex=CMS_NONE;


static viewstr * cview;
static filestr * cfile;

extern dboxstr   cpbox;


static os_error * cpupdatetext(void)
{
 os_error     * err;
 imagestr     * sim;
 ximagestr    * sxim;
 char           string[128];
 char           profilename[128];
 int            index;

 err=NULL;


 sxim=cfile->frames[cview->frame].xim;
 sim=(sxim->sim[IM]);

 index=sim->profile.index;

 cmsprofilename(&sim->profile,profilename,sizeof(profilename));

 if(index==CMS_NONE)
 {
  sprintf(string,"%dbpp %s",sim->bpp,sim->ipal.palclass==CL_CMYK?"CMYK":"RGB");

 }
 else
 {
  sprintf(string,"%dbpp %s %s %s",sim->bpp,sim->ipal.palclass==CL_CMYK?"CMYK":"RGB",
                                  cmsprofile[index].xtype==CMSTYPEMEM?"Embeded":"Profile",
                                  profilename);
 }
 
 writeicon(cpbox.handle,100,string);
 
 return(err);
}


os_error * cpshade(void)
{
 os_error     * err;
 imagestr     * sim;
 ximagestr    * sxim;
 int            index;
 int            cspace;

 err=NULL;


 sxim=cfile->frames[cview->frame].xim;
 sim=(sxim->sim[IM]);

 index=sim->profile.index;
 cspace=cmsprofile[profileindex].cspace;

 shadeiconst(cpbox.handle,7,(sim->ipal.palclass==CL_CMYK && cspace!=icSigCmykData) || (sim->ipal.palclass==CL_RGB && cspace!=icSigRgbData));     // convert to profile
 shadeiconst(cpbox.handle,8,(sim->ipal.palclass==CL_CMYK && cspace!=icSigCmykData) || (sim->ipal.palclass==CL_RGB && cspace!=icSigRgbData));     // assign profile
 shadeiconst(cpbox.handle,3,sim->ipal.palclass==CL_CMYK || cspace!=icSigCmykData);     // make CMYK
 shadeiconst(cpbox.handle,4,sim->ipal.palclass==CL_RGB  || cspace!=icSigRgbData); // make RGB
 shadeiconst(cpbox.handle,5,cmsprofile[index].xtype==CMSTYPEMEM);

 return(err);
}




static os_error * cpclose(int code)
{
 os_error * err;

 err=NULL;


 return(err);

 USE(code);
}


static os_error * cpevent(int event,wimp_w handle,uservalue userhandle,int data,void * datap)
{
 os_error * err;

 err=NULL;

 if(event==CC_COMBOBOXSELECT)
 {
  profileindex=data;
  cpshade();
 }

 return(err);

 USE(datap);
 USE(userhandle);
 USE(handle);
}



static os_error * cpchange(int src,int dest)
{
 os_error     * err;
 int          * ddata1;
 improfilestr   destprofile;
 int            y;
 imagestr     * sim;
 ximagestr    * sxim;


 sxim=cfile->frames[cview->frame].xim;
 sim=(sxim->sim[IM]);

 cmsinitprofile(&destprofile);
 destprofile.intent=sim->profile.intent;
 destprofile.index=profileindex;
 destprofile.active=1;
 
 err=viewdeleteimagefileframe(cfile,cview->frame);            

 if(sim->bpp<=8)
 {
  err=cmstranslate(sim->ipal.word,sim->ipal.word,sim->ipal.ncolours,&sim->profile,CMS_ARGB,&destprofile,CMS_ARGB);
 }
 else
 if(sim->bpp==16)
 {
  for(y=0;y<sim->ypix;y++)
  {
   err=imfind1w(sim,y,&ddata1);
   if(err) break;
   err=cmstranslate(ddata1,ddata1,sim->xpix,&sim->profile,CMS_16,&destprofile,CMS_16);
   if(err) break;
  }
 }
 else
 if(sim->bpp==24)
 {
  cprintf("cpchange in");
  for(y=0;y<sim->ypix;y++)
  {
   err=imfind1w(sim,y,&ddata1);
   if(err) break;
   err=cmstranslate(ddata1,ddata1,sim->xpix,&sim->profile,CMS_RGB,&destprofile,CMS_RGB);
   if(err) break;
  }
    cprintf("cpchange out");
 }
 else
 if(sim->bpp==32)
 {
  for(y=0;y<sim->ypix;y++)
  {
   err=imfind1w(sim,y,&ddata1);
   if(err) break;
   err=cmstranslate(ddata1,ddata1,sim->xpix,&sim->profile,src,&destprofile,dest);
   if(err) break;
  }
 }

 if(!err)
 {
  sim->ipal.palclass=(dest==CMS_CMYK)?CL_CMYK:CL_RGB;
  cmsscrapprofile(&sim->profile);
  sim->profile=destprofile;
 }
 viewcreateimagefileframe(cfile,cview->frame);

 refreshviewfileframe(cfile,cview->frame);

 modifyview(cview);

 cpupdatetext();
 cpshade();

 return(err);
}



static os_error * cpicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error     * err;
 imagestr     * sim;
 imagestr     * dim;
 ximagestr    * sxim;
 ximagestr    * dxim;
 improfilestr   destprofile;


 err=NULL;

 if(cfile->frames && cfile->framen)
 {
  sxim=cfile->frames[cview->frame].xim;
  sim=(sxim->sim[IM]);


  switch(m->i)
  {
    case 3:       // ->CMYK
           if(sim->ipal.palclass==CL_RGB)
           {
            if(sim->bpp!=32)
            {
             formatstr fs;

             memset(&fs,0,sizeof(formatstr));

             fs.fbpp=32;
             fs.fobpp=sim->bpp;

                      err=ximnew(sim->xpix,sim->ypix,fs.fbpp,&dxim);
             if(!err) err=ximcopyal(sxim,dxim);
             if(!err)
             {
              undostart(sxim);

              dim=(dxim->sim[IM]);

              dim->xdpi=sim->xdpi;
              dim->ydpi=sim->ydpi;

              dim->ipal=sim->ipal;   /* !!!! */

              dim->tr=sim->tr;

              cmscopyprofile(dim,sim);

              err=reformat(&fs,sim,dim);

              if(err) ximtrash(&dxim);
              else
              {
               if(undosteps) undolink(sxim,dxim);
               else          ximtrash(&sxim);

               cfile->frames[cview->frame].xim=dxim;
              }
             }
            }

            err=cpchange(CMS_RGBA,CMS_CMYK);
           }
           break;

    case 4:       // ->RGB
           if(sim->ipal.palclass==CL_CMYK)
           {
            err=cpchange(CMS_CMYK,CMS_RGBA);
           }
           break;

    case 5:       // embed
           err=cmscreateembeddedprofile(&sim->profile,&destprofile);
           if(!err)
           {
            cmsscrapprofile(&sim->profile);
            sim->profile=destprofile;

            cpupdatetext();
            cpshade();
           }
           break;

    case 7:       // convert to new profile
           err=cpchange((sim->ipal.palclass==CL_RGB)?CMS_RGBA:CMS_CMYK,(sim->ipal.palclass==CL_RGB)?CMS_RGBA:CMS_CMYK);
           break;

    case 8:       // assign new profile
           err=viewdeleteimagefileframe(cfile,cview->frame);            
           if(!err)
           {
            cmsscrapprofile(&sim->profile);

            cmsinitprofile(&destprofile);
            destprofile.intent=sim->profile.intent;
            destprofile.index=profileindex;

            sim->profile=destprofile;

            viewcreateimagefileframe(cfile,cview->frame);

            refreshviewfileframe(cfile,cview->frame);

            modifyview(cview);

            cpupdatetext();
            cpshade();
           }
           break;

  }
 }


 return(err);

 USE(userhandle);
 USE(handle);
 USE(m);
}





static dbiconstr cpicondefs[]=
{
 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr cpbox=
{
 0,
 TPROFILE,
 DBFIX,
 0,
 cpclose,
 cpicon,
 NULL,
 NULL,
 cpicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};



os_error * cmsprofiledbox(viewstr * view,filestr * file)
{
 os_error   * err;
 int          i;
 imagestr   * sim;
 ximagestr  * sxim;
 int          index;


 err=NULL;

 if(cpbox.handle) err=dbclose(&cpbox,DBCANCEL);

 if(cmsprofilen<=0) err=geterror(EIC00);

 if(!err)
 {
  cview=view;
  cfile=file;

  sxim=cfile->frames[cview->frame].xim;
  sim=(sxim->sim[IM]);
  index=sim->profile.index;
  if(index==CMS_NONE) err=geterror(EIC01);

  if(!err)
  {
   if(profileindex==CMS_NONE) profileindex=monitorindex;

   err=dodboxparent(&cpbox,1,cview->handle);
   if(!err)
   {
    cc_addcombobox(cpbox.handle,0,IDC_COMBO1,&combo1boxhandle,cpevent);

    for(i=0;i<cmsprofilen;i++)
    {
     cc_addcomboboxstring(combo1boxhandle,cmsprofile[i].name);
    }

    cc_selectcombobox(combo1boxhandle,(profileindex!=CMS_NONE)?profileindex:0);

    cpupdatetext();
    cpshade();
   }
  }
 }

 return(err);
}






/********************************************************************************/







static int cmpxnames(const void * p1,const void * p2)
{
 cmsprofilestr * profile1;
 cmsprofilestr * profile2;

 profile1=(cmsprofilestr*)p1;
 profile2=(cmsprofilestr*)p2;

 return(cstrcmp(profile1->name,profile2->name));
}





static os_error * cmsgetprofiles(void)
{
 os_error   * err;
 int          type0=0;
 int          type1=0;
 fxstat       f;
 int          eof;
 char      *  str;
	int          cspace;
 char         name[MAX_PATH];
 char         path0[MAX_PATH];
 char         path1[MAX_PATH];
 fsscanhandle handle;
 int          flags;
	char         buffer[1024];



 cmsprofilen=0;

	err=NULL;

	if(upath0)
	{
           err=fs_exists(upath0,&type0);
  if(!err) err=fs_expandpath(upath0,path0,sizeof(path0));
	}

 if(!err)
 {
		if(upath1)
		{
   err=fs_exists(upath1,&type1);
  if(!err) err=fs_expandpath(upath1,path1,sizeof(path1));
		}
	}

 if(!err && (type0>1 || type1>1))
 {
//  cprintf("double scan");

  err=fs_startdoublesortscan(upath0,upath1,"*.*",0,&handle);
  if(!err)
  {
//  cprintf("double scan1");

   while(1)
   {
//    cprintf("name %s",f.name);

    err=fs_nextdoublesortitem(handle,&f,&eof,&flags);
    if(err) break;
    if(eof) break;

    if(!fs_extensionis(f.name,"icm") || !fs_extensionis(f.name,"icc"))
    {
//    cprintf("profile %s",f.name);

     if(cmsprofile) err=flex_chunk((flex_ptr)&cmsprofile,(cmsprofilen+1)*sizeof(cmsprofilestr),CMSCHUNK);
     else           err=flex_alloc((flex_ptr)&cmsprofile,CMSCHUNK);

     if(!err)
     {
      err=stralloc(f.name,&str);
      if(!err)
      {
       cmsprofile[cmsprofilen].xtype=CMSTYPEFILE;

       cmsprofile[cmsprofilen].leaf=str;

       cmsprofile[cmsprofilen].flags=flags;

       cmsHPROFILE hInProfile;

       fs_join(name,NITEM(name),(flags & 1)?path1:path0,f.name);

       err=XcmsOpenProfileFromFile(name,"r",&hInProfile);
       if(!err && hInProfile!=NULL)
       {
								err=XcmsGetProductDesc(hInProfile,buffer,sizeof(buffer));

        err=stralloc(buffer,&str);
        if(!err)
        {
         cmsprofile[cmsprofilen].name=str;
         cmsprofile[cmsprofilen].profile=NULL;
								 XcmsGetColorSpace(hInProfile,&cspace);
         cmsprofile[cmsprofilen].cspace=cspace;

//         cprintf("name %s %x",str,cmsprofile[cmsprofilen].cspace);

        }
     
        XcmsCloseProfile(hInProfile);
       }
      }
      cmsprofilen++;
     }
    }
    if(err) break;
   }

   fs_enddoublesortscan(&handle);
  }

  if(!err)
  {
   qsort(cmsprofile,cmsprofilen,sizeof(cmsprofilestr),cmpxnames);
  }

  cmsprofilen2=cmsprofilen;
 }
 return(err);
}












static contag contable[]=
{
 "CMYK",    CONSTR,cmykname,    (contokstr*)sizeof(cmykname),NULL,
 "Monitor", CONSTR,monitorname, (contokstr*)sizeof(monitorname),NULL,
 "Scanner", CONSTR,scannername, (contokstr*)sizeof(scannername),NULL,
 "Printer", CONSTR,printername, (contokstr*)sizeof(printername),NULL,
 "RGB",     CONSTR,rgbname,     (contokstr*)sizeof(rgbname),NULL,
 "Intent",  CONINT,             &monitorintent, NULL,NULL,
 "PrinterIntent",CONINT,        &printerintent, NULL,NULL,
 "Active",CONINT,               &cmsactive,NULL,NULL,
 "PrinterActive",CONINT,        &printcmsactive,NULL,NULL,
 "Proofing",CONINT,             &proofing,NULL,NULL,
	"MonitorSystem",CONINT,								&monitorsystem,NULL,NULL,
	"PrinterSystem",CONINT,								&printersystem,NULL,NULL,
	"UseICM",			CONINT,												&xuseicm,NULL,NULL,

 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "CMS",
 NULL,
 NULL
};


static os_error * configloaded(int eventn,uservalue userhandle,void * data,int data1)
{
	os_error * err;

	err=NULL;

 if(eventn==EVENT_CONFIGLOADED)
 {
		XcmsInit(xuseicm);

  err=cmsgetprofiles();

		if(!useicm)
		{
			monitorsystem=printersystem=0;
		}

  cmykindex=cmsfindname(cmykname);
  if(cmykindex==CMS_NONE) cmykindex=cmsfirstcmyk();

  monitorindex=cmsfindname(monitorname);
  if(monitorindex==CMS_NONE) monitorindex=cmsfirstrgb();

  rgbindex=cmsfindname(rgbname);
  if(rgbindex==CMS_NONE) rgbindex=cmsfirstrgb();

  scannerindex=cmsfindname(scannername);
  if(scannerindex==CMS_NONE) scannerindex=cmsfirstrgb();

  printerindex=cmsfindname(printername);
  if(printerindex==CMS_NONE) printerindex=cmsfirstrgb();
 
 }

 return(err);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}




os_error * cmsinit(void)
{
 os_error * err;

 err=addcontable(contable,&configlink);
 if(!err)
 {
  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);


 }


 return(err);
}




os_error * cmsfinit(void)
{
 os_error * err;
 int        i;

 err=NULL;


 cmsflushtransform();


 for(i=0;i<cmsprofilen;i++)
 {
  if(cmsprofile[i].profile)
  {
   XcmsCloseProfile(cmsprofile[i].profile);
   cmsprofile[i].profile=NULL;
  }
 }

 return(err);
}



