/*->c.cmap */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <time.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "dbhi.h"
#include "deb.h"


#include "str.h"
#include "constants.h"

#include "reslink.h"

#include "file.h"
#include "view.h"

#include "im.h"
#include "inv_cmap.h"
#include "getmatch.h"

#include "cmap.h"



char         rgbmap[4096];
static int   pal[256];
static int   palnc;

os_error * makecmap(int colours,int * colourmap,int bits,char * rgbmap)
{
 os_error            * err;
 int                   i;
 static unsigned int * dist_buf;

 cprintf("makecmp %d",bits);

 err=NULL;

 for(i=0;i<colours;i++)
 {
  if(pal[i]!=colourmap[i]) break;
 }

 if(i<colours || palnc!=colours)
 {
//  err=flex_alloc((flex_ptr)&dist_buf,(1<<(bits*3))*sizeof(unsigned int));
  if(!err)
  {
   memcpy(pal,colourmap,sizeof(int)*colours);
   palnc=colours;
   inversemap(colours,colourmap,bits,dist_buf,(unsigned char*)rgbmap);
//   err=flex_free((flex_ptr)&dist_buf);
  }
 }

 return(err);
}

/***************************************************************************/

/* grey map is an array of bytes, index in with 0..255, get out pal entry */


typedef struct gval
{
 int value;
 int index;

} gval;


static int cmpbyte(const void * p1,const void * p2)
{
 int w1;
 int w2;

 w1=((gval*)p1)->value;
 w2=((gval*)p2)->value;

 return(w1-w2);
}


os_error * makegmap(int colours,int *colourmap,char * greymap,int * size)
{
 gval tempmap[256];
 int  i;
 int  j;
 int  ngrey;
 int  r;
 int  g;
 int  b;

 ngrey=0;

 for(i=0;i<colours;i++) 
 {
  r=(colourmap[i]>> 8)&0xFF;
  g=(colourmap[i]>>16)&0xFF;
  b=(colourmap[i]>>24)&0xFF;

  if(r==g && g==b)
  {
   tempmap[ngrey].value=r;
   tempmap[ngrey++].index=i;
  }
 }

 qsort(tempmap,ngrey,sizeof(gval),cmpbyte);


 /* strip duplicates */

 j=0;
 for(i=0;i<ngrey;i++)
 {
  if(i>0 && tempmap[i].value==tempmap[i-1].value) {}
  else
  {
   tempmap[j]=tempmap[i];
   j++;
  }
 }
 ngrey=j;


 j=0;

 for(i=0;i<256;i++)
 {
  if(j==(ngrey-1)) greymap[i]=(char)tempmap[j].index;
  else
  {
   while(((ABS(i-tempmap[j].value))>(ABS(tempmap[j+1].value-i)))
                                                       && j<(ngrey-1)) j++;
   greymap[i]=(char)tempmap[j].index;
  }

  /* dprintf(0,"in=%d out=%d",i,greymap[i]);  */
 }


 *size=ngrey;

 return(NULL);
}


/****************************************************************************/

os_error * palmapf(int scolours,int * srcpal,int dcolours,int * destpal,char * map)
{
 os_error * err;
 int        i;
 int        sbyte;
 int        grey;
 int        size;
 char       greymap[256];

 err=NULL;

 grey=greypal(srcpal,scolours);

 if(grey) 
 {
  err=makegmap(dcolours,destpal,greymap,&size);
  if(size<2) grey=0;
 }

 if(grey)
 {
  for(i=0;i<scolours;i++)
  {
   sbyte=(srcpal[i]>>8)&0xFF;
   map[i]=greymap[sbyte];
  }
 }
 else
 {
/* err=makecmap(colours,destpal,4,rgbmap); */
  if(!err)
  {
   for(i=0;i<scolours;i++)
   {
#ifdef NEVER
    sbyte=srcpal[i]; /* rgb */
    sbyte=((sbyte>>4) & 0xF00)|
         ((sbyte>>16) & 0xF0)|
         ((sbyte>>28) & 0xF);

    map[i]=rgbmap[sbyte]; 
#endif

    map[i]=(char)getmatch(destpal,destpal+dcolours,srcpal[i]);
   }
  }
 }
 return(err);
}


/****************************************************************************/

/* rgb 0..MAXCV */
/* h 0..HUE360  */
/* v 0..1000    */
/* s 0..1000    */


void rgb2hsv(int * rgb,int * hsv)
{
 int r;
 int g;
 int b;
 int h;
 int s;
 int v;
 int max;
 int min;

 r=rgb[0];
 g=rgb[1];
 b=rgb[2];

 max=MAX(r,g);
 max=MAX(max,b);
 v=(max*1000)/MAXCV;

 min=MIN(r,g);
 min=MIN(min,b);

 if(min==max)
 {
  s=0;
  h=0;
 }
 else
 {
  s=((max-min)*1000)/max;

  if(min==b)
  {
   h=(HUE120*(g-min))/(r+g-2*min);
  }
  else
  if(min==r)
  {
   h=HUE120+(HUE120*(b-min))/(b+g-2*min);
  }
  else
  {
   h=HUE240+(HUE120*(r-min))/(r+b-2*min);
  }
 }

 hsv[0]=h;
 hsv[1]=s;
 hsv[2]=v;
}


/* rgb 0..MAXCV */
/* h 0..HUE360  */
/* v 0..1000    */
/* s 0..1000    */

void hsv2rgb(int * hsv,int * rgb)
{
 int r;
 int g;
 int b;
 int h;
 int s;
 int v;
 int min;


 h=hsv[0];
 s=hsv[1];
 v=(hsv[2]*MAXCV)/1000;

 min=(v*(1000-s))/1000;

 if(h<=HUE120)
 {
  b=min;
  if(h<=HUE60)
  {
   r=v;
   g=min+(h*(v-min))/(HUE120-h);
  }
  else
  {
   g=v;
   r=min+((HUE120-h)*(v-min))/h;
  }
 }
 else
 if(h<=HUE240)
 {
  r=min;
  if(h<=HUE180)
  {
   g=v;
   b=min+((h-HUE120)*(v-min))/(HUE240-h);
  }
  else
  {
   b=v;
   g=min+((HUE240-h)*(v-min))/(h-HUE120);
  }
 }
 else
 {
  g=min;
  if(h<=HUE300)
  {
   b=v;
   r=min+((h-HUE240)*(v-min))/(HUE360-h);
  }
  else
  {
   r=v;
   b=min+((HUE360-h)*(v-min))/(h-HUE240);
  }
 }

 rgb[0]=r;
 rgb[1]=g;
 rgb[2]=b;
}



/* rgb  0..MAXCV  */
/* cymk 0..MAXCV  */

void rgb2cmyk(int * rgb,int * cmyk)
{
 int r;
 int g;
 int b;
 int c;
 int m;
 int y;
 int k;

 r=rgb[0];
 g=rgb[1];
 b=rgb[2];

 c=MAXCV-r;
 m=MAXCV-g;
 y=MAXCV-b;

 k=MIN(c,m);
 k=MIN(k,y);

 c-=k;
 m-=k;
 y-=k;

 cmyk[0]=c;
 cmyk[1]=m;
 cmyk[2]=y;
 cmyk[3]=k;
}



void cmyk2rgb(int * cmyk,int * rgb)
{
 int r;
 int g;
 int b;
 int c;
 int m;
 int y;
 int k;

 c=cmyk[0];
 m=cmyk[1];
 y=cmyk[2];
 k=cmyk[3];

 c=ROOF(k+c,MAXCV);
 m=ROOF(k+m,MAXCV);
 y=ROOF(k+y,MAXCV);

 r=MAXCV-c;
 g=MAXCV-m;
 b=MAXCV-y;

 rgb[0]=r;
 rgb[1]=g;
 rgb[2]=b;
}

