/*->c.clear */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "fsx.h"
#include "filetype.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"


#include "constants.h"
#include "str.h"
#include "main.h"
#include "reslink.h"
#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "units.h"
#include "cms.h"

#include "clear.h"



#ifdef NEVER

/*

The 'Clear' graphics format was devised because of all this, and holds either
pure 24-bit RGB data or byte-wide pixel values with a 24-bit RGB palette (one
entry per pixel value).

The full format is as follows (the descriptions are necessarily 'formal' to
avoid misinterpretation, the format is actually extremely simple) :

Offset  Bytes   Description
-------------------------------------------------------------------------------
0       m       String (e.g. 'Translator') to indicate the maker, or some other
                comment (e.g. date, image contents, whatever)
m       1       0 (string terminator)
m+1     4       Version number *100 (or any other informational value)
m+5     4       Width of image in pixels (w)
m+9     4       Height of image in pixels (h)
m+13    4       Bits per pixel (bpp)
                - If 1<=bpp<=8, then 24-bit palette entries for all colours
                follow (i.e. n=3*2^bpp, and l (bytes per pixel) is 1).
                - If bpp>8, then pure 24-bit RGB is stored, which needs no
                palette (i.e. n=0, and l (bytes per pixel) is 3)
m+17    n       Palette entries for all colours (only if 1<=bpp<=8), which
                are triples of byte values (0=off, up to 255=full intensity),
                one byte per primary colour, red first, then green, then blue.
                For example, when 'Rx','Gx' and 'Bx' represent the intensities
                of red, green and blue respectively for colour x, the palette
                for 4 colours (bpp=2) would be stored : R0,G0,B0, R1,G1,B1,
                R2,G2,B2, R3,G3,B3.
m+17+n  w*h*l   Pixel values, representing the image rows from top to bottom
                and within every row the pixels from left to right.
                - If l=1, every pixel value is a byte representing the colour
                number/index.
                - If l=3 (pure 24-bit RGB), data is stored like the palette
                entries, i.e. red first, then green, finally blue, all byte
                values (0-255) representing the intensity of the corresponding
                primary colour for that pixel.
----------------------------------------------------------------------------

In the case of pure 24-bit RGB storage (i.e. bpp>8), bpp represents the bits of
RGB resolution of the original image (i.e. 12 for Amiga IFF HAM mode, 15 for
ArVis and 24 for QRT currently). If there are less than 8 bits per primary
colour, lower bits are set to 0 (but do not try to deduce how many per primary
colour if you don't know what the original image was).
For example, in the case ofArVis' 15 bits RGB (5 bits each for red, green and
blue), the lower three bits of red, green and blue for each pixel are set to 0
when Translator creates the Clear file.

When 1<=bpp<=8, only the lower 2^bpp pixel values of the 256 available are
used.

Clear files are always 'pure' representations of the input images, i.e. they
represent the image exactly 'as it is'. They are thus independent of Archimedes
mode and palette, error spreading, etc.. Their palettes (if any) are full scale
24-bit RGB, as calculated *after* applying all colour manipulating options
(which are all in the 'Colour' submenu) to the input image's colours. To have
an exact reflection of the input image in the Clear file, you would switch off
all these options.

IMPORTANT NOTE : When the 'Black and white' option is ON, then where an RGB
(i.e. non-paletted) Clear file would normally result (with R=G=B), instead a
grey-paletted 8-bit Clear file is output. This is to save space, and to enable
easier conversion to formats that do not support non-paletted images (i.e.
GIF).

The image inside the Clear file will also have been scaled as appropiate, so
that you may easily create Clear files of, for example, a specified number of
pixels (e.g. 256x256, which is required for further conversion to the AIM
format, using !Creator. Refer to the end of this guide).

*/

#endif


extern ftypestr ftype;
extern dboxstr  configbox;


static int clearxres=90;
static int clearyres=90;
static int txres;
static int tyres;



static os_error * getinfo(framestr * frame,char * name,int vers)
{
 char   string[256];
 char * p;

 p=string;

 p+=sprintf(p,"Clear file - %d.%d\n",vers/100,vers%100);
 p+=sprintf(p,"\"%s\"\n",name);
 p+=sprintf(p,"%d x %d pixels %d bpp",frame->fxpix,frame->fypix,frame->fbpp);

 return(infowrite(string,frame));
}



static os_error * loadclear(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;
 buffer      bf;
 int         c;
 int         version;
 int         width=0;
 int         height=0;
 int         bpp=0;
 int         l;
 int         ncol;
 int         i;
 int         ch;
 int         len;
 int         pal[256];
 int         fn;
 int         x;
 int         y;
 imagestr  * loadimage;
 int       * idata;
 int         shift;
 int         sshift;
 char        string[256];
 char      * p;


 err=bf_open(name,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  len=0;
  p=string;

  while(1)
  {
   err=bf_getc(&bf,&c);

   if(len<(sizeof(string)-1)) *p++=(char)c;
   else                       len++;

   if(err) break;
   if(!c) break;
  }

  *p=0;


  if(!err)
  {
            err=bf_geti(&bf,&version);
   if(!err) err=bf_geti(&bf,&width);
   if(!err) err=bf_geti(&bf,&height);
   if(!err) err=bf_geti(&bf,&bpp);
   if(!err)
   {
    addframe(loadfile,&fn,0);
    loadfile->frames[fn].fxpix=width;
    loadfile->frames[fn].fypix=height;
    sprintf(loadfile->frames[fn].name,"Clear%d",fn);
    bf_tell(&bf,&loadfile->frames[fn].offset);

    if(bpp>8) loadfile->frames[fn].fbpp=24;
    else      loadfile->frames[fn].fbpp=bpp;

    loadfile->frames[fn].fxdpi=clearxres;
    loadfile->frames[fn].fydpi=clearyres;
    loadfile->frames[fn].xim=NULL;

    getinfo(&loadfile->frames[fn],string,version);


    if(bpp<=8)
    {
     l=1;
     ncol=(1<<bpp);
     /* read palette */

     for(i=0;i<ncol;i++)
     {
      err=bf_getc(&bf,&ch);
      c =(ch)<<8; /* Red */
      err=bf_getc(&bf,&ch);
      c|=(ch)<<16;
      err=bf_getc(&bf,&ch);
      c|=(ch)<<24;
      pal[i]=c;
     }

     err=ximnew(loadfile->frames[fn].fxpix,loadfile->frames[fn].fypix,
                          loadfile->frames[fn].fbpp,&loadfile->frames[fn].xim);

     if(!err)
     {
      loadimage=((loadfile->frames[fn].xim)->sim[IM]);
      loadimage->xdpi=loadfile->frames[fn].fxdpi;
      loadimage->ydpi=loadfile->frames[fn].fydpi;

      cmsrgbprofile(&loadimage->profile);

      loadimage->ipal.ncolours=ncol;

      for(i=0;i<ncol;i++) loadimage->ipal.word[i]=pal[i];

      if(bpp==1) sshift=1;
      else
      if(bpp==2) sshift=2;
      else
      if(bpp==4) sshift=4;
      else       sshift=8;


      for(y=0;y<height;y++)
      {
       err=imfind1w(loadimage,y,&idata);
       if(err) break;

       shift=0;
       ch=0;
       for(x=0;x<width;x++)
       {
        bf_getc(&bf,&c);
        ch|=(c<<shift);
        shift+=sshift;
        if(shift==32)
        {
         *idata++=ch;
         ch=0;
         shift=0;
        }
       }
       *idata++=ch;
      }
     }
    }
    else
    {
     l=3;

     err=ximnew(loadfile->frames[fn].fxpix,loadfile->frames[fn].fypix,
                          loadfile->frames[fn].fbpp,&loadfile->frames[fn].xim);

     if(!err)
     {
      loadimage=((loadfile->frames[fn].xim)->sim[IM]);
      loadimage->xdpi=loadfile->frames[fn].fxdpi;
      loadimage->ydpi=loadfile->frames[fn].fydpi;
      loadimage->ipal.ncolours=0;

      cmsrgbprofile(&loadimage->profile);

      for(y=0;y<height;y++)
      {
       err=imfind1w(loadimage,y,&idata);
       if(err) break;

       err=bf_read(&bf,idata,width*3);
       if(err) break;
      }
     }
    }

    len=width*height*l;
   }
  }
  err=bf_close(&bf,err);
 }

 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}



static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;

 err=NULL;

/* dprintf(0,"load clear post"); */

 return(err);
 USE(userhandle);
}



static os_error * saveclear(char * name,int type)
{
 os_error * err;
 buffer      bf;
 char        string[64];
 int         xpix;
 int         ypix;
 int         bpp;
 int         fn;
 int       * idata;
 imagestr  * saveimage;
 int         x;
 int         y;
 int         shift;
 int         word;
 int         mask;
 int         sstep;
 int         sbyte;
 int         i;
 int         ncol;

 err=bf_open(name,'w',DEFBUFFSIZE,&bf);
 if(!err)
 {
  fn=menuview->frame;
  saveimage=((menufile->frames[fn].xim)->sim[IM]);

  xpix=saveimage->xpix;
  ypix=saveimage->ypix;
  bpp=saveimage->bpp;

  strcpy(string,wimpt_programname());
  bf_write(&bf,string,strlen(string)+1);
  bf_puti(&bf,version);
  bf_puti(&bf,xpix);
  bf_puti(&bf,ypix);

  if(bpp==16) bf_puti(&bf,15);
  else        bf_puti(&bf,ROOF(bpp,24));

  if(bpp<=8)
  {
   ncol=1<<bpp;

   for(i=0;i<ncol;i++)
   {
    if(i<saveimage->ipal.ncolours) word=saveimage->ipal.word[i];
    else                           word=0;

             err=bf_putc(&bf,word>>8);
    if(!err) err=bf_putc(&bf,word>>16);
    if(!err) err=bf_putc(&bf,word>>24);
    if(err) break;
   }
  }

  if(!err)
  {
   for(y=0;y<ypix;y++)
   {
    if(err) break;
    err=imfind1r(saveimage,y,&idata);
    if(err) break;

    if(saveimage->bpp<=8)
    {
     word=0;   /* compiler */
     shift=32;

     if(saveimage->bpp==1) {mask=0x1;sstep=1;}
     else
     if(saveimage->bpp==2) {mask=0x3;sstep=2;}
     else
     if(saveimage->bpp==4) {mask=0xF;sstep=4;}
     else                  {mask=0xFF;sstep=8;}

     for(x=0;x<xpix;x++)
     {
      if(shift==32)
      {
       word=*idata++;
       shift=0;
      }
      sbyte=(word>>shift)&mask;
      shift+=sstep;
      err=bf_putc(&bf,sbyte);
      if(err) break;
     }
    }
    else
    if(saveimage->bpp==24)
    {
     err=bf_write(&bf,idata,xpix*3);
     if(err) break;
    }
    else
    if(saveimage->bpp==16)
    {
     word=0; /* compiler */
     shift=32;
     mask=0x7FFF;
     sstep=16;

     for(x=0;x<xpix;x++)
     {
      if(shift==32)
      {
       word=*idata++;
       shift=0;
      }
      sbyte=(word>>shift)&mask;
      shift+=sstep;

      err=bf_putc(&bf,(sbyte<<3)&0xF8);
      if(!err) err=bf_putc(&bf,(sbyte>>2)&0xF8);
      if(!err) err=bf_putc(&bf,(sbyte>>7)&0xF8);
      if(err) break;
     }
    }
    else
    if(saveimage->bpp==32)
    {
     for(x=0;x<xpix;x++)
     {
      err=bf_write(&bf,idata,3);
      if(err) break;
      idata++;
     }
    }
    if(err) break;
   }
  }
  err=bf_closec(&bf,err,name,type);
 }
 return(err);
}


/*****************************************************************************/

static int tdbl;
static int dbl;


static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}



static os_error * configloaded(int eventn,uservalue userhandle,void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {
  dbl=ftypegetrun(&ftype);

//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}


static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
  dbl=tdbl;
  clearxres=txres;
  clearyres=tyres;
 }

 return(err);
}




static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}






static os_error * wrpc(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdpc(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}



static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,
    4, &txres,       DBWRITE,  0,   0,      6, -1,  6,-1, rdpc, wrpc,
    6, &tyres,       DBWRITE,  0,   0,     -1,  4, -1, 4, rdpc, wrpc,


   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TCLEAR,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);
 
 tdbl=dbl;
 txres=clearxres;
 tyres=clearyres;
 err=dodboxparent(&configbox,1,parent);


 return(err);
}

/*****************************************************************************/



static ftypestr ftype=
{
 CLEAR,           /* file type  */
 0,               /* flags      */
 loadclear,       /* load       */
 loadfilepost,    /* loadpost   */
 "{CLEAR}",       /* name       */
 "{CLEAR}",       /* type name  */
 saveclear,       /* save       */
 config,          /* configure  */
 0,               /* icon       */
 bits,            /* flag bits  */
 NULL,            /* load frame */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,

 NULL,            /* saveim */
 "clr\0""690\0",  /* extension */

 "RISC OS/Acorn Clear (*.clr)", /* description */
};



static contag contable[4]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "DefaultXRes",CONINT,&clearxres,NULL,NULL,
 "DefaultYRes",CONINT,&clearyres,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "Clear",
 NULL,
 NULL
};



os_error * clearinit(void)
{
 os_error * err;

 err=registerfiletype(&ftype);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);
 }

 return(err);
}


