/*->c.chunk */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "deb.h"
#include "dbhi.h"


#include "vm.h"

#include "crc.h"

#include "str.h"
#include "constants.h"
#include "configx.h"

#include "reslink.h"

#include "file.h"
#include "view.h"

#include "cx.h"


#include "chunk.h"






#ifdef USEVM



#ifdef MEMDBUG

int crcchunk(chunkstr * chunk)
{
 int crc;

 crc=0;

 crcblock32(&crc,((char*)chunk->data)+sizeof(sprite_header),
                 chunk->size-sizeof(sprite_header));


 return(crc);
}

#endif




/***************************************************************************/
/* handle lru queue */

static chunkstr * mru;          /* pointer to start of chain */
static chunkstr * lru;          /* pointer to lru in memory  */


/*

  at enormous cost in time and trouble...

  the mru-lru queue only consists of blocks in memory
  it *does not* link the blocks on disc.
  when blocks enter the queue they must have next and prev zeroed
  or else they may corrupt the chain 

 */



#ifdef LRUDBUG

static int lrudebug(char * why,chunkstr * ex)
{
 chunkstr * x;
 chunkstr * prev;
 int          failed=0;
 int          i;

 x=mru;
 prev=NULL;

 while(x)
 {
  if(x->prev!=prev)       {failed=1;break;}
  if(x!=ex && (!x->data || x->disc)) {failed=1;break;}
  prev=x;
  x=x->next;
 }

 if(prev!=lru) failed=1;

 if(failed)
 {
  dprintf(2,"lru corrupt %s mru=%x lru=%x",why,mru,lru);
  i=3;

  x=mru;
  while(x)
  {
   dprintf(i,"x=%x disc=%d data=%d next=%x prev=%x",x,x->disc,x->data,
                                                      x->next,x->prev);
   i++;
   x=x->next;
  }
 }

 return(failed);
}


#endif



/* move chunk to start of chain */

static void lrupromote(chunkstr * chunk)
{
 chunkstr * next;
 chunkstr * prev;

 if(!mru)
 {
  mru=lru=chunk;
  chunk->next=chunk->prev=NULL;
 }
 else
 if(mru!=chunk)
 {
  if(lru==chunk)
  {
   if(chunk->prev) lru=chunk->prev;
   else            lru=mru;
  }

  next=chunk->next;
  prev=chunk->prev;

  if(next) next->prev=prev;
  if(prev) prev->next=next;

  mru->prev=chunk;
 
  chunk->next=mru;
  chunk->prev=NULL;

  mru=chunk;
 }
}


/* create a new chunk */

static void lrucreate(chunkstr * chunk)
{
 chunk->prev=chunk->next=NULL;
/* printf("lrucreate %d",chunk); */
 lrupromote(chunk);
}


/* destroy a chunk */

static void lrudestroy(chunkstr * chunk)
{
 chunkstr * next;
 chunkstr * prev;


/* printf("lru %d next=%d prev=%d lru=%d mru=%d",chunk,chunk->next,
                    chunk->prev,lru,mru); */

 if(chunk==lru && chunk==mru)
 {
  lru=mru=NULL;
 }
 else
 if(chunk==lru)
 {
  lru=chunk->prev;
  lru->next=NULL;
 }
 else
 if(chunk==mru)
 {
  mru=chunk->next;
  mru->prev=NULL;
 }
 else
 {
  next=chunk->next;
  prev=chunk->prev;

  if(next)
  {
   next->prev=prev;
  }

  if(prev)
  {
   prev->next=next;
  }
 }

 chunk->prev=chunk->next=NULL;

}


/* the lru is going out to disc */

static void lrudemote(void)
{
 if(lru==mru)
 {
  lru=mru=NULL;
 }
 else
 if(lru && lru->prev) 
 {
  lru=lru->prev;
  lru->next=NULL;
 }
/* else
  dprintf(10,"lru demote error"); */
}


static void lruinit(void)
{
 lru=mru=NULL;
}


/*****************************************************************************/

static int ivmmaxsize;
static int ivmsize;


#ifdef MEMDBUG

static void imdebug(void)
{
 chunkstr * chunk;

 chunk=mru;
 while(chunk)
 {
  if(chunk==lru) printf("**** lru ****");
  printf("chunk=%x prev=%x next=%x\n",chunk,chunk->prev,chunk->next);
  printf("data=%x disc=%d exists=%d",chunk->data,chunk->disc,chunk->exists);
  printf("\n");
  chunk=chunk->next;
 }
}

#endif








/* get rid of the lru */

static os_error * ivmlose(void)
{
 os_error * err;

 if(lru && lru->data)
 {
 /* dprintf(0,"vmlose data=%x ",lru->data); */
  /* lru->crc=crcchunk(lru); */

  err=vmsave((void**)&lru->data,lru->size,&lru->addr);
  if(!err)
  {
   ivmsize-=lru->size;
   err=flex_free((flex_ptr)&lru->data);
   lru->disc=1;
   vmmemory();        /* ! give vm a chance to get some memory */
  }

  if(!err) lrudemote();
 }
 else err=geterror(EVM00);

 return(err);
}


static os_error * ivmload(chunkstr * chunk)
{
 os_error * err;

/* dprintf(0,"vmload"); */

 err=flex_alloc((flex_ptr)&chunk->data,chunk->size);
 if(!err)
 {
  err=vmload((void**)&chunk->data,chunk->size,chunk->addr);
  if(!err)
  {
   ivmsize+=chunk->size;
   chunk->disc=0;

   /* if(chunk->crc!=crcchunk(chunk)) dprintf(5,"crc error"); */
  }
 }
 return(err);
}


static os_error * ivmchunkcreate(chunkstr ** chunkp,int size)
{
 os_error * err;
 chunkstr * chunk;

 err=NULL;

// cprintf("size %d ivmsize %d ivmmax %d flex %d",size,ivmsize,ivmmaxsize,flex_freemem());

 while((size+ivmsize)>ivmmaxsize || size>(flex_freemem()-overhead)) 
 {
  err=ivmlose();
  if(err) break;
 }

 if(!err)
 {
  err=salloc((flex_ptr)chunkp,sizeof(chunkstr));
  if(!err)
  {
   chunk=*chunkp;
   memset(chunk,0,sizeof(chunkstr));

   chunk->uses=1;
   chunk->size=size;

   while(1)
   {
    err=flex_alloc((flex_ptr)&chunk->data,chunk->size);

    if(!err || err->errnum!=EMEM) break;
    err=ivmlose();
    if(err) break;
   }

   if(!err)
   {
    ivmsize+=chunk->size;
    lrucreate(chunk);
   }
  }
 }

 return(err);
}




os_error * ivmchunkdestroy(chunkstr ** chunkp)
{
 os_error * err;
 chunkstr * chunk;

 err=NULL;

 chunk=*chunkp;

/* dprintf(5,"chunk dest %d disc=%d data=%d",chunk,chunk->disc,chunk->data); */

 if(chunk)
 {
 /* dprintf(0,"uses=%d",chunk->uses); */
  chunk->uses--;
  if(chunk->uses<=0)
  {
   if(chunk->disc) 
   {
    err=vmclear(chunk->addr);
    chunk->disc=0;
   }
   else
   if(chunk->data)
   {
                                            /* dprintf(0,"(1)"); */
    err=flex_free((flex_ptr)&chunk->data);
                                            /* dprintf(0,"(2)"); */
    ivmsize-=chunk->size;
                                            /* dprintf(0,"(3)"); */
    lrudestroy(chunk);
   }
                                            /* dprintf(0,"(4)"); */
   sfree((flex_ptr)chunkp);
                                            /* dprintf(0,"(5)"); */
  }

  *chunkp=NULL;
 }

 return(err);
}




os_error * ivmchunkensurer(chunkstr ** chunkp,int size)
{
 os_error * err;
 chunkstr * chunk;

/* dprintf(0,"chunk ensure "); */

 err=NULL;

 chunk=*chunkp;

 if(!chunk) err=ivmchunkcreate(chunkp,size);
 else
 {
  /* lrupromote(chunk); moved down below */

  if(chunk->disc)
  {
   /* dprintf(3,"freemem=%d",flex_freemem()); */


   while((chunk->size+ivmsize)>ivmmaxsize  || 
         size>(flex_freemem()-overhead)) 
   {
    err=ivmlose();
    if(err) break;
   }

   if(!err)
   {
    while(1)
    {
     err=ivmload(chunk);
     if(!err || err->errnum!=EMEM) break;

     err=ivmlose();
     if(err) break;
    }
   }
   if(!err) lrucreate(chunk);
  }
  else
  {
 /*  printf("chunk ensure read %d",chunk); */
   lrupromote(chunk);
  }
 }

 return(err);
}


os_error * ivmchunkensurew(chunkstr ** chunkp,int size)
{
 os_error * err;
 chunkstr * schunk;
 chunkstr * dchunk;

 err=ivmchunkensurer(chunkp,size);
 if(!err)
 {
  schunk=*chunkp;

  if(schunk->uses>1)
  {
   err=ivmchunkcreate(chunkp,size);

   if(!err)
   {
    dchunk=*chunkp;

    memcpy(dchunk->data,schunk->data,size);

    schunk->uses--;
   }
  }
 }
 return(err);
}


void ivmgetmemory(int * bytes)
{
 *bytes=ivmsize;
}


os_error * ivmsetmemory(int bytes)
{
 os_error * err;

 err=NULL;

/* dprintf(0,"size=%d max=%d",ivmsize,ivmmaxsize); */


 if(bytes<ivmsize)
 {
  while(bytes<ivmsize) 
  {
   err=ivmlose();
   if(err) break;
  }
  if(!err) ivmmaxsize=bytes;
 }
 else
 {
  ivmmaxsize=bytes;
 }

 return(err);
}


/*

static os_error * ivmfinit(void)
{
 return(NULL);
}

*/


static os_error * panic(int n)
{
 return(ivmlose());
 USE(n);
}


os_error * ivminit(void)
{
 lruinit();
 flex_addpanic(panic);
 vminit();
 return(NULL);
}



#endif




