/*->c.bmp */



#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"
#include "deb.h"
#include "bitrev.h"
#include "xmath.h"


#include "constants.h"
#include "str.h"
#include "reslink.h"
#include "units.h"

#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "cms.h"

#include "bmp.h"



#if (WINVER < 0x0500)
typedef struct {
        DWORD        bV5Size;
        LONG         bV5Width;
        LONG         bV5Height;
        WORD         bV5Planes;
        WORD         bV5BitCount;
        DWORD        bV5Compression;
        DWORD        bV5SizeImage;
        LONG         bV5XPelsPerMeter;
        LONG         bV5YPelsPerMeter;
        DWORD        bV5ClrUsed;
        DWORD        bV5ClrImportant;
        DWORD        bV5RedMask;
        DWORD        bV5GreenMask;
        DWORD        bV5BlueMask;
        DWORD        bV5AlphaMask;
        DWORD        bV5CSType;
        CIEXYZTRIPLE bV5Endpoints;
        DWORD        bV5GammaRed;
        DWORD        bV5GammaGreen;
        DWORD        bV5GammaBlue;
        DWORD        bV5Intent;
        DWORD        bV5ProfileData;
        DWORD        bV5ProfileSize;
        DWORD        bV5Reserved;
} BITMAPV5HEADER, FAR *LPBITMAPV5HEADER, *PBITMAPV5HEADER;

// Values for bV5CSType
#define PROFILE_LINKED          'LINK'
#define PROFILE_EMBEDDED        'MBED'
#endif








extern ftypestr ftype;
extern dboxstr  configbox;








static int tdbl;
static int dbl;
static int tos2;
static int os2;

static int bmpxres=90;
static int bmpyres=45;
static int txres;
static int tyres;






/*****************************************************************************/


#define C_OS2 12
#define C_WIN 40
#define C_WIN4 (sizeof(BITMAPV4HEADER))
#define C_WIN5 (sizeof(BITMAPV5HEADER))


typedef struct bmphdrstr
{
 int        cbsize;
 short int  xhotspot;
 short int  yhotspot;
 int        offbits;    
 int        cbfix;      /* size of what follows */
} bmphdrstr;


typedef union bmpinfostr
{
 struct
 {
  short int cx;
  short int cy;
  short int cplanes;
  short int bitcount;

 } os2;

 struct
 {
  int       cx;
  int       cy;
  short int cplanes;
  short int bitcount;

  int       compression;
  int       imagesize; /*uncompressed size, can be 0 if compression not used*/
  int       xdpm;
  int       ydpm;
  int       ncolourused;      /* number of palette entries actually used */
                              /* can be 0 for all */
  int       ncolourimportant; /* number of important colours */
                              /* can be 0 for all */
 } windows;


 struct
 {
  int       cx;
  int       cy;
  short int cplanes;
  short int bitcount;

  int       compression;
  int       imagesize; /*uncompressed size, can be 0 if compression not used*/
  int       xdpm;
  int       ydpm;
  int       ncolourused;      /* number of palette entries actually used */
                              /* can be 0 for all */
  int       ncolourimportant; /* number of important colours */
                              /* can be 0 for all */

  int       bV4RedMask;
  int       bV4GreenMask;
  int       bV4BlueMask;
  int       bV4AlphaMask;
  int       bV4CSType;
  CIEXYZTRIPLE bV4Endpoints;
  int       bV4GammaRed;
  int       bV4GammaGreen;
  int       bV4GammaBlue;


 } windows4;


 struct
 {
  int       cx;
  int       cy;
  short int cplanes;
  short int bitcount;

  int       compression;
  int       imagesize; /*uncompressed size, can be 0 if compression not used*/
  int       xdpm;
  int       ydpm;
  int       ncolourused;      /* number of palette entries actually used */
                              /* can be 0 for all */
  int       ncolourimportant; /* number of important colours */
                              /* can be 0 for all */

  int       bV5RedMask;
  int       bV5GreenMask;
  int       bV5BlueMask;
  int       bV5AlphaMask;
  int       bV5CSType;
  CIEXYZTRIPLE bV5Endpoints;
  int       bV5GammaRed;
  int       bV5GammaGreen;
  int       bV5GammaBlue;

  
  int       bV5Intent; 
  int       bV5ProfileData; 
  int       bV5ProfileSize; 
  int       bV5Reserved; 

 } windows5;







} bmpinfostr;


// #define BI_RGB       0
// #define BI_RLE8      1
// #define BI_RLE4      2
// #define BI_BITFIELDS 3
// #define BI_JPEG      4


typedef struct bmpstr
{
 bmphdrstr  hdr;
 bmpinfostr info;

} bmpstr;


#define STBASE 0
#define STABS  1
#define STRUN  2



static char * cotypes[]={"None","RLE8","RLE4","BI_BITFIELDS","BI_JPEG","BI_PNG"};


static os_error * getinfo(framestr * frame,bmpstr * bmp,improfilestr * profile)
{
 char   string[256];
 char   string2[256];
 char * p;
 int    colours;

 p=string;

 if(bmp->hdr.cbfix==C_OS2)
 {
  p+=sprintf(p,"OS2 bit map file\n");
  p+=sprintf(p,"%d x %d pixels, %d bpp\n",frame->fxpix,
                                          frame->fypix,frame->fbpp);
 }
 else
 {
  if(bmp->hdr.cbfix==C_WIN)  p+=sprintf(p,"Windows 3 bit map\n");
  else
  if(bmp->hdr.cbfix==C_WIN4) p+=sprintf(p,"Windows 4 bit map\n");
  else
  if(bmp->hdr.cbfix==C_WIN5) p+=sprintf(p,"Windows 5 bit map\n");
  else                       p+=sprintf(p,"Unknown version Windows bit map\n");

  p+=sprintf(p,"%d x %d pixels, %d bpp\n",frame->fxpix,
                                          frame->fypix,frame->fbpp);
  colours=bmp->info.windows.ncolourused;

  if(frame->fbpp<=8)
  {
   if(!colours) colours=(1<<frame->fbpp);
   p+=sprintf(p,"Palette entries %d.\n",colours);
  }

  p+=sprintf(p,"Compression %s\n",cotypes[bmp->info.windows.compression]);

		cprintf("cbfix %d WIN4 %d WIN5 %d",bmp->hdr.cbfix,C_WIN4,C_WIN5);

  if(bmp->hdr.cbfix==C_WIN4 || bmp->hdr.cbfix==C_WIN5)
  {
   if(bmp->info.windows4.bV4CSType==LCS_CALIBRATED_RGB)
   {
    p+=sprintf(p,"Colour space RGB calibrated\n");
   }
   else
   if(bmp->info.windows4.bV4CSType==LCS_sRGB)
   {
    p+=sprintf(p,"Colour space sRGB\n");
   }
   else
   if(bmp->info.windows4.bV4CSType==LCS_WINDOWS_COLOR_SPACE)
   {
    p+=sprintf(p,"Windows default colour space\n");
   }
   else
   if(bmp->info.windows4.bV4CSType==PROFILE_LINKED)
   {
    p+=sprintf(p,"Colour profile linked\n");
   }
   else
   if(bmp->info.windows4.bV4CSType==PROFILE_EMBEDDED)
   {
    cmsprofilename(profile,string2,sizeof(string2));
    p+=sprintf(p,"Colour profile: %s\n",string2);
   }
   else
   {
    p+=sprintf(p,"No or unknown colour space\n");
   }

   if(bmp->hdr.cbfix==C_WIN5)
   {
    if(bmp->info.windows5.bV5Intent==LCS_GM_ABS_COLORIMETRIC)
    {
     p+=sprintf(p,"Rendering intent: Match\n");
    }
    else
    if(bmp->info.windows5.bV5Intent==LCS_GM_BUSINESS)
    {
     p+=sprintf(p,"Rendering intent: Graphic\n");
    }
    else
    if(bmp->info.windows5.bV5Intent==LCS_GM_GRAPHICS)
    {
     p+=sprintf(p,"Rendering intent: Proof\n");
    }
    else
    if(bmp->info.windows5.bV5Intent==LCS_GM_IMAGES)
    {
     p+=sprintf(p,"Rendering intent: Picture\n");
    }
    else
    {
     p+=sprintf(p,"Rendering intent: Unknown\n");
    }
   }
  }
 }

 return(infowrite(string,frame));
}




static void setbitmask(int bpp,int rmask,int * rshiftp)
{
 int i;
 int rshift;
 int c1;

 rshift=-1;
 c1=0;

 for(i=0;i<32;i++)
 {
  if(rmask & (1<<i))
  {
   c1=i;
   if(rshift<0) rshift=i;
  }
 }

 if(rshift<0) rshift=0;

 if(bpp==16)
 {
  if((c1-rshift)>=5) rshift=c1-4;
 }
 else
 if(bpp==32)
 {
  if((c1-rshift)>=8) rshift=c1-7;
 }


 *rshiftp=rshift;
}








static os_error * loadbmp(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error  * err;
 buffer      bf;
 bmpstr      bmp;
 int         pal[256];
 int         bpp;
 int         xpix;
 int         ypix;
 int         colours;
 int         r;
 int         g;
 int         b;
 int         i;
 int         x;
 int         y;
 int       * idata;
 imagestr  * loadimage;
 int         wwidth;
 int         offset;
 int         offset2;
 int         fn=0;
 int         c=0;
 int         count;
 char      * p;
 int         state;
 int         sshift;
 int         dshift;
 int         pad;
 int         c1=0;
 int         c2=0;
 int         topdown;
 int         rmask;
 int         gmask;
 int         bmask;
 int         rshift;
 int         gshift;
 int         bshift;
 int         cxres;
	int         cyres;
 unsigned char                  * iccdata;
 unsigned int                     icclen;


 iccdata=NULL;


 bpp=xpix=ypix=colours=0;    /* compiler */
 topdown=0;
 rshift=gshift=bshift=0;
 rmask=gmask=bmask=0;

 cxres=bmpxres;
 cyres=bmpyres;


 err=bf_open(name,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
		if(type==DIB)
		{
   bf_tell(&bf,&offset);

   err=bf_read(&bf,&bmp.hdr.cbfix,sizeof(int));
   if(!err) err=bf_read(&bf,&bmp.info,bmp.hdr.cbfix-4);

//   bmp.hdr.cbsize=picturep->imagelen-2;

   bmp.hdr.offbits=bmp.hdr.cbfix;

   if(bmp.hdr.cbfix==C_WIN)
   {
    if(bmp.info.windows.compression==BI_BITFIELDS 
       /* && (bmp->info.windows.bitcount==16 || bmp->info.windows.bitcount==32)*/) bmp.hdr.offbits+=12;
   }

   if(bmp.hdr.cbfix==C_OS2)
   {
    if(bmp.info.windows.bitcount<=8) bmp.hdr.offbits+=4*(1<<bmp.info.windows.bitcount);
   }
   else
   {
    if(bmp.info.windows.bitcount<=8)
    {
     if(bmp.info.windows.ncolourused==0) bmp.hdr.offbits+=4*(1<<bmp.info.windows.bitcount);
     else                                bmp.hdr.offbits+=4*bmp.info.windows.ncolourused;
    }
    else
    {
     bmp.hdr.offbits+=4*bmp.info.windows.ncolourused;
    }
   }
		}
		else
		{
            err=bf_getc(&bf,&c1);  /* B */
   if(!err) err=bf_getc(&bf,&c2);  /* M */

   if(c1!='B' || c2!='M') err=generror(0,"This is not a BMP file");

   if(!err) err=bf_read(&bf,&bmp.hdr,sizeof(bmphdrstr));

   bf_tell(&bf,&offset);
   offset-=4;

   if(!err) err=bf_read(&bf,&bmp.info,bmp.hdr.cbfix-4);
		}


  if(!err)
  {
   if(bmp.hdr.cbfix==C_OS2)
   {
    bpp=bmp.info.os2.bitcount;
    xpix=bmp.info.os2.cx;
    ypix=bmp.info.os2.cy;

    if(bpp>8) colours=0;
    else      colours=(1<<bpp);

    for(i=0;i<colours;i++)
    {
     bf_getc(&bf,&b);
     bf_getc(&bf,&g);
     bf_getc(&bf,&r);
     pal[i]=(b<<24)|(g<<16)|(r<<8);
    }
   }
   else
   {
    bpp=bmp.info.windows.bitcount;
    xpix=bmp.info.windows.cx;
    ypix=bmp.info.windows.cy;

				if(bmp.info.windows.xdpm)	cxres=scale(bmp.info.windows.xdpm,254,10000);
				if(bmp.info.windows.ydpm)	cyres=scale(bmp.info.windows.ydpm,254,10000);

				cprintf("xdpm %d ydpm %d",bmp.info.windows.xdpm,bmp.info.windows.ydpm);

    if(ypix<0)
    {
     ypix=-ypix;
     topdown=1;
    }

    colours=bmp.info.windows.ncolourused;
    if(bpp<=8)
    {
     if(colours==0) colours=(1<<bpp);

     for(i=0;i<colours;i++)
     {
      bf_getc(&bf,&b);
      bf_getc(&bf,&g);
      bf_getc(&bf,&r);
      pal[i]=(b<<24)|(g<<16)|(r<<8);
      bf_getc(&bf,&b);
     }
    }
    else
    {
     if(bmp.info.windows.compression==BI_BITFIELDS)
     {
      if(bmp.hdr.cbfix==C_WIN4 || bmp.hdr.cbfix==C_WIN5)
      {
       rmask=bmp.info.windows4.bV4RedMask;
       gmask=bmp.info.windows4.bV4GreenMask;
       bmask=bmp.info.windows4.bV4BlueMask;
      }
      else
      {
       bf_geti(&bf,&rmask);
       bf_geti(&bf,&gmask);
       bf_geti(&bf,&bmask);

      }

      setbitmask(bpp,rmask,&rshift);
      setbitmask(bpp,gmask,&gshift);
      setbitmask(bpp,bmask,&bshift);

      cprintf("rmask %x rshift %x",rmask,rshift);
      cprintf("gmask %x gshift %x",gmask,gshift);
      cprintf("bmask %x bshift %x",bmask,bshift);
     }
     else
     {
      if(bpp==16)
      {
       rshift=10;
       rmask=0x7C00;
       gshift=5;
       gmask=0x3E0;
       bshift=0;
       bmask=0x1F;
      }
      else
      if(bpp==32)
      {
       rshift=16;
       rmask=0xFF0000;
       gshift=8;
       gmask=0xFF00;
       bshift=0;
       bmask=0xFF;
      }
     }
    }
   }
  }

  if(!err)
  {
   if(bmp.hdr.cbfix==C_WIN5)
   {
    if(bmp.info.windows4.bV4CSType==PROFILE_EMBEDDED)
    {
     bf_tell(&bf,&offset2);
     
     bf_seek(&bf,offset+bmp.info.windows5.bV5ProfileData);
     icclen=bmp.info.windows5.bV5ProfileSize;

     salloc((flex_ptr)&iccdata,icclen);

     bf_read(&bf,iccdata,icclen);

     bf_seek(&bf,offset2);
    }
   }
  }


 cprintf("xp=%d yp=%d xr=%d yr=%d col=%d bpp %d",xpix,ypix,cxres,cyres,colours,bpp); 

  if(!err)
  {
   addframe(loadfile,&fn,0);
   loadfile->frames[fn].fxpix=xpix;
   loadfile->frames[fn].fypix=ypix;
   sprintf(loadfile->frames[fn].name,"BMP%d",fn);
   loadfile->frames[fn].fbpp=bpp;
   loadfile->frames[fn].fxdpi=cxres;
   loadfile->frames[fn].fydpi=cyres;
   loadfile->frames[fn].xim=NULL;

   err=ximnew(loadfile->frames[fn].fxpix,loadfile->frames[fn].fypix,
                        loadfile->frames[fn].fbpp,&loadfile->frames[fn].xim);
  }

  if(!err)
  {
   loadimage=((loadfile->frames[fn].xim)->sim[IM]);
   loadimage->xdpi=loadfile->frames[fn].fxdpi;
   loadimage->ydpi=loadfile->frames[fn].fydpi;

   if(iccdata)
   {
    cmsaddprofile(&loadimage->profile,&iccdata,icclen,0);
   }
   else
   {
    cmsrgbprofile(&loadimage->profile);
   }

   getinfo(&loadfile->frames[fn],&bmp,&loadimage->profile);


   loadimage->ipal.ncolours=colours;
   for(i=0;i<colours;i++)
   {
    loadimage->ipal.word[i]=pal[i];
   }

   bf_tell(&bf,&offset);

			cprintf("offset %d hdr %d",offset,bmp.hdr.offbits);

   for(i=offset;i<bmp.hdr.offbits;i++) bf_getc(&bf,&b); /* skip */


   wwidth=((bpp*xpix+31) & ~0x1F)>>3;


   if(bmp.hdr.cbfix==C_OS2 || bmp.info.windows.compression==BI_RGB || bmp.info.windows.compression==BI_BITFIELDS)
   {
   /* dprintf(1,"OS2/RGB"); */

    for(y=0;y<ypix;y++)
    {
//     cprintf("ypix %d y %d",ypix,y);

     err=imfind1w(loadimage,topdown?y:(ypix-y-1),&idata);
     if(err) break;
     err=bf_read(&bf,idata,wwidth);
     if(err) break;


     if(bpp==32)
     {
      for(x=0;x<xpix;x++)
      {
       c1=*idata;

       r=(c1 & rmask) >> rshift;
       g=(c1 & gmask) >> gshift;
       b=(c1 & bmask) >> bshift;

       *idata++=r|(g<<8)|(b<<16);
      }
     }
     else
     if(bpp==16)
     {
      for(x=0;x<xpix;x+=2)
      {
       c1=*idata;
       r=(c1 & rmask)>>rshift;
       g=(c1 & gmask)>>gshift;
       b=(c1 & bmask)>>bshift;
       c2=r|(g<<5)|(b<<10);

       c1=c1>>16;
       r=(c1 & rmask)>>rshift;
       g=(c1 & gmask)>>gshift;
       b=(c1 & bmask)>>bshift;
       c2|=(r<<16)|(g<<(5+16))|(b<<(10+16));

       *idata++=c2;
      }
     }
     else
     if(bpp==24)
     {
      p=(char*)idata;
      for(x=0;x<xpix;x++)
      {
       b=*p;
       *p=*(p+2);
       *(p+2)=(char)b;
       p+=3;
      }
     }
     else imrevline(loadimage,topdown?y:(ypix-y-1));
    }
   }
   else
   {
    if(bmp.info.windows.compression==BI_RLE8)
    {
   /*  dprintf(1,"RLE8"); */

     imzero(loadimage);
     count=0;
     state=STBASE;
     pad=0;

     for(y=(ypix-1);y>=0;y--)
     {
      err=imfind1w(loadimage,y,&idata);
      if(err) break;
      p=(char*)idata;


/* !!! worry get out with eol or x>=xpix                */
/* !!! can get eol code just after x>=xpix              */
/* Don't assume x inc's once for each loop - it doesn't */

     /* for(x=0;x<wwidth;x++) */
      x=0;
      while(1)
      { 
       if(count--)  
       {
        if(state==STABS) 
        {
         bf_getc(&bf,&c);
        }

        if(x<xpix)
        {
         *p++=(char)c;
        }
        x++;
       }
       else
       {
        if(state==STABS && pad) 
        {
         state=STBASE;
         bf_getc(&bf,&count);
        }

        bf_getc(&bf,&count);
        if(count==0)
        {
         bf_getc(&bf,&count);
         if(count==0) {break;}         /* eol */
         else
         if(count==1) {y=-1;break;}    /* eoimage */
         else
         if(count==2)                  /* skip x,y */
         {
          count=0;
          bf_getc(&bf,&c);
          x+=c;
          bf_getc(&bf,&c);

          if(c)
          {
           imrevline(loadimage,y);
           y-=c;
           err=imfind1w(loadimage,y,&idata);
           if(err) break;
          }

          p=(char*)idata+x;
         }
         else                           /* goto absolute mode */
         {
          pad=(count & 0x1);
          state=STABS;
         }
        }
        else
        {
         state=STRUN;
         bf_getc(&bf,&c);
        }
       }
      }

      imrevline(loadimage,y);
     }
    }
    else
    if(bmp.info.windows.compression==BI_RLE4)
    {

   /*  dprintf(1,"RLE4"); */

     imzero(loadimage);
     count=0;
     state=STBASE;
     sshift=0;
     pad=0;

     for(y=(ypix-1);y>=0;y--)
     {
      err=imfind1w(loadimage,y,&idata);
      if(err) break;
      p=(char*)idata;
      dshift=0;

/* !!! worry get out with eol or x>=xpix                */
/* !!! can get eol code just after x>=xpix              */
/* Don't assume x inc's once for each loop - it doesn't */

      x=0;
      while(1)
      {
       if(count--)
       {
        if(state==STABS) 
        {
         if(sshift) 
         {
          bf_getc(&bf,&c);
          if(c<0) break;
         }
        }

        if(x<xpix)
        {
         *p|=((c>>sshift) & 0x7)<<dshift;
         if(dshift) p++;
        }
        x++;

        sshift^=4;
        dshift^=4;
       }
       else
       {
        if(state==STABS && pad) 
        {
         state=STBASE;
         bf_getc(&bf,&count);
        }

        bf_getc(&bf,&count);
        if(count==0)
        {
         bf_getc(&bf,&count);

         if(count==0)
         {
          break;                          /* eol */
         }
         else
         if(count==1) {y=-1;break;}       /* eoimage */
         else
         if(count==2)                     /* skip x,y */
         {
          count=0;
          bf_getc(&bf,&c);
          x+=c;
          bf_getc(&bf,&c);

          if(c)
          {
           y-=c;
           err=imfind1w(loadimage,y,&idata);
           if(err) break;
          }

          if(x & 1) dshift=4;
          else      dshift=0;

          p=(char*)idata+x/2;
         }
         else
         if(count<0) break;
         else                           /* goto absolute mode */
         {
          pad=(count/2) & 0x1;
          state=STABS;
          sshift=4;
         }
        }
        else
        if(count<0) break;
        else
        {
         state=STRUN;
         bf_getc(&bf,&c);
         sshift=4;
        }
       }
      }
     }
    }
   }
  }

  sfree((flex_ptr)&iccdata);

  err=bf_close(&bf,err);
 }

 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}



static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;
 err=NULL;
 return(err);
 USE(userhandle);
}


/*****************************************************************************/

static char explode[16]=
{
 0x00,  /* 0x0 */
 0x10,  /* 0x1 */
 0x20,
 0x30,

 0x01,
 0x11,
 0x21,
 0x31,

 0x02,
 0x12,
 0x22,
 0x32,

 0x03,
 0x13,
 0x23,
 0x33
};


static os_error * savebmp(char * name,int type)
{
 os_error * err;
 buffer      bf;
 bmpstr      bmp;
 int         fn;
 imagestr  * saveimage;
 int         xpix;
 int         ypix;
 int         bpp;
 int         obpp;
 int         hdrsize;
 int         infosize;
 int         palsize;
 int         bitsize;
 int         wwidth;
 char      * p;
 char      * q;
 char      * temp;
 int         i;
 int         palword;
 int         y;
 int       * idata;
 int         ch;
 int         colours;
 int         x;
 int         xdpi;
 int         ydpi;
 int         mk24=0;
 unsigned char               * iccdata;
 unsigned int                  icclen;


	cprintf("bmp save %x",type);

 err=bf_open(name,'w',DEFBUFFSIZE,&bf);
 if(!err)
 {
  memset(&bmp,0,sizeof(bmp));


  fn=menuview->frame;
  saveimage=((menufile->frames[fn].xim)->sim[IM]);

  xpix=saveimage->xpix;
  ypix=saveimage->ypix;
  xdpi=saveimage->xdpi;
  ydpi=saveimage->ydpi;
  bpp=saveimage->bpp;

  if((bpp==16 || bpp==32) && mk24) obpp=24;
  else                             obpp=(bpp==2)?4:bpp;

  if(obpp>8) colours=0;
  else       colours=(1<<obpp);


  cmsembedprofile(saveimage,&iccdata,&icclen);


  hdrsize=sizeof(bmphdrstr)+2;
  infosize=(os2?C_OS2:((iccdata!=NULL)?C_WIN5:C_WIN))-4;
  palsize=os2?(3*colours):(4*colours);
  wwidth=((xpix*obpp+31)&~0x1F)>>3;

  bitsize=wwidth*ypix;

  bmp.hdr.cbsize=hdrsize+infosize+palsize+bitsize;
  bmp.hdr.xhotspot=0;
  bmp.hdr.yhotspot=0;
  bmp.hdr.offbits=hdrsize+infosize+palsize+icclen;    
  bmp.hdr.cbfix=infosize+4;

  if(os2)
  {
   bmp.info.os2.cx=(short int)xpix;
   bmp.info.os2.cy=(short int)ypix;
   bmp.info.os2.cplanes=1;
   bmp.info.os2.bitcount=(short int)obpp;
  }
  else
  {
   bmp.info.windows.cx=xpix;
   bmp.info.windows.cy=ypix;
   bmp.info.windows.cplanes=1;
   bmp.info.windows.bitcount=(short int)obpp;
   bmp.info.windows.compression=BI_RGB;
   bmp.info.windows.imagesize=0;
   bmp.info.windows.xdpm=(xdpi*10000)/254;
   bmp.info.windows.ydpm=(ydpi*10000)/254;
   bmp.info.windows.ncolourused=0;
   bmp.info.windows.ncolourimportant=0;

   if(iccdata!=NULL)
   {
    bmp.info.windows5.bV5CSType=PROFILE_EMBEDDED;
    bmp.info.windows5.bV5ProfileData=infosize+palsize+4;
    bmp.info.windows5.bV5ProfileSize=icclen;
    bmp.info.windows5.bV5Intent=LCS_GM_IMAGES;
   }
  }

		if(type==DIB)
		{

   bf_write(&bf,&bmp.hdr.cbfix,hdrsize-2+infosize-12);
		}
		else
		{
   bf_putc(&bf,'B');
   bf_putc(&bf,'M');

   bf_write(&bf,&bmp,hdrsize-2+infosize);
		}

  for(i=0;i<colours;i++)
  {
   palword=saveimage->ipal.word[i];

   bf_putc(&bf,(palword>>24)&0xFF);
   bf_putc(&bf,(palword>>16)&0xFF);
   bf_putc(&bf,(palword>>8)&0xFF);
   if(!os2) bf_putc(&bf,0);
  }


  if(iccdata!=NULL)
  {
   bf_write(&bf,iccdata,icclen);
  }


  if(obpp==1 || obpp==4 || bpp==16 || bpp==32 || bpp==24)
                                    err=flex_alloc((flex_ptr)&temp,wwidth);
  else                              temp=NULL;

  if(!err)
  {
   for(y=(ypix-1);y>=0;y--)
   {
    err=imfind1r(saveimage,y,&idata);
    if(err) break;

    if(bpp==32)
    {
     q=temp;
     if(mk24)
     {
      for(x=0;x<xpix;x++)
      {
       ch=*idata++;
       *q++=(char)(ch>>16);
       *q++=(char)(ch>>8);
       *q++=(char)ch;
      }
     }
     else
     {
      for(x=0;x<xpix;x++)
      {
       ch=*idata++;
       *q++=(char)(ch>>16);
       *q++=(char)(ch>>8);
       *q++=(char)ch;
       *q++=0;
      }
     }
     err=bf_write(&bf,temp,wwidth);
    }
    else
    if(bpp==16)
    {
     q=temp;

     if(mk24)
     {
      for(x=0;x<xpix;x++)
      {
       ch=*idata++;

       *q++=(char)((ch>>7)&0xF8);
       *q++=(char)((ch>>2)&0xF8);
       *q++=(char)((ch<<3)&0xF8);

       x++;
       if(x>=xpix) break;

       *q++=(char)((ch>>23)&0xF8);
       *q++=(char)((ch>>18)&0xF8);
       *q++=(char)((ch>>13)&0xF8);
      }
     }
     else
     {
      for(x=0;x<xpix;x+=2)
      {
       ch=*idata++;

       ch=((ch & 0x1F)<<10)|(ch & 0x3E0)|((ch & 0x7C00)>>10)|
          ((ch & 0x1F0000)<<10)|(ch & 0x3E00000)|((ch & 0x7C000000)>>10);

       (*((int*)q))=ch;
       q+=4;
      }
     }
     err=bf_write(&bf,temp,wwidth);
    }
    else
    if(bpp==24)
    {
     q=temp;
     p=(char*)idata;

     for(x=0;x<xpix;x++)
     {
      *q++=*(p+2);
      *q++=*(p+1);
      *q++=*p;
      p+=3;
     }

     err=bf_write(&bf,temp,wwidth);
    }
    else
    if(bpp==8) err=bf_write(&bf,idata,wwidth);
    else
    if(bpp==1)
    {
     q=temp;
     p=(char*)idata;
     for(i=0;i<wwidth;i++) *q++=bitrev[*p++];
     err=bf_write(&bf,temp,wwidth);
    }
    else
    if(bpp==4)
    {
     q=temp;
     p=(char*)idata;
     for(i=0;i<wwidth;i++) *q++=nybrev[*p++];
     err=bf_write(&bf,temp,wwidth);
    }
    else
    if(obpp==4)
    {
     q=temp;
     p=(char*)idata;
     for(i=0;i<wwidth;i++)
     {
      ch=*p++;
      *q++=explode[ch & 0xF];
      *q++=explode[ch>>4];
     }
     err=bf_write(&bf,temp,wwidth);
    }
   }

   if(temp) flex_free((flex_ptr)&temp);
  }
  err=bf_closec(&bf,err,name,type);
 }
 return(err);
}


/*****************************************************************************/


static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}


static os_error * configloaded(int eventn,uservalue userhandle,void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {
  dbl=ftypegetrun(&ftype);

//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
  os2=tos2;
  bmpxres=txres;
  bmpyres=tyres;
 }

 return(err);
}





static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}







static os_error * wrpc(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}

static os_error * rdpc(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}



static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,
    3, &tos2,        DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
    5, &txres,       DBWRITE,  0,   0,      7, -1,  7,-1, rdpc, wrpc,
    7, &tyres,       DBWRITE,  0,   0,     -1,  5, -1, 5, rdpc, wrpc,


   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0
};



static dboxstr configbox=
{
 0,
 TBMP,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);
 
 tdbl=dbl;
 tos2=os2;
 txres=bmpxres;
 tyres=bmpyres;
 err=dodboxparent(&configbox,1,parent);

 return(err);
}

/*****************************************************************************/

static ftypestr ftype=
{
 BMP,             /* file type  */
 0,               /* flags      */
 loadbmp,         /* load       */
 loadfilepost,    /* loadpost   */
 "{BMP}",         /* name       */
 "{BMP}",         /* type name  */
 savebmp,         /* save       */
 config,          /* configure  */
 0,               /* icon       */
 bits,            /* bit flags  */
 NULL,            /* get frame  */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,            /* file info  */


 NULL,            /* saveim */
 "bmp\0""69c\0",  /* extension */

 "Windows Bitmap (*.bmp)",/* description */
};



static ftypestr ftypedib=
{
 DIB,             /* file type  */
 0,               /* flags      */
 loadbmp,         /* load       */
 loadfilepost,    /* loadpost   */
 "{DIB}",         /* name       */
 "{DIB}",         /* type name  */
 savebmp,         /* save       */
 NULL,            /* configure  */
 0,               /* icon       */
 bits,            /* bit flags  */
 NULL,            /* get frame  */
 "",              /* real name  */
 "",              /* file sp    */
 NULL,            /* file info  */


 NULL,            /* saveim */
 "dib\0",         /* extension */

 "Windows bitmap (*.dib)",/* description */
};






static contag contable[5]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,
 "OS/2",CONINT,&os2,NULL,NULL,
 "DefaultXRes",CONINT,&bmpxres,NULL,NULL,
 "DefaultYRes",CONINT,&bmpyres,NULL,NULL,
 NULL,0,NULL,NULL,NULL
};




static conlink configlink=
{
 "BMP",
 NULL,
 NULL
};



os_error * bmpinit(void)
{
 os_error * err;

          err=registerfiletype(&ftype);
	if(!err) err=registerfiletype(&ftypedib);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);
 }

 return(err);
}


