/*->c.bm */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <math.h>


#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"


#include "err.h"
#include "xext.h"
#include "poll.h"
#include "key.h"
#include "temp.h"
#include "alloc.h"
#include "fsx.h"
#include "trans.h"
#include "xmath.h"
#include "etc.h"
#include "mlo.h"
#include "config.h"
#include "dbhi.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"

#include "file.h"
#include "view.h"

#include "im.h"
#include "cmap.h"
#include "col.h"
#include "filter.h"
#include "pal.h"
#include "hsv.h"
#include "long.h"
#include "cms.h"

#include "bm.h"


/*****************************************************************************/
/* bit map manipulation */

static os_error * fliplineh(imagestr * im,int y)
{
 os_error * err;
 int      * ldata;
 int      * rdata;
 int        x;
 int        xpix;
 int        temp;

 int        lrword;
 int        lwword;
 int        rrword;
 int        rwword;

 int        lshift;
 int        rshift;
 int        mask;
 unsigned int uword;


 char     * lp;
 char     * rp;


 err=imfind1w(im,y,&ldata);
 if(err) return(err);

 rdata=ldata+(im->wwidth-1);


 xpix=im->xpix;


 switch(im->bpp)
 {
  case 1:
          mask=0x1;

          lshift=0;
          lrword=*ldata;
          rshift=((xpix-1) & 0x1F)*1;
         /* if(rshift==0) rshift=31; */

          rrword=*rdata;
          rwword=0;
          lwword=0;
          xpix/=2;

          for(x=0;x<xpix;x++)
          {
           rwword|=((lrword>>lshift)&mask)<<rshift;
           lwword|=((rrword>>rshift)&mask)<<lshift;

           lshift+=1;
           rshift-=1;

           if(lshift==32)
           {
            *ldata++=lwword;
            lwword=0;
            lrword=*ldata;
            lshift=0;
           }

           if(rshift<0)
           {
            *rdata--=rwword;
            rwword=0;
            rrword=*rdata;
            rshift=31;
           }
          }


          if(lshift)
          {
           lrword=(lrword>>lshift)<<lshift;
           lrword|=lwword;
           *ldata=lrword;
          }

          if(rshift<31)
          {
           uword=*rdata;
           uword=(uword<<(31-rshift))>>(31-rshift);
           uword|=rwword;
           *rdata=uword;
          }
          break;

  case 2:
          mask=0x3;

          lshift=0;
          lrword=*ldata;
          rshift=((xpix-1) & 0xF)*2;
        /*  if(rshift==0) rshift=30; */

          rrword=*rdata;
          rwword=0;
          lwword=0;
          xpix/=2;

          for(x=0;x<xpix;x++)
          {
           rwword|=((lrword>>lshift)&mask)<<rshift;
           lwword|=((rrword>>rshift)&mask)<<lshift;

           lshift+=2;
           rshift-=2;

           if(lshift==32)
           {
            *ldata++=lwword;
            lwword=0;
            lrword=*ldata;
            lshift=0;
           }

           if(rshift<0)
           {
            *rdata--=rwword;
            rwword=0;
            rrword=*rdata;
            rshift=30;
           }
          }

          if(lshift)
          {
           lrword=(lrword>>lshift)<<lshift;
           lrword|=lwword;
           *ldata=lrword;
          }

          if(rshift<30)
          {
           uword=*rdata;
           uword=(uword<<(30-rshift))>>(30-rshift);
           uword|=rwword;
           *rdata=uword;
          }
          break;


  case 4:
          mask=0xF;

          lshift=0;
          lrword=*ldata;
          rshift=((xpix-1) & 0x7)*4;
        /*  if(rshift==0) rshift=28; */

          rrword=*rdata;
          rwword=0;
          lwword=0;
          xpix/=2;

          for(x=0;x<xpix;x++)
          {
           rwword|=((lrword>>lshift)&mask)<<rshift;
           lwword|=((rrword>>rshift)&mask)<<lshift;

           lshift+=4;
           rshift-=4;

           if(lshift==32)
           {
            *ldata++=lwword;
            lwword=0;
            lrword=*ldata;
            lshift=0;
           }

           if(rshift<0)
           {
            *rdata--=rwword;
            rwword=0;
            rrword=*rdata;
            rshift=28;
           }
          }


          if(lshift)
          {
           lrword=(lrword>>lshift)<<lshift;
           lrword|=lwword;
           *ldata=lrword;
          }

          if(rshift<28)
          {
           uword=*rdata;
           uword=(uword<<(28-rshift))>>(28-rshift);
           uword|=rwword;
           *rdata=uword;
          }
          break;


  case 8:
          mask=0xFF;

          lshift=0;
          lrword=*ldata;
          rshift=((xpix-1) & 0x3)*8;
         /* if(rshift==0) rshift=24; */

          rrword=*rdata;
          rwword=0;
          lrword=*ldata; /* compiler */
          lwword=0;
          xpix/=2;

          for(x=0;x<xpix;x++)
          {
           rwword|=((lrword>>lshift)&mask)<<rshift;
           lwword|=((rrword>>rshift)&mask)<<lshift;

           lshift+=8;
           rshift-=8;

           if(lshift>=32)
           {
            *ldata++=lwword;
            lwword=0;
            lrword=*ldata;
            lshift=0;
           }

           if(rshift<0)
           {
            *rdata--=rwword;
            rwword=0;
            rrword=*rdata;
            rshift=24;
           }
          }


          if(lshift)
          {
           lrword=(lrword>>lshift)<<lshift;
           lrword|=lwword;
           *ldata=lrword;
          }

          if(rshift<24)
          {
           uword=*rdata;
           uword=(uword<<(24-rshift))>>(24-rshift);
           uword|=rwword;
           *rdata=uword;
          }
          break;


  case 24:
          lp=(char*)ldata;
          rp=lp+(xpix-1)*3;

          xpix/=2;

          for(x=0;x<xpix;x++)
          {
           temp=*lp;
           *lp++=*rp;
           *rp++=(char)temp;

           temp=*lp;
           *lp++=*rp;
           *rp++=(char)temp;

           temp=*lp;
           *lp++=*rp;
           *rp++=(char)temp;

           rp-=6;
          }
          break;



  case 16:
          lp=(char*)ldata;
          rp=lp+(xpix-1)*2;

          xpix/=2;

          for(x=0;x<xpix;x++)
          {
           temp=*lp;
           *lp++=*rp;
           *rp++=(char)temp;

           temp=*lp;
           *lp++=*rp;
           *rp++=(char)temp;

           rp-=4;
          }
          break;


  case 32:
          xpix/=2;

          for(x=0;x<xpix;x++)
          {
           temp=*ldata;
           *ldata++=*rdata;
           *rdata--=temp;
          }
          break;
 }


 return(err);
}


os_error * flipimageh(imagestr * im)
{
 os_error * err;
 int        y;

 err=NULL;

 if(im)
 {
  for(y=0;y<im->ypix;y++)
  {
   err=longproctick2(y,im->ypix);
   if(err) break;
   err=fliplineh(im,y);
   if(err) break;
  }
 }

 return(err);
}


os_error * flipimagev(imagestr * im)
{
 os_error * err;
 int        yt;
 int        yb;
 int        ypix;
 int      * tdata;
 int      * bdata;
 int        temp;
 int        i;
 int        wwidth;

 err=NULL;

 if(im)
 {
  ypix=im->ypix;
  yb=ypix-1;
  ypix/=2;
  wwidth=im->wwidth;

  for(yt=0;yt<ypix;yt++,yb--)
  {
   err=longproctick2(yt,ypix);
   if(err) break;

   err=imfind2ww(im,yt,&tdata,im,yb,&bdata);

   for(i=0;i<wwidth;i++)
   {
    temp=*tdata;
    *tdata++=*bdata;
    *bdata++=temp;
   }
  }
 }

 return(err);
}


os_error * rotimage180(ximagestr * sxim,ximagestr ** dximp)
{
 os_error * err;
 imagestr * sim;

 sim=(sxim->sim[IM]);

          err=flipimageh(sim);
 if(!err) err=flipimagev(sim);

 if(!err)
 {
  sim=(sxim->sim[AL]);

           err=flipimageh(sim);
  if(!err) err=flipimagev(sim);
 }

 *dximp=sxim;

 return(err);
}



static os_error * rotimagep90s(imagestr * sim,imagestr * dim)
{
 os_error * err;
 int        sc;
 int        dc;
 int        yd;
 int        ys;
 int        xs;
 int      * sdata;
 int      * ddata;


 char     * dp;
 char     * sp;

 int        spshift;
 int        el;

 int        dshift;
 int        init;
 int        mask;
 int        sshift;
 int        step;
 int        ppb;     /* pixels per byte */



 err=NULL;


 switch(sim->bpp)
 {
  case  1:
  case  2:
  case  4:
          imzero(dim);

          step=sim->bpp;
          if(step==1) {init=7;mask=0x1;ppb=8;}
          else
          if(step==2) {init=6;mask=0x3;ppb=4;}
          else
          /* if(step==4) */ {init=4;mask=0xF;ppb=2;}


          for(sc=0;sc<sim->imchunks;sc++)
          {
           err=longproctick2(sc,sim->imchunks);
           if(err) break;

           for(dc=0;dc<dim->imchunks;dc++)
           {
            for(yd=dim->imchunk[dc].sl;yd<dim->imchunk[dc].el;yd++)
            {
             ys=sim->imchunk[sc].sl;

             err=imfind2rw(sim,ys,&sdata,
                           dim,yd,&ddata);

             xs=dim->ypix-1-yd;

             dp=(char*)ddata+ys/ppb;
             dshift=(ys*step)&0x7;

             sp=(char*)sdata+xs/ppb;
             sshift=(xs*step)&0x7;

             spshift=sim->wwidth*4;
             el=sim->imchunk[sc].el;

             for(;ys<sim->imchunk[sc].el;ys++)
             {
              *dp|=(((*sp)>>sshift)&mask)<<dshift;
              dshift+=step;
              if(dshift>init)
              {
               dp++;
               dshift=0;
              }
              sp+=spshift;
             }
            }
           }
          }
          break;



  case  8:
          for(sc=0;sc<sim->imchunks;sc++)
          {
           err=longproctick2(sc,sim->imchunks);
           if(err) break;

           for(dc=0;dc<dim->imchunks;dc++)
           {
            for(yd=dim->imchunk[dc].sl;yd<dim->imchunk[dc].el;yd++)
            {
             ys=sim->imchunk[sc].sl;

             err=imfind2rw(sim,ys,&sdata,
                           dim,yd,&ddata);

             xs=dim->ypix-1-yd;

             dp=(char*)ddata+ys;
             sp=(char*)sdata+xs;

             spshift=sim->wwidth*4;
             el=sim->imchunk[sc].el;

             for(;ys<el;ys++)
             {
              *dp++=*sp;
              sp+=spshift;
             }
            }
           }
          }
          break;




  case 16:
          for(sc=0;sc<sim->imchunks;sc++)
          {
           err=longproctick2(sc,sim->imchunks);
           if(err) break;

           for(dc=0;dc<dim->imchunks;dc++)
           {
            for(yd=dim->imchunk[dc].sl;yd<dim->imchunk[dc].el;yd++)
            {
             ys=sim->imchunk[sc].sl;

             err=imfind2rw(sim,ys,&sdata,
                           dim,yd,&ddata);

             xs=dim->ypix-1-yd;

             dp=(char*)ddata+ys*2;
             sp=(char*)sdata+xs*2;

             spshift=sim->wwidth*4-1;
             el=sim->imchunk[sc].el;

             for(;ys<el;ys++)
             {
              *dp++=*sp++;
              *dp++=*sp;
              sp+=spshift;
             }
            }
           }
          }
          break;





  case 24:
          for(sc=0;sc<sim->imchunks;sc++)
          {
           err=longproctick2(sc,sim->imchunks);
           if(err) break;

           for(dc=0;dc<dim->imchunks;dc++)
           {
            for(yd=dim->imchunk[dc].sl;yd<dim->imchunk[dc].el;yd++)
            {
             ys=sim->imchunk[sc].sl;

             err=imfind2rw(sim,ys,&sdata,
                           dim,yd,&ddata);

             xs=dim->ypix-1-yd;

             dp=(char*)ddata+ys*3;
             sp=(char*)sdata+xs*3;

             spshift=sim->wwidth*4-2;
             el=sim->imchunk[sc].el;

             for(;ys<el;ys++)
             {
              *dp++=*sp++;
              *dp++=*sp++;
              *dp++=*sp;
              sp+=spshift;
             }
            }
           }
          }
          break;



  case 32:
          for(sc=0;sc<sim->imchunks;sc++)
          {
           err=longproctick2(sc,sim->imchunks);
           if(err) break;

           for(dc=0;dc<dim->imchunks;dc++)
           {
            for(yd=dim->imchunk[dc].sl;yd<dim->imchunk[dc].el;yd++)
            {
             ys=sim->imchunk[sc].sl;

             err=imfind2rw(sim,ys,&sdata,
                           dim,yd,&ddata);

             xs=dim->ypix-1-yd;

             dp=(char*)ddata+ys*4;
             sp=(char*)sdata+xs*4;

             spshift=sim->wwidth*4-3;
             el=sim->imchunk[sc].el;

             for(;ys<el;ys++)
             {
              *dp++=*sp++;
              *dp++=*sp++;
              *dp++=*sp++;
              *dp++=*sp;
              sp+=spshift;
             }
            }
           }
          }
          break;

 }
 return(err);
}



os_error * rotimagep90(ximagestr * sxim,ximagestr ** dximp)
{
 os_error * err;
 imagestr * dim;
 imagestr * sim;
 imagestr * mim;

 sim=(sxim->sim[IM]);
 mim=(sxim->sim[AL]);

 err=ximnew2(sim->ypix,sim->xpix,sim->bpp,mim?mim->bpp:0,dximp);
 if(!err)
 {
  dim=((*dximp)->sim[IM]);

  dim->xdpi=sim->ydpi;
  dim->ydpi=sim->xdpi;
  dim->ipal=sim->ipal;
  dim->tr=sim->tr;

  cmscopyprofile(dim,sim);

  rotimagep90s(sim,dim);

  if(mim)
  {
   dim=((*dximp)->sim[AL]);

   dim->xdpi=mim->ydpi;
   dim->ydpi=mim->xdpi;
   dim->ipal=mim->ipal;
   dim->tr=mim->tr;

   rotimagep90s(mim,dim);
  }

  ximtrash(&sxim);
 }
 return(err);
}



static os_error * rotimagem90s(imagestr * sim,imagestr * dim)
{
 os_error * err;
 int        sc;
 int        dc;
 int        xd;
 int        yd;
 int        ys;
 int      * sdata;
 int      * ddata;

 char     * dp;
 char     * sp;

 int        spshift;
 int        el;

 int        dshift;
 int        init;
 int        mask;
 int        sshift;
 int        step;
 int        ppb;     /* pixels per byte */


 err=NULL;


 switch(sim->bpp)
 {
  case  1:
  case  2:
  case  4:
          imzero(dim);

          step=sim->bpp;
          if(step==1) {init=7;mask=0x1;ppb=8;}
          else
          if(step==2) {init=6;mask=0x3;ppb=4;}
          else
          /* if(step==4) */ {init=4;mask=0xF;ppb=2;}


          for(sc=0;sc<sim->imchunks;sc++)
          {
           err=longproctick2(sc,sim->imchunks);
           if(err) break;

           for(dc=0;dc<dim->imchunks;dc++)
           {
            for(yd=dim->imchunk[dc].sl;yd<dim->imchunk[dc].el;yd++)
            {
             ys=sim->imchunk[sc].sl;

             err=imfind2rw(sim,ys,&sdata,
                           dim,yd,&ddata);

             xd=sim->ypix-1-ys;
             dp=((char*)ddata)+xd/ppb;
             dshift=(xd*step)&0x7;

             sp=((char*)sdata)+yd/ppb;
             sshift=(yd*step)&0x7;

             spshift=sim->wwidth*4;
             el=sim->imchunk[sc].el;

             for(;ys<sim->imchunk[sc].el;ys++)
             {
              *dp|=(((*sp)>>sshift)&mask)<<dshift;
              dshift-=step;
              if(dshift<0)
              {
               dp--;
               dshift=init;
              }
              sp+=spshift;
             }
            }
           }
          }
          break;



  case  8:
          for(sc=0;sc<sim->imchunks;sc++)
          {
           err=longproctick2(sc,sim->imchunks);
           if(err) break;

           for(dc=0;dc<dim->imchunks;dc++)
           {
            for(yd=dim->imchunk[dc].sl;yd<dim->imchunk[dc].el;yd++)
            {
             ys=sim->imchunk[sc].sl;

             err=imfind2rw(sim,ys,&sdata,
                           dim,yd,&ddata);

             xd=sim->ypix-1-ys;
             dp=((char*)ddata)+xd;
             sp=((char*)sdata)+yd;
             spshift=sim->wwidth*4;
             el=sim->imchunk[sc].el;

             for(;ys<sim->imchunk[sc].el;ys++)
             {
              *dp--=*sp;
              sp+=spshift;
             }
            }
           }
          }
          break;



  case 16:
          for(sc=0;sc<sim->imchunks;sc++)
          {
           err=longproctick2(sc,sim->imchunks);
           if(err) break;

           for(dc=0;dc<dim->imchunks;dc++)
           {
            for(yd=dim->imchunk[dc].sl;yd<dim->imchunk[dc].el;yd++)
            {
             ys=sim->imchunk[sc].sl;

             err=imfind2rw(sim,ys,&sdata,
                           dim,yd,&ddata);

             xd=sim->ypix-1-ys;
             dp=((char*)ddata)+xd*2+1;
             sp=((char*)sdata)+yd*2+1;
             spshift=sim->wwidth*4+1;
             el=sim->imchunk[sc].el;

             for(;ys<el;ys++)
             {
              *dp--=*sp--;
              *dp--=*sp;
              sp+=spshift;
             }
            }
           }
          }
          break;


  case 24:
          for(sc=0;sc<sim->imchunks;sc++)
          {
           err=longproctick2(sc,sim->imchunks);
           if(err) break;

           for(dc=0;dc<dim->imchunks;dc++)
           {
            for(yd=dim->imchunk[dc].sl;yd<dim->imchunk[dc].el;yd++)
            {
             ys=sim->imchunk[sc].sl;

             err=imfind2rw(sim,ys,&sdata,
                           dim,yd,&ddata);

             xd=sim->ypix-1-ys;
             dp=((char*)ddata)+xd*3+2;
             sp=((char*)sdata)+yd*3+2;
             spshift=sim->wwidth*4+2;
             el=sim->imchunk[sc].el;

             for(;ys<el;ys++)
             {
              *dp--=*sp--;
              *dp--=*sp--;
              *dp--=*sp;
              sp+=spshift;
             }
            }
           }
          }
          break;

  case 32:
          for(sc=0;sc<sim->imchunks;sc++)
          {
           err=longproctick2(sc,sim->imchunks);
           if(err) break;

           for(dc=0;dc<dim->imchunks;dc++)
           {
            for(yd=dim->imchunk[dc].sl;yd<dim->imchunk[dc].el;yd++)
            {
             ys=sim->imchunk[sc].sl;

             err=imfind2rw(sim,ys,&sdata,
                           dim,yd,&ddata);

             xd=sim->ypix-1-ys;
             dp=((char*)ddata)+xd*4+3;
             sp=((char*)sdata)+yd*4+3;
             spshift=sim->wwidth*4+3;
             el=sim->imchunk[sc].el;

             for(;ys<el;ys++)
             {
              *dp--=*sp--;
              *dp--=*sp--;
              *dp--=*sp--;
              *dp--=*sp;
              sp+=spshift;
             }
            }
           }
          }
          break;
 }
 return(err);
}



os_error * rotimagem90(ximagestr * sxim,ximagestr ** dximp)
{
 os_error * err;
 imagestr * dim;
 imagestr * sim;
 imagestr * mim;

 sim=(sxim->sim[IM]);
 mim=(sxim->sim[AL]);

 err=ximnew2(sim->ypix,sim->xpix,sim->bpp,mim?mim->bpp:0,dximp);
 if(!err)
 {
  dim=((*dximp)->sim[IM]);

  dim->xdpi=sim->ydpi;
  dim->ydpi=sim->xdpi;
  dim->ipal=sim->ipal;
  dim->tr=sim->tr;

  cmscopyprofile(dim,sim);

  rotimagem90s(sim,dim);

  if(mim)
  {
   dim=((*dximp)->sim[AL]);

   dim->xdpi=mim->ydpi;
   dim->ydpi=mim->xdpi;
   dim->ipal=mim->ipal;
   dim->tr=mim->tr;

   rotimagem90s(mim,dim);
  }

  ximtrash(&sxim);
 }
 return(err);
}




os_error * cropim(imagestr * sim,imagestr * dim,boxstr * area)
{
 os_error * err;
 int        sc;
 int        ys;
 int        el;
 int        yd;
 int      * sdata;
 int      * ddata;
 int        xs;
 int        xl;
 int        c;
 int        s;
 char     * sp;
 char     * dp;

 int        limit;
 int        ppw;
 int        mask;
 int        sshift;
 int        dshift;
 int        step;


 err=NULL;

 yd=0;

 xl=area->w+area->x;

 for(sc=0;sc<sim->imchunks;sc++)
 {
  ys=sim->imchunk[sc].sl;
  el=sim->imchunk[sc].el;

  if(el>area->y && ys<=(area->y+area->h))
  {
   ys=MAX(ys,area->y);
   el=MIN(el,(area->y+area->h));

   for(;ys<el;ys++,yd++)
   {
    err=longproctick2(yd,dim->ypix);
    if(err) break;

    err=imfind2rw(sim,ys,&sdata,dim,yd,&ddata);

    switch(sim->bpp)
    {
     case  1:
     case  2:
     case  4:
     case  8:
     case 16:
             step=sim->bpp;
             if(step==1) {limit=31;mask=0x1;ppw=32;}
             else
             if(step==2) {limit=30;mask=0x3;ppw=16;}
             else
             if(step==4) {limit=28;mask=0xF;ppw=8;}
             else
             if(step==8) {limit=24;mask=0xFF;ppw=4;}
             else
            /* if(step==16) */ {limit=16;mask=0xFFFF;ppw=2;}
    
             dshift=0;
             c=0;

             xs=area->x;
             sshift=(xs*step)&0x1F;
             sdata+=xs/ppw;

             s=(*sdata++)>>sshift;

             for(;xs<xl;xs++)
             {
              c|=(s & mask)<<dshift;

              sshift+=step;
              if(sshift>limit)
              {
               s=*sdata++;
               sshift=0;
              }
              else s>>=step;

              dshift+=step;
              if(dshift>limit)
              {
               *ddata++=c;
               dshift=0;
               c=0;
              }
             }
             if(dshift) *ddata=c;
             break;

     case 24:
             xs=area->x;
             sp=((char*)sdata)+3*xs;
             dp=((char*)ddata);
             memcpy(dp,sp,(xl-xs)*3);
             break;

     case 32:
             xs=area->x;
             sdata+=xs;
             memcpy(ddata,sdata,(xl-xs)*4);
             break;
    }
   }
  }
 }
 return(err);
}

/*****************************************************************************/


os_error * mapim(imagestr * im,int ylo,int yhi,spanstr ** s,int mode)
{
 os_error * err;
 int        y;
 int        x;
 int        xlo;
 int        xhi;
 int        bpp;
 char     * sp;
 int      * sdata;
 int        srcpal[256];
 int        i;
 char       map[256];
 int        ncolours;
 int        r;
 int        g;
 int        b;
 int        c;
 unsigned int w;
 int        mask;
 int        shift;
/* int        time=clock(); */


 err=NULL;

 bpp=im->bpp;
 mask=0;    /* compiler */

 if(bpp<=8)
 {
  ncolours=im->ipal.ncolours;

  for(i=0;i<ncolours;i++)
  {
   w=im->ipal.word[i];
   r=(w>> 8)&0xFF;
   g=(w>>16)&0xFF;
   b=(w>>24)&0xFF;

   switch(mode)
   {
    case MIMINVERT:
                   r=255-r;
                   g=255-g;
                   b=255-b;
                   break;

    case   MIMROT:
                  w=r;
                  r=b;
                  b=g;
                  g=w;
                  break;

    case    MIMRG:
                  SWOP(r,g);
                  break;

    case    MIMGB:
                  SWOP(g,b);
                  break;

    case    MIMBR:
                  SWOP(r,b);
                  break;

    case  MIGAMMA:
                  r=rvmap[r];
                  g=gvmap[g];
                  b=bvmap[b];
                  break;

       case MIHSV:
                  r=hsvmap(r,g,b);
                  g=(r>>8)&0xFF;
                  b=(r>>16)&0xFF;
                  r&=0xFF;
                  break;
   }

   srcpal[i]=(r<<8)|(g<<16)|(b<<24);
  }

  err=palmapf(im->ipal.ncolours,srcpal,im->ipal.ncolours,&im->ipal.word[0],map);

  if(bpp==1) mask=0x1;
  else
  if(bpp==2) mask=0x3;
  else
  if(bpp==4) mask=0xF;
  else       mask=0xFF;
 }

 if(err) return(err);


 for(y=ylo;y<yhi;y++)
 {
  err=longproctick2(y,yhi-ylo);
  if(err) break;

  xlo=(*s)[y-ylo].xlo;
  xhi=(*s)[y-ylo].xhi;

  err=imfind1w(im,y,&sdata);
  if(err) break;
  sp=(char*)sdata;


  switch(bpp)
  {
   case  1:
   case  2:
   case  4:
   case  8:
           sdata+=(xlo*bpp)/32;
           shift=(xlo*bpp)&0x1F;
           w=*sdata;
                                          /* clear 32-shift bits */
           if(shift==0) c=0;
           else         c=(w<<(32-shift))>>(32-shift);

           for(x=xlo;x<xhi;x++)                                                            {
            c|=(map[(w>>shift)&mask])<<shift;
            shift+=bpp;
            if(shift>=32)
            {
             *sdata++=c;
             w=*sdata;
             shift=c=0;
            }
           }
           if(shift)
           {
            w=w>>shift;
            w=w<<shift;
            w|=c;
            *sdata=w;
           }
           break;


   case 24:
           sp+=3*xlo;

           switch(mode)
           {
            case MIMINVERT:
                           xhi*=3;
                           xlo*=3;
                           for(x=xlo;x<xhi;x++)                                                            {
                            *sp=(char)(255-*sp);
                            sp++;
                           }
                           break;

           case     MIMROT:
                           for(x=xlo;x<xhi;x++)                                                            {
                            r=*sp;
                            g=*(sp+1);
                            b=*(sp+2);

                            *sp++=(char)b;
                            *sp++=(char)r;
                            *sp++=(char)g;
                           }
                           break;


             case    MIMRG:
                           for(x=xlo;x<xhi;x++)                                                            {
                            r=*sp;
                            g=*(sp+1);
                            b=*(sp+2);

                            *sp++=(char)g;
                            *sp++=(char)r;
                            *sp++=(char)b;
                           }
                           break;

             case    MIMGB:
                           for(x=xlo;x<xhi;x++)                                                            {
                            r=*sp;
                            g=*(sp+1);
                            b=*(sp+2);

                            *sp++=(char)r;
                            *sp++=(char)b;
                            *sp++=(char)g;
                           }
                           break;

             case    MIMBR:
                           for(x=xlo;x<xhi;x++)                                                            {
                            r=*sp;
                            g=*(sp+1);
                            b=*(sp+2);

                            *sp++=(char)b;
                            *sp++=(char)g;
                            *sp++=(char)r;
                           }
                           break;

             case  MIGAMMA:
                           for(x=xlo;x<xhi;x++)                                                            {
                            r=*sp;
                            g=*(sp+1);
                            b=*(sp+2);

                            r=rvmap[r];
                            g=gvmap[g];
                            b=bvmap[b];

                            *sp++=(char)r;
                            *sp++=(char)g;
                            *sp++=(char)b;
                           }
                           break;

               case  MIHSV:
                           for(x=xlo;x<xhi;x++)                                                            {
                            r=*sp;
                            g=*(sp+1);
                            b=*(sp+2);

                            r=hsvmap(r,g,b);

                            *sp++=(char)r;
                            *sp++=(char)(r>>8);
                            *sp++=(char)(r>>16);
                           }
                           break;





           }
           break;





   case 16:
           sdata+=(xlo*bpp)/32;
           shift=(xlo*bpp)&0x1F;
           w=*sdata;
                                          /* clear 32-shift bits */
           if(shift==0) c=0;
           else         c=(w<<(32-shift))>>(32-shift);

           switch(mode)
           {
            case MIMINVERT:
                           for(x=xlo;x<xhi;x++)                                                            {
                            c|=(((w>>shift)&0x7FFF)^0x7FFF)<<shift;
                            shift+=bpp;
                            if(shift>=32)
                            {
                             *sdata++=c;
                             w=*sdata;
                             shift=c=0;
                            }
                           }
                           break;

           case     MIMROT:
                           for(x=xlo;x<xhi;x++)                                                            {
                            r=(w>>shift)&0x1F;
                            g=(w>>(shift+5))&0x1F;
                            b=(w>>(shift+10))&0x1F;

                            c|=(b<<shift)|(r<<(shift+5))|(g<<(shift+10));

                            shift+=bpp;
                            if(shift>=32)
                            {
                             *sdata++=c;
                             w=*sdata;
                             shift=c=0;
                            }
                           }
                           break;


             case    MIMRG:
                           for(x=xlo;x<xhi;x++)                                                            {
                            r=(w>>shift)&0x1F;
                            g=(w>>(shift+5))&0x1F;
                            b=(w>>(shift+10))&0x1F;

                            c|=(g<<shift)|(r<<(shift+5))|(b<<(shift+10));

                            shift+=bpp;
                            if(shift>=32)
                            {
                             *sdata++=c;
                             w=*sdata;
                             shift=c=0;
                            }
                           }
                           break;

             case    MIMGB:
                           for(x=xlo;x<xhi;x++)                                                            {
                            r=(w>>shift)&0x1F;
                            g=(w>>(shift+5))&0x1F;
                            b=(w>>(shift+10))&0x1F;

                            c|=(r<<shift)|(b<<(shift+5))|(g<<(shift+10));

                            shift+=bpp;
                            if(shift>=32)
                            {
                             *sdata++=c;
                             w=*sdata;
                             shift=c=0;
                            }
                           }
                           break;

             case    MIMBR:
                           for(x=xlo;x<xhi;x++)                                                            {
                            r=(w>>shift)&0x1F;
                            g=(w>>(shift+5))&0x1F;
                            b=(w>>(shift+10))&0x1F;

                            c|=(b<<shift)|(g<<(shift+5))|(r<<(shift+10));

                            shift+=bpp;
                            if(shift>=32)
                            {
                             *sdata++=c;
                             w=*sdata;
                             shift=c=0;
                            }
                           }
                           break;

             case  MIGAMMA:
                           for(x=xlo;x<xhi;x++)                                                            {
                            if(shift) r=(w>>(shift-3))&0xF8;
                            else      r=(w<<3)&0xF8;

                            g=(w>>(shift+5-3))&0xF8;
                            b=(w>>(shift+10-3))&0xF8;

                            r=rvmap[r] & 0xF8;
                            g=gvmap[g] & 0xF8;
                            b=bvmap[b] & 0xF8;

                            if(shift) 
                              c|=(r<<(shift-3))|
                                 (g<<(shift+5-3))|
                                 (b<<(shift+10-3));
                            else
                              c|=(r>>3)|
                                 (g<<(shift+5-3))|
                                 (b<<(shift+10-3));

                            shift+=16;
                            if(shift>=32)
                            {
                             *sdata++=c;
                             w=*sdata;
                             shift=c=0;
                            }
                           }
                           break;



                case MIHSV:
                           for(x=xlo;x<xhi;x++)                                                            {
                            if(shift) r=(w>>(shift-3))&0xF8;
                            else      r=(w<<3)&0xF8;

                            g=(w>>(shift+5-3))&0xF8;
                            b=(w>>(shift+10-3))&0xF8;

                            r=hsvmap(r,g,b);

                            c|=
                     (((r&0xF8)>>3)|((r&0xF800)>>6)|((r&0xF80000)>>9))<<shift;

                            shift+=16;
                            if(shift>=32)
                            {
                             *sdata++=c;
                             w=*sdata;
                             shift=c=0;
                            }
                           }
                           break;



           }
           if(shift)
           {
            w=w>>shift;
            w=w<<shift;
            w|=c;
            *sdata=w;
           }
           break;



   case 32:
           sdata+=xlo;

           switch(mode)
           {
            case MIMINVERT:
                           for(x=xlo;x<xhi;x++)                                                            {
                            *sdata=(*sdata)^0xFFFFFF;
                            sdata++;
                           }
                           break;

           case     MIMROT:
                           for(x=xlo;x<xhi;x++)                                                            {
                            w=*sdata;
                            r=w&0xFF;
                            g=(w>>8)&0xFF;
                            b=(w>>16)&0xFF;

                            *sdata++=b|(r<<8)|(g<<16);
                           }
                           break;


             case    MIMRG:
                           for(x=xlo;x<xhi;x++)                                                            {
                            w=*sdata;
                            r=w&0xFF;
                            g=(w>>8)&0xFF;
                            b=(w>>16)&0xFF;

                            *sdata++=g|(r<<8)|(b<<16);
                           }
                           break;

             case    MIMGB:
                           for(x=xlo;x<xhi;x++)                                                            {
                            w=*sdata;
                            r=w&0xFF;
                            g=(w>>8)&0xFF;
                            b=(w>>16)&0xFF;

                            *sdata++=r|(b<<8)|(g<<16);
                           }
                           break;

             case    MIMBR:
                           for(x=xlo;x<xhi;x++)                                                            {
                            w=*sdata;
                            r=w&0xFF;
                            g=(w>>8)&0xFF;
                            b=(w>>16)&0xFF;

                            *sdata++=b|(g<<8)|(r<<16);
                           }
                           break;

             case  MIGAMMA:
                           for(x=xlo;x<xhi;x++)                                                            {
                            w=*sdata;
                            r=w&0xFF;
                            g=(w>>8)&0xFF;
                            b=(w>>16)&0xFF;

                            r=rvmap[r];
                            g=gvmap[g];
                            b=bvmap[b];

                            *sdata++=r|(g<<8)|(b<<16);
                           }
                           break;

                case MIHSV:
                           for(x=xlo;x<xhi;x++)                                                            {
                            w=*sdata;
                            r=w&0xFF;
                            g=(w>>8)&0xFF;
                            b=(w>>16)&0xFF;
                            *sdata++=hsvmap(r,g,b);
                           }
                           break;

           }
           break;

  }
 }


/* dprintf(0,"time=%d",clock()-time); */

 return(err);
}




/*****************************************************************************/

/* greyscale an entire image */
/* if bpp<=8 then we just greyscale the palette */


os_error * greyscaleim(imagestr * sim,imagestr * dim)
{
 os_error * err;
 int        bpp;
 int        y;
 int        x;
 int        xpix;
 int        ypix;
 int      * sdata;
 char     * sp;
 int      * ddata;
 char     * dp;

 int        rtab[256];
 int        gtab[256];
 int        btab[256];
 int        w;
 int        i;
 int        sum;
 int        r;
 int        g;
 int        b;
 int        c;


 err=NULL;

 bpp=sim->bpp;
 xpix=sim->xpix;
 ypix=sim->ypix;

 sum=redweight+greenweight+blueweight;
 
 if(bpp<=8)
 {
  for(i=0;i<sim->ipal.ncolours;i++)
  {
   w=sim->ipal.word[i];

   r=(w>>8)&0xFF;
   g=(w>>16)&0xFF;
   b=(w>>24)&0xFF;

   w=(r*redweight+g*greenweight+b*blueweight)/sum;

   sim->ipal.word[i]=(w<<8)|(w<<16)|(w<<24);
  }
 }
 else
 {                               /* assume only ever called with 8 bpp */
  imsetgreypal(dim,dim->bpp);

  for(i=0;i<256;i++)
  {
   rtab[i]=scale(i<<16,redweight,sum);
   gtab[i]=scale(i<<16,greenweight,sum);
   btab[i]=scale(i<<16,blueweight,sum);
  }

  for(y=0;y<ypix;y++)
  {
   err=longproctick2(y,ypix);

   err=imfind2rw(sim,y,&sdata,dim,y,&ddata);
   if(err) break;

   sp=(char*)sdata;
   dp=(char*)ddata;


   switch(bpp)
   {
    case 24:
            for(x=0;x<xpix;x++)
            {
             w =rtab[*sp++];
             w+=gtab[*sp++];
             w+=btab[*sp++];
             *dp++=(char)(w>>16);
            }
            break;

    case 32:
            for(x=0;x<xpix;x++)
            {
             c=*sdata++;
             w =rtab[c&0xFF];
             w+=gtab[(c>>8)&0xFF];
             w+=btab[(c>>16)&0xFF];
             *dp++=(char)(w>>16);
            }
            break;

    case 16:
            for(x=0;x<xpix;x++)
            {
             c=*sdata++;
             w =rtab[(c<<3)&0xF8];
             w+=gtab[(c>>2)&0xF8];
             w+=btab[(c>>7)&0xF8];
             *dp++=(char)(w>>16);
             c=c>>16;
             x++;
             if(x>=xpix) break;
             w =rtab[(c<<3)&0xF8];
             w+=gtab[(c>>2)&0xF8];
             w+=btab[(c>>7)&0xF8];
             *dp++=(char)(w>>16);
            }
            break;
   }
  }
 }
 return(err);
}

/*****************************************************************************/

os_error * addnoise(imagestr * im,int ylo,int yhi,spanstr ** s,int a,int flags)
{
 os_error * err;
 int        y;
 int        x;
 int        xlo;
 int        xhi;
 int        bpp;
 char     * sp;
 char     * dp;
 int      * sdata;
 int        index;
 int        r;
 int        g;
 int        b;
 int        c;
 int        a2;
 unsigned int w;
 int        mask;
 int        shift;
 char       rtab[256];
 char       gtab[256];
 char       btab[256];
 int        delta;
 int        grey;
 int        size;


 err=NULL;

 a2=a*2;

 bpp=im->bpp;
 grey=imgrey(im);

 mask=0;    /* compiler */

 if(bpp<=8)
 {
  imsplitpalette(rtab,gtab,btab,im);

  if(grey)
  {
   err=makegmap(im->ipal.ncolours,im->ipal.word,gtab,&size);
   if(size<2) grey=0;
  }

  if(!grey) err=makecmap(im->ipal.ncolours,im->ipal.word,4,rgbmap);

  if(bpp==1) mask=0x1;
  else
  if(bpp==2) mask=0x3;
  else
  if(bpp==4) mask=0xF;
  else       mask=0xFF;
 }

 if(err) return(err);


 for(y=ylo;y<yhi;y++)
 {
  err=longproctick2(y,yhi-ylo);

  xlo=(*s)[y-ylo].xlo;
  xhi=(*s)[y-ylo].xhi;

  err=imfind1w(im,y,&sdata);
  if(err) break;
  sp=(char*)sdata;
  dp=(char*)sdata;

  switch(bpp)
  {
   case  1:
   case  2:
   case  4:
   case  8:
           sdata+=(xlo*bpp)/32;
           shift=(xlo*bpp)&0x1F;
           w=*sdata;
                                          /* clear 32-shift bits */

           if(shift==0) c=0;
           else         c=(w<<(32-shift))>>(32-shift);

           for(x=xlo;x<xhi;x++)                                                            {
            index=(w>>shift)&mask;
            r=rtab[index];
            g=gtab[index];
            b=btab[index];

            if(flags || grey)
            {
             delta=(((rand() & 0x7FFF)*a2)>>15)-a;
             r+=delta;
             g+=delta;
             b+=delta;
            }
            else
            {
             r+=(((rand() & 0x7FFF)*a2)>>15)-a;
             g+=(((rand() & 0x7FFF)*a2)>>15)-a;
             b+=(((rand() & 0x7FFF)*a2)>>15)-a;
            }

            if(r<0)   r=0;
            if(r>255) r=255;
            if(g<0)   g=0;
            if(g>255) g=255;
            if(b<0)   b=0;
            if(b>255) b=255;

            if(grey)
            {
             index=gtab[r];
            }
            else
            {
             index=((r&0xF0)<<4)|(g&0xF0)|((b&0xF0)>>4);
             index=rgbmap[index];
            }

            c|=index<<shift;
            shift+=bpp;
            if(shift>=32)
            {
             *sdata++=c;
             w=*sdata;
             shift=c=0;
            }
           }
           if(shift)
           {
            w=w>>shift;
            w=w<<shift;
            w|=c;
            *sdata=w;
           }
           break;


   case 24:
           sp+=3*xlo;
           dp+=3*xlo;
           for(x=xlo;x<xhi;x++)                                                            {
            r=*sp++;
            g=*sp++;
            b=*sp++;

            if(flags)
            {
             delta=(((rand() & 0x7FFF)*a2)>>15)-a;
             r+=delta;
             g+=delta;
             b+=delta;
            }
            else
            {
             r+=(((rand() & 0x7FFF)*a2)>>15)-a;
             g+=(((rand() & 0x7FFF)*a2)>>15)-a;
             b+=(((rand() & 0x7FFF)*a2)>>15)-a;
            }

            if(r<0)   r=0;
            if(r>255) r=255;
            if(g<0)   g=0;
            if(g>255) g=255;
            if(b<0)   b=0;
            if(b>255) b=255;

            *dp++=(char)r;
            *dp++=(char)g;
            *dp++=(char)b;
           }
           break;



   case 16:
           sdata+=xlo/2;
           shift=(xlo*16)&0x1F;

           w=*sdata;

           if(shift==0) c=0;
           else         c=(w<<(32-shift))>>(32-shift);

           for(x=xlo;x<xhi;x++)                                                            {
            if(shift) r=(w>>(shift-3))&0xF8;
            else      r=(w<<3)&0xF8;

            g=(w>>(shift-3+5))&0xF8;
            b=(w>>(shift-3+10))&0xF8;

            if(flags)
            {
             delta=(((rand() & 0x7FFF)*a2)>>15)-a;
             r+=delta;
             g+=delta;
             b+=delta;
            }
            else
            {
             r+=(((rand() & 0x7FFF)*a2)>>15)-a;
             g+=(((rand() & 0x7FFF)*a2)>>15)-a;
             b+=(((rand() & 0x7FFF)*a2)>>15)-a;
            }

            if(r<0)   r=0;
            if(r>255) r=255;
            if(g<0)   g=0;
            if(g>255) g=255;
            if(b<0)   b=0;
            if(b>255) b=255;

            if(shift)
            {
             c|=((r&0xF8)<<(16-3))|
                ((g&0xF8)<<(16+2))|
                ((b&0xF8)<<(16+7));
            }
            else
            {
             c|=((r&0xF8)>>3)|((g&0xF8)<<2)|((b&0xF8)<<7);
            }

            shift+=16;
            if(shift>=32)
            {
             *sdata++=c;
             w=*sdata;
             shift=c=0;
            }
           }
           if(shift)
           {
            w=w>>shift;
            w=w<<shift;
            w|=c;
            *sdata=w;
           }
           break;


   case 32:
           sdata+=xlo;
           for(x=xlo;x<xhi;x++)                                                            {
            w=*sdata;
            r=w&0xFF;
            g=(w>>8)&0xFF;
            b=(w>>16)&0xFF;

            if(flags)
            {
             delta=(((rand() & 0x7FFF)*a2)>>15)-a;
             r+=delta;
             g+=delta;
             b+=delta;
            }
            else
            {
             r+=(((rand() & 0x7FFF)*a2)>>15)-a;
             g+=(((rand() & 0x7FFF)*a2)>>15)-a;
             b+=(((rand() & 0x7FFF)*a2)>>15)-a;
            }

            if(r<0)   r=0;
            if(r>255) r=255;
            if(g<0)   g=0;
            if(g>255) g=255;
            if(b<0)   b=0;
            if(b>255) b=255;

            w=r|(g<<8)|(b<<16);

            *sdata++=w;
           }
           break;

  }
 }
 return(err);
}

/****************************************************************************/

static char * rl;
static char * bl;
static char * gl;

static int xrback;
static int xgback;
static int xbback;


static void setbackground(int r,int g,int b)
{
 xrback=r;
 xgback=g;
 xbback=b;
}


 
static os_error * imget(imagestr * sim,int y,
                                       char * rtab,char * gtab,char * btab)
{
 os_error * err;
 char     * r;
 char     * b;
 char     * g;
 int      * sdata;
 char     * sp;
 int        w;
 int        index;
 int        shift;
 int        xpix;
 int        bpp;
 int        mask;
 int        x;

 xpix=sim->xpix;
 bpp=sim->bpp;
 mask=0;

 if(bpp<=8)
 {
  if(bpp==1) mask=0x1;
  else
  if(bpp==2) mask=0x3;
  else
  if(bpp==4) mask=0xF;
  else       mask=0xFF;
 }

 err=imfind1r(sim,y,&sdata);
 if(!err)
 {
  sp=(char*)sdata;
  r=rl;
  b=bl;
  g=gl;

  switch(bpp)
  {
   case  1:
   case  2:
   case  4:
   case  8:
           shift=0;
           w=*sdata++;
                                          /* clear 32-shift bits */
           for(x=0;x<xpix;x++)
           {
            index=(w>>shift)&mask;
            *r++=rtab[index];
            *g++=gtab[index];
            *b++=btab[index];

            shift+=bpp;
            if(shift>=32)
            {
             w=*sdata++;
             shift=0;
            }
           }
           break;

   case 16:
           shift=0;
           w=*sdata++;
           for(x=0;x<xpix;x++)
           {
            index=(w>>shift);
            *r++=(char)((index<< 3)&0xF8);
            *g++=(char)((index>> 2)&0xF8);
            *b++=(char)((index>> 7)&0xF8);
            shift+=16;
            if(shift>=32)
            {
             w=*sdata++;
             shift=0;
            }
           }
           break;

   case 24:
           for(x=0;x<xpix;x++)
           {
            *r++=*sp++;
            *g++=*sp++;
            *b++=*sp++;
           }
           break;

   case 32:
           for(x=0;x<xpix;x++)
           {
            w=*sdata++;
            *r++=(char)(w&0xFF);
            *g++=(char)((w>>8)&0xFF);
            *b++=(char)((w>>16)&0xFF);
           }
           break;
  }
 }
 return(err);
}


/* blank line from 0 to xlo and xhi to xpix */

static os_error * imput(imagestr * dim,int y,int xlo,int xhi,
                                             int junk,int grey,char * gtab)
{
 os_error * err;
 char     * r;
 char     * b;
 char     * g;
 int      * ddata;
 char     * dp;
 int        w;
 int        index;
 int        shift;
 int        xpix;
 int        bpp;
 int        mask;
 int        bindex;
 int        x;

 xpix=dim->xpix;
 bpp=dim->bpp;
 mask=0;


 if(bpp<=8)
 {
  if(bpp==1) mask=0x1;
  else
  if(bpp==2) mask=0x3;
  else
  if(bpp==4) mask=0xF;
  else       mask=0xFF;
 }

 xpix+=junk;
 if(xpix<xhi) xhi=xpix;

 err=imfind1w(dim,y,&ddata);
 if(!err)
 {
  dp=(char*)ddata;
  r=rl;
  b=bl;
  g=gl;

  switch(bpp)
  {
   case  1:
   case  2:
   case  4:
   case  8:
           shift=0;
           w=0;

           if(grey)
           {
            bindex=gtab[xrback];
           }
           else
           {
            bindex=((xrback&0xF0)<<4)|(xgback&0xF0)|((xbback&0xF0)>>4);
            bindex=rgbmap[bindex];
           }

           for(x=junk;x<xlo;x++)
           {
            w|=bindex<<shift;
            shift+=bpp;
            if(shift>=32)
            {
             *ddata++=w;
             shift=0;
             w=0;
            }
           }

           if(x>xlo) {r+=x-xlo;g+=x-xlo;b+=x-xlo;}

           for(;x<xhi;x++)
           {
            if(grey)
            {
             index=gtab[*r++];
            }
            else
            {
             index=(((*r++)&0xF0)<<4)|((*g++)&0xF0)|(((*b++)&0xF0)>>4);
             index=rgbmap[index];
            }

            w|=index<<shift;
            shift+=bpp;
            if(shift>=32)
            {
             *ddata++=w;
             shift=0;
             w=0;
            }
           }

           for(;x<xpix;x++)
           {
            w|=bindex<<shift;
            shift+=bpp;
            if(shift>=32)
            {
             *ddata++=w;
             shift=0;
             w=0;
            }
           }

           if(shift) *ddata=w;
           break;



   case 16:
           shift=0;
           w=0;

           bindex=((xrback&0xF8)>>3)|((xgback&0xF8)<<2)|((xbback&0xF8)<<7);

           for(x=junk;x<xlo;x++)
           {
            w|=bindex<<shift;
            shift+=16;
            if(shift>=32)
            {
             *ddata++=w;
             shift=0;
             w=0;
            }
           }

           if(x>xlo) {r+=x-xlo;g+=x-xlo;b+=x-xlo;}

           for(;x<xhi;x++)
           {
            index=(((*r++)&0xF8)>>3)|(((*g++)&0xF8)<<2)|(((*b++)&0xF8)<<7);

            w|=index<<shift;
            shift+=16;
            if(shift>=32)
            {
             *ddata++=w;
             shift=0;
             w=0;
            }
           }

           for(;x<xpix;x++)
           {
            w|=bindex<<shift;
            shift+=16;
            if(shift>=32)
            {
             *ddata++=w;
             shift=0;
             w=0;
            }
           }
           if(shift) *ddata=w;
           break;



   case 24:
           for(x=junk;x<xlo;x++)
           {
            *dp++=(char)xrback;
            *dp++=(char)xgback;
            *dp++=(char)xbback;
           }

           if(x>xlo) {r+=x-xlo;g+=x-xlo;b+=x-xlo;}

           for(;x<xhi;x++)
           {
            *dp++=*r++;
            *dp++=*g++;
            *dp++=*b++;
           }

           for(;x<xpix;x++)
           {
            *dp++=(char)xrback;
            *dp++=(char)xgback;
            *dp++=(char)xbback;
           }
           break;


   case 32:
           for(x=junk;x<xlo;x++)
           {
            *ddata++=xrback|(xgback<<8)|(xbback<<16);
           }

           if(x>xlo) {r+=x-xlo;g+=x-xlo;b+=x-xlo;}

           for(;x<xhi;x++)
           {
            *ddata++=(*r++)|((*g++)<<8)|((*b++)<<16);
           }

           for(;x<xpix;x++)
           {
            *ddata++=xrback|(xgback<<8)|(xbback<<16);
           }
           break;
  }
 }
 return(err);
}



#define SCALE 4096
#define HALFSCALE 2048



static void shearxline(int xpix,double new0,int intnew0)
{
 int    x;
 int    fracnew0;
 int    omfracnew0;
 int    pr;
 int    pg;
 int    pb;
 int    rv;
 int    gv;
 int    bv;
 char * r;
 char * g;
 char * b;


 fracnew0=(int)((new0-(double)intnew0)*SCALE);
 omfracnew0=SCALE-fracnew0;

 pr=xrback;
 pg=xgback;
 pb=xbback;

 r=rl;
 b=bl;
 g=gl;

 for(x=0;x<xpix;x++)
 {
  rv=*r;
  *r++=(char)((pr*fracnew0+rv*omfracnew0+HALFSCALE)/SCALE);
  pr=rv;

  gv=*g;
  *g++=(char)((pg*fracnew0+gv*omfracnew0+HALFSCALE)/SCALE);
  pg=gv;

  bv=*b;
  *b++=(char)((pb*fracnew0+bv*omfracnew0+HALFSCALE)/SCALE);
  pb=bv;
 }

 if(fracnew0>0)
 {
  *r++=(char)((pr*fracnew0+xrback*omfracnew0+HALFSCALE)/SCALE);
  *g++=(char)((pg*fracnew0+xgback*omfracnew0+HALFSCALE)/SCALE);
  *b++=(char)((pb*fracnew0+xbback*omfracnew0+HALFSCALE)/SCALE);
 }
}




static os_error * shearxs(imagestr * sim,imagestr * dim,
                                 double fangle,double shearfac,int junk)
{
 os_error * err;
 int        y;
 int        ypix;
 int        sxpix;
 int        bpp;
 double     new0;
 int        intnew0;

 char       rtab[256];
 char       gtab[256];
 char       btab[256];
 int        grey;
 int        size;

 err=NULL;

 bpp=sim->bpp;

 grey=imgrey(sim);

 if(bpp<=8)
 {
  imsplitpalette(rtab,gtab,btab,sim);

  if(grey)
  {
   err=makegmap(sim->ipal.ncolours,sim->ipal.word,gtab,&size);
   if(size<2) grey=0;
  }

  if(!grey) err=makecmap(sim->ipal.ncolours,sim->ipal.word,4,rgbmap);
 }

 if(err) return(err);

 ypix=sim->ypix;
 sxpix=sim->xpix;

 err=flex_alloc((flex_ptr)&rl,sxpix+1);
 if(!err)
 {
  err=flex_alloc((flex_ptr)&gl,sxpix+1);
  if(!err)
  {
   err=flex_alloc((flex_ptr)&bl,sxpix+1);
   if(!err)
   {
    for(y=0;y<ypix;y++)
    {
     err=longproctick2(y,ypix);
     if(err) break;

     if(fangle>0.0) new0=((double)y)*shearfac;
     else           new0=((double)ypix-(double)y)*shearfac;
     intnew0=(int)new0;

     imget(sim,y,rtab,gtab,btab);
     if(filtertype) shearxline(sxpix,new0,intnew0);

     imput(dim,y,intnew0,intnew0+sxpix,junk,grey,gtab);
    }
    err=flex_free((flex_ptr)&bl);
   }
   err=flex_free((flex_ptr)&gl);
  }
  err=flex_free((flex_ptr)&rl);
 }
 return(err);
}



static os_error * shearxf(ximagestr * sxim,ximagestr ** dximp,
                                     double fangle,double shearfac,int junk)
{
 os_error * err;
 int        rows;
 int        cols;
 int        newcols;
 imagestr * dim;
 imagestr * sim;
 imagestr * mim;
 imagestr * cim;
 int        i;

 sim=(sxim->sim[IM]);
 mim=(sxim->sim[AL]);

 rows=sim->ypix;
 cols=sim->xpix;

 newcols=(int)(rows*shearfac+cols+0.999999)-2*junk;

 err=ximnew2(newcols,rows,sim->bpp,mim?mim->bpp:0,dximp);
 if(!err)
 {
  for(i=0;i<2;i++)
  {
   if(i==1)
   {
    if(mim==NULL) break;
    setbackground(tmask,tmask,tmask);
    dim=((*dximp)->sim[AL]);
    cim=mim;
   }
   else
   {
    setbackground(rback,gback,bback);
    dim=((*dximp)->sim[IM]);
    cim=sim;
    cmscopyprofile(dim,sim);
   }

   dim->xdpi=cim->xdpi;
   dim->ydpi=cim->ydpi;
   dim->ipal=cim->ipal;
   dim->tr=cim->tr;

   err=shearxs(cim,dim,fangle,shearfac,junk);
   if(err) break;
  }

  ximtrash(&sxim);
 }
 return(err);
}



os_error * shearx(ximagestr * sxim,ximagestr ** dximp,int angle)
{
 os_error * err;
 double     fangle; 
 double     shearfac;

 fangle=(((double)angle)/((double)0x10000));
 if(fangle<=-90.0 || fangle>=90.0 || angle==0) 
 {
  *dximp=sxim;        /* !!!! */
  return(NULL);
 }
 fangle=(fangle*PI)/180.0;
 shearfac=tan(fangle);
 if(shearfac<0.0) shearfac=-shearfac;

 err=shearxf(sxim,dximp,fangle,shearfac,0);

 return(err);
}



static os_error * shearyf(ximagestr * sxim,ximagestr ** dximp,
                                    double fangle,double shearfac,int junk)
{
 os_error * err;

 err=rotimagep90(sxim,dximp);
 if(!err)
 {
  sxim=*dximp;
  err=shearxf(sxim,dximp,fangle,shearfac,junk);
  if(!err)
  {
   sxim=*dximp;
   err=rotimagem90(sxim,dximp);
  }
 }
 return(err);
}



os_error * sheary(ximagestr * sxim,ximagestr ** dximp,int angle)
{
 os_error * err;
 double     fangle; 
 double     shearfac;

 fangle=(((double)angle)/((double)0x10000));
 if(fangle<=-90.0 || fangle>=90.0 || angle==0) 
 {
  *dximp=sxim;
  return(NULL);
 }

 fangle=(fangle*PI)/180.0;
 shearfac=tan(fangle);
 if(shearfac<0.0) shearfac=-shearfac;

 err=shearyf(sxim,dximp,fangle,shearfac,0);

 return(err);
}



os_error * rotate(ximagestr * sxim,ximagestr ** dximp,int angle)
{
 os_error * err;
 double     fangle; 
 double     xshearfac;
 double     yshearfac;
 int        rows;
 int        cols;
 int        tempcols;
 int        yshearjunk;
 int        x2shearjunk;
 int        newrows;
 imagestr * sim;


 while(angle>=( 360*0x10000)) angle-=(360*0x10000);
 while(angle<=(-360*0x10000)) angle+=(360*0x10000);

 if(angle==(   0        ))
 {
  *dximp=sxim;
  return(NULL);
 }
 if(angle==(  90*0x10000))  return(rotimagep90(sxim,dximp));
 if(angle==( -90*0x10000))  return(rotimagem90(sxim,dximp));
 if(angle==( 180*0x10000))  return(rotimage180(sxim,dximp));
 if(angle==(-180*0x10000))  return(rotimage180(sxim,dximp));

 if(angle>(90*0x10000))
 {
  rotimage180(sxim,dximp);
  sxim=*dximp;
  angle-=(180*0x10000);
 }

 if(angle<(-90*0x10000))
 {
  rotimage180(sxim,dximp);
  sxim=*dximp;
  angle+=(180*0x10000);
 }

 if(angle>( 45*0x10000))
 {
  rotimagep90(sxim,dximp);
  sxim=*dximp;
  angle-=(90*0x10000);
 }

 if(angle<(-45*0x10000))
 {
  rotimagem90(sxim,dximp);
  sxim=*dximp;
  angle+=(90*0x10000);
 }


 fangle=(((double)angle)/((double)0x10000));
 if(fangle<=-90.0 || fangle>=90.0) return(NULL);
 fangle=(fangle*PI)/180.0;

 xshearfac=tan(fangle/2.0);
 if(xshearfac<0.0) xshearfac=-xshearfac;

 yshearfac=sin(fangle);
 if(yshearfac<0.0) yshearfac=-yshearfac;

 sim=(sxim->sim[IM]);

 cols=sim->xpix;
 rows=sim->ypix;

 tempcols=(int)(rows*xshearfac+cols+0.999999);
 yshearjunk=(int)(((double)tempcols-(double)cols)*yshearfac);
 newrows=(int)(tempcols*yshearfac+rows+0.999999);
 x2shearjunk=
         (int)(((double)newrows-(double)rows-(double)yshearjunk)*xshearfac);

 err=shearxf(sxim,dximp,fangle,xshearfac,0);
 if(!err)
 {
  sxim=*dximp;
  err=shearyf(sxim,dximp,fangle,yshearfac,yshearjunk);
  if(!err)
  {
   sxim=*dximp;
   err=shearxf(sxim,dximp,fangle,xshearfac,x2shearjunk);
  }
 }
 return(err);
}



/*****************************************************************************/


os_error * extendim(ximagestr * sxim,ximagestr ** dximp,boxstr * area)
{
 os_error * err;
 int        y;
 int        sypix;
 int        dypix;
 int        sxpix;
 int        dxpix;
 int        bpp;
 imagestr * dim;
 imagestr * sim;
 imagestr * mim;
 imagestr * cim;

 char       rtab[256];
 char       gtab[256];
 char       btab[256];

 int        grey;
 int        size;
 int        i;



 err=NULL;

 sim=(sxim->sim[IM]);
 mim=(sxim->sim[AL]);


 sypix=sim->ypix;
 sxpix=sim->xpix;
 dxpix=area->w;
 dypix=area->h;

 err=ximnew2(dxpix,dypix,sim->bpp,mim?mim->bpp:0,dximp);
 if(!err)
 {
  for(i=0;i<2;i++)
  {
   if(i==1)
   {
    if(mim==NULL) break;
    dim=((*dximp)->sim[AL]);
    cim=mim;
    setbackground(tmask,tmask,tmask);
   }
   else
   {
    dim=((*dximp)->sim[IM]);
    cim=sim;
    setbackground(rback,gback,bback);
    cmscopyprofile(dim,sim);
   }


   bpp=cim->bpp;
   grey=imgrey(cim);


   if(bpp<=8)
   {
    imsplitpalette(rtab,gtab,btab,cim);

    if(grey)
    {
     err=makegmap(cim->ipal.ncolours,cim->ipal.word,gtab,&size);
     if(size<2) grey=0;
    }

    if(!grey) err=makecmap(cim->ipal.ncolours,cim->ipal.word,4,rgbmap);
   }

   if(err) break;


   dim->xdpi=cim->xdpi;
   dim->ydpi=cim->ydpi;
   dim->ipal=cim->ipal;
   dim->tr=cim->tr;

   err=flex_alloc((flex_ptr)&rl,sxpix+1);
   if(!err)
   {
    err=flex_alloc((flex_ptr)&gl,sxpix+1);
    if(!err)
    {
     err=flex_alloc((flex_ptr)&bl,sxpix+1);
     if(!err)
     {
      for(y=0;y<-area->y;y++) 
      {
       imput(dim,y,dxpix,dxpix,0,grey,gtab);
       err=longproctick();
       if(err) break;
      }

      if(!err)
      {
       for(;y<(sypix-area->y);y++)
       {
        imget(cim,y+area->y,rtab,gtab,btab);
        imput(dim,y,-area->x,-area->x+sxpix,0,grey,gtab);
        err=longproctick();
        if(err) break;
       }
      }

      if(!err)
      {
       for(;y<dypix;y++)
       {
        imput(dim,y,dxpix,dxpix,0,grey,gtab);
        err=longproctick();
        if(err) break;
       }
      }

      err=flex_free((flex_ptr)&bl);
     }
     err=flex_free((flex_ptr)&gl);
    }
    err=flex_free((flex_ptr)&rl);
   }
   if(err) break;
  }
 }
 return(err);
}

