/*->c.asprite */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <ctype.h>

#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "wos.h"
#include "flex.h"
#include "transform.h"
#include "xprocess.h"


#include "err.h"
#include "filetype.h"
#include "fsx.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "alloc.h"
#include "trans.h"
#include "etc.h"
#include "bf.h"
#include "dbhi.h"
#include "key.h"
#include "config.h"
#include "pane.h"
#include "colour.h"
#include "deb.h"
#include "mlo.h"

#include "units.h"

#include "constants.h"
#include "str.h"
#include "reslink.h"

#include "view.h"
#include "file.h"
#include "im.h"
#include "info.h"
#include "format.h"
#include "mask.h"
#include "cms.h"

#include "asprite.h"



/*

  type 1  1bpp image 1bpp mask
       2  2bpp
       3  4bpp
       4  8bpp
       5  16bpp
       6  32bpp
       7  CMYK
       8  24bpp

  palette not supported by RISC OS 3.50, but is by 3.60


*/





extern ftypestr ftype;
extern dboxstr  configbox;


static int bppmap[11]={0,1,2,4,8,16,32,32,24,32,16};

static int      deepsprites;  // if false force anything over 8bpp to 8bpp
static int      newformat;    // force to 1bpp mask for all bpp




typedef struct xmodestr
{
 int mode;
 int dx;
 int dy;
 int bpp;
 int mask;
} xmodestr;



static xmodestr * modes;
static int        moden;

#define MODECHUNK (16*sizeof(xmodestr))


static char * path="<HKEY_LOCAL_MACHINE\\Software\\DavidPilling\\DPScan\\>\\modes.txt";


static os_error * loadmodes(void)
{
 os_error  * err;
 int         eof;
 char        string[256];
 buffer      bf;
 int         type;

 err=fs_exists(path,&type);
 if(!err && type==1)
 {
  err=flex_alloc((flex_ptr)&modes,MODECHUNK);

  if(!err) err=bf_open(path,'r',DEFBUFFSIZE,&bf);
  if(!err)
  {
   eof=0;

   while(!eof)
   {
    err=bf_getstring(&bf,string,sizeof(string),&eof);
    if(err) break;

    if(string[0]=='/' || string[0]==0) continue; /* !!! */

    flex_chunk((flex_ptr)&modes,(moden+1)*sizeof(xmodestr),MODECHUNK);


    if(sscanf(string,"%d %d %d %d %x",
              &modes[moden].mode,
              &modes[moden].dx,
              &modes[moden].dy,
              &modes[moden].bpp,
              &modes[moden].mask)==5) moden++;
   }
   err=bf_close(&bf,err);
  }
 }

 return(err);
}



static os_error * missingmode(int mode,int * spdx,int * spdy,
                                                  int * spbpp,int * spbitmask)
{
 int i;

 for(i=0;i<moden;i++)
 {
  if(modes[i].mode==mode)
  {
   *spdx=modes[i].dx;
   *spdy=modes[i].dy;
   *spbpp=modes[i].bpp;
   *spbitmask=modes[i].mask;
   return(NULL);
  }
 }

 return(geterror(EMODE));
}



static os_error * getinfo(framestr * frame,newsprite_header * sph)
{
 char   string[256];
 char * p;
 int    palentries;

 palentries=(sph->image-sizeof(sprite_header))/8;
 p=string;


 p+=sprintf(p,"Acorn sprite file - \"%s\"\n",frame->name);
 p+=sprintf(p,"%d x %d pixels, %d bpp\n",frame->fxpix,frame->fypix,
                                                      frame->fbpp);

 if(sph->selector.type.type)
 {
  p+=sprintf(p,"Type %d. Palette entries %d\n",sph->selector.type.type,palentries);
 }
 else
 {
  p+=sprintf(p,"Mode %d. Palette entries %d\n",sph->selector.mode,palentries);
 }

	if(sph->selector.type.alpha)
	{
  p+=sprintf(p,"Alpha %s. Palette %s.",sph->image!=sph->mask?"Yes":"No",palentries?"Yes":"No");
	}
	else
	{
  p+=sprintf(p,"Mask %s. Palette %s.",sph->image!=sph->mask?"Yes":"No",palentries?"Yes":"No");
	}

 return(infowrite(string,frame));
}


static os_error * getpal(buffer * bf,imagestr * im,newsprite_header * sph)
{
 os_error * err;
 int        palentries;
 int        paltab[257];
 int        i;
 int        c1;

 err=NULL;


 palentries=(sph->image-sizeof(sprite_header))/8;
 if(palentries<0) palentries = 0;

 if(palentries==0)
 {
  if(im->bpp>8)
  {
   im->ipal.ncolours=0;
   memset(&im->ipal,0,sizeof(ipalstr));
   im->ipal.palclass=(sph->selector.type.type==7)?CL_CMYK:CL_RGB;
   return(err);
  }

  /* if there is no palette, we'd like it to look like wimp cols */

  if(im->bpp==8)
  {
   palentries=16;
   paltab[0]=0x0;
   paltab[1]=0x10101000;
   paltab[2]=0x20202000;
   paltab[3]=0x30303000;
   paltab[4]=0x4000;
   paltab[5]=0x10105000;
   paltab[6]=0x20206000;
   paltab[7]=0x30307000;
   paltab[8]=0x40000000;
   paltab[9]=0x50101000;
   paltab[10]=0x60202000;
   paltab[11]=0x70303000;
   paltab[12]=0x40004000;
   paltab[13]=0x50105000;
   paltab[14]=0x60206000;
   paltab[15]=0x70307000;
   palentries=16;
  }
  else
  if(im->bpp==4)
  {
   paltab[0]=0xffffff00;
   paltab[1]=0xdddddd00;
   paltab[2]=0xbbbbbb00;
   paltab[3]=0x99999900;
   paltab[4]=0x77777700;
   paltab[5]=0x55555500;
   paltab[6]=0x33333300;
   paltab[7]=0x00000000;
   paltab[8]=0x99440000;
   paltab[9]=0x00eeee00;
   paltab[10]=0x00cc0000;
   paltab[11]=0x0000dd00;
   paltab[12]=0xbbeeee00;
   paltab[13]=0x00885500;
   paltab[14]=0x00bbff00;
   paltab[15]=0xffbb0000;
   palentries=16;
  }
  else
  if(im->bpp==2)
  {
   paltab[0]=0xffffff00;
   paltab[1]=0xdddddd00;
   paltab[2]=0x99999900;
   paltab[3]=0x00000000;
   palentries=4;
  }
  else
  if(im->bpp==1)
  {
   paltab[0]=0xffffff00;
   paltab[1]=0x00000000;
   palentries=2;
  }
 }
 else
 {
  for(i=0;i<palentries;i++)
  {
   if(i<256) bf_read(bf,paltab+i,2*sizeof(int));
   else      bf_read(bf,paltab+256,2*sizeof(int));
  }
 }

 if(im->bpp==8 && (palentries==64 || palentries==16))
 {

  if(palentries==64)
  {
   for(i=0;i<16;i++) paltab[i]=paltab[i+48];
  }

  for(i=255;i>=0;i--)
  {
   c1=paltab[(i & 0xF)];

   if(i & 0x10) c1|=0x8000;
   else         c1&=~0x8000;

   if(i & 0x20) c1|=0x400000;
   else         c1&=~0x400000;

   if(i & 0x40) c1|=0x800000;
   else         c1&=~0x800000;

   if(i & 0x80) c1|=0x80000000;
   else         c1&=~0x80000000;

   c1&=0xF0F0F000;
   c1|=(c1>>4)&0xF0F0F00;

   paltab[i]=c1;
  }
  palentries=256;
 }

 im->ipal.ncolours=palentries;
 for(i=0;i<palentries;i++) im->ipal.word[i]=paltab[i];

 return(err);
}





os_error * spreadhdr(int fn,buffer * bf,newsprite_header * sph)
{
 os_error * err;
 char     * p;
 char     * q;
 int        spdx;
 int        spdy;
 int        spbpp;
 int        spbitmask;
 int        bitwidth;
 int        xdpi;
 int        ydpi;
 int        xpix;
 int        ypix;

 err=NULL;

 /* nb name is not zero terminated */

 if(sph->selector.type.type)  /* it is a new sprite */
 {
  xdpi=sph->selector.type.xdpi;
  ydpi=sph->selector.type.ydpi;
  spbpp=bppmap[sph->selector.type.type];

 /* dprintf(0,"xdpi=%d ydpi=%d bpp=%d type=%d",
             sph->selector.type.xdpi,sph->selector.type.ydpi,
             spbpp,sph->selector.type.type); */

  bitwidth=32*(sph->width+1)-(31-sph->rbit);
  xpix=bitwidth/spbpp;
  ypix=sph->height+1;
 }
 else
 {
  err=missingmode(sph->selector.mode.mode,&spdx,&spdy,&spbpp,&spbitmask);
  if(err)
  {
   err=getdeltas(sph->selector.mode.mode,&spdx,&spdy);
   if(!err)
   {
    getbpp(sph->selector.mode.mode,&spbpp,&spbitmask);
//    spbpp=(1<<spbpp);
   }
  }

  bitwidth=32*(sph->width+1)-sph->lbit-(31-sph->rbit);

  xpix=bitwidth/spbpp;
  ypix=sph->height+1;

  xdpi=180/spdx;
  ydpi=180/spdy;
 }

 p=sph->name;
 q=loadfile->frames[fn].name;
 while(*p>=32) *q++=*p++;
 *q=0;


 loadfile->frames[fn].fbpp=spbpp;
 loadfile->frames[fn].fxdpi=xdpi;
 loadfile->frames[fn].fydpi=ydpi;
 loadfile->frames[fn].fxpix=xpix;
 loadfile->frames[fn].fypix=ypix;

 return(err);
 USE(bf);
}





os_error * sploadframe(filestr * file,buffer * bf,
                                                newsprite_header * sph,int fn)
{
 os_error * err;
 imagestr * loadimage;
 int        y;
 int      * idata;
 int        mbpp;
 int        mask;
 int        mwidth;
 int      * buff;



 if(sph->mask!=sph->image)
 {
  if(sph->selector.type.type)
  {
 		mbpp=1;
   mwidth=((file->frames[fn].fxpix+0x1F) & (~0x1F))/8;
  }
  else
  {
   mbpp=file->frames[fn].fbpp;
   mwidth=(sph->width+1)*sizeof(int);
  }

  if(sph->selector.mode.alpha)
  {
   mbpp=8;
			mwidth=((file->frames[fn].fxpix+3) & (~3));
		}

		cprintf("alpha %d mode %x",sph->selector.mode.alpha,sph->selector.mode.mode);
 }
 else
 {
  mbpp=mwidth=0;
 }


 err=bf_tell(bf,&mask);
 mask-=sizeof(sprite_header);
 mask+=sph->mask;


 err=ximnew2(file->frames[fn].fxpix,file->frames[fn].fypix,
            file->frames[fn].fbpp,(mbpp>0)?1:0,&file->frames[fn].xim);
 if(!err)
 {
  loadimage=((file->frames[fn].xim)->sim[IM]);
  loadimage->xdpi=file->frames[fn].fxdpi;
  loadimage->ydpi=file->frames[fn].fydpi;

/*
dprintf(1,"ld=%x fn=%d file=%d xim=%d",loadimage,fn,file,(file->frames[fn].xim));
*/

  getpal(bf,loadimage,sph);

  if(loadimage->ipal.palclass==CL_CMYK)
  { 
   cmscmykprofile(&loadimage->profile);
  }
  else
  {
   cmsrgbprofile(&loadimage->profile);
  }

  getinfo(&file->frames[fn],sph);

  cprintf("lbt %d rbit %d image=%d",sph->lbit,sph->rbit,sph->image);


  for(y=0;y<file->frames[fn].fypix;y++)
  {
   err=imfind1w(loadimage,y,&idata);
   if(err) break;
   err=bf_read(bf,idata,(sph->width+1)*sizeof(int));
   if(err) break;
   if(sph->lbit) shiftline(idata,file->frames[fn].fxpix,
                                 file->frames[fn].fbpp,sph->lbit);

			if(sph->selector.type.type==10)
			{
				unsigned short int * p;
				int x;
				unsigned int w,r,g,b;

				p=(unsigned short int *)idata;

				for(x=0;x<file->frames[fn].fxpix;x++)
				{
					w=*p;
					r=w & 0x1F;
					g=(w>>5)	& 0x1F;
					b=(w>>11) & 0x1F;

					*p=r | (g<<5) | (b<<10);
					p++;
				}

			}
  }

  if(mbpp)
  {
   bf_seek(bf,mask);

   loadimage=((file->frames[fn].xim)->sim[AL]);

   imsetgreypal(loadimage,1);

   if(mbpp==1)
   {
    for(y=0;y<file->frames[fn].fypix;y++)
    {
     err=imfind1w(loadimage,y,&idata);
     if(err) break;
     err=bf_read(bf,idata,mwidth);
     if(err) break;
     if(sph->lbit) shiftline(idata,file->frames[fn].fxpix,1,sph->lbit);
    }
   }
   else
   if(mbpp!=0)
   {
    bf_seek(bf,mask);

    err=flex_alloc((flex_ptr)&buff,mwidth);
    if(!err)
    {
     for(y=0;y<file->frames[fn].fypix;y++)
     {
      err=bf_read(bf,buff,mwidth);
      if(err) break;

      if(sph->lbit) shiftline(buff,file->frames[fn].fxpix,mbpp,sph->lbit);

      err=imfind1w(loadimage,y,&idata);
      if(err) break;

      maskcut(buff,mbpp,idata,1,file->frames[fn].fxpix);
     }
     flex_free((flex_ptr)&buff);
    }
   }
  }
 }
 return(err);
}



static os_error *loadasprite(char * name,int type,uservalue userhandle,int xvolatile)
{
 os_error    * err;
 buffer        bf;
 sprite_area   spa;
 newsprite_header sph;
 int           i;
 int           next;
 int           fn;

 err=bf_open(name,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
  err=bf_read(&bf,&spa.number,sizeof(sprite_area)-sizeof(int));
  if(!err) err=bf_seek(&bf,spa.sproff-sizeof(int));
  if(!err)
  {
   for(i=0;i<spa.number;i++)
   {
    err=bf_tell(&bf,&next);
    if(err) break;

    err=bf_read(&bf,&sph,sizeof(sprite_header));
    if(err) break;

    err=addframe(loadfile,&fn,0);
    if(err) break;

    loadfile->frames[fn].offset=next;
    loadfile->frames[fn].xim=NULL;
    next+=sph.next;

    err=spreadhdr(fn,&bf,&sph);
    if(err) break;

    if(i==0)
    {
     err=sploadframe(loadfile,&bf,&sph,fn);
     if(err) break;
    }

    err=bf_seek(&bf,next);
    if(err) break;
   }
  }
  err=bf_close(&bf,err);
 }


 return(err);

 USE(type);
 USE(userhandle);
 USE(xvolatile);
}




static os_error * getframe(filestr * file,int fn)
{
 os_error    * err;
 buffer        bf;
 newsprite_header sph;

 err=bf_open(file->oname,'r',DEFBUFFSIZE,&bf);
 if(!err)
 {
           err=bf_seek(&bf,file->frames[fn].offset);
  if(!err) err=bf_read(&bf,&sph,sizeof(newsprite_header));
  if(!err) err=spreadhdr(fn,&bf,&sph);
  if(!err) err=sploadframe(loadfile,&bf,&sph,fn);

  err=bf_close(&bf,err);
 }
 return(err);
}



static os_error * loadfilepost(uservalue userhandle)
{
 os_error    * err;

 err=NULL;
 return(err);
 USE(userhandle);
}

static int rpixmode[4]=
{
 0,4,12,15,
};

static int spixmode[4]=
{
 25,26,27,28,
};

static int getspmode(int bpp,int palclass,int xres,int yres,int newformat)
{
 int mode;
 int index;

 if(bpp<=8 && !newformat)
 {
  if(bpp==8) index=3;
  else
  if(bpp==4) index=2;
  else
  if(bpp==2) index=1;
  else       index=0;

  if(yres>=xres) mode=spixmode[index];  /* square */
  else           mode=rpixmode[index];
 }
 else
 {
  mode=1;

  if(xres==yres)
  {
   if(xres<=45)  mode|=(45<<1)|(45<<14);
   else
   if(xres>=180) mode|=(180<<1)|(180<<14);
   else          mode|=(90<<1)|(90<<14);
  }
  else
  {
   if(yres>xres) mode|=(90<<1)|(90<<14);
   else          mode|=(90<<1)|(45<<14);
  }

  if(bpp==1)  mode|=(1<<27);
  else
  if(bpp==2)  mode|=(2<<27);
  else
  if(bpp==4)  mode|=(3<<27);
  else
  if(bpp==8)  mode|=(4<<27);
  else
  if(bpp==16) mode|=(5<<27);
  else
  {
   if(palclass==CL_CMYK) mode|=(7<<27);
   else                  mode|=(6<<27);
  }
 }
 return(mode);
}



static os_error * saveinfo(int * len)
{
 int fn;
 int xpix;
 int ypix;
 int sbpp;
 int dbpp;
 int palsize;
 int dwwidth;
 imagestr  * saveimage;

 fn=menuview->frame;
 saveimage=((menufile->frames[fn].xim)->sim[IM]);

 xpix=saveimage->xpix;
 ypix=saveimage->ypix;
 sbpp=saveimage->bpp;

 if(sbpp==24) dbpp=32;
 else         dbpp=sbpp;

 if(sbpp<=8) palsize=(1<<sbpp)*2*sizeof(int);
 else        palsize=0;

 dwwidth=((dbpp*xpix+0x1F)&(~0x1F))/32;

 *len=sizeof(sprite_area)+sizeof(sprite_header)+palsize+
                                             dwwidth*ypix*sizeof(int);
 return(NULL);
}




#define DRAWW 16

static void dummysprite(int *buff,int size,int xpix,int ypix,int xdpi,int ydpi)
{
 char * p;
 char * q;
 int    xhi;
 int    yhi;


 xhi=(xpix*256*180)/xdpi;                         /* draw units */
 yhi=(ypix*256*180)/ydpi;

 strcpy((char *)buff,"Draw");
 *(buff+1)=201;
 *(buff+2)=0;
 p=(char*)(buff+3);
 q=p+12;
 strcpy(p,"DPScan");
 p+=strlen(p);
 for(;p<q;p++) *p=32;

 *(buff+6)=0;
 *(buff+7)=0;
 *(buff+8)=xhi;
 *(buff+9)=yhi;

 *(buff+10)=5;
 *(buff+11)=size;

 *(buff+12)=0;
 *(buff+13)=0;
 *(buff+14)=xhi;
 *(buff+15)=yhi;
}







os_error * savespritesub(char * name,int type,int draw)
{
 os_error  * err;
 buffer      bf;
 int         xpix;
 int         ypix;
 int         sbpp;
 int         dbpp;
 int         fn;
 int       * idata;
 imagestr  * saveimage;
 imagestr  * sim;
 imagestr  * mim;
 int         x;
 int         y;
 sprite_header sph;
 sprite_area   spa;
 char      * p;
 char      * q;
 int         i;
 int         palsize;
 int       * buff;
 int         dwwidth;
 int         tempimage;
 int         buffer[DRAWW];
 int         mbpp;
 int         msbpp;
 int         imsize;
 int         mwwidth;
 int         masksize;



 fn=menuview->frame;
 saveimage=sim=((menufile->frames[fn].xim)->sim[IM]);
           mim=((menufile->frames[fn].xim)->sim[AL]);

 tempimage=0;

 if(saveimage->bpp>8 && !deepsprites)
 {
  tempimage=1;
  err=imnew(sim->xpix,sim->ypix,8,&saveimage);
  if(!err)
  {
   saveimage->xdpi=sim->xdpi;
   saveimage->ydpi=sim->ydpi;

   saveimage->ipal=sim->ipal;   /* !!!! */

   saveimage->tr=sim->tr;

   cmscopyprofile(saveimage,sim);

   imospal(saveimage); /* give it the OS pal */

   err=reformat(&cformat,sim,saveimage);
  }
 }

 xpix=saveimage->xpix;
 ypix=saveimage->ypix;
 sbpp=saveimage->bpp;

 if(sbpp==24) dbpp=32;
 else         dbpp=sbpp;


 if(sbpp>32)
 {
  err=geterror(EBADBITS);

 }
 else
 {
  err=bf_open(name,'w',DEFBUFFSIZE,&bf);
  if(!err)
  {
   if(sbpp<=8) palsize=(1<<sbpp)*2*sizeof(int);
   else        palsize=0;


   dwwidth=((dbpp*xpix+0x1F)&(~0x1F))/32;

   imsize=dwwidth*ypix*sizeof(int);

   if(mim)
   {
    msbpp=mim->bpp;

    if(sbpp<=8 && !newformat) 
    {
     masksize=imsize;
     mwwidth=dwwidth;
     mbpp=sbpp;
    }
    else
    {
     mbpp=1;
     mwwidth=((mbpp*xpix+0x1F)&(~0x1F))/32;
     masksize=mwwidth*ypix*sizeof(int);
    }
   }
   else
   {
    masksize=mwwidth=mbpp=msbpp=0;
   }

   spa.number=1;
   spa.sproff=sizeof(sprite_area);
   spa.freeoff=sizeof(sprite_area)+
                      sizeof(sprite_header)+palsize+imsize+masksize;

   sph.next=sizeof(sprite_header)+palsize+imsize+masksize;

   p=sph.name;
   memset(p,0,sizeof(sph.name));
   q=menufile->frames[fn].name;
   while((*p++=(char)tolower(*q++))!=0);

   sph.width=dwwidth-1;
   sph.height=saveimage->ypix-1;
   sph.lbit=0;
   sph.rbit=(xpix*(dbpp)-1) % 32;
   sph.image=sizeof(sprite_header)+palsize;
   sph.mask=sph.image;
   if(mim) sph.mask+=imsize;
   sph.mode=getspmode(dbpp,saveimage->ipal.palclass,
                           saveimage->xdpi,saveimage->ydpi,newformat);


   dummysprite(buffer,sph.next+24,saveimage->xpix,saveimage->ypix,
                             saveimage->xdpi,saveimage->ydpi);

   if(draw) bf_write(&bf,buffer,DRAWW*sizeof(int));
   else     bf_write(&bf,&spa.number,sizeof(sprite_area)-sizeof(int));

   bf_write(&bf,&sph,sizeof(sprite_header));


   if(palsize)
   {
    for(i=0;i<(1<<dbpp);i++)
    {
     if(i<saveimage->ipal.ncolours)
     {
      bf_puti(&bf,saveimage->ipal.word[i]);
      bf_puti(&bf,saveimage->ipal.word[i]);
     }
     else
     {
      bf_puti(&bf,0);
      bf_puti(&bf,0);
     }
    }
   }


   if(sbpp==24)
   {
    err=flex_alloc((flex_ptr)&buff,dwwidth*sizeof(int));
    if(!err)
    {
     for(y=0;y<ypix;y++)
     {
      err=imfind1r(saveimage,y,&idata);
      if(err) break;
      p=(char*)idata;
      q=(char*)buff;
      for(x=0;x<xpix;x++)
      {
       *q++=*p++;
       *q++=*p++;
       *q++=*p++;
       *q++=0;
      }
      err=bf_write(&bf,buff,dwwidth*sizeof(int));
      if(err) break;
     }
     flex_free((flex_ptr)&buff);
    }
   }
   else
   {
    for(y=0;y<ypix;y++)
    {
     err=imfind1r(saveimage,y,&idata);
     if(err) break;
     err=bf_write(&bf,idata,dwwidth*sizeof(int));
     if(err) break;
    }
   }


   if(!err)
   {
    if(mim)
    {
     if(mbpp!=msbpp)
     {
      err=flex_alloc((flex_ptr)&buff,mwwidth*sizeof(int));
      if(!err)
      {
       for(y=0;y<ypix;y++)
       {
        err=imfind1r(mim,y,&idata);
        if(err) break;

        maskcut(idata,msbpp,buff,mbpp,xpix);

        err=bf_write(&bf,buff,mwwidth*sizeof(int));
        if(err) break;
       }
       flex_free((flex_ptr)&buff);
      }
     }
     else
     {
      for(y=0;y<ypix;y++)
      {
       err=imfind1r(mim,y,&idata);
       if(err) break;
       err=bf_write(&bf,idata,mwwidth*sizeof(int));
       if(err) break;
      }
     }
    }
   }


   err=bf_closec(&bf,err,name,type);

   if(tempimage) imtrash(&saveimage);
  }
 }
 return(err);
}



static os_error * savesprite(char * name,int type)
{
 return(savespritesub(name,type,0));
}



/*****************************************************************************/

static int tdbl;
static int dbl;



static int bits(int xcase)
{
 if(xcase==FAUTORUN) return(dbl);

 return(0);
}




static os_error * configloaded(int eventn,uservalue userhandle,void * data,int data1)
{

 if(eventn==EVENT_CONFIGLOADED)
 {
  dbl=ftypegetrun(&ftype);

//  if(dbl) docaddruntype(ftype.type);
 }

 return(NULL);

 USE(eventn);
 USE(userhandle);
 USE(data);
 USE(data1);
}



static os_error * configclose(int code)
{
 os_error * err;

 err=NULL;

 if(code==DBOK || code==DBAPPLY)
 {
  if(dbl!=tdbl)
  {
//   if(tdbl) docaddruntype(ftype.type);
//   else     docremruntype(ftype.type);
   dbl=tdbl;
  }
  dbl=tdbl;
 }

 return(err);
}



/*****************************************************************************/



static os_error * configicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

 switch(m->i)
 {
  case 20:
          err=ftypemenu(&ftype,handle,&configbox,&tdbl);
          break;

 }


 return(err);

 USE(userhandle);
 USE(handle);
}



static os_error * wrdbl(int value,char * string)
{
 ftypewr(value,string,&ftype);
 return(NULL);
}




static os_error * wrm(int value,char * string)
{
 strcpy(string,numbertostring(value));
 return(NULL);
}


static os_error * rdm(int * value,char * string)
{
 os_error * err;
 err=stringtonumber(string,value);
 return(err);
}


static dbiconstr configicondefs[]=
{
 /* N   &V           Type     Grp   Flags   R   L   D   U     In    Out */

 /* N   &V           Type     Grp   Flags   Act Key -  -       Clickfn 0 */

    1, NULL,         DBACTION, 0,   0,      DBOK,RETURN,0,0,     NULL ,0,
    2, NULL,         DBACTION, 0,   0,      DBCANCEL,ESCAPE,0,0 ,NULL ,0,
   22, &tdbl,        DBTEXT,   0,   0,      1, F1,  0, 0, NULL, wrdbl,
   18,&deepsprites, DBTOGGLE, 0,   0,      1, F2,  0, 0, NULL, 0,
   19,&newformat,   DBTOGGLE, 0,   0,      1, F3,  0, 0, NULL, 0,
    6, &spixmode[0], DBWRITE,  0,   0,     11, -1, 14,-1,  rdm,  wrm,
   11, &spixmode[1], DBWRITE,  0,   0,     12,  6, 15,-1,  rdm,  wrm,
   12, &spixmode[2], DBWRITE,  0,   0,     13, 11, 16,-1,  rdm,  wrm,
   13, &spixmode[3], DBWRITE,  0,   0,     14, 12, 17,-1,  rdm,  wrm,

   14, &rpixmode[0], DBWRITE,  0,   0,     15, 13, -1, 6,  rdm,  wrm,
   15, &rpixmode[1], DBWRITE,  0,   0,     16, 14, -1,11,  rdm,  wrm,
   16, &rpixmode[2], DBWRITE,  0,   0,     17, 15, -1,12,  rdm,  wrm,
   17, &rpixmode[3], DBWRITE,  0,   0,     -1, 16, -1,13,  rdm,  wrm,

   -1, NULL,         0,       0,    0,      0,  0,  0,  0,  0,      0,
};




static dboxstr configbox=
{
 0,
 TSPRITE,
 DBFIX,
 0,
 configclose,
 configicon,
 NULL,
 NULL,
 configicondefs,
 0,
 0,

 0,
 NULL,
 NULL,
 0,

};


static os_error * config(wimp_w parent)
{
 os_error * err;

 if(configbox.handle) err=dbclose(&configbox,DBCANCEL);
 
 tdbl=dbl;
 err=dodboxparent(&configbox,1,parent);

 return(err);
}

/*****************************************************************************/

static ftypestr ftype=
{
 SPRITE,          /* file type */
 0,               /* flags     */
 loadasprite,     /* load      */
 loadfilepost,    /* loadpost  */
 "{SPRITE}",      /* name      */
 "{SPRITE}",      /* type name */
 savesprite,      /* save      */
 config,          /* config    */
 0,               /* icon number */
 bits,            /* flag bits   */
 getframe,        /* get one frame */
 "",              /* real name  */
 "",              /* file sp    */
 saveinfo,        /* save info function */

 NULL,            /* saveim */
 "spr\0""ff9\0",  /* extension */

 "RISC OS/Acorn Sprite (*.spr)",/* description*/
};


static contag contable[]=
{
// "Autorun",CONINT,&dbl,NULL,NULL,

 "Sq1bpp",CONINT,&spixmode[0],NULL,NULL,
 "Sq2bpp",CONINT,&spixmode[1],NULL,NULL,
 "Sq4bpp",CONINT,&spixmode[2],NULL,NULL,
 "Sq8bpp",CONINT,&spixmode[3],NULL,NULL,

 "Rc1bpp",CONINT,&rpixmode[0],NULL,NULL,
 "Rc2bpp",CONINT,&rpixmode[1],NULL,NULL,
 "Rc4bpp",CONINT,&rpixmode[2],NULL,NULL,
 "Rc8bpp",CONINT,&rpixmode[3],NULL,NULL,

 "DeepSprites",CONINT,&deepsprites,NULL,NULL,
 "NewFormat",  CONINT,&newformat,NULL,NULL,

 NULL,0,NULL,NULL,NULL
};


static conlink configlink=
{
 "Sprite",
 NULL,
 NULL
};


os_error * spriteinit(void)
{
 os_error * err;


 err=registerfiletype(&ftype);
 if(!err)
 {
  err=addcontable(contable,&configlink);

  addevent(EVENT_CONFIGLOADED,(eventfn)configloaded,0);


  if(!err) err=loadmodes();
 }

 return(err);
}


