/*->c.area */


#include "stdafx.h"

#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <stdio.h>
#include <locale.h>
#include <math.h>
#include <time.h>



#include "os.h"
#include "wimp.h"
#include "wimpt.h"
#include "werr.h"
#include "transform.h"
#include "flex.h"
#include "bbc.h"

#include "osunits.h"
#include "alloc.h"
#include "wos.h"
#include "err.h"
#include "task.h"
#include "xext.h"
#include "poll.h"
#include "temp.h"
#include "scrap.h"
#include "fsx.h"
#include "etc.h"
#include "dbhi.h"
#include "akbd.h"
#include "key.h"
#include "mlo.h"
#include "units.h"
#include "redraw.h"
#include "colour.h"
#include "drag.h"
#include "xmath.h"
#include "config.h"
#include "pane.h"
#include "deb.h"
#include "save.h"
#include "load.h"
#include "getscreen.h"
#include "ram.h"


#include "resource.h"

#include "str.h"
#include "constants.h"

#include "reslink.h"
#include "file.h"
#include "view.h"
#include "viewo.h"
#include "viewr.h"
#include "select.h"
#include "im.h"
#include "bm.h"
#include "fx.h"
#include "cmap.h"
#include "edit.h"
#include "resize.h"
#include "format.h"
#include "undo.h"
#include "long.h"
#include "filter.h"


#include "area.h"



#define SIZE  20
#define CSIZE 40


int areax0=100;
int areax1=300;
int areay0=300;
int areay1=100;


static int aopen;

static int absize;
static int acsize;


#define TL 0
#define TR 1
#define BL 2
#define BR 3

#define TOP   4
#define BOT   5
#define LEFT  6
#define RIGHT 7

#define MAXW  8

static wimp_w handle[MAXW];


static os_error * dragwindow(wimp_mousestr * m)
{
 os_error   * err;
 wimp_dragstr drg;
 windowstr    window;

 err=getw(m->w,&window);
 if(!err)
 {
  drg.window=m->w;
  drg.type=wimp_MOVE_WIND;

  err=wimp_drag_box(&drg);
 }
 return(err);
}



static os_error * areaxopen(wimp_w xhandle,wimp_w handle,int x0,int y0,int x1,int y1,int scx,int scy,
                                                               wimp_w behind)
{
 if(handle!=xhandle) return(open(handle,xcoordpix2os(x0),ycoordpix2os(y0),xcoordpix2os(x1),ycoordpix2os(y1),scx,scy,behind));

 return(NULL);
}



static os_error * areastack(wimp_w bhandle,wimp_w xhandle)
{
 os_error * err;

 err=NULL;

 areaxopen(xhandle,handle[TL],areax0-acsize,areay1,areax0,areay1-acsize,0,0,bhandle);
 areaxopen(xhandle,handle[TR],areax1,areay1,areax1+acsize,areay1-acsize,0,0,handle[TL]);
 areaxopen(xhandle,handle[BL],areax0-acsize,areay0+acsize,areax0,areay0,0,0,handle[TR]);
 areaxopen(xhandle,handle[BR],areax1,areay0+acsize,areax1+acsize,areay0,0,0,handle[BL]);

 areaxopen(xhandle,handle[LEFT],areax0-absize,areay0,areax0,areay1,0,0,handle[BR]);
 areaxopen(xhandle,handle[TOP],areax0,areay1,areax1,areay1-absize,0,0,handle[LEFT]);
 areaxopen(xhandle,handle[RIGHT],areax1,areay0,areax1+absize,areay1,0,0,handle[TOP]);
 areaxopen(xhandle,handle[BOT],areax0,areay0+absize,areax1,areay0,0,0,handle[RIGHT]);

 return(err);
}



static os_error * areaopen(wimp_w handle,uservalue userhandle,wimp_openstr * o)
{
 os_error * err;
 wimp_w     bhandle;
 int        dx0;
 int        dy0;
 int        dx1;
 int        dy1;

 int        x0;
 int        x1;
 int        y0;
 int        y1;
 int        solid;


 dx0=dx1=dy0=dy1=0;

 x0=xcoordos2pix(o->box.x0);
 x1=xcoordos2pix(o->box.x1);
 y0=ycoordos2pix(o->box.y0);
 y1=ycoordos2pix(o->box.y1);


 err=NULL;
 solid=0;

 bhandle=o->behind;

 if(userhandle<TOP) /* resize */
 {
  switch(userhandle)
  {
   case TL:
           dx0=x0-(areax0-acsize);
           dy0=0;
           dx1=0;
           dy1=y1-(areay1-acsize);
           break;

   case TR:
           dx0=0;
           dy0=0;
           dx1=x1-(areax1+acsize);
           dy1=y1-(areay1-acsize);
           break;

   case BL:
           dx0=x0-(areax0-acsize);
           dy0=y0-(areay0+acsize);
           dx1=0;
           dy1=0;
           break;

   case BR:
           dx0=0;
           dy0=y0-(areay0+acsize);
           dx1=x1-(areax1+acsize);
           dy1=0;
           break;
  }


  if(isctrl) 
  {
   if(dx1) dx0=-dx1;
   else    dx1=-dx0;
   if(dy1) dy0=-dy1;
   else    dy1=-dy0;
  }
  else
  if(isshift)
  {
   if(dx1) dx0=dx1;
   else    dx1=dx0;
   if(dy1) dy0=dy1;
   else    dy1=dy0;
   solid=1;
  }
 }
 else               /* solid */
 {
  switch(userhandle)
  {
   case LEFT:
             dx0=x0-(areax0-absize);
             dy0=y0-areay0;
             dx1=x1-areax0;
             dy1=y1-areay1;
             break;

    case TOP:
             dx0=x0-areax0;
             dy0=y0-areay1;
             dx1=x1-areax1;
             dy1=y1-(areay1-absize);
             break;

  case RIGHT:
             dx0=x0-areax1;
             dy0=y0-areay0;
             dx1=x1-(areax1+absize);
             dy1=y1-areay1;
             break;

    case BOT:
             dx0=x0-areax0;
             dy0=y0-(areay0+absize);
             dx1=x1-areax1;
             dy1=y1-areay0;
             break;
  }
  solid=1;
 }


// cprintf("dy0 %d dy1 %d",dy0,dy1);



 areax0+=dx0;
 if(areax0>areax1 && !solid) areax0=areax1;
 areax1+=dx1;
 if(areax1<areax0 && !solid) areax1=areax0;

 areay0+=dy0;
 if(areay1>areay0 && !solid) areay0=areay1;
 areay1+=dy1;
 if(areay0<areay1 && !solid) areay1=areay0;

 err=areastack(bhandle,handle);

 return(err);

 USE(handle);
}


static os_error * areaicon(wimp_w handle,uservalue userhandle,wimp_mousestr * m)
{
 os_error * err;

 err=NULL;

// cprintf("bbits %x",m->bbits);

 if(m->bbits==0x40)
 {
  err=dragwindow(m);
 }

 USE(handle);
 USE(userhandle);
 USE(m);

 return(err);
}



static os_error * redcorner(wimp_redrawstr * redrawstr,int corner)
{
 os_error * err;
 int        ox;
 int        oy;

 err=NULL;

 ox=redrawstr->box.x0-redrawstr->scx;
 oy=redrawstr->box.y1-redrawstr->scy;



 switch(corner)
 {
  case TL:
          setgcol(0xFFFF00);
          bbc_move(ox,oy);
          bbc_move(ox+(redrawstr->box.x1-redrawstr->box.x0),oy);
          bbc_plot(bbc_TriangleFill+bbc_DrawAbsFore,ox,oy-(redrawstr->box.y1-redrawstr->box.y0));

//          setgcol(0);
//          bbc_move(ox,oy);
//          bbc_draw(ox+(redrawstr->box.x1-redrawstr->box.x0),oy);          
          break;

  case TR:
          setgcol(0xFFFF00);
          bbc_move(ox,oy);
          bbc_move(ox+(redrawstr->box.x1-redrawstr->box.x0),oy);
          bbc_plot(bbc_TriangleFill+bbc_DrawAbsFore,ox+(redrawstr->box.x1-redrawstr->box.x0),oy-(redrawstr->box.y1-redrawstr->box.y0));
          break;


  case BL:
          setgcol(0xFFFF00);
          bbc_move(ox,oy);
          bbc_move(ox,oy-(redrawstr->box.y1-redrawstr->box.y0));
          bbc_plot(bbc_TriangleFill+bbc_DrawAbsFore,ox+(redrawstr->box.x1-redrawstr->box.x0),oy-(redrawstr->box.y1-redrawstr->box.y0));
          break;


  case BR:
          setgcol(0xFFFF00);
          bbc_move(ox+(redrawstr->box.x1-redrawstr->box.x0),oy);
          bbc_move(ox,oy-(redrawstr->box.y1-redrawstr->box.y0));
          bbc_plot(bbc_TriangleFill+bbc_DrawAbsFore,ox+(redrawstr->box.x1-redrawstr->box.x0),oy-(redrawstr->box.y1-redrawstr->box.y0));
          break;


 }


 return(err);
}




static os_error * arearedrawsub(wimp_w handle,uservalue userhandle,
                                wimp_redrawstr * redrawstr,int more)
{
 os_error * err;
// windowstr  window;

 err=NULL;

 while(more)
 {
  redcorner(redrawstr,(int)userhandle);
  err=wimp_get_rectangle(redrawstr,&more);
  if(err) break;
 }

 return(err);

 USE(handle);
}


static os_error * arearedraw(wimp_w handle,uservalue userhandle)
{
 os_error     * err;
 wimp_redrawstr redrawstr;
 int            more;
 redrawstr.w=handle;
 err=wimp_redraw_wind(&redrawstr,&more);
 if(!err) err=arearedrawsub(handle,userhandle,&redrawstr,more);
 return(err);
}




static os_error * areacursor(wimp_w handle,uservalue userhandle,wimp_mousestr * m,int * set)
{

 if(userhandle>BR || isshift)          changepointer(SIZEALLPOINTER,NULL,NULL);
 else
 if(userhandle==TL || userhandle==BR)  changepointer(SIZENWSEPOINTER,NULL,NULL);
 else
 if(userhandle==TR || userhandle==BL)  changepointer(SIZENESWPOINTER,NULL,NULL);


 *set=1;
 return(NULL);

 USE(m);
 USE(handle);
}



os_error * closearea(void)
{
 os_error * err;
 int        i;

 err=NULL;

 if(aopen)
 {
  for(i=0;i<TOP;i++)
  {
   remredrawevent(arearedraw,handle[i],i);
  }

  for(i=(MAXW-1);i>=0;i--)
  {
   remclickevent(areaicon,handle[i],i);
   remopenevent(areaopen,handle[i],i);
   remsetcursorevent(areacursor,handle[i],i);

   err=closedown(&handle[i]);
  }

  aopen=0;
 }
 return(err);
}



os_error * openarea(void)
{
 os_error * err;
 int        i;
 wimp_w     parent;


 err=NULL;

 if(!aopen)
 {
  acsize=xos2pix(CSIZE);
  absize=xos2pix(SIZE);

  parent=0;

  for(i=0;i<TOP;i++)
  {
   err=createwindowparent(TCORNER,&handle[i],parent);
   if(err) break;
   parent=handle[i];
  }

  if(!err)
  {
   for(;i<MAXW;i++)
   {
    err=createwindowparent(TBAR,&handle[i],parent);
    if(err) break;
    parent=handle[i];
   }

   aopen=1;

   if(!err)
   {
    for(i=0;i<MAXW;i++)
    {
     addclickevent(areaicon,handle[i],i);
     addopenevent(areaopen,handle[i],i);
     addsetcursorevent(areacursor,handle[i],i);

     wimp_setwindowbackground(handle[i],CCWIMPBASE+WIMPRED);
    }

    for(i=0;i<TOP;i++)
    {
     addredrawevent(arearedraw,handle[i],i);
    }
    areastack((wimp_w)-1,(wimp_w)0);
   }
  }
 }

 return(err);
}



/*****************************************************************************/

static wimp_w fhandle;

os_error * openfillwindow(int colour)
{
 os_error * err;
 wimp_wind * wp;

 err=NULL;

 if(!fhandle)
 {
  err=findtemp(TFILL,&wp);

  if(!err) 
  {
   err=wimp_create_wind(wp,&fhandle);
   wimp_setwindowbackground(fhandle,CCRGB+colour);

//   if(!err) err=open(fhandle,areax0,areay0,areax1,areay1,0,0,handle[BOT]);
   areaxopen(0,fhandle,areax0,areay0,areax1,areay1,0,0,handle[0]);
  }
 }

 return(err);
}

os_error * closefillwindow(void)
{
 return(closedown(&fhandle));
}

